/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.payments.core.injection;

import android.content.Context;
import androidx.activity.result.ActivityResultCaller;
import androidx.lifecycle.SavedStateHandle;
import com.stripe.android.Logger;
import com.stripe.android.networking.AnalyticsRequestFactory;
import com.stripe.android.networking.AnalyticsRequestFactory_Factory;
import com.stripe.android.networking.ApiRequest;
import com.stripe.android.networking.ApiRequest_Options_Factory;
import com.stripe.android.networking.DefaultAnalyticsRequestExecutor;
import com.stripe.android.networking.DefaultAnalyticsRequestExecutor_Factory;
import com.stripe.android.networking.StripeApiRepository;
import com.stripe.android.networking.StripeApiRepository_Factory;
import com.stripe.android.payments.DefaultReturnUrl;
import com.stripe.android.payments.PaymentIntentFlowResultProcessor;
import com.stripe.android.payments.PaymentIntentFlowResultProcessor_Factory;
import com.stripe.android.payments.SetupIntentFlowResultProcessor;
import com.stripe.android.payments.SetupIntentFlowResultProcessor_Factory;
import com.stripe.android.payments.core.authentication.PaymentAuthenticatorRegistry;
import com.stripe.android.payments.core.injection.CoroutineContextModule;
import com.stripe.android.payments.core.injection.CoroutineContextModule_ProvideUIContextFactory;
import com.stripe.android.payments.core.injection.CoroutineContextModule_ProvideWorkContextFactory;
import com.stripe.android.payments.core.injection.LoggingModule;
import com.stripe.android.payments.core.injection.LoggingModule_ProvideLoggerFactory;
import com.stripe.android.payments.core.injection.PaymentLauncherModule;
import com.stripe.android.payments.core.injection.PaymentLauncherModule_ProvideDefaultReturnUrlFactory;
import com.stripe.android.payments.core.injection.PaymentLauncherModule_ProvidePaymentAuthenticatorRegistryFactory;
import com.stripe.android.payments.core.injection.PaymentLauncherModule_ProvideThreeDs1IntentReturnUrlMapFactory;
import com.stripe.android.payments.core.injection.PaymentLauncherViewModelFactoryComponent;
import com.stripe.android.payments.core.injection.PaymentLauncherViewModelSubcomponent;
import com.stripe.android.payments.paymentlauncher.PaymentLauncherViewModel;
import com.stripe.android.payments.paymentlauncher.PaymentLauncherViewModel_Factory_MembersInjector;
import com.stripe.android.view.AuthActivityStarterHost;
import dagger.Lazy;
import dagger.internal.DaggerGenerated;
import dagger.internal.DoubleCheck;
import dagger.internal.InstanceFactory;
import dagger.internal.Preconditions;
import java.util.Map;
import java.util.Set;
import javax.inject.Provider;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.functions.Function0;

@DaggerGenerated
public final class DaggerPaymentLauncherViewModelFactoryComponent
implements PaymentLauncherViewModelFactoryComponent {
    private final Context context;
    private final Function0<String> publishableKeyProvider;
    private final Set<String> productUsage;
    private final DaggerPaymentLauncherViewModelFactoryComponent paymentLauncherViewModelFactoryComponent = this;
    private Provider<PaymentLauncherViewModelSubcomponent.Builder> paymentLauncherViewModelSubcomponentBuilderProvider;
    private Provider<CoroutineContext> provideWorkContextProvider;
    private Provider<Boolean> enableLoggingProvider;
    private Provider<Logger> provideLoggerProvider;
    private Provider<Context> contextProvider;
    private Provider<Function0<String>> publishableKeyProvider2;
    private Provider<Set<String>> productUsageProvider;
    private Provider<AnalyticsRequestFactory> analyticsRequestFactoryProvider;
    private Provider<DefaultAnalyticsRequestExecutor> defaultAnalyticsRequestExecutorProvider;
    private Provider<StripeApiRepository> stripeApiRepositoryProvider;
    private Provider<CoroutineContext> provideUIContextProvider;
    private Provider<Map<String, String>> provideThreeDs1IntentReturnUrlMapProvider;
    private Provider<PaymentAuthenticatorRegistry> providePaymentAuthenticatorRegistryProvider;
    private Provider<DefaultReturnUrl> provideDefaultReturnUrlProvider;
    private Provider<Function0<String>> stripeAccountIdProvider;
    private Provider<PaymentIntentFlowResultProcessor> paymentIntentFlowResultProcessorProvider;
    private Provider<SetupIntentFlowResultProcessor> setupIntentFlowResultProcessorProvider;

    private DaggerPaymentLauncherViewModelFactoryComponent(PaymentLauncherModule paymentLauncherModuleParam, CoroutineContextModule coroutineContextModuleParam, LoggingModule loggingModuleParam, Context contextParam, Boolean enableLoggingParam, Function0<String> publishableKeyProviderParam, Function0<String> stripeAccountIdProviderParam, Set<String> productUsageParam) {
        this.context = contextParam;
        this.publishableKeyProvider = publishableKeyProviderParam;
        this.productUsage = productUsageParam;
        this.initialize(paymentLauncherModuleParam, coroutineContextModuleParam, loggingModuleParam, contextParam, enableLoggingParam, publishableKeyProviderParam, stripeAccountIdProviderParam, productUsageParam);
    }

    public static PaymentLauncherViewModelFactoryComponent.Builder builder() {
        return new Builder();
    }

    private AnalyticsRequestFactory analyticsRequestFactory() {
        return new AnalyticsRequestFactory(this.context, this.publishableKeyProvider, this.productUsage);
    }

    private DefaultAnalyticsRequestExecutor defaultAnalyticsRequestExecutor() {
        return new DefaultAnalyticsRequestExecutor((Logger)this.provideLoggerProvider.get(), (CoroutineContext)this.provideWorkContextProvider.get());
    }

    private StripeApiRepository stripeApiRepository() {
        return new StripeApiRepository(this.context, this.publishableKeyProvider, (CoroutineContext)this.provideWorkContextProvider.get(), this.productUsage, this.analyticsRequestFactory(), this.defaultAnalyticsRequestExecutor(), (Logger)this.provideLoggerProvider.get());
    }

    private void initialize(PaymentLauncherModule paymentLauncherModuleParam, CoroutineContextModule coroutineContextModuleParam, LoggingModule loggingModuleParam, Context contextParam, Boolean enableLoggingParam, Function0<String> publishableKeyProviderParam, Function0<String> stripeAccountIdProviderParam, Set<String> productUsageParam) {
        this.paymentLauncherViewModelSubcomponentBuilderProvider = new Provider<PaymentLauncherViewModelSubcomponent.Builder>(){

            public PaymentLauncherViewModelSubcomponent.Builder get() {
                return new PaymentLauncherViewModelSubcomponentBuilder(DaggerPaymentLauncherViewModelFactoryComponent.this.paymentLauncherViewModelFactoryComponent);
            }
        };
        this.provideWorkContextProvider = DoubleCheck.provider((Provider)CoroutineContextModule_ProvideWorkContextFactory.create(coroutineContextModuleParam));
        this.enableLoggingProvider = InstanceFactory.create((Object)enableLoggingParam);
        this.provideLoggerProvider = DoubleCheck.provider((Provider)LoggingModule_ProvideLoggerFactory.create(loggingModuleParam, this.enableLoggingProvider));
        this.contextProvider = InstanceFactory.create((Object)contextParam);
        this.publishableKeyProvider2 = InstanceFactory.create(publishableKeyProviderParam);
        this.productUsageProvider = InstanceFactory.create(productUsageParam);
        this.analyticsRequestFactoryProvider = AnalyticsRequestFactory_Factory.create(this.contextProvider, this.publishableKeyProvider2, this.productUsageProvider);
        this.defaultAnalyticsRequestExecutorProvider = DefaultAnalyticsRequestExecutor_Factory.create(this.provideLoggerProvider, this.provideWorkContextProvider);
        this.stripeApiRepositoryProvider = StripeApiRepository_Factory.create(this.contextProvider, this.publishableKeyProvider2, this.provideWorkContextProvider, this.productUsageProvider, this.analyticsRequestFactoryProvider, this.defaultAnalyticsRequestExecutorProvider, this.provideLoggerProvider);
        this.provideUIContextProvider = DoubleCheck.provider((Provider)CoroutineContextModule_ProvideUIContextFactory.create(coroutineContextModuleParam));
        this.provideThreeDs1IntentReturnUrlMapProvider = DoubleCheck.provider((Provider)PaymentLauncherModule_ProvideThreeDs1IntentReturnUrlMapFactory.create(paymentLauncherModuleParam));
        this.providePaymentAuthenticatorRegistryProvider = DoubleCheck.provider((Provider)PaymentLauncherModule_ProvidePaymentAuthenticatorRegistryFactory.create(paymentLauncherModuleParam, this.contextProvider, this.stripeApiRepositoryProvider, this.enableLoggingProvider, this.provideWorkContextProvider, this.provideUIContextProvider, this.provideThreeDs1IntentReturnUrlMapProvider, this.defaultAnalyticsRequestExecutorProvider, this.analyticsRequestFactoryProvider, this.publishableKeyProvider2, this.productUsageProvider));
        this.provideDefaultReturnUrlProvider = DoubleCheck.provider((Provider)PaymentLauncherModule_ProvideDefaultReturnUrlFactory.create(paymentLauncherModuleParam, this.contextProvider));
        this.stripeAccountIdProvider = InstanceFactory.create(stripeAccountIdProviderParam);
        this.paymentIntentFlowResultProcessorProvider = DoubleCheck.provider((Provider)PaymentIntentFlowResultProcessor_Factory.create(this.contextProvider, this.publishableKeyProvider2, this.stripeApiRepositoryProvider, this.provideLoggerProvider, this.provideWorkContextProvider));
        this.setupIntentFlowResultProcessorProvider = DoubleCheck.provider((Provider)SetupIntentFlowResultProcessor_Factory.create(this.contextProvider, this.publishableKeyProvider2, this.stripeApiRepositoryProvider, this.provideLoggerProvider, this.provideWorkContextProvider));
    }

    @Override
    public void inject(PaymentLauncherViewModel.Factory factory) {
        this.injectFactory(factory);
    }

    private PaymentLauncherViewModel.Factory injectFactory(PaymentLauncherViewModel.Factory instance) {
        PaymentLauncherViewModel_Factory_MembersInjector.injectSubComponentBuilderProvider(instance, this.paymentLauncherViewModelSubcomponentBuilderProvider);
        return instance;
    }

    private static final class PaymentLauncherViewModelSubcomponentImpl
    implements PaymentLauncherViewModelSubcomponent {
        private final Boolean isPaymentIntent;
        private final AuthActivityStarterHost authActivityStarterHost;
        private final ActivityResultCaller activityResultCaller;
        private final SavedStateHandle savedStateHandle;
        private final DaggerPaymentLauncherViewModelFactoryComponent paymentLauncherViewModelFactoryComponent;
        private final PaymentLauncherViewModelSubcomponentImpl paymentLauncherViewModelSubcomponentImpl = this;
        private Provider<ApiRequest.Options> optionsProvider;

        private PaymentLauncherViewModelSubcomponentImpl(DaggerPaymentLauncherViewModelFactoryComponent paymentLauncherViewModelFactoryComponent, Boolean isPaymentIntentParam, SavedStateHandle savedStateHandleParam, AuthActivityStarterHost authActivityStarterHostParam, ActivityResultCaller activityResultCallerParam) {
            this.paymentLauncherViewModelFactoryComponent = paymentLauncherViewModelFactoryComponent;
            this.isPaymentIntent = isPaymentIntentParam;
            this.authActivityStarterHost = authActivityStarterHostParam;
            this.activityResultCaller = activityResultCallerParam;
            this.savedStateHandle = savedStateHandleParam;
            this.initialize(isPaymentIntentParam, savedStateHandleParam, authActivityStarterHostParam, activityResultCallerParam);
        }

        private void initialize(Boolean isPaymentIntentParam, SavedStateHandle savedStateHandleParam, AuthActivityStarterHost authActivityStarterHostParam, ActivityResultCaller activityResultCallerParam) {
            this.optionsProvider = ApiRequest_Options_Factory.create((Provider<Function0<String>>)this.paymentLauncherViewModelFactoryComponent.publishableKeyProvider2, (Provider<Function0<String>>)this.paymentLauncherViewModelFactoryComponent.stripeAccountIdProvider);
        }

        @Override
        public PaymentLauncherViewModel getViewModel() {
            return new PaymentLauncherViewModel(this.isPaymentIntent, this.paymentLauncherViewModelFactoryComponent.stripeApiRepository(), (PaymentAuthenticatorRegistry)this.paymentLauncherViewModelFactoryComponent.providePaymentAuthenticatorRegistryProvider.get(), (DefaultReturnUrl)this.paymentLauncherViewModelFactoryComponent.provideDefaultReturnUrlProvider.get(), this.optionsProvider, (Map)this.paymentLauncherViewModelFactoryComponent.provideThreeDs1IntentReturnUrlMapProvider.get(), (Lazy<PaymentIntentFlowResultProcessor>)DoubleCheck.lazy((Provider)this.paymentLauncherViewModelFactoryComponent.paymentIntentFlowResultProcessorProvider), (Lazy<SetupIntentFlowResultProcessor>)DoubleCheck.lazy((Provider)this.paymentLauncherViewModelFactoryComponent.setupIntentFlowResultProcessorProvider), this.paymentLauncherViewModelFactoryComponent.defaultAnalyticsRequestExecutor(), this.paymentLauncherViewModelFactoryComponent.analyticsRequestFactory(), (CoroutineContext)this.paymentLauncherViewModelFactoryComponent.provideUIContextProvider.get(), this.authActivityStarterHost, this.activityResultCaller, this.savedStateHandle);
        }
    }

    private static final class PaymentLauncherViewModelSubcomponentBuilder
    implements PaymentLauncherViewModelSubcomponent.Builder {
        private final DaggerPaymentLauncherViewModelFactoryComponent paymentLauncherViewModelFactoryComponent;
        private Boolean isPaymentIntent;
        private SavedStateHandle savedStateHandle;
        private AuthActivityStarterHost authActivityStarterHost;
        private ActivityResultCaller activityResultCaller;

        private PaymentLauncherViewModelSubcomponentBuilder(DaggerPaymentLauncherViewModelFactoryComponent paymentLauncherViewModelFactoryComponent) {
            this.paymentLauncherViewModelFactoryComponent = paymentLauncherViewModelFactoryComponent;
        }

        @Override
        public PaymentLauncherViewModelSubcomponentBuilder isPaymentIntent(boolean isPaymentIntent) {
            this.isPaymentIntent = (Boolean)Preconditions.checkNotNull((Object)isPaymentIntent);
            return this;
        }

        @Override
        public PaymentLauncherViewModelSubcomponentBuilder savedStateHandle(SavedStateHandle handle) {
            this.savedStateHandle = (SavedStateHandle)Preconditions.checkNotNull((Object)handle);
            return this;
        }

        @Override
        public PaymentLauncherViewModelSubcomponentBuilder authActivityStarterHost(AuthActivityStarterHost authActivityStarterHost) {
            this.authActivityStarterHost = (AuthActivityStarterHost)Preconditions.checkNotNull((Object)authActivityStarterHost);
            return this;
        }

        @Override
        public PaymentLauncherViewModelSubcomponentBuilder activityResultCaller(ActivityResultCaller activityResultCaller) {
            this.activityResultCaller = (ActivityResultCaller)Preconditions.checkNotNull((Object)activityResultCaller);
            return this;
        }

        @Override
        public PaymentLauncherViewModelSubcomponent build() {
            Preconditions.checkBuilderRequirement((Object)this.isPaymentIntent, Boolean.class);
            Preconditions.checkBuilderRequirement((Object)this.savedStateHandle, SavedStateHandle.class);
            Preconditions.checkBuilderRequirement((Object)this.authActivityStarterHost, AuthActivityStarterHost.class);
            Preconditions.checkBuilderRequirement((Object)this.activityResultCaller, ActivityResultCaller.class);
            return new PaymentLauncherViewModelSubcomponentImpl(this.paymentLauncherViewModelFactoryComponent, this.isPaymentIntent, this.savedStateHandle, this.authActivityStarterHost, this.activityResultCaller);
        }
    }

    private static final class Builder
    implements PaymentLauncherViewModelFactoryComponent.Builder {
        private Context context;
        private Boolean enableLogging;
        private Function0<String> publishableKeyProvider;
        private Function0<String> stripeAccountIdProvider;
        private Set<String> productUsage;

        private Builder() {
        }

        @Override
        public Builder context(Context context) {
            this.context = (Context)Preconditions.checkNotNull((Object)context);
            return this;
        }

        @Override
        public Builder enableLogging(boolean enableLogging) {
            this.enableLogging = (Boolean)Preconditions.checkNotNull((Object)enableLogging);
            return this;
        }

        @Override
        public Builder publishableKeyProvider(Function0<String> publishableKeyProvider) {
            this.publishableKeyProvider = (Function0)Preconditions.checkNotNull(publishableKeyProvider);
            return this;
        }

        @Override
        public Builder stripeAccountIdProvider(Function0<String> stripeAccountIdProvider) {
            this.stripeAccountIdProvider = (Function0)Preconditions.checkNotNull(stripeAccountIdProvider);
            return this;
        }

        @Override
        public Builder productUsage(Set<String> productUsage) {
            this.productUsage = (Set)Preconditions.checkNotNull(productUsage);
            return this;
        }

        @Override
        public PaymentLauncherViewModelFactoryComponent build() {
            Preconditions.checkBuilderRequirement((Object)this.context, Context.class);
            Preconditions.checkBuilderRequirement((Object)this.enableLogging, Boolean.class);
            Preconditions.checkBuilderRequirement(this.publishableKeyProvider, Function0.class);
            Preconditions.checkBuilderRequirement(this.stripeAccountIdProvider, Function0.class);
            Preconditions.checkBuilderRequirement(this.productUsage, Set.class);
            return new DaggerPaymentLauncherViewModelFactoryComponent(new PaymentLauncherModule(), new CoroutineContextModule(), new LoggingModule(), this.context, this.enableLogging, this.publishableKeyProvider, this.stripeAccountIdProvider, this.productUsage);
        }
    }
}

