/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.payments.core.injection;

import android.content.Context;
import androidx.activity.result.ActivityResultCaller;
import androidx.lifecycle.SavedStateHandle;
import com.stripe.android.Logger;
import com.stripe.android.networking.AnalyticsRequestFactory;
import com.stripe.android.networking.ApiRequest;
import com.stripe.android.networking.ApiRequest_Options_Factory;
import com.stripe.android.networking.DefaultAnalyticsRequestExecutor;
import com.stripe.android.networking.DefaultAnalyticsRequestExecutor_Factory;
import com.stripe.android.networking.StripeRepository;
import com.stripe.android.payments.DefaultReturnUrl;
import com.stripe.android.payments.PaymentIntentFlowResultProcessor;
import com.stripe.android.payments.PaymentIntentFlowResultProcessor_Factory;
import com.stripe.android.payments.SetupIntentFlowResultProcessor;
import com.stripe.android.payments.SetupIntentFlowResultProcessor_Factory;
import com.stripe.android.payments.core.authentication.PaymentAuthenticatorRegistry;
import com.stripe.android.payments.core.injection.LoggingModule;
import com.stripe.android.payments.core.injection.LoggingModule_ProvideLoggerFactory;
import com.stripe.android.payments.core.injection.PaymentLauncherComponent;
import com.stripe.android.payments.core.injection.PaymentLauncherModule;
import com.stripe.android.payments.core.injection.PaymentLauncherModule_ProvideDefaultReturnUrlFactory;
import com.stripe.android.payments.core.injection.PaymentLauncherModule_ProvidePaymentAuthenticatorRegistryFactory;
import com.stripe.android.payments.core.injection.PaymentLauncherModule_ProvideThreeDs1IntentReturnUrlMapFactory;
import com.stripe.android.payments.core.injection.PaymentLauncherViewModelSubcomponent;
import com.stripe.android.payments.paymentlauncher.PaymentLauncherViewModel;
import com.stripe.android.payments.paymentlauncher.PaymentLauncherViewModel_Factory_MembersInjector;
import com.stripe.android.view.AuthActivityStarterHost;
import dagger.Lazy;
import dagger.internal.DaggerGenerated;
import dagger.internal.DoubleCheck;
import dagger.internal.InstanceFactory;
import dagger.internal.Preconditions;
import java.util.Map;
import java.util.Set;
import javax.inject.Provider;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.functions.Function0;

@DaggerGenerated
public final class DaggerPaymentLauncherComponent
implements PaymentLauncherComponent {
    private final StripeRepository stripeRepository;
    private final CoroutineContext ioContext;
    private final AnalyticsRequestFactory analyticsRequestFactory;
    private final CoroutineContext uiContext;
    private final DaggerPaymentLauncherComponent paymentLauncherComponent = this;
    private Provider<PaymentLauncherViewModelSubcomponent.Builder> paymentLauncherViewModelSubcomponentBuilderProvider;
    private Provider<Context> contextProvider;
    private Provider<StripeRepository> stripeRepositoryProvider;
    private Provider<Boolean> enableLoggingProvider;
    private Provider<CoroutineContext> ioContextProvider;
    private Provider<CoroutineContext> uiContextProvider;
    private Provider<Map<String, String>> provideThreeDs1IntentReturnUrlMapProvider;
    private Provider<Logger> provideLoggerProvider;
    private Provider<DefaultAnalyticsRequestExecutor> defaultAnalyticsRequestExecutorProvider;
    private Provider<AnalyticsRequestFactory> analyticsRequestFactoryProvider;
    private Provider<Function0<String>> publishableKeyProvider;
    private Provider<Set<String>> productUsageProvider;
    private Provider<PaymentAuthenticatorRegistry> providePaymentAuthenticatorRegistryProvider;
    private Provider<DefaultReturnUrl> provideDefaultReturnUrlProvider;
    private Provider<Function0<String>> stripeAccountIdProvider;
    private Provider<PaymentIntentFlowResultProcessor> paymentIntentFlowResultProcessorProvider;
    private Provider<SetupIntentFlowResultProcessor> setupIntentFlowResultProcessorProvider;

    private DaggerPaymentLauncherComponent(PaymentLauncherModule paymentLauncherModuleParam, LoggingModule loggingModuleParam, Context contextParam, Boolean enableLoggingParam, CoroutineContext ioContextParam, CoroutineContext uiContextParam, StripeRepository stripeRepositoryParam, AnalyticsRequestFactory analyticsRequestFactoryParam, Function0<String> publishableKeyProviderParam, Function0<String> stripeAccountIdProviderParam, Set<String> productUsageParam) {
        this.stripeRepository = stripeRepositoryParam;
        this.ioContext = ioContextParam;
        this.analyticsRequestFactory = analyticsRequestFactoryParam;
        this.uiContext = uiContextParam;
        this.initialize(paymentLauncherModuleParam, loggingModuleParam, contextParam, enableLoggingParam, ioContextParam, uiContextParam, stripeRepositoryParam, analyticsRequestFactoryParam, publishableKeyProviderParam, stripeAccountIdProviderParam, productUsageParam);
    }

    public static PaymentLauncherComponent.Builder builder() {
        return new Builder();
    }

    private DefaultAnalyticsRequestExecutor defaultAnalyticsRequestExecutor() {
        return new DefaultAnalyticsRequestExecutor((Logger)this.provideLoggerProvider.get(), this.ioContext);
    }

    private void initialize(PaymentLauncherModule paymentLauncherModuleParam, LoggingModule loggingModuleParam, Context contextParam, Boolean enableLoggingParam, CoroutineContext ioContextParam, CoroutineContext uiContextParam, StripeRepository stripeRepositoryParam, AnalyticsRequestFactory analyticsRequestFactoryParam, Function0<String> publishableKeyProviderParam, Function0<String> stripeAccountIdProviderParam, Set<String> productUsageParam) {
        this.paymentLauncherViewModelSubcomponentBuilderProvider = new Provider<PaymentLauncherViewModelSubcomponent.Builder>(){

            public PaymentLauncherViewModelSubcomponent.Builder get() {
                return new PaymentLauncherViewModelSubcomponentBuilder(DaggerPaymentLauncherComponent.this.paymentLauncherComponent);
            }
        };
        this.contextProvider = InstanceFactory.create((Object)contextParam);
        this.stripeRepositoryProvider = InstanceFactory.create((Object)stripeRepositoryParam);
        this.enableLoggingProvider = InstanceFactory.create((Object)enableLoggingParam);
        this.ioContextProvider = InstanceFactory.create((Object)ioContextParam);
        this.uiContextProvider = InstanceFactory.create((Object)uiContextParam);
        this.provideThreeDs1IntentReturnUrlMapProvider = DoubleCheck.provider((Provider)PaymentLauncherModule_ProvideThreeDs1IntentReturnUrlMapFactory.create(paymentLauncherModuleParam));
        this.provideLoggerProvider = DoubleCheck.provider((Provider)LoggingModule_ProvideLoggerFactory.create(loggingModuleParam, this.enableLoggingProvider));
        this.defaultAnalyticsRequestExecutorProvider = DefaultAnalyticsRequestExecutor_Factory.create(this.provideLoggerProvider, this.ioContextProvider);
        this.analyticsRequestFactoryProvider = InstanceFactory.create((Object)analyticsRequestFactoryParam);
        this.publishableKeyProvider = InstanceFactory.create(publishableKeyProviderParam);
        this.productUsageProvider = InstanceFactory.create(productUsageParam);
        this.providePaymentAuthenticatorRegistryProvider = DoubleCheck.provider((Provider)PaymentLauncherModule_ProvidePaymentAuthenticatorRegistryFactory.create(paymentLauncherModuleParam, this.contextProvider, this.stripeRepositoryProvider, this.enableLoggingProvider, this.ioContextProvider, this.uiContextProvider, this.provideThreeDs1IntentReturnUrlMapProvider, this.defaultAnalyticsRequestExecutorProvider, this.analyticsRequestFactoryProvider, this.publishableKeyProvider, this.productUsageProvider));
        this.provideDefaultReturnUrlProvider = DoubleCheck.provider((Provider)PaymentLauncherModule_ProvideDefaultReturnUrlFactory.create(paymentLauncherModuleParam, this.contextProvider));
        this.stripeAccountIdProvider = InstanceFactory.create(stripeAccountIdProviderParam);
        this.paymentIntentFlowResultProcessorProvider = DoubleCheck.provider((Provider)PaymentIntentFlowResultProcessor_Factory.create(this.contextProvider, this.publishableKeyProvider, this.stripeRepositoryProvider, this.provideLoggerProvider, this.ioContextProvider));
        this.setupIntentFlowResultProcessorProvider = DoubleCheck.provider((Provider)SetupIntentFlowResultProcessor_Factory.create(this.contextProvider, this.publishableKeyProvider, this.stripeRepositoryProvider, this.provideLoggerProvider, this.ioContextProvider));
    }

    @Override
    public void inject(PaymentLauncherViewModel.Factory factory) {
        this.injectFactory(factory);
    }

    private PaymentLauncherViewModel.Factory injectFactory(PaymentLauncherViewModel.Factory instance) {
        PaymentLauncherViewModel_Factory_MembersInjector.injectSubComponentBuilderProvider(instance, this.paymentLauncherViewModelSubcomponentBuilderProvider);
        return instance;
    }

    private static final class PaymentLauncherViewModelSubcomponentImpl
    implements PaymentLauncherViewModelSubcomponent {
        private final Boolean isPaymentIntent;
        private final AuthActivityStarterHost authActivityStarterHost;
        private final ActivityResultCaller activityResultCaller;
        private final SavedStateHandle savedStateHandle;
        private final DaggerPaymentLauncherComponent paymentLauncherComponent;
        private final PaymentLauncherViewModelSubcomponentImpl paymentLauncherViewModelSubcomponentImpl = this;
        private Provider<ApiRequest.Options> optionsProvider;

        private PaymentLauncherViewModelSubcomponentImpl(DaggerPaymentLauncherComponent paymentLauncherComponent, Boolean isPaymentIntentParam, SavedStateHandle savedStateHandleParam, AuthActivityStarterHost authActivityStarterHostParam, ActivityResultCaller activityResultCallerParam) {
            this.paymentLauncherComponent = paymentLauncherComponent;
            this.isPaymentIntent = isPaymentIntentParam;
            this.authActivityStarterHost = authActivityStarterHostParam;
            this.activityResultCaller = activityResultCallerParam;
            this.savedStateHandle = savedStateHandleParam;
            this.initialize(isPaymentIntentParam, savedStateHandleParam, authActivityStarterHostParam, activityResultCallerParam);
        }

        private void initialize(Boolean isPaymentIntentParam, SavedStateHandle savedStateHandleParam, AuthActivityStarterHost authActivityStarterHostParam, ActivityResultCaller activityResultCallerParam) {
            this.optionsProvider = ApiRequest_Options_Factory.create((Provider<Function0<String>>)this.paymentLauncherComponent.publishableKeyProvider, (Provider<Function0<String>>)this.paymentLauncherComponent.stripeAccountIdProvider);
        }

        @Override
        public PaymentLauncherViewModel getViewModel() {
            return new PaymentLauncherViewModel(this.isPaymentIntent, this.paymentLauncherComponent.stripeRepository, (PaymentAuthenticatorRegistry)this.paymentLauncherComponent.providePaymentAuthenticatorRegistryProvider.get(), (DefaultReturnUrl)this.paymentLauncherComponent.provideDefaultReturnUrlProvider.get(), this.optionsProvider, (Map)this.paymentLauncherComponent.provideThreeDs1IntentReturnUrlMapProvider.get(), (Lazy<PaymentIntentFlowResultProcessor>)DoubleCheck.lazy((Provider)this.paymentLauncherComponent.paymentIntentFlowResultProcessorProvider), (Lazy<SetupIntentFlowResultProcessor>)DoubleCheck.lazy((Provider)this.paymentLauncherComponent.setupIntentFlowResultProcessorProvider), this.paymentLauncherComponent.defaultAnalyticsRequestExecutor(), this.paymentLauncherComponent.analyticsRequestFactory, this.paymentLauncherComponent.uiContext, this.authActivityStarterHost, this.activityResultCaller, this.savedStateHandle);
        }
    }

    private static final class PaymentLauncherViewModelSubcomponentBuilder
    implements PaymentLauncherViewModelSubcomponent.Builder {
        private final DaggerPaymentLauncherComponent paymentLauncherComponent;
        private Boolean isPaymentIntent;
        private SavedStateHandle savedStateHandle;
        private AuthActivityStarterHost authActivityStarterHost;
        private ActivityResultCaller activityResultCaller;

        private PaymentLauncherViewModelSubcomponentBuilder(DaggerPaymentLauncherComponent paymentLauncherComponent) {
            this.paymentLauncherComponent = paymentLauncherComponent;
        }

        @Override
        public PaymentLauncherViewModelSubcomponentBuilder isPaymentIntent(boolean isPaymentIntent) {
            this.isPaymentIntent = (Boolean)Preconditions.checkNotNull((Object)isPaymentIntent);
            return this;
        }

        @Override
        public PaymentLauncherViewModelSubcomponentBuilder savedStateHandle(SavedStateHandle handle) {
            this.savedStateHandle = (SavedStateHandle)Preconditions.checkNotNull((Object)handle);
            return this;
        }

        @Override
        public PaymentLauncherViewModelSubcomponentBuilder authActivityStarterHost(AuthActivityStarterHost authActivityStarterHost) {
            this.authActivityStarterHost = (AuthActivityStarterHost)Preconditions.checkNotNull((Object)authActivityStarterHost);
            return this;
        }

        @Override
        public PaymentLauncherViewModelSubcomponentBuilder activityResultCaller(ActivityResultCaller activityResultCaller) {
            this.activityResultCaller = (ActivityResultCaller)Preconditions.checkNotNull((Object)activityResultCaller);
            return this;
        }

        @Override
        public PaymentLauncherViewModelSubcomponent build() {
            Preconditions.checkBuilderRequirement((Object)this.isPaymentIntent, Boolean.class);
            Preconditions.checkBuilderRequirement((Object)this.savedStateHandle, SavedStateHandle.class);
            Preconditions.checkBuilderRequirement((Object)this.authActivityStarterHost, AuthActivityStarterHost.class);
            Preconditions.checkBuilderRequirement((Object)this.activityResultCaller, ActivityResultCaller.class);
            return new PaymentLauncherViewModelSubcomponentImpl(this.paymentLauncherComponent, this.isPaymentIntent, this.savedStateHandle, this.authActivityStarterHost, this.activityResultCaller);
        }
    }

    private static final class Builder
    implements PaymentLauncherComponent.Builder {
        private Context context;
        private Boolean enableLogging;
        private CoroutineContext ioContext;
        private CoroutineContext uiContext;
        private StripeRepository stripeRepository;
        private AnalyticsRequestFactory analyticsRequestFactory;
        private Function0<String> publishableKeyProvider;
        private Function0<String> stripeAccountIdProvider;
        private Set<String> productUsage;

        private Builder() {
        }

        @Override
        public Builder context(Context context) {
            this.context = (Context)Preconditions.checkNotNull((Object)context);
            return this;
        }

        @Override
        public Builder enableLogging(boolean enableLogging) {
            this.enableLogging = (Boolean)Preconditions.checkNotNull((Object)enableLogging);
            return this;
        }

        @Override
        public Builder ioContext(CoroutineContext workContext) {
            this.ioContext = (CoroutineContext)Preconditions.checkNotNull((Object)workContext);
            return this;
        }

        @Override
        public Builder uiContext(CoroutineContext uiContext) {
            this.uiContext = (CoroutineContext)Preconditions.checkNotNull((Object)uiContext);
            return this;
        }

        @Override
        public Builder stripeRepository(StripeRepository stripeRepository2) {
            this.stripeRepository = (StripeRepository)Preconditions.checkNotNull((Object)stripeRepository2);
            return this;
        }

        @Override
        public Builder analyticsRequestFactory(AnalyticsRequestFactory analyticsRequestFactory2) {
            this.analyticsRequestFactory = (AnalyticsRequestFactory)Preconditions.checkNotNull((Object)analyticsRequestFactory2);
            return this;
        }

        @Override
        public Builder publishableKeyProvider(Function0<String> publishableKeyProvider) {
            this.publishableKeyProvider = (Function0)Preconditions.checkNotNull(publishableKeyProvider);
            return this;
        }

        @Override
        public Builder stripeAccountIdProvider(Function0<String> stripeAccountIdProvider) {
            this.stripeAccountIdProvider = (Function0)Preconditions.checkNotNull(stripeAccountIdProvider);
            return this;
        }

        @Override
        public Builder productUsage(Set<String> productUsage) {
            this.productUsage = (Set)Preconditions.checkNotNull(productUsage);
            return this;
        }

        @Override
        public PaymentLauncherComponent build() {
            Preconditions.checkBuilderRequirement((Object)this.context, Context.class);
            Preconditions.checkBuilderRequirement((Object)this.enableLogging, Boolean.class);
            Preconditions.checkBuilderRequirement((Object)this.ioContext, CoroutineContext.class);
            Preconditions.checkBuilderRequirement((Object)this.uiContext, CoroutineContext.class);
            Preconditions.checkBuilderRequirement((Object)this.stripeRepository, StripeRepository.class);
            Preconditions.checkBuilderRequirement((Object)this.analyticsRequestFactory, AnalyticsRequestFactory.class);
            Preconditions.checkBuilderRequirement(this.publishableKeyProvider, Function0.class);
            Preconditions.checkBuilderRequirement(this.stripeAccountIdProvider, Function0.class);
            Preconditions.checkBuilderRequirement(this.productUsage, Set.class);
            return new DaggerPaymentLauncherComponent(new PaymentLauncherModule(), new LoggingModule(), this.context, this.enableLogging, this.ioContext, this.uiContext, this.stripeRepository, this.analyticsRequestFactory, this.publishableKeyProvider, this.stripeAccountIdProvider, this.productUsage);
        }
    }
}

