/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.payments.core.authentication;

import androidx.activity.result.ActivityResultCallback;
import androidx.activity.result.ActivityResultCaller;
import com.stripe.android.PaymentBrowserAuthStarter;
import com.stripe.android.StripePaymentController;
import com.stripe.android.auth.PaymentBrowserAuthContract;
import com.stripe.android.model.StripeIntent;
import com.stripe.android.networking.AnalyticsEvent;
import com.stripe.android.networking.AnalyticsRequestExecutor;
import com.stripe.android.networking.AnalyticsRequestFactory;
import com.stripe.android.networking.ApiRequest;
import com.stripe.android.payments.PaymentFlowResult;
import com.stripe.android.payments.core.authentication.PaymentAuthenticator;
import com.stripe.android.payments.core.injection.UIContext;
import com.stripe.android.view.AuthActivityStarterHost;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.JvmSuppressWildcards;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Singleton
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\b\b\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001Bc\b\u0007\u0012\u0012\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\b\u0001\u0010\u000b\u001a\u00020\f\u0012\b\b\u0001\u0010\r\u001a\u00020\u000e\u0012\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00110\u0010\u0012\u000e\b\u0001\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\u0013\u00a2\u0006\u0002\u0010\u0014J)\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u00022\u0006\u0010\u0019\u001a\u00020\u001aH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001bJc\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u00022\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00112\u0006\u0010!\u001a\u00020\u00112\b\u0010\"\u001a\u0004\u0018\u00010\u00112\n\b\u0002\u0010#\u001a\u0004\u0018\u00010\u00112\b\b\u0002\u0010$\u001a\u00020\f2\b\b\u0002\u0010%\u001a\u00020\fH\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010&R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006'"}, d2={"Lcom/stripe/android/payments/core/authentication/WebIntentAuthenticator;", "Lcom/stripe/android/payments/core/authentication/PaymentAuthenticator;", "Lcom/stripe/android/model/StripeIntent;", "paymentBrowserAuthStarterFactory", "Lkotlin/Function1;", "Lcom/stripe/android/view/AuthActivityStarterHost;", "Lcom/stripe/android/PaymentBrowserAuthStarter;", "analyticsRequestExecutor", "Lcom/stripe/android/networking/AnalyticsRequestExecutor;", "analyticsRequestFactory", "Lcom/stripe/android/networking/AnalyticsRequestFactory;", "enableLogging", "", "uiContext", "Lkotlin/coroutines/CoroutineContext;", "threeDs1IntentReturnUrlMap", "", "", "publishableKeyProvider", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function1;Lcom/stripe/android/networking/AnalyticsRequestExecutor;Lcom/stripe/android/networking/AnalyticsRequestFactory;ZLkotlin/coroutines/CoroutineContext;Ljava/util/Map;Lkotlin/jvm/functions/Function0;)V", "authenticate", "", "host", "authenticatable", "requestOptions", "Lcom/stripe/android/networking/ApiRequest$Options;", "(Lcom/stripe/android/view/AuthActivityStarterHost;Lcom/stripe/android/model/StripeIntent;Lcom/stripe/android/networking/ApiRequest$Options;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "beginWebAuth", "stripeIntent", "requestCode", "", "clientSecret", "authUrl", "stripeAccount", "returnUrl", "shouldCancelSource", "shouldCancelIntentOnUserNavigation", "(Lcom/stripe/android/view/AuthActivityStarterHost;Lcom/stripe/android/model/StripeIntent;ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;ZZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "payments-core_release"})
@JvmSuppressWildcards
public final class WebIntentAuthenticator
implements PaymentAuthenticator<StripeIntent> {
    @NotNull
    private final Function1<AuthActivityStarterHost, PaymentBrowserAuthStarter> paymentBrowserAuthStarterFactory;
    @NotNull
    private final AnalyticsRequestExecutor analyticsRequestExecutor;
    @NotNull
    private final AnalyticsRequestFactory analyticsRequestFactory;
    private final boolean enableLogging;
    @NotNull
    private final CoroutineContext uiContext;
    @NotNull
    private final Map<String, String> threeDs1IntentReturnUrlMap;
    @NotNull
    private final Function0<String> publishableKeyProvider;

    @Inject
    public WebIntentAuthenticator(@NotNull Function1<AuthActivityStarterHost, PaymentBrowserAuthStarter> paymentBrowserAuthStarterFactory, @NotNull AnalyticsRequestExecutor analyticsRequestExecutor, @NotNull AnalyticsRequestFactory analyticsRequestFactory2, @Named(value="enableLogging") boolean enableLogging, @UIContext @NotNull CoroutineContext uiContext, @NotNull Map<String, String> threeDs1IntentReturnUrlMap, @Named(value="publishableKey") @NotNull Function0<String> publishableKeyProvider) {
        Intrinsics.checkNotNullParameter(paymentBrowserAuthStarterFactory, (String)"paymentBrowserAuthStarterFactory");
        Intrinsics.checkNotNullParameter((Object)analyticsRequestExecutor, (String)"analyticsRequestExecutor");
        Intrinsics.checkNotNullParameter((Object)analyticsRequestFactory2, (String)"analyticsRequestFactory");
        Intrinsics.checkNotNullParameter((Object)uiContext, (String)"uiContext");
        Intrinsics.checkNotNullParameter(threeDs1IntentReturnUrlMap, (String)"threeDs1IntentReturnUrlMap");
        Intrinsics.checkNotNullParameter(publishableKeyProvider, (String)"publishableKeyProvider");
        this.paymentBrowserAuthStarterFactory = paymentBrowserAuthStarterFactory;
        this.analyticsRequestExecutor = analyticsRequestExecutor;
        this.analyticsRequestFactory = analyticsRequestFactory2;
        this.enableLogging = enableLogging;
        this.uiContext = uiContext;
        this.threeDs1IntentReturnUrlMap = threeDs1IntentReturnUrlMap;
        this.publishableKeyProvider = publishableKeyProvider;
    }

    @Override
    @Nullable
    public Object authenticate(@NotNull AuthActivityStarterHost host, @NotNull StripeIntent authenticatable, @NotNull ApiRequest.Options requestOptions, @NotNull Continuation<Unit> $completion) {
        String authUrl = null;
        String returnUrl = null;
        boolean shouldCancelSource = false;
        boolean shouldCancelIntentOnUserNavigation = true;
        StripeIntent.NextActionData nextActionData = authenticatable.getNextActionData();
        if (nextActionData instanceof StripeIntent.NextActionData.SdkData.Use3DS1) {
            String string2;
            authUrl = ((StripeIntent.NextActionData.SdkData.Use3DS1)nextActionData).getUrl();
            String string3 = authenticatable.getId();
            if (string3 == null) {
                string2 = null;
            } else {
                String string4 = string3;
                boolean bl = false;
                boolean bl2 = false;
                String it = string4;
                boolean bl3 = false;
                string2 = this.threeDs1IntentReturnUrlMap.remove(it);
            }
            returnUrl = string2;
            shouldCancelSource = true;
            this.analyticsRequestExecutor.executeAsync(AnalyticsRequestFactory.createRequest$payments_core_release$default(this.analyticsRequestFactory, AnalyticsEvent.Auth3ds1Sdk, null, null, null, null, 30, null));
        } else if (nextActionData instanceof StripeIntent.NextActionData.RedirectToUrl) {
            this.analyticsRequestExecutor.executeAsync(AnalyticsRequestFactory.createRequest$payments_core_release$default(this.analyticsRequestFactory, AnalyticsEvent.AuthRedirect, null, null, null, null, 30, null));
            String string5 = ((StripeIntent.NextActionData.RedirectToUrl)nextActionData).getUrl().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"nextActionData.url.toString()");
            authUrl = string5;
            returnUrl = ((StripeIntent.NextActionData.RedirectToUrl)nextActionData).getReturnUrl();
        } else if (nextActionData instanceof StripeIntent.NextActionData.AlipayRedirect) {
            this.analyticsRequestExecutor.executeAsync(AnalyticsRequestFactory.createRequest$payments_core_release$default(this.analyticsRequestFactory, AnalyticsEvent.AuthRedirect, null, null, null, null, 30, null));
            String string6 = ((StripeIntent.NextActionData.AlipayRedirect)nextActionData).getWebViewUrl().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"nextActionData.webViewUrl.toString()");
            authUrl = string6;
            returnUrl = ((StripeIntent.NextActionData.AlipayRedirect)nextActionData).getReturnUrl();
        } else if (nextActionData instanceof StripeIntent.NextActionData.DisplayOxxoDetails) {
            String string7;
            String string8 = ((StripeIntent.NextActionData.DisplayOxxoDetails)nextActionData).getHostedVoucherUrl();
            boolean bl = false;
            boolean bl4 = false;
            String it = string8;
            boolean bl5 = false;
            String string9 = it;
            Intrinsics.checkNotNull((Object)string9);
            CharSequence charSequence = string9;
            boolean bl6 = false;
            String string10 = string7 = Boxing.boxBoolean((charSequence.length() > 0 ? 1 : 0) != 0) != false ? string8 : null;
            if (string7 == null) {
                throw new IllegalArgumentException("null hostedVoucherUrl for DisplayOxxoDetails");
            }
            authUrl = string7;
            returnUrl = null;
            shouldCancelIntentOnUserNavigation = false;
        } else {
            throw new IllegalArgumentException(Intrinsics.stringPlus((String)"WebAuthenticator can't process nextActionData: ", (Object)nextActionData));
        }
        int n = StripePaymentController.Companion.getRequestCode$payments_core_release(authenticatable);
        String string11 = authenticatable.getClientSecret();
        boolean bl = false;
        String string12 = string11;
        if (string12 == null) {
            string12 = "";
        }
        Object object = this.beginWebAuth(host, authenticatable, n, string12, authUrl, requestOptions.getStripeAccount$payments_core_release(), returnUrl, shouldCancelSource, shouldCancelIntentOnUserNavigation, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private final Object beginWebAuth(AuthActivityStarterHost host, StripeIntent stripeIntent, int requestCode, String clientSecret, String authUrl, String stripeAccount, String returnUrl, boolean shouldCancelSource, boolean shouldCancelIntentOnUserNavigation, Continuation<Unit> $completion) {
        Object object = BuildersKt.withContext((CoroutineContext)this.uiContext, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, host, stripeIntent, requestCode, clientSecret, authUrl, returnUrl, stripeAccount, shouldCancelSource, shouldCancelIntentOnUserNavigation, null){
            int label;
            final /* synthetic */ WebIntentAuthenticator this$0;
            final /* synthetic */ AuthActivityStarterHost $host;
            final /* synthetic */ StripeIntent $stripeIntent;
            final /* synthetic */ int $requestCode;
            final /* synthetic */ String $clientSecret;
            final /* synthetic */ String $authUrl;
            final /* synthetic */ String $returnUrl;
            final /* synthetic */ String $stripeAccount;
            final /* synthetic */ boolean $shouldCancelSource;
            final /* synthetic */ boolean $shouldCancelIntentOnUserNavigation;
            {
                this.this$0 = $receiver;
                this.$host = $host;
                this.$stripeIntent = $stripeIntent;
                this.$requestCode = $requestCode;
                this.$clientSecret = $clientSecret;
                this.$authUrl = $authUrl;
                this.$returnUrl = $returnUrl;
                this.$stripeAccount = $stripeAccount;
                this.$shouldCancelSource = $shouldCancelSource;
                this.$shouldCancelIntentOnUserNavigation = $shouldCancelIntentOnUserNavigation;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        PaymentBrowserAuthStarter paymentBrowserWebStarter = (PaymentBrowserAuthStarter)WebIntentAuthenticator.access$getPaymentBrowserAuthStarterFactory$p(this.this$0).invoke((Object)this.$host);
                        String string2 = this.$stripeIntent.getId();
                        boolean bl = false;
                        String string3 = string2;
                        if (string3 == null) {
                            string3 = "";
                        }
                        paymentBrowserWebStarter.start(new PaymentBrowserAuthContract.Args(string3, this.$requestCode, this.$clientSecret, this.$authUrl, this.$returnUrl, WebIntentAuthenticator.access$getEnableLogging$p(this.this$0), null, this.$stripeAccount, this.$shouldCancelSource, this.$shouldCancelIntentOnUserNavigation, null, (String)WebIntentAuthenticator.access$getPublishableKeyProvider$p(this.this$0).invoke(), 1088, null));
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    static /* synthetic */ Object beginWebAuth$default(WebIntentAuthenticator webIntentAuthenticator, AuthActivityStarterHost authActivityStarterHost, StripeIntent stripeIntent, int n, String string2, String string3, String string4, String string5, boolean bl, boolean bl2, Continuation continuation, int n2, Object object) {
        if ((n2 & 0x40) != 0) {
            string5 = null;
        }
        if ((n2 & 0x80) != 0) {
            bl = false;
        }
        if ((n2 & 0x100) != 0) {
            bl2 = true;
        }
        return webIntentAuthenticator.beginWebAuth(authActivityStarterHost, stripeIntent, n, string2, string3, string4, string5, bl, bl2, (Continuation<Unit>)continuation);
    }

    @Override
    public void onLauncherInvalidated() {
        PaymentAuthenticator.DefaultImpls.onLauncherInvalidated(this);
    }

    @Override
    public void onNewActivityResultCaller(@NotNull ActivityResultCaller activityResultCaller, @NotNull ActivityResultCallback<PaymentFlowResult.Unvalidated> activityResultCallback) {
        PaymentAuthenticator.DefaultImpls.onNewActivityResultCaller(this, activityResultCaller, activityResultCallback);
    }

    public static final /* synthetic */ Object access$beginWebAuth(WebIntentAuthenticator $this, AuthActivityStarterHost host, StripeIntent stripeIntent, int requestCode, String clientSecret, String authUrl, String stripeAccount, String returnUrl, boolean shouldCancelSource, boolean shouldCancelIntentOnUserNavigation, Continuation $completion) {
        return $this.beginWebAuth(host, stripeIntent, requestCode, clientSecret, authUrl, stripeAccount, returnUrl, shouldCancelSource, shouldCancelIntentOnUserNavigation, (Continuation<Unit>)$completion);
    }

    public static final /* synthetic */ Function1 access$getPaymentBrowserAuthStarterFactory$p(WebIntentAuthenticator $this) {
        return $this.paymentBrowserAuthStarterFactory;
    }

    public static final /* synthetic */ boolean access$getEnableLogging$p(WebIntentAuthenticator $this) {
        return $this.enableLogging;
    }

    public static final /* synthetic */ Function0 access$getPublishableKeyProvider$p(WebIntentAuthenticator $this) {
        return $this.publishableKeyProvider;
    }
}

