/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.payments.core.authentication;

import android.content.Context;
import androidx.activity.result.ActivityResultCallback;
import androidx.activity.result.ActivityResultCaller;
import androidx.activity.result.ActivityResultLauncher;
import androidx.activity.result.contract.ActivityResultContract;
import androidx.annotation.VisibleForTesting;
import com.stripe.android.PaymentRelayContract;
import com.stripe.android.PaymentRelayStarter;
import com.stripe.android.auth.PaymentBrowserAuthContract;
import com.stripe.android.model.Source;
import com.stripe.android.model.StripeIntent;
import com.stripe.android.model.StripeModel;
import com.stripe.android.networking.AnalyticsRequestExecutor;
import com.stripe.android.networking.AnalyticsRequestFactory;
import com.stripe.android.networking.StripeRepository;
import com.stripe.android.payments.PaymentFlowResult;
import com.stripe.android.payments.core.authentication.NoOpIntentAuthenticator;
import com.stripe.android.payments.core.authentication.PaymentAuthenticator;
import com.stripe.android.payments.core.authentication.PaymentAuthenticatorRegistry;
import com.stripe.android.payments.core.authentication.SourceAuthenticator;
import com.stripe.android.payments.core.authentication.threeds2.Stripe3ds2TransactionViewModelFactory;
import com.stripe.android.payments.core.injection.AuthenticationComponent;
import com.stripe.android.payments.core.injection.DaggerAuthenticationComponent;
import com.stripe.android.payments.core.injection.Injectable;
import com.stripe.android.payments.core.injection.Injector;
import com.stripe.android.payments.core.injection.IntentAuthenticatorMap;
import com.stripe.android.payments.core.injection.WeakMapInjectorRegistry;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Singleton
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0001\u0018\u0000 62\u00020\u00012\u00020\u0002:\u00016B@\b\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012'\b\u0001\u0010\u0007\u001a!\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\n0\t\u0012\u000f\u0012\r\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\u0002\b\r0\b\u00a2\u0006\u0002\u0010\u000eJ!\u0010'\u001a\b\u0012\u0004\u0012\u0002H(0\u000b\"\u0004\b\u0000\u0010(2\u0006\u0010)\u001a\u0002H(H\u0016\u00a2\u0006\u0002\u0010*J\u0014\u0010+\u001a\u00020,2\n\u0010-\u001a\u0006\u0012\u0002\b\u00030.H\u0016J\b\u0010/\u001a\u00020,H\u0016J\u001e\u00100\u001a\u00020,2\u0006\u00101\u001a\u0002022\f\u00103\u001a\b\u0012\u0004\u0012\u00020504H\u0016R*\u0010\u000f\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00110\u000b0\u00108\u0000X\u0081\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\u0017X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R-\u0010\u0007\u001a!\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\n0\t\u0012\u000f\u0012\r\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\u0002\b\r0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u001c\u001a\n\u0012\u0004\u0012\u00020\u001e\u0018\u00010\u001dX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\"\u0010#\u001a\n\u0012\u0004\u0012\u00020$\u0018\u00010\u001dX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010 \"\u0004\b&\u0010\"R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lcom/stripe/android/payments/core/authentication/DefaultPaymentAuthenticatorRegistry;", "Lcom/stripe/android/payments/core/authentication/PaymentAuthenticatorRegistry;", "Lcom/stripe/android/payments/core/injection/Injector;", "noOpIntentAuthenticator", "Lcom/stripe/android/payments/core/authentication/NoOpIntentAuthenticator;", "sourceAuthenticator", "Lcom/stripe/android/payments/core/authentication/SourceAuthenticator;", "paymentAuthenticatorMap", "", "Ljava/lang/Class;", "Lcom/stripe/android/model/StripeIntent$NextActionData;", "Lcom/stripe/android/payments/core/authentication/PaymentAuthenticator;", "Lcom/stripe/android/model/StripeIntent;", "Lkotlin/jvm/JvmSuppressWildcards;", "(Lcom/stripe/android/payments/core/authentication/NoOpIntentAuthenticator;Lcom/stripe/android/payments/core/authentication/SourceAuthenticator;Ljava/util/Map;)V", "allAuthenticators", "", "Lcom/stripe/android/model/StripeModel;", "getAllAuthenticators$payments_core_release$annotations", "()V", "getAllAuthenticators$payments_core_release", "()Ljava/util/List;", "authenticationComponent", "Lcom/stripe/android/payments/core/injection/AuthenticationComponent;", "getAuthenticationComponent", "()Lcom/stripe/android/payments/core/injection/AuthenticationComponent;", "setAuthenticationComponent", "(Lcom/stripe/android/payments/core/injection/AuthenticationComponent;)V", "paymentBrowserAuthLauncher", "Landroidx/activity/result/ActivityResultLauncher;", "Lcom/stripe/android/auth/PaymentBrowserAuthContract$Args;", "getPaymentBrowserAuthLauncher$payments_core_release", "()Landroidx/activity/result/ActivityResultLauncher;", "setPaymentBrowserAuthLauncher$payments_core_release", "(Landroidx/activity/result/ActivityResultLauncher;)V", "paymentRelayLauncher", "Lcom/stripe/android/PaymentRelayStarter$Args;", "getPaymentRelayLauncher$payments_core_release", "setPaymentRelayLauncher$payments_core_release", "getAuthenticator", "Authenticatable", "authenticatable", "(Ljava/lang/Object;)Lcom/stripe/android/payments/core/authentication/PaymentAuthenticator;", "inject", "", "injectable", "Lcom/stripe/android/payments/core/injection/Injectable;", "onLauncherInvalidated", "onNewActivityResultCaller", "activityResultCaller", "Landroidx/activity/result/ActivityResultCaller;", "activityResultCallback", "Landroidx/activity/result/ActivityResultCallback;", "Lcom/stripe/android/payments/PaymentFlowResult$Unvalidated;", "Companion", "payments-core_release"})
public final class DefaultPaymentAuthenticatorRegistry
implements PaymentAuthenticatorRegistry,
Injector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final NoOpIntentAuthenticator noOpIntentAuthenticator;
    @NotNull
    private final SourceAuthenticator sourceAuthenticator;
    @NotNull
    private final Map<Class<? extends StripeIntent.NextActionData>, PaymentAuthenticator<StripeIntent>> paymentAuthenticatorMap;
    @NotNull
    private final List<PaymentAuthenticator<? extends StripeModel>> allAuthenticators;
    public AuthenticationComponent authenticationComponent;
    @Nullable
    private ActivityResultLauncher<PaymentRelayStarter.Args> paymentRelayLauncher;
    @Nullable
    private ActivityResultLauncher<PaymentBrowserAuthContract.Args> paymentBrowserAuthLauncher;

    @Inject
    public DefaultPaymentAuthenticatorRegistry(@NotNull NoOpIntentAuthenticator noOpIntentAuthenticator, @NotNull SourceAuthenticator sourceAuthenticator, @IntentAuthenticatorMap @NotNull Map<Class<? extends StripeIntent.NextActionData>, PaymentAuthenticator<StripeIntent>> paymentAuthenticatorMap) {
        Intrinsics.checkNotNullParameter((Object)noOpIntentAuthenticator, (String)"noOpIntentAuthenticator");
        Intrinsics.checkNotNullParameter((Object)sourceAuthenticator, (String)"sourceAuthenticator");
        Intrinsics.checkNotNullParameter(paymentAuthenticatorMap, (String)"paymentAuthenticatorMap");
        this.noOpIntentAuthenticator = noOpIntentAuthenticator;
        this.sourceAuthenticator = sourceAuthenticator;
        this.paymentAuthenticatorMap = paymentAuthenticatorMap;
        Object[] objectArray = new Collection[2];
        Object[] objectArray2 = new PaymentAuthenticator[]{this.noOpIntentAuthenticator, this.sourceAuthenticator};
        objectArray[0] = CollectionsKt.listOf((Object[])objectArray2);
        objectArray[1] = this.paymentAuthenticatorMap.values();
        this.allAuthenticators = CollectionsKt.flatten((Iterable)SetsKt.setOf((Object[])objectArray));
    }

    @NotNull
    public final List<PaymentAuthenticator<? extends StripeModel>> getAllAuthenticators$payments_core_release() {
        return this.allAuthenticators;
    }

    @VisibleForTesting
    public static /* synthetic */ void getAllAuthenticators$payments_core_release$annotations() {
    }

    @NotNull
    public final AuthenticationComponent getAuthenticationComponent() {
        AuthenticationComponent authenticationComponent = this.authenticationComponent;
        if (authenticationComponent != null) {
            return authenticationComponent;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"authenticationComponent");
        throw null;
    }

    public final void setAuthenticationComponent(@NotNull AuthenticationComponent authenticationComponent) {
        Intrinsics.checkNotNullParameter((Object)authenticationComponent, (String)"<set-?>");
        this.authenticationComponent = authenticationComponent;
    }

    @Nullable
    public final ActivityResultLauncher<PaymentRelayStarter.Args> getPaymentRelayLauncher$payments_core_release() {
        return this.paymentRelayLauncher;
    }

    public final void setPaymentRelayLauncher$payments_core_release(@Nullable ActivityResultLauncher<PaymentRelayStarter.Args> activityResultLauncher) {
        this.paymentRelayLauncher = activityResultLauncher;
    }

    @Nullable
    public final ActivityResultLauncher<PaymentBrowserAuthContract.Args> getPaymentBrowserAuthLauncher$payments_core_release() {
        return this.paymentBrowserAuthLauncher;
    }

    public final void setPaymentBrowserAuthLauncher$payments_core_release(@Nullable ActivityResultLauncher<PaymentBrowserAuthContract.Args> activityResultLauncher) {
        this.paymentBrowserAuthLauncher = activityResultLauncher;
    }

    @Override
    @NotNull
    public <Authenticatable> PaymentAuthenticator<Authenticatable> getAuthenticator(Authenticatable authenticatable) {
        Authenticatable Authenticatable = authenticatable;
        if (Authenticatable instanceof StripeIntent) {
            PaymentAuthenticator paymentAuthenticator;
            boolean bl;
            PaymentAuthenticator paymentAuthenticator2;
            if (!((StripeIntent)authenticatable).requiresAction()) {
                return this.noOpIntentAuthenticator;
            }
            Object object = ((StripeIntent)authenticatable).getNextActionData();
            if (object == null) {
                paymentAuthenticator2 = null;
            } else {
                StripeIntent.NextActionData nextActionData = object;
                bl = false;
                boolean bl2 = false;
                StripeIntent.NextActionData it = nextActionData;
                boolean bl3 = false;
                Map<Class<? extends StripeIntent.NextActionData>, PaymentAuthenticator<StripeIntent>> map = this.paymentAuthenticatorMap;
                Class<?> clazz = it.getClass();
                boolean bl4 = false;
                PaymentAuthenticator paymentAuthenticator3 = map.get(clazz);
                if (paymentAuthenticator3 == null) {
                    boolean bl5 = false;
                    paymentAuthenticator3 = this.noOpIntentAuthenticator;
                }
                paymentAuthenticator2 = paymentAuthenticator3;
            }
            PaymentAuthenticator paymentAuthenticator4 = paymentAuthenticator2;
            if (paymentAuthenticator4 == null) {
                object = this;
                boolean bl6 = false;
                bl = false;
                DefaultPaymentAuthenticatorRegistry $this$getAuthenticator_u24lambda_u2d2 = (DefaultPaymentAuthenticatorRegistry)object;
                boolean bl7 = false;
                paymentAuthenticator = $this$getAuthenticator_u24lambda_u2d2.noOpIntentAuthenticator;
            } else {
                paymentAuthenticator = paymentAuthenticator4;
            }
            return paymentAuthenticator;
        }
        if (!(Authenticatable instanceof Source)) {
            String string2 = Intrinsics.stringPlus((String)"No suitable PaymentAuthenticator for ", authenticatable);
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        return this.sourceAuthenticator;
    }

    @Override
    public void onNewActivityResultCaller(@NotNull ActivityResultCaller activityResultCaller, @NotNull ActivityResultCallback<PaymentFlowResult.Unvalidated> activityResultCallback) {
        Intrinsics.checkNotNullParameter((Object)activityResultCaller, (String)"activityResultCaller");
        Intrinsics.checkNotNullParameter(activityResultCallback, (String)"activityResultCallback");
        Iterable $this$forEach$iv = this.allAuthenticators;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PaymentAuthenticator it = (PaymentAuthenticator)element$iv;
            boolean bl = false;
            it.onNewActivityResultCaller(activityResultCaller, activityResultCallback);
        }
        this.paymentRelayLauncher = activityResultCaller.registerForActivityResult((ActivityResultContract)new PaymentRelayContract(), activityResultCallback);
        this.paymentBrowserAuthLauncher = activityResultCaller.registerForActivityResult((ActivityResultContract)new PaymentBrowserAuthContract(), activityResultCallback);
    }

    @Override
    public void onLauncherInvalidated() {
        Iterable $this$forEach$iv = this.allAuthenticators;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PaymentAuthenticator it = (PaymentAuthenticator)element$iv;
            boolean bl = false;
            it.onLauncherInvalidated();
        }
        Object object = this.paymentRelayLauncher;
        if (object != null) {
            object.unregister();
        }
        object = this.paymentBrowserAuthLauncher;
        if (object != null) {
            object.unregister();
        }
        this.paymentRelayLauncher = null;
        this.paymentBrowserAuthLauncher = null;
    }

    @Override
    public void inject(@NotNull Injectable<?> injectable) {
        Intrinsics.checkNotNullParameter(injectable, (String)"injectable");
        Injectable<?> injectable2 = injectable;
        if (!(injectable2 instanceof Stripe3ds2TransactionViewModelFactory)) {
            throw new IllegalArgumentException("invalid Injectable " + injectable + " requested in " + this);
        }
        this.getAuthenticationComponent().inject((Stripe3ds2TransactionViewModelFactory)injectable);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002Jn\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00140\u00132\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00140\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00140\u0018\u00a8\u0006\u0019"}, d2={"Lcom/stripe/android/payments/core/authentication/DefaultPaymentAuthenticatorRegistry$Companion;", "", "()V", "createInstance", "Lcom/stripe/android/payments/core/authentication/PaymentAuthenticatorRegistry;", "context", "Landroid/content/Context;", "stripeRepository", "Lcom/stripe/android/networking/StripeRepository;", "analyticsRequestExecutor", "Lcom/stripe/android/networking/AnalyticsRequestExecutor;", "analyticsRequestFactory", "Lcom/stripe/android/networking/AnalyticsRequestFactory;", "enableLogging", "", "workContext", "Lkotlin/coroutines/CoroutineContext;", "uiContext", "threeDs1IntentReturnUrlMap", "", "", "publishableKeyProvider", "Lkotlin/Function0;", "productUsage", "", "payments-core_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final PaymentAuthenticatorRegistry createInstance(@NotNull Context context, @NotNull StripeRepository stripeRepository2, @NotNull AnalyticsRequestExecutor analyticsRequestExecutor, @NotNull AnalyticsRequestFactory analyticsRequestFactory2, boolean enableLogging, @NotNull CoroutineContext workContext, @NotNull CoroutineContext uiContext, @NotNull Map<String, String> threeDs1IntentReturnUrlMap, @NotNull Function0<String> publishableKeyProvider, @NotNull Set<String> productUsage) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)stripeRepository2, (String)"stripeRepository");
            Intrinsics.checkNotNullParameter((Object)analyticsRequestExecutor, (String)"analyticsRequestExecutor");
            Intrinsics.checkNotNullParameter((Object)analyticsRequestFactory2, (String)"analyticsRequestFactory");
            Intrinsics.checkNotNullParameter((Object)workContext, (String)"workContext");
            Intrinsics.checkNotNullParameter((Object)uiContext, (String)"uiContext");
            Intrinsics.checkNotNullParameter(threeDs1IntentReturnUrlMap, (String)"threeDs1IntentReturnUrlMap");
            Intrinsics.checkNotNullParameter(publishableKeyProvider, (String)"publishableKeyProvider");
            Intrinsics.checkNotNullParameter(productUsage, (String)"productUsage");
            String string2 = Reflection.getOrCreateKotlinClass(PaymentAuthenticatorRegistry.class).getSimpleName();
            boolean bl = false;
            boolean bl2 = false;
            bl2 = false;
            boolean bl3 = false;
            if (string2 == null) {
                boolean bl4 = false;
                String string3 = "Required value was null.";
                throw (Throwable)new IllegalArgumentException(string3.toString());
            }
            String injectorKey = WeakMapInjectorRegistry.INSTANCE.nextKey(string2);
            AuthenticationComponent component = DaggerAuthenticationComponent.builder().context(context).stripeRepository(stripeRepository2).analyticsRequestExecutor(analyticsRequestExecutor).analyticsRequestFactory(analyticsRequestFactory2).enableLogging(enableLogging).workContext(workContext).uiContext(uiContext).threeDs1IntentReturnUrlMap(threeDs1IntentReturnUrlMap).injectorKey(injectorKey).publishableKeyProvider(publishableKeyProvider).productUsage(productUsage).build();
            DefaultPaymentAuthenticatorRegistry registry = component.getRegistry();
            registry.setAuthenticationComponent(component);
            WeakMapInjectorRegistry.INSTANCE.register(registry, injectorKey);
            return registry;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

