/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.payments;

import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import androidx.browser.customtabs.CustomTabColorSchemeParams;
import androidx.browser.customtabs.CustomTabsIntent;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.lifecycle.AbstractSavedStateViewModelFactory;
import androidx.lifecycle.SavedStateHandle;
import androidx.lifecycle.ViewModel;
import androidx.savedstate.SavedStateRegistryOwner;
import com.stripe.android.PaymentConfiguration;
import com.stripe.android.R;
import com.stripe.android.auth.PaymentBrowserAuthContract;
import com.stripe.android.networking.AnalyticsEvent;
import com.stripe.android.networking.AnalyticsRequestExecutor;
import com.stripe.android.networking.AnalyticsRequestFactory;
import com.stripe.android.networking.DefaultAnalyticsRequestExecutor;
import com.stripe.android.payments.BrowserCapabilities;
import com.stripe.android.payments.BrowserCapabilitiesSupplier;
import com.stripe.android.payments.PaymentFlowResult;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.Delegates;
import kotlin.properties.ObservableProperty;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 \u001e2\u00020\u0001:\u0002\u001e\u001fB-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019J\u000e\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019J\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R+\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000e8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0014\u0010\u0015\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/stripe/android/payments/StripeBrowserLauncherViewModel;", "Landroidx/lifecycle/ViewModel;", "analyticsRequestExecutor", "Lcom/stripe/android/networking/AnalyticsRequestExecutor;", "analyticsRequestFactory", "Lcom/stripe/android/networking/AnalyticsRequestFactory;", "browserCapabilities", "Lcom/stripe/android/payments/BrowserCapabilities;", "intentChooserTitle", "", "savedStateHandle", "Landroidx/lifecycle/SavedStateHandle;", "(Lcom/stripe/android/networking/AnalyticsRequestExecutor;Lcom/stripe/android/networking/AnalyticsRequestFactory;Lcom/stripe/android/payments/BrowserCapabilities;Ljava/lang/String;Landroidx/lifecycle/SavedStateHandle;)V", "<set-?>", "", "hasLaunched", "getHasLaunched", "()Z", "setHasLaunched", "(Z)V", "hasLaunched$delegate", "Lkotlin/properties/ReadWriteProperty;", "createLaunchIntent", "Landroid/content/Intent;", "args", "Lcom/stripe/android/auth/PaymentBrowserAuthContract$Args;", "getResultIntent", "logCapabilities", "", "shouldUseCustomTabs", "Companion", "Factory", "payments-core_release"})
public final class StripeBrowserLauncherViewModel
extends ViewModel {
    @NotNull
    public static final Companion Companion;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final AnalyticsRequestExecutor analyticsRequestExecutor;
    @NotNull
    private final AnalyticsRequestFactory analyticsRequestFactory;
    @NotNull
    private final BrowserCapabilities browserCapabilities;
    @NotNull
    private final String intentChooserTitle;
    @NotNull
    private final SavedStateHandle savedStateHandle;
    @NotNull
    private final ReadWriteProperty hasLaunched$delegate;
    @NotNull
    public static final String KEY_HAS_LAUNCHED = "has_launched";

    /*
     * WARNING - void declaration
     */
    public StripeBrowserLauncherViewModel(@NotNull AnalyticsRequestExecutor analyticsRequestExecutor, @NotNull AnalyticsRequestFactory analyticsRequestFactory2, @NotNull BrowserCapabilities browserCapabilities, @NotNull String intentChooserTitle, @NotNull SavedStateHandle savedStateHandle) {
        void initialValue$iv;
        Intrinsics.checkNotNullParameter((Object)analyticsRequestExecutor, (String)"analyticsRequestExecutor");
        Intrinsics.checkNotNullParameter((Object)analyticsRequestFactory2, (String)"analyticsRequestFactory");
        Intrinsics.checkNotNullParameter((Object)((Object)browserCapabilities), (String)"browserCapabilities");
        Intrinsics.checkNotNullParameter((Object)intentChooserTitle, (String)"intentChooserTitle");
        Intrinsics.checkNotNullParameter((Object)savedStateHandle, (String)"savedStateHandle");
        this.analyticsRequestExecutor = analyticsRequestExecutor;
        this.analyticsRequestFactory = analyticsRequestFactory2;
        this.browserCapabilities = browserCapabilities;
        this.intentChooserTitle = intentChooserTitle;
        this.savedStateHandle = savedStateHandle;
        Delegates delegates = Delegates.INSTANCE;
        Boolean bl = this.savedStateHandle.contains(KEY_HAS_LAUNCHED);
        boolean $i$f$observable = false;
        this.hasLaunched$delegate = (ReadWriteProperty)new ObservableProperty<Boolean>((Object)initialValue$iv, (Object)initialValue$iv, this){
            final /* synthetic */ Object $initialValue;
            final /* synthetic */ StripeBrowserLauncherViewModel this$0;
            {
                this.$initialValue = $captured_local_variable$1;
                this.this$0 = stripeBrowserLauncherViewModel;
                super($super_call_param$2);
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            protected void afterChange(@NotNull KProperty property, Object oldValue, Object newValue) {
                Intrinsics.checkNotNullParameter((Object)property, (String)"property");
                boolean bl = (Boolean)newValue;
                boolean bl2 = (Boolean)oldValue;
                KProperty $noName_0 = property;
                boolean bl3 = false;
                StripeBrowserLauncherViewModel.access$getSavedStateHandle$p(this.this$0).set("has_launched", (Object)true);
            }
        };
    }

    public final boolean getHasLaunched() {
        return (Boolean)this.hasLaunched$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    public final void setHasLaunched(boolean bl) {
        this.hasLaunched$delegate.setValue((Object)this, $$delegatedProperties[0], (Object)bl);
    }

    @NotNull
    public final Intent createLaunchIntent(@NotNull PaymentBrowserAuthContract.Args args2) {
        Intent intent;
        Intrinsics.checkNotNullParameter((Object)args2, (String)"args");
        boolean shouldUseCustomTabs = this.browserCapabilities == BrowserCapabilities.CustomTabs;
        this.logCapabilities(shouldUseCustomTabs);
        Uri url = Uri.parse((String)args2.getUrl());
        if (shouldUseCustomTabs) {
            boolean bl;
            Integer n;
            CustomTabColorSchemeParams customTabColorSchemeParams;
            Integer n2 = args2.getStatusBarColor();
            if (n2 == null) {
                customTabColorSchemeParams = null;
            } else {
                n = n2;
                boolean bl2 = false;
                bl = false;
                int statusBarColor = ((Number)n).intValue();
                boolean bl3 = false;
                customTabColorSchemeParams = new CustomTabColorSchemeParams.Builder().setToolbarColor(statusBarColor).build();
            }
            CustomTabColorSchemeParams customTabColorSchemeParams2 = customTabColorSchemeParams;
            CustomTabsIntent.Builder builder = new CustomTabsIntent.Builder().setShareState(2);
            bl = false;
            boolean bl4 = false;
            CustomTabsIntent.Builder it = builder;
            boolean bl5 = false;
            if (customTabColorSchemeParams2 != null) {
                it.setDefaultColorSchemeParams(customTabColorSchemeParams2);
            }
            n = builder.build();
            Intrinsics.checkNotNullExpressionValue((Object)n, (String)"Builder()\n                .setShareState(CustomTabsIntent.SHARE_STATE_OFF)\n                .also {\n                    if (customTabColorSchemeParams != null) {\n                        it.setDefaultColorSchemeParams(customTabColorSchemeParams)\n                    }\n                }\n                .build()");
            Integer customTabsIntent = n;
            ((CustomTabsIntent)customTabsIntent).intent.setData(url);
            Intent intent2 = Intent.createChooser((Intent)((CustomTabsIntent)customTabsIntent).intent, (CharSequence)this.intentChooserTitle);
            Intrinsics.checkNotNullExpressionValue((Object)intent2, (String)"{\n            val customTabColorSchemeParams = args.statusBarColor?.let { statusBarColor ->\n                CustomTabColorSchemeParams.Builder()\n                    .setToolbarColor(statusBarColor)\n                    .build()\n            }\n\n            // use Custom Tabs\n            val customTabsIntent = CustomTabsIntent.Builder()\n                .setShareState(CustomTabsIntent.SHARE_STATE_OFF)\n                .also {\n                    if (customTabColorSchemeParams != null) {\n                        it.setDefaultColorSchemeParams(customTabColorSchemeParams)\n                    }\n                }\n                .build()\n            customTabsIntent.intent.data = url\n\n            Intent.createChooser(\n                customTabsIntent.intent,\n                intentChooserTitle\n            )\n        }");
            intent = intent2;
        } else {
            Intent intent3 = Intent.createChooser((Intent)new Intent("android.intent.action.VIEW", url), (CharSequence)this.intentChooserTitle);
            Intrinsics.checkNotNullExpressionValue((Object)intent3, (String)"{\n            // use default device browser\n            Intent.createChooser(\n                Intent(Intent.ACTION_VIEW, url),\n                intentChooserTitle\n            )\n        }");
            intent = intent3;
        }
        return intent;
    }

    @NotNull
    public final Intent getResultIntent(@NotNull PaymentBrowserAuthContract.Args args2) {
        Intrinsics.checkNotNullParameter((Object)args2, (String)"args");
        Uri url = Uri.parse((String)args2.getUrl());
        Intent intent = new Intent();
        String string2 = args2.getClientSecret();
        String string3 = url.getLastPathSegment();
        boolean bl = false;
        String string4 = string3;
        if (string4 == null) {
            string4 = "";
        }
        String string5 = string4;
        string3 = args2.getStripeAccountId();
        bl = args2.getShouldCancelSource();
        Intent intent2 = intent.putExtras(new PaymentFlowResult.Unvalidated(string2, 0, null, bl, string5, null, string3, 38, null).toBundle());
        Intrinsics.checkNotNullExpressionValue((Object)intent2, (String)"Intent().putExtras(\n            PaymentFlowResult.Unvalidated(\n                clientSecret = args.clientSecret,\n                sourceId = url.lastPathSegment.orEmpty(),\n                stripeAccountId = args.stripeAccountId,\n                canCancelSource = args.shouldCancelSource\n            ).toBundle()\n        )");
        return intent2;
    }

    public final void logCapabilities(boolean shouldUseCustomTabs) {
        AnalyticsEvent analyticsEvent;
        boolean bl = shouldUseCustomTabs;
        if (bl) {
            analyticsEvent = AnalyticsEvent.AuthWithCustomTabs;
        } else if (!bl) {
            analyticsEvent = AnalyticsEvent.AuthWithDefaultBrowser;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        this.analyticsRequestExecutor.executeAsync(AnalyticsRequestFactory.createRequest$payments_core_release$default(this.analyticsRequestFactory, analyticsEvent, null, null, null, null, 30, null));
    }

    public static final /* synthetic */ SavedStateHandle access$getSavedStateHandle$p(StripeBrowserLauncherViewModel $this) {
        return $this.savedStateHandle;
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{(KProperty)Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(StripeBrowserLauncherViewModel.class), "hasLaunched", "getHasLaunched()Z")))};
        $$delegatedProperties = kPropertyArray;
        Companion = new Companion(null);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J7\u0010\u0007\u001a\u0002H\b\"\n\b\u0000\u0010\b*\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\b0\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014\u00a2\u0006\u0002\u0010\u0010R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/stripe/android/payments/StripeBrowserLauncherViewModel$Factory;", "Landroidx/lifecycle/AbstractSavedStateViewModelFactory;", "application", "Landroid/app/Application;", "owner", "Landroidx/savedstate/SavedStateRegistryOwner;", "(Landroid/app/Application;Landroidx/savedstate/SavedStateRegistryOwner;)V", "create", "T", "Landroidx/lifecycle/ViewModel;", "key", "", "modelClass", "Ljava/lang/Class;", "handle", "Landroidx/lifecycle/SavedStateHandle;", "(Ljava/lang/String;Ljava/lang/Class;Landroidx/lifecycle/SavedStateHandle;)Landroidx/lifecycle/ViewModel;", "payments-core_release"})
    @StabilityInferred(parameters=0)
    public static final class Factory
    extends AbstractSavedStateViewModelFactory {
        @NotNull
        private final Application application;
        public static final int $stable = 8;

        public Factory(@NotNull Application application, @NotNull SavedStateRegistryOwner owner) {
            Intrinsics.checkNotNullParameter((Object)application, (String)"application");
            Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
            super(owner, null);
            this.application = application;
        }

        protected <T extends ViewModel> T create(@NotNull String key, @NotNull Class<T> modelClass, @NotNull SavedStateHandle handle) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter(modelClass, (String)"modelClass");
            Intrinsics.checkNotNullParameter((Object)handle, (String)"handle");
            PaymentConfiguration config = PaymentConfiguration.Companion.getInstance((Context)this.application);
            BrowserCapabilitiesSupplier browserCapabilitiesSupplier = new BrowserCapabilitiesSupplier((Context)this.application);
            AnalyticsRequestExecutor analyticsRequestExecutor = new DefaultAnalyticsRequestExecutor();
            AnalyticsRequestFactory analyticsRequestFactory2 = new AnalyticsRequestFactory((Context)this.application, config.getPublishableKey(), null, 4, null);
            BrowserCapabilities browserCapabilities = browserCapabilitiesSupplier.get();
            String string2 = this.application.getString(R.string.stripe_verify_your_payment);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"application.getString(R.string.stripe_verify_your_payment)");
            return (T)((Object)new StripeBrowserLauncherViewModel(analyticsRequestExecutor, analyticsRequestFactory2, browserCapabilities, string2, handle));
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/stripe/android/payments/StripeBrowserLauncherViewModel$Companion;", "", "()V", "KEY_HAS_LAUNCHED", "", "payments-core_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

