/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.networking;

import com.stripe.android.exception.APIException;
import com.stripe.android.networking.RequestId;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0010 \n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0012\b\u0080\b\u0018\u0000 /2\u00020\u0001:\u0001/B5\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u001a\b\u0002\u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\b0\u0007\u00a2\u0006\u0002\u0010\tJ\u000e\u0010!\u001a\u00020\u0003H\u00c0\u0003\u00a2\u0006\u0002\b\"J\u0010\u0010#\u001a\u0004\u0018\u00010\u0005H\u00c0\u0003\u00a2\u0006\u0002\b$J \u0010%\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\b0\u0007H\u00c0\u0003\u00a2\u0006\u0002\b&J;\u0010'\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u001a\b\u0002\u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\b0\u0007H\u00c6\u0001J\u0013\u0010(\u001a\u00020\u00122\b\u0010)\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u001d\u0010*\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\b2\u0006\u0010+\u001a\u00020\u0005H\u0000\u00a2\u0006\u0002\b,J\t\u0010-\u001a\u00020\u0003H\u00d6\u0001J\b\u0010.\u001a\u00020\u0005H\u0016R\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\b0\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u0012X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u0012X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0014R\u0014\u0010\u0017\u001a\u00020\u0012X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0014R\u0016\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010\u001d\u001a\u00020\u001e8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 \u00a8\u00060"}, d2={"Lcom/stripe/android/networking/StripeResponse;", "", "code", "", "body", "", "headers", "", "", "(ILjava/lang/String;Ljava/util/Map;)V", "getBody$payments_core_release", "()Ljava/lang/String;", "getCode$payments_core_release", "()I", "contentType", "getHeaders$payments_core_release", "()Ljava/util/Map;", "isError", "", "isError$payments_core_release", "()Z", "isOk", "isOk$payments_core_release", "isRateLimited", "isRateLimited$payments_core_release", "requestId", "Lcom/stripe/android/networking/RequestId;", "getRequestId$payments_core_release", "()Lcom/stripe/android/networking/RequestId;", "responseJson", "Lorg/json/JSONObject;", "getResponseJson$payments_core_release", "()Lorg/json/JSONObject;", "component1", "component1$payments_core_release", "component2", "component2$payments_core_release", "component3", "component3$payments_core_release", "copy", "equals", "other", "getHeaderValue", "key", "getHeaderValue$payments_core_release", "hashCode", "toString", "Companion", "payments-core_release"})
public final class StripeResponse {
    @NotNull
    private static final Companion Companion = new Companion(null);
    private final int code;
    @Nullable
    private final String body;
    @NotNull
    private final Map<String, List<String>> headers;
    private final boolean isOk;
    private final boolean isError;
    private final boolean isRateLimited;
    @Nullable
    private final RequestId requestId;
    @Nullable
    private final String contentType;
    @Deprecated
    @NotNull
    private static final String REQUEST_ID_HEADER = "Request-Id";
    @Deprecated
    @NotNull
    private static final String CONTENT_TYPE_HEADER = "Content-Type";

    public StripeResponse(int code, @Nullable String body, @NotNull Map<String, ? extends List<String>> headers) {
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        this.code = code;
        this.body = body;
        this.headers = headers;
        this.isOk = this.code == 200;
        this.isError = this.code < 200 || this.code >= 300;
        this.isRateLimited = this.code == 429;
        List<String> list = this.getHeaderValue$payments_core_release(REQUEST_ID_HEADER);
        this.requestId = RequestId.Companion.fromString(list == null ? null : (String)CollectionsKt.firstOrNull(list));
        list = this.getHeaderValue$payments_core_release(CONTENT_TYPE_HEADER);
        this.contentType = list == null ? null : (String)CollectionsKt.firstOrNull(list);
    }

    public /* synthetic */ StripeResponse(int n, String string, Map map, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            map = MapsKt.emptyMap();
        }
        this(n, string, map);
    }

    public final int getCode$payments_core_release() {
        return this.code;
    }

    @Nullable
    public final String getBody$payments_core_release() {
        return this.body;
    }

    @NotNull
    public final Map<String, List<String>> getHeaders$payments_core_release() {
        return this.headers;
    }

    public final boolean isOk$payments_core_release() {
        return this.isOk;
    }

    public final boolean isError$payments_core_release() {
        return this.isError;
    }

    public final boolean isRateLimited$payments_core_release() {
        return this.isRateLimited;
    }

    @Nullable
    public final RequestId getRequestId$payments_core_release() {
        return this.requestId;
    }

    @NotNull
    public final JSONObject getResponseJson$payments_core_release() throws APIException {
        JSONObject jSONObject;
        String string = this.body;
        if (string == null) {
            jSONObject = null;
        } else {
            JSONObject jSONObject2;
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String it = string2;
            boolean bl3 = false;
            try {
                jSONObject2 = new JSONObject(it);
            }
            catch (JSONException e) {
                throw new APIException(null, null, 0, StringsKt.trimIndent((String)("\n                            Exception while parsing response body.\n                              Status code: " + this.getCode$payments_core_release() + "\n                              Request-Id: " + this.getRequestId$payments_core_release() + "\n                              Content-Type: " + this.contentType + "\n                              Body: \"" + it + "\"\n                        ")), e, 7, null);
            }
            jSONObject = jSONObject2;
        }
        JSONObject jSONObject3 = jSONObject;
        return jSONObject3 == null ? new JSONObject() : jSONObject3;
    }

    @NotNull
    public String toString() {
        return "Request-Id: " + this.requestId + ", Status Code: " + this.code;
    }

    @Nullable
    public final List<String> getHeaderValue$payments_core_release(@NotNull String key) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Iterable $this$firstOrNull$iv = this.headers.entrySet();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Map.Entry it = (Map.Entry)element$iv;
                boolean bl = false;
                if (!StringsKt.equals((String)((String)it.getKey()), (String)key, (boolean)true)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        Map.Entry entry = v0;
        return entry == null ? null : (List)entry.getValue();
    }

    public final int component1$payments_core_release() {
        return this.code;
    }

    @Nullable
    public final String component2$payments_core_release() {
        return this.body;
    }

    @NotNull
    public final Map<String, List<String>> component3$payments_core_release() {
        return this.headers;
    }

    @NotNull
    public final StripeResponse copy(int code, @Nullable String body, @NotNull Map<String, ? extends List<String>> headers) {
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        return new StripeResponse(code, body, headers);
    }

    public static /* synthetic */ StripeResponse copy$default(StripeResponse stripeResponse, int n, String string, Map map, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = stripeResponse.code;
        }
        if ((n2 & 2) != 0) {
            string = stripeResponse.body;
        }
        if ((n2 & 4) != 0) {
            map = stripeResponse.headers;
        }
        return stripeResponse.copy(n, string, map);
    }

    public int hashCode() {
        int result2 = Integer.hashCode(this.code);
        result2 = result2 * 31 + (this.body == null ? 0 : this.body.hashCode());
        result2 = result2 * 31 + ((Object)this.headers).hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof StripeResponse)) {
            return false;
        }
        StripeResponse stripeResponse = (StripeResponse)other;
        if (this.code != stripeResponse.code) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.body, (Object)stripeResponse.body)) {
            return false;
        }
        return Intrinsics.areEqual(this.headers, stripeResponse.headers);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/stripe/android/networking/StripeResponse$Companion;", "", "()V", "CONTENT_TYPE_HEADER", "", "REQUEST_ID_HEADER", "payments-core_release"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

