/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.networking;

import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import androidx.compose.runtime.internal.StabilityInferred;
import com.stripe.android.exception.InvalidRequestException;
import com.stripe.android.networking.QueryStringFactory;
import com.stripe.android.networking.RequestHeadersFactory;
import com.stripe.android.networking.StripeRequest;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b'\u0018\u0000 12\u00020\u0001:\u0003123B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010+\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0002\b\u0003\u0018\u00010\u000eH\u0007J\u0015\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/H\u0010\u00a2\u0006\u0002\b0R\u0012\u0010\u0003\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0016\u0010\u0007\u001a\u0004\u0018\u00010\u0004X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0016\u0010\t\u001a\u0004\u0018\u00010\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR \u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0002\b\u0003\u0018\u00010\u000e8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u00048PX\u0090\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0006R \u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u000e8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0010R\u0012\u0010\u0015\u001a\u00020\u0016X\u00a0\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0012\u0010\u0019\u001a\u00020\u001aX\u00a0\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0012\u0010\u001d\u001a\u00020\u001eX\u00a0\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u001e\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0002\b\u0003\u0018\u00010\u000eX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u0010R\u0014\u0010#\u001a\u00020\u00048DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010\u0006R\u000e\u0010%\u001a\u00020&X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010'\u001a\u00020\u00048@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010\u0006R\u0014\u0010)\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010\u0006\u00a8\u00064"}, d2={"Lcom/stripe/android/networking/StripeRequest;", "", "()V", "baseUrl", "", "getBaseUrl", "()Ljava/lang/String;", "body", "getBody", "bodyBytes", "", "getBodyBytes", "()[B", "compactParams", "", "getCompactParams$payments_core_release", "()Ljava/util/Map;", "contentType", "getContentType$payments_core_release", "headers", "getHeaders$payments_core_release", "headersFactory", "Lcom/stripe/android/networking/RequestHeadersFactory;", "getHeadersFactory$payments_core_release", "()Lcom/stripe/android/networking/RequestHeadersFactory;", "method", "Lcom/stripe/android/networking/StripeRequest$Method;", "getMethod$payments_core_release", "()Lcom/stripe/android/networking/StripeRequest$Method;", "mimeType", "Lcom/stripe/android/networking/StripeRequest$MimeType;", "getMimeType$payments_core_release", "()Lcom/stripe/android/networking/StripeRequest$MimeType;", "params", "getParams", "query", "getQuery", "queryStringFactory", "Lcom/stripe/android/networking/QueryStringFactory;", "url", "getUrl$payments_core_release", "urlWithQuery", "getUrlWithQuery", "getCompactParams", "writeBody", "", "outputStream", "Ljava/io/OutputStream;", "writeBody$payments_core_release", "Companion", "Method", "MimeType", "payments-core_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@StabilityInferred(parameters=0)
public abstract class StripeRequest {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final QueryStringFactory queryStringFactory = new QueryStringFactory();
    @Nullable
    private final String body;
    public static final int $stable;
    @NotNull
    private static final Function1<String, String> DEFAULT_SYSTEM_PROPERTY_SUPPLIER;
    private static final String CHARSET;

    @NotNull
    public abstract Method getMethod$payments_core_release();

    @NotNull
    public abstract String getBaseUrl();

    @Nullable
    public abstract Map<String, ?> getParams();

    @NotNull
    public abstract MimeType getMimeType$payments_core_release();

    @NotNull
    public abstract RequestHeadersFactory getHeadersFactory$payments_core_release();

    @Nullable
    public final Map<String, ?> getCompactParams$payments_core_release() {
        Map map;
        Map<String, ?> map2 = this.getParams();
        if (map2 == null) {
            map = null;
        } else {
            Map<String, ?> map3 = map2;
            boolean bl = false;
            boolean bl2 = false;
            Map<String, ?> it = map3;
            boolean bl3 = false;
            map = StripeRequest.Companion.compactParams(it);
        }
        return map;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @VisibleForTesting
    @Nullable
    public final Map<String, ?> getCompactParams() {
        return this.getCompactParams$payments_core_release();
    }

    @NotNull
    public final String getUrl$payments_core_release() throws UnsupportedEncodingException, InvalidRequestException {
        return Method.GET == this.getMethod$payments_core_release() ? this.getUrlWithQuery() : this.getBaseUrl();
    }

    @NotNull
    public String getContentType$payments_core_release() {
        return (Object)((Object)this.getMimeType$payments_core_release()) + "; charset=" + CHARSET;
    }

    @NotNull
    public final Map<String, String> getHeaders$payments_core_release() {
        return this.getHeadersFactory$payments_core_release().create();
    }

    public void writeBody$payments_core_release(@NotNull OutputStream outputStream) {
        Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
        byte[] byArray = this.getBodyBytes();
        if (byArray != null) {
            byte[] byArray2 = byArray;
            boolean bl = false;
            boolean bl2 = false;
            byte[] it = byArray2;
            boolean bl3 = false;
            outputStream.write(it);
            outputStream.flush();
        }
    }

    @Nullable
    protected String getBody() {
        return this.body;
    }

    private final byte[] getBodyBytes() {
        try {
            byte[] byArray;
            String string = this.getBody();
            if (string == null) {
                byArray = null;
            } else {
                String string2 = string;
                Charset charset = Charsets.UTF_8;
                boolean bl = false;
                byte[] byArray2 = string2.getBytes(charset);
                byArray = byArray2;
                Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"(this as java.lang.String).getBytes(charset)");
            }
            return byArray;
        }
        catch (UnsupportedEncodingException e) {
            throw new InvalidRequestException(null, null, 0, "Unable to encode parameters to " + Charsets.UTF_8.name() + ". Please contact support@stripe.com for assistance.", e, 7, null);
        }
    }

    @NotNull
    protected final String getQuery() {
        return this.queryStringFactory.create(this.getCompactParams$payments_core_release());
    }

    /*
     * WARNING - void declaration
     */
    private final String getUrlWithQuery() {
        void it;
        Object[] objectArray = new String[2];
        objectArray[0] = this.getBaseUrl();
        String string = this.getQuery();
        boolean bl = false;
        boolean bl2 = false;
        String string2 = string;
        int n = 1;
        Object[] objectArray2 = objectArray;
        boolean bl3 = false;
        CharSequence charSequence = (CharSequence)it;
        boolean bl4 = false;
        boolean bl5 = charSequence.length() > 0;
        objectArray2[n] = bl5 ? string : null;
        return CollectionsKt.joinToString$default((Iterable)CollectionsKt.listOfNotNull((Object[])objectArray), (CharSequence)(StringsKt.contains$default((CharSequence)this.getBaseUrl(), (CharSequence)"?", (boolean)false, (int)2, null) ? "&" : "?"), null, null, (int)0, null, null, (int)62, null);
    }

    static {
        DEFAULT_SYSTEM_PROPERTY_SUPPLIER = Companion.DEFAULT_SYSTEM_PROPERTY_SUPPLIER.1.INSTANCE;
        CHARSET = Charsets.UTF_8.name();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0080\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\t\u00a8\u0006\n"}, d2={"Lcom/stripe/android/networking/StripeRequest$Method;", "", "code", "", "(Ljava/lang/String;ILjava/lang/String;)V", "getCode", "()Ljava/lang/String;", "GET", "POST", "DELETE", "payments-core_release"})
    public static final class Method
    extends Enum<Method> {
        @NotNull
        private final String code;
        public static final /* enum */ Method GET = new Method("GET");
        public static final /* enum */ Method POST = new Method("POST");
        public static final /* enum */ Method DELETE = new Method("DELETE");
        private static final /* synthetic */ Method[] $VALUES;

        private Method(String code) {
            this.code = code;
        }

        @NotNull
        public final String getCode() {
            return this.code;
        }

        public static Method[] values() {
            return (Method[])$VALUES.clone();
        }

        public static Method valueOf(String value) {
            return Enum.valueOf(Method.class, value);
        }

        static {
            $VALUES = methodArray = new Method[]{Method.GET, Method.POST, Method.DELETE};
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\b\u0080\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lcom/stripe/android/networking/StripeRequest$MimeType;", "", "code", "", "(Ljava/lang/String;ILjava/lang/String;)V", "getCode", "()Ljava/lang/String;", "toString", "Form", "MultipartForm", "Json", "payments-core_release"})
    public static final class MimeType
    extends Enum<MimeType> {
        @NotNull
        private final String code;
        public static final /* enum */ MimeType Form = new MimeType("application/x-www-form-urlencoded");
        public static final /* enum */ MimeType MultipartForm = new MimeType("multipart/form-data");
        public static final /* enum */ MimeType Json = new MimeType("application/json");
        private static final /* synthetic */ MimeType[] $VALUES;

        private MimeType(String code) {
            this.code = code;
        }

        @NotNull
        public final String getCode() {
            return this.code;
        }

        @NotNull
        public String toString() {
            return this.code;
        }

        public static MimeType[] values() {
            return (MimeType[])$VALUES.clone();
        }

        public static MimeType valueOf(String value) {
            return Enum.valueOf(MimeType.class, value);
        }

        static {
            $VALUES = mimeTypeArray = new MimeType[]{MimeType.Form, MimeType.MultipartForm, MimeType.Json};
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0002\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010\u000b2\u0010\u0010\f\u001a\f\u0012\u0004\u0012\u00020\u0004\u0012\u0002\b\u00030\u000bH\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\r"}, d2={"Lcom/stripe/android/networking/StripeRequest$Companion;", "", "()V", "CHARSET", "", "kotlin.jvm.PlatformType", "DEFAULT_SYSTEM_PROPERTY_SUPPLIER", "Lkotlin/Function1;", "getDEFAULT_SYSTEM_PROPERTY_SUPPLIER$payments_core_release", "()Lkotlin/jvm/functions/Function1;", "compactParams", "", "params", "payments-core_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Function1<String, String> getDEFAULT_SYSTEM_PROPERTY_SUPPLIER$payments_core_release() {
            return DEFAULT_SYSTEM_PROPERTY_SUPPLIER;
        }

        private final Map<String, Object> compactParams(Map<String, ?> params) {
            HashMap compactParams = new HashMap(params);
            for (String key : new HashSet(compactParams.keySet())) {
                Object value = compactParams.get(key);
                if (value instanceof Map) {
                    Map map = compactParams;
                    Intrinsics.checkNotNullExpressionValue((Object)key, (String)"key");
                    String string = key;
                    Map<String, Object> map2 = this.compactParams((Map)value);
                    boolean bl = false;
                    map.put(string, map2);
                    continue;
                }
                if (value != null) continue;
                compactParams.remove(key);
            }
            return compactParams;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

