/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.networking;

import android.content.Context;
import android.os.Build;
import android.util.DisplayMetrics;
import androidx.annotation.VisibleForTesting;
import com.stripe.android.networking.FraudDetectionData;
import com.stripe.android.utils.ContextUtils;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u000f\b\u0010\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B)\b\u0001\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\b\u0012\u0006\u0010\n\u001a\u00020\b\u00a2\u0006\u0002\u0010\u000bJ\u0014\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00010\u000fH\u0002J#\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00010\u000f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0000\u00a2\u0006\u0002\b\u0013J\u001e\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00010\u000f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002J\u001c\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00010\u000f2\u0006\u0010\u0016\u001a\u00020\bH\u0002R\u000e\u0010\f\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/stripe/android/networking/FraudDetectionDataRequestParamsFactory;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "displayMetrics", "Landroid/util/DisplayMetrics;", "packageName", "", "versionName", "timeZone", "(Landroid/util/DisplayMetrics;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "androidVersionString", "screen", "createFirstMap", "", "createParams", "fraudDetectionData", "Lcom/stripe/android/networking/FraudDetectionData;", "createParams$payments_core_release", "createSecondMap", "createValueMap", "value", "Companion", "payments-core_release"})
public final class FraudDetectionDataRequestParamsFactory {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final DisplayMetrics displayMetrics;
    @NotNull
    private final String packageName;
    @Nullable
    private final String versionName;
    @NotNull
    private final String timeZone;
    @NotNull
    private final String screen;
    @NotNull
    private final String androidVersionString;

    @VisibleForTesting
    public FraudDetectionDataRequestParamsFactory(@NotNull DisplayMetrics displayMetrics, @NotNull String packageName, @Nullable String versionName, @NotNull String timeZone) {
        Intrinsics.checkNotNullParameter((Object)displayMetrics, (String)"displayMetrics");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        Intrinsics.checkNotNullParameter((Object)timeZone, (String)"timeZone");
        this.displayMetrics = displayMetrics;
        this.packageName = packageName;
        this.versionName = versionName;
        this.timeZone = timeZone;
        this.screen = this.displayMetrics.widthPixels + "w_" + this.displayMetrics.heightPixels + "h_" + this.displayMetrics.densityDpi + "dpi";
        this.androidVersionString = "Android " + Build.VERSION.RELEASE + ' ' + Build.VERSION.CODENAME + ' ' + Build.VERSION.SDK_INT;
    }

    public FraudDetectionDataRequestParamsFactory(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object object = context.getResources().getDisplayMetrics();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"context.resources.displayMetrics");
        DisplayMetrics displayMetrics = object;
        object = context.getPackageName();
        boolean bl = false;
        Object object2 = object;
        if (object2 == null) {
            object2 = "";
        }
        object = ContextUtils.INSTANCE.getPackageInfo$payments_core_release(context);
        this(displayMetrics, (String)object2, object == null ? null : object.versionName, FraudDetectionDataRequestParamsFactory.Companion.createTimezone());
    }

    public final /* synthetic */ Map createParams$payments_core_release(FraudDetectionData fraudDetectionData) {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"v2", (Object)1), TuplesKt.to((Object)"tag", (Object)"18.1.0"), TuplesKt.to((Object)"src", (Object)"android-sdk"), TuplesKt.to((Object)"a", this.createFirstMap()), TuplesKt.to((Object)"b", this.createSecondMap(fraudDetectionData))};
        return MapsKt.mapOf((Pair[])pairArray);
    }

    private final Map<String, Object> createFirstMap() {
        Pair[] pairArray = new Pair[4];
        String string = Locale.getDefault().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getDefault().toString()");
        pairArray[0] = TuplesKt.to((Object)"c", this.createValueMap(string));
        pairArray[1] = TuplesKt.to((Object)"d", this.createValueMap(this.androidVersionString));
        pairArray[2] = TuplesKt.to((Object)"f", this.createValueMap(this.screen));
        pairArray[3] = TuplesKt.to((Object)"g", this.createValueMap(this.timeZone));
        return MapsKt.mapOf((Pair[])pairArray);
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, Object> createSecondMap(FraudDetectionData fraudDetectionData) {
        Map map;
        Object object = new Pair[9];
        Object object2 = fraudDetectionData;
        object2 = object2 == null ? null : object2.getMuid$payments_core_release();
        boolean bl = false;
        Object object3 = object2;
        if (object2 == null) {
            object3 = "";
        }
        object[0] = TuplesKt.to((Object)"d", (Object)object3);
        object2 = fraudDetectionData;
        object2 = object2 == null ? null : object2.getSid$payments_core_release();
        bl = false;
        Object object4 = object2;
        if (object2 == null) {
            object4 = "";
        }
        object[1] = TuplesKt.to((Object)"e", (Object)object4);
        object[2] = TuplesKt.to((Object)"k", (Object)this.packageName);
        object[3] = TuplesKt.to((Object)"o", (Object)Build.VERSION.RELEASE);
        object[4] = TuplesKt.to((Object)"p", (Object)Build.VERSION.SDK_INT);
        object[5] = TuplesKt.to((Object)"q", (Object)Build.MANUFACTURER);
        object[6] = TuplesKt.to((Object)"r", (Object)Build.BRAND);
        object[7] = TuplesKt.to((Object)"s", (Object)Build.MODEL);
        object[8] = TuplesKt.to((Object)"t", (Object)Build.TAGS);
        Map map2 = MapsKt.mapOf((Pair[])object);
        object = this.versionName;
        if (object == null) {
            map = null;
        } else {
            void it;
            object2 = object;
            bl = false;
            boolean bl2 = false;
            Object object5 = object2;
            Map map3 = map2;
            boolean bl3 = false;
            Map map4 = MapsKt.mapOf((Pair)TuplesKt.to((Object)"l", (Object)it));
            map2 = map3;
            map = map4;
        }
        object = map;
        boolean bl4 = false;
        Object object6 = object;
        if (object == null) {
            object6 = MapsKt.emptyMap();
        }
        return MapsKt.plus((Map)map2, (Map)object6);
    }

    private final Map<String, Object> createValueMap(String value) {
        return MapsKt.mapOf((Pair)TuplesKt.to((Object)"v", (Object)value));
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0002\u00a8\u0006\u0005"}, d2={"Lcom/stripe/android/networking/FraudDetectionDataRequestParamsFactory$Companion;", "", "()V", "createTimezone", "", "payments-core_release"})
    private static final class Companion {
        private Companion() {
        }

        private final String createTimezone() {
            int minutes = (int)TimeUnit.MINUTES.convert(TimeZone.getDefault().getRawOffset(), TimeUnit.MILLISECONDS);
            if (minutes % 60 == 0) {
                return String.valueOf(minutes / 60);
            }
            BigDecimal decimalValue = new BigDecimal(minutes).setScale(2, 6);
            BigDecimal decHours = decimalValue.divide(new BigDecimal(60), new MathContext(2)).setScale(2, 6);
            String string = decHours.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"decHours.toString()");
            return string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

