/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.networking;

import androidx.annotation.VisibleForTesting;
import com.stripe.android.Logger;
import com.stripe.android.exception.APIConnectionException;
import com.stripe.android.networking.AnalyticsRequest;
import com.stripe.android.networking.AnalyticsRequestExecutor;
import com.stripe.android.networking.ConnectionFactory;
import com.stripe.android.networking.StripeConnection;
import com.stripe.android.payments.core.injection.IOContext;
import java.io.Closeable;
import java.io.IOException;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\b\u0010\u00a2\u0006\u0002\u0010\u0002B\u0019\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0001\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0015\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0001\u00a2\u0006\u0002\b\u000eJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/stripe/android/networking/DefaultAnalyticsRequestExecutor;", "Lcom/stripe/android/networking/AnalyticsRequestExecutor;", "()V", "logger", "Lcom/stripe/android/Logger;", "workContext", "Lkotlin/coroutines/CoroutineContext;", "(Lcom/stripe/android/Logger;Lkotlin/coroutines/CoroutineContext;)V", "connectionFactory", "Lcom/stripe/android/networking/ConnectionFactory$Default;", "execute", "", "request", "Lcom/stripe/android/networking/AnalyticsRequest;", "execute$payments_core_release", "executeAsync", "", "payments-core_release"})
public final class DefaultAnalyticsRequestExecutor
implements AnalyticsRequestExecutor {
    @NotNull
    private final Logger logger;
    @NotNull
    private final CoroutineContext workContext;
    @NotNull
    private final ConnectionFactory.Default connectionFactory;

    @Inject
    public DefaultAnalyticsRequestExecutor(@NotNull Logger logger2, @IOContext @NotNull CoroutineContext workContext) {
        Intrinsics.checkNotNullParameter((Object)logger2, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)workContext, (String)"workContext");
        this.logger = logger2;
        this.workContext = workContext;
        this.connectionFactory = new ConnectionFactory.Default();
    }

    public DefaultAnalyticsRequestExecutor() {
        this(Logger.Companion.noop(), (CoroutineContext)Dispatchers.getIO());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public final int execute$payments_core_release(@NotNull AnalyticsRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Closeable closeable = this.connectionFactory.create(request);
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            StripeConnection it = (StripeConnection)closeable;
            boolean bl3 = false;
            try {
                int n = it.getResponseCode();
                return n;
            }
            catch (IOException e) {
                try {
                    throw APIConnectionException.Companion.create$payments_core_release(e, request.getBaseUrl());
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @Override
    public void executeAsync(@NotNull AnalyticsRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        this.logger.info(Intrinsics.stringPlus((String)"Event: ", request.getParams().get("event")));
        BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)this.workContext), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, request, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ DefaultAnalyticsRequestExecutor this$0;
            final /* synthetic */ AnalyticsRequest $request;
            {
                this.this$0 = $receiver;
                this.$request = $request;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        boolean bl;
                        Object object3;
                        CoroutineScope $this$launch;
                        ResultKt.throwOnFailure((Object)object);
                        CoroutineScope coroutineScope = $this$launch = (CoroutineScope)this.L$0;
                        DefaultAnalyticsRequestExecutor defaultAnalyticsRequestExecutor = this.this$0;
                        AnalyticsRequest analyticsRequest = this.$request;
                        boolean bl2 = false;
                        try {
                            object3 = Result.Companion;
                            Object object4 = coroutineScope;
                            boolean bl3 = false;
                            object4 = Boxing.boxInt((int)defaultAnalyticsRequestExecutor.execute$payments_core_release(analyticsRequest));
                            boolean bl4 = false;
                            object3 = Result.constructor-impl((Object)object4);
                        }
                        catch (Throwable throwable) {
                            Result.Companion companion = Result.Companion;
                            bl = false;
                            object3 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                        }
                        coroutineScope = object3;
                        defaultAnalyticsRequestExecutor = this.this$0;
                        boolean bl5 = false;
                        bl2 = false;
                        Throwable throwable = Result.exceptionOrNull-impl((Object)coroutineScope);
                        if (throwable != null) {
                            Throwable throwable2 = throwable;
                            boolean bl6 = false;
                            boolean bl7 = false;
                            Throwable throwable3 = throwable2;
                            bl = false;
                            Throwable it = throwable3;
                            boolean bl8 = false;
                            DefaultAnalyticsRequestExecutor.access$getLogger$p(defaultAnalyticsRequestExecutor).error("Exception while making analytics request", it);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)function2;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    public static final /* synthetic */ Logger access$getLogger$p(DefaultAnalyticsRequestExecutor $this) {
        return $this.logger;
    }
}

