/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.model.parsers;

import androidx.annotation.Size;
import com.stripe.android.model.Address;
import com.stripe.android.model.Source;
import com.stripe.android.model.SourceOrder;
import com.stripe.android.model.SourceTypeModel;
import com.stripe.android.model.StripeJsonUtils;
import com.stripe.android.model.StripeModel;
import com.stripe.android.model.WeChat;
import com.stripe.android.model.parsers.AddressJsonParser;
import com.stripe.android.model.parsers.ModelJsonParser;
import com.stripe.android.model.parsers.SourceCardDataJsonParser;
import com.stripe.android.model.parsers.SourceOrderJsonParser;
import com.stripe.android.model.parsers.SourceSepaDebitDataJsonParser;
import com.stripe.android.model.parsers.WeChatJsonParser;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u0000 \b2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0006\u0007\b\t\n\u000b\fB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\r"}, d2={"Lcom/stripe/android/model/parsers/SourceJsonParser;", "Lcom/stripe/android/model/parsers/ModelJsonParser;", "Lcom/stripe/android/model/Source;", "()V", "parse", "json", "Lorg/json/JSONObject;", "CodeVerificationJsonParser", "Companion", "KlarnaJsonParser", "OwnerJsonParser", "ReceiverJsonParser", "RedirectJsonParser", "payments-core_release"})
public final class SourceJsonParser
implements ModelJsonParser<Source> {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @Deprecated
    @NotNull
    private static final String VALUE_SOURCE = "source";
    @Deprecated
    @NotNull
    private static final String VALUE_CARD = "card";
    @Deprecated
    @NotNull
    private static final Set<String> MODELED_TYPES;
    @Deprecated
    @NotNull
    private static final String FIELD_ID = "id";
    @Deprecated
    @NotNull
    private static final String FIELD_OBJECT = "object";
    @Deprecated
    @NotNull
    private static final String FIELD_AMOUNT = "amount";
    @Deprecated
    @NotNull
    private static final String FIELD_CLIENT_SECRET = "client_secret";
    @Deprecated
    @NotNull
    private static final String FIELD_CODE_VERIFICATION = "code_verification";
    @Deprecated
    @NotNull
    private static final String FIELD_CREATED = "created";
    @Deprecated
    @NotNull
    private static final String FIELD_CURRENCY = "currency";
    @Deprecated
    @NotNull
    private static final String FIELD_FLOW = "flow";
    @Deprecated
    @NotNull
    private static final String FIELD_LIVEMODE = "livemode";
    @Deprecated
    @NotNull
    private static final String FIELD_OWNER = "owner";
    @Deprecated
    @NotNull
    private static final String FIELD_RECEIVER = "receiver";
    @Deprecated
    @NotNull
    private static final String FIELD_REDIRECT = "redirect";
    @Deprecated
    @NotNull
    private static final String FIELD_SOURCE_ORDER = "source_order";
    @Deprecated
    @NotNull
    private static final String FIELD_STATEMENT_DESCRIPTOR = "statement_descriptor";
    @Deprecated
    @NotNull
    private static final String FIELD_STATUS = "status";
    @Deprecated
    @NotNull
    private static final String FIELD_TYPE = "type";
    @Deprecated
    @NotNull
    private static final String FIELD_USAGE = "usage";
    @Deprecated
    @NotNull
    private static final String FIELD_WECHAT = "wechat";
    @Deprecated
    @NotNull
    private static final String FIELD_KLARNA = "klarna";

    @Override
    @Nullable
    public Source parse(@NotNull JSONObject json) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        String string = json.optString(FIELD_OBJECT);
        return Intrinsics.areEqual((Object)string, (Object)VALUE_CARD) ? SourceJsonParser.Companion.fromCardJson(json) : (Intrinsics.areEqual((Object)string, (Object)VALUE_SOURCE) ? SourceJsonParser.Companion.fromSourceJson(json) : null);
    }

    static {
        Object[] objectArray = new String[]{VALUE_CARD, "sepa_debit"};
        MODELED_TYPES = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00072\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0007B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lcom/stripe/android/model/parsers/SourceJsonParser$RedirectJsonParser;", "Lcom/stripe/android/model/parsers/ModelJsonParser;", "Lcom/stripe/android/model/Source$Redirect;", "()V", "parse", "json", "Lorg/json/JSONObject;", "Companion", "payments-core_release"})
    public static final class RedirectJsonParser
    implements ModelJsonParser<Source.Redirect> {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private static final String FIELD_RETURN_URL = "return_url";
        @NotNull
        private static final String FIELD_STATUS = "status";
        @NotNull
        private static final String FIELD_URL = "url";

        @Override
        @NotNull
        public Source.Redirect parse(@NotNull JSONObject json) {
            Intrinsics.checkNotNullParameter((Object)json, (String)"json");
            return new Source.Redirect(StripeJsonUtils.optString(json, FIELD_RETURN_URL), Source.Redirect.Status.Companion.fromCode(StripeJsonUtils.optString(json, "status")), StripeJsonUtils.optString(json, FIELD_URL));
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/stripe/android/model/parsers/SourceJsonParser$RedirectJsonParser$Companion;", "", "()V", "FIELD_RETURN_URL", "", "FIELD_STATUS", "FIELD_URL", "payments-core_release"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00072\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0007B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lcom/stripe/android/model/parsers/SourceJsonParser$CodeVerificationJsonParser;", "Lcom/stripe/android/model/parsers/ModelJsonParser;", "Lcom/stripe/android/model/Source$CodeVerification;", "()V", "parse", "json", "Lorg/json/JSONObject;", "Companion", "payments-core_release"})
    public static final class CodeVerificationJsonParser
    implements ModelJsonParser<Source.CodeVerification> {
        @NotNull
        private static final Companion Companion = new Companion(null);
        @Deprecated
        @NotNull
        private static final String FIELD_ATTEMPTS_REMAINING = "attempts_remaining";
        @Deprecated
        @NotNull
        private static final String FIELD_STATUS = "status";
        @Deprecated
        private static final int INVALID_ATTEMPTS_REMAINING = -1;

        @Override
        @NotNull
        public Source.CodeVerification parse(@NotNull JSONObject json) {
            Intrinsics.checkNotNullParameter((Object)json, (String)"json");
            return new Source.CodeVerification(json.optInt(FIELD_ATTEMPTS_REMAINING, -1), Source.CodeVerification.Status.Companion.fromCode(StripeJsonUtils.optString(json, "status")));
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/stripe/android/model/parsers/SourceJsonParser$CodeVerificationJsonParser$Companion;", "", "()V", "FIELD_ATTEMPTS_REMAINING", "", "FIELD_STATUS", "INVALID_ATTEMPTS_REMAINING", "", "payments-core_release"})
        private static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00072\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0007B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lcom/stripe/android/model/parsers/SourceJsonParser$ReceiverJsonParser;", "Lcom/stripe/android/model/parsers/ModelJsonParser;", "Lcom/stripe/android/model/Source$Receiver;", "()V", "parse", "json", "Lorg/json/JSONObject;", "Companion", "payments-core_release"})
    public static final class ReceiverJsonParser
    implements ModelJsonParser<Source.Receiver> {
        @NotNull
        private static final Companion Companion = new Companion(null);
        @Deprecated
        @NotNull
        private static final String FIELD_ADDRESS = "address";
        @Deprecated
        @NotNull
        private static final String FIELD_AMOUNT_CHARGED = "amount_charged";
        @Deprecated
        @NotNull
        private static final String FIELD_AMOUNT_RECEIVED = "amount_received";
        @Deprecated
        @NotNull
        private static final String FIELD_AMOUNT_RETURNED = "amount_returned";

        @Override
        @NotNull
        public Source.Receiver parse(@NotNull JSONObject json) {
            Intrinsics.checkNotNullParameter((Object)json, (String)"json");
            return new Source.Receiver(StripeJsonUtils.optString(json, FIELD_ADDRESS), json.optLong(FIELD_AMOUNT_CHARGED), json.optLong(FIELD_AMOUNT_RECEIVED), json.optLong(FIELD_AMOUNT_RETURNED));
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/stripe/android/model/parsers/SourceJsonParser$ReceiverJsonParser$Companion;", "", "()V", "FIELD_ADDRESS", "", "FIELD_AMOUNT_CHARGED", "FIELD_AMOUNT_RECEIVED", "FIELD_AMOUNT_RETURNED", "payments-core_release"})
        private static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00072\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0007B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lcom/stripe/android/model/parsers/SourceJsonParser$OwnerJsonParser;", "Lcom/stripe/android/model/parsers/ModelJsonParser;", "Lcom/stripe/android/model/Source$Owner;", "()V", "parse", "json", "Lorg/json/JSONObject;", "Companion", "payments-core_release"})
    public static final class OwnerJsonParser
    implements ModelJsonParser<Source.Owner> {
        @NotNull
        private static final Companion Companion = new Companion(null);
        @Deprecated
        @NotNull
        private static final String FIELD_ADDRESS = "address";
        @Deprecated
        @NotNull
        private static final String FIELD_EMAIL = "email";
        @Deprecated
        @NotNull
        private static final String FIELD_NAME = "name";
        @Deprecated
        @NotNull
        private static final String FIELD_PHONE = "phone";
        @Deprecated
        @NotNull
        private static final String FIELD_VERIFIED_ADDRESS = "verified_address";
        @Deprecated
        @NotNull
        private static final String FIELD_VERIFIED_EMAIL = "verified_email";
        @Deprecated
        @NotNull
        private static final String FIELD_VERIFIED_NAME = "verified_name";
        @Deprecated
        @NotNull
        private static final String FIELD_VERIFIED_PHONE = "verified_phone";

        @Override
        @NotNull
        public Source.Owner parse(@NotNull JSONObject json) {
            Address address;
            Address address2;
            JSONObject it;
            boolean bl;
            boolean bl2;
            JSONObject jSONObject;
            Address address3;
            Intrinsics.checkNotNullParameter((Object)json, (String)"json");
            JSONObject jSONObject2 = json.optJSONObject(FIELD_ADDRESS);
            if (jSONObject2 == null) {
                address3 = null;
            } else {
                jSONObject = jSONObject2;
                bl2 = false;
                bl = false;
                it = jSONObject;
                boolean bl3 = false;
                address3 = address2 = new AddressJsonParser().parse(it);
            }
            String string = StripeJsonUtils.optString(json, FIELD_EMAIL);
            String string2 = StripeJsonUtils.optString(json, FIELD_NAME);
            String string3 = StripeJsonUtils.optString(json, FIELD_PHONE);
            jSONObject2 = json.optJSONObject(FIELD_VERIFIED_ADDRESS);
            if (jSONObject2 == null) {
                address = null;
            } else {
                jSONObject = jSONObject2;
                bl2 = false;
                bl = false;
                it = jSONObject;
                String string4 = string3;
                String string5 = string2;
                String string6 = string;
                address2 = address3;
                boolean bl4 = false;
                Address address4 = new AddressJsonParser().parse(it);
                address3 = address2;
                string = string6;
                string2 = string5;
                string3 = string4;
                address = address4;
            }
            String string7 = StripeJsonUtils.optString(json, FIELD_VERIFIED_PHONE);
            String string8 = StripeJsonUtils.optString(json, FIELD_VERIFIED_NAME);
            String string9 = StripeJsonUtils.optString(json, FIELD_VERIFIED_EMAIL);
            Address address5 = address;
            String string10 = string3;
            String string11 = string2;
            String string12 = string;
            Address address6 = address3;
            return new Source.Owner(address6, string12, string11, string10, address5, string9, string8, string7);
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/stripe/android/model/parsers/SourceJsonParser$OwnerJsonParser$Companion;", "", "()V", "FIELD_ADDRESS", "", "FIELD_EMAIL", "FIELD_NAME", "FIELD_PHONE", "FIELD_VERIFIED_ADDRESS", "FIELD_VERIFIED_EMAIL", "FIELD_VERIFIED_NAME", "FIELD_VERIFIED_PHONE", "payments-core_release"})
        private static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0000\u0018\u0000 \u000b2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u000bB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u001e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\tH\u0002\u00a8\u0006\f"}, d2={"Lcom/stripe/android/model/parsers/SourceJsonParser$KlarnaJsonParser;", "Lcom/stripe/android/model/parsers/ModelJsonParser;", "Lcom/stripe/android/model/Source$Klarna;", "()V", "parse", "json", "Lorg/json/JSONObject;", "parseSet", "", "", "key", "Companion", "payments-core_release"})
    public static final class KlarnaJsonParser
    implements ModelJsonParser<Source.Klarna> {
        @NotNull
        private static final Companion Companion = new Companion(null);
        @Deprecated
        @NotNull
        private static final String FIELD_FIRST_NAME = "first_name";
        @Deprecated
        @NotNull
        private static final String FIELD_LAST_NAME = "last_name";
        @Deprecated
        @NotNull
        private static final String FIELD_PURCHASE_COUNTRY = "purchase_country";
        @Deprecated
        @NotNull
        private static final String FIELD_CLIENT_TOKEN = "client_token";
        @Deprecated
        @NotNull
        private static final String FIELD_PAY_LATER_ASSET_URLS_DESCRIPTIVE = "pay_later_asset_urls_descriptive";
        @Deprecated
        @NotNull
        private static final String FIELD_PAY_LATER_ASSET_URLS_STANDARD = "pay_later_asset_urls_standard";
        @Deprecated
        @NotNull
        private static final String FIELD_PAY_LATER_NAME = "pay_later_name";
        @Deprecated
        @NotNull
        private static final String FIELD_PAY_LATER_REDIRECT_URL = "pay_later_redirect_url";
        @Deprecated
        @NotNull
        private static final String FIELD_PAY_NOW_ASSET_URLS_DESCRIPTIVE = "pay_now_asset_urls_descriptive";
        @Deprecated
        @NotNull
        private static final String FIELD_PAY_NOW_ASSET_URLS_STANDARD = "pay_now_asset_urls_standard";
        @Deprecated
        @NotNull
        private static final String FIELD_PAY_NOW_NAME = "pay_now_name";
        @Deprecated
        @NotNull
        private static final String FIELD_PAY_NOW_REDIRECT_URL = "pay_now_redirect_url";
        @Deprecated
        @NotNull
        private static final String FIELD_PAY_OVER_TIME_ASSET_URLS_DESCRIPTIVE = "pay_over_time_asset_urls_descriptive";
        @Deprecated
        @NotNull
        private static final String FIELD_PAY_OVER_TIME_ASSET_URLS_STANDARD = "pay_over_time_asset_urls_standard";
        @Deprecated
        @NotNull
        private static final String FIELD_PAY_OVER_TIME_NAME = "pay_over_time_name";
        @Deprecated
        @NotNull
        private static final String FIELD_PAY_OVER_TIME_REDIRECT_URL = "pay_over_time_redirect_url";
        @Deprecated
        @NotNull
        private static final String FIELD_PAYMENT_METHOD_CATEGORIES = "payment_method_categories";
        @Deprecated
        @NotNull
        private static final String FIELD_CUSTOM_PAYMENT_METHODS = "custom_payment_methods";

        @Override
        @NotNull
        public Source.Klarna parse(@NotNull JSONObject json) {
            Intrinsics.checkNotNullParameter((Object)json, (String)"json");
            String string = StripeJsonUtils.optString(json, FIELD_FIRST_NAME);
            String string2 = StripeJsonUtils.optString(json, FIELD_LAST_NAME);
            String string3 = StripeJsonUtils.optString(json, FIELD_PURCHASE_COUNTRY);
            String string4 = StripeJsonUtils.optString(json, FIELD_CLIENT_TOKEN);
            String string5 = StripeJsonUtils.optString(json, FIELD_PAY_LATER_ASSET_URLS_DESCRIPTIVE);
            String string6 = StripeJsonUtils.optString(json, FIELD_PAY_LATER_ASSET_URLS_STANDARD);
            String string7 = StripeJsonUtils.optString(json, FIELD_PAY_LATER_NAME);
            String string8 = StripeJsonUtils.optString(json, FIELD_PAY_LATER_REDIRECT_URL);
            String string9 = StripeJsonUtils.optString(json, FIELD_PAY_NOW_ASSET_URLS_DESCRIPTIVE);
            String string10 = StripeJsonUtils.optString(json, FIELD_PAY_NOW_ASSET_URLS_STANDARD);
            String string11 = StripeJsonUtils.optString(json, FIELD_PAY_NOW_NAME);
            String string12 = StripeJsonUtils.optString(json, FIELD_PAY_NOW_REDIRECT_URL);
            String string13 = StripeJsonUtils.optString(json, FIELD_PAY_OVER_TIME_ASSET_URLS_DESCRIPTIVE);
            String string14 = StripeJsonUtils.optString(json, FIELD_PAY_OVER_TIME_ASSET_URLS_STANDARD);
            String string15 = StripeJsonUtils.optString(json, FIELD_PAY_OVER_TIME_NAME);
            String string16 = StripeJsonUtils.optString(json, FIELD_PAY_OVER_TIME_REDIRECT_URL);
            Set<String> set = this.parseSet(json, FIELD_PAYMENT_METHOD_CATEGORIES);
            Set<String> set2 = this.parseSet(json, FIELD_CUSTOM_PAYMENT_METHODS);
            return new Source.Klarna(string, string2, string3, string4, string9, string10, string11, string12, string5, string6, string7, string8, string13, string14, string15, string16, set, set2);
        }

        private final Set<String> parseSet(JSONObject json, String key) {
            Set set;
            String string = StripeJsonUtils.optString(json, key);
            if (string == null) {
                set = null;
            } else {
                String[] stringArray = new String[]{","};
                List list = StringsKt.split$default((CharSequence)string, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
                set = list == null ? null : CollectionsKt.toSet((Iterable)list);
            }
            string = set;
            boolean bl = false;
            Object object = string;
            if (object == null) {
                object = SetsKt.emptySet();
            }
            return object;
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0012\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/stripe/android/model/parsers/SourceJsonParser$KlarnaJsonParser$Companion;", "", "()V", "FIELD_CLIENT_TOKEN", "", "FIELD_CUSTOM_PAYMENT_METHODS", "FIELD_FIRST_NAME", "FIELD_LAST_NAME", "FIELD_PAYMENT_METHOD_CATEGORIES", "FIELD_PAY_LATER_ASSET_URLS_DESCRIPTIVE", "FIELD_PAY_LATER_ASSET_URLS_STANDARD", "FIELD_PAY_LATER_NAME", "FIELD_PAY_LATER_REDIRECT_URL", "FIELD_PAY_NOW_ASSET_URLS_DESCRIPTIVE", "FIELD_PAY_NOW_ASSET_URLS_STANDARD", "FIELD_PAY_NOW_NAME", "FIELD_PAY_NOW_REDIRECT_URL", "FIELD_PAY_OVER_TIME_ASSET_URLS_DESCRIPTIVE", "FIELD_PAY_OVER_TIME_ASSET_URLS_STANDARD", "FIELD_PAY_OVER_TIME_NAME", "FIELD_PAY_OVER_TIME_REDIRECT_URL", "FIELD_PURCHASE_COUNTRY", "payments-core_release"})
        private static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0013\n\u0002\u0010\"\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u001b\u001a\u00020\u00042\b\u0010\u001c\u001a\u0004\u0018\u00010\u0004H\u0002J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0010\u0010!\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002J.\u0010\"\u001a\u0004\u0018\u0001H#\"\n\b\u0000\u0010#\u0018\u0001*\u00020$2\u0006\u0010\u001f\u001a\u00020 2\b\b\u0001\u0010%\u001a\u00020\u0004H\u0082\b\u00a2\u0006\u0002\u0010&R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00040\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/stripe/android/model/parsers/SourceJsonParser$Companion;", "", "()V", "FIELD_AMOUNT", "", "FIELD_CLIENT_SECRET", "FIELD_CODE_VERIFICATION", "FIELD_CREATED", "FIELD_CURRENCY", "FIELD_FLOW", "FIELD_ID", "FIELD_KLARNA", "FIELD_LIVEMODE", "FIELD_OBJECT", "FIELD_OWNER", "FIELD_RECEIVER", "FIELD_REDIRECT", "FIELD_SOURCE_ORDER", "FIELD_STATEMENT_DESCRIPTOR", "FIELD_STATUS", "FIELD_TYPE", "FIELD_USAGE", "FIELD_WECHAT", "MODELED_TYPES", "", "VALUE_CARD", "VALUE_SOURCE", "asSourceType", "sourceType", "fromCardJson", "Lcom/stripe/android/model/Source;", "jsonObject", "Lorg/json/JSONObject;", "fromSourceJson", "optStripeJsonModel", "T", "Lcom/stripe/android/model/StripeModel;", "key", "(Lorg/json/JSONObject;Ljava/lang/String;)Lcom/stripe/android/model/StripeModel;", "payments-core_release"})
    private static final class Companion {
        private Companion() {
        }

        private final Source fromCardJson(JSONObject jsonObject) {
            return new Source(StripeJsonUtils.optString(jsonObject, SourceJsonParser.FIELD_ID), null, null, null, null, null, null, null, null, null, null, null, null, new SourceCardDataJsonParser().parse(jsonObject), SourceJsonParser.VALUE_CARD, SourceJsonParser.VALUE_CARD, null, null, null, null, null, 0x1F1FFE, null);
        }

        /*
         * WARNING - void declaration
         */
        private final Source fromSourceJson(JSONObject jsonObject) {
            JSONObject jSONObject;
            WeChat weChat;
            JSONObject jSONObject2;
            SourceOrder sourceOrder;
            StripeModel stripeModel;
            Source.Receiver receiver;
            Source.Owner owner;
            boolean bl;
            Source.Flow flow;
            String string;
            String string2;
            Long l;
            String string3;
            SourceTypeModel sourceTypeModel;
            Object object;
            Object object2;
            Map sourceTypeData;
            String type;
            String typeRaw;
            block192: {
                StripeModel model$iv;
                StripeModel stripeModel2;
                StripeModel stripeModel3;
                String key$iv;
                block191: {
                    StripeModel stripeModel4;
                    Object key$iv2;
                    block189: {
                        StripeModel model$iv2;
                        StripeModel stripeModel5;
                        StripeModel stripeModel6;
                        boolean bl2;
                        Object object3;
                        block188: {
                            StripeModel stripeModel7;
                            Object key$iv3;
                            block186: {
                                StripeModel model$iv3;
                                StripeModel stripeModel8;
                                StripeModel stripeModel9;
                                block185: {
                                    StripeModel stripeModel10;
                                    Object model$iv4;
                                    block183: {
                                        StripeModel model$iv5;
                                        StripeModel stripeModel11;
                                        StripeModel stripeModel12;
                                        void key$iv4;
                                        block182: {
                                            SourceTypeModel sourceTypeModel2;
                                            block181: {
                                                block177: {
                                                    StripeModel stripeModel13;
                                                    block179: {
                                                        StripeModel stripeModel14;
                                                        block178: {
                                                            String string4 = StripeJsonUtils.optString(jsonObject, SourceJsonParser.FIELD_TYPE);
                                                            typeRaw = string4 == null ? "unknown" : string4;
                                                            type = this.asSourceType(typeRaw);
                                                            sourceTypeData = StripeJsonUtils.INSTANCE.jsonObjectToMap$payments_core_release(jsonObject.optJSONObject(typeRaw));
                                                            if (!MODELED_TYPES.contains(typeRaw)) break block177;
                                                            Companion this_$iv = this;
                                                            boolean $i$f$optStripeJsonModel = false;
                                                            if (jsonObject.has(typeRaw)) break block178;
                                                            stripeModel13 = null;
                                                            break block179;
                                                        }
                                                        switch (typeRaw) {
                                                            case "code_verification": {
                                                                Companion it$iv;
                                                                boolean bl3;
                                                                boolean bl4;
                                                                Source.CodeVerification codeVerification;
                                                                object2 = jsonObject.optJSONObject(SourceJsonParser.FIELD_CODE_VERIFICATION);
                                                                if (object2 == null) {
                                                                    codeVerification = null;
                                                                } else {
                                                                    object = object2;
                                                                    bl4 = false;
                                                                    bl3 = false;
                                                                    it$iv = object;
                                                                    boolean bl5 = false;
                                                                    codeVerification = new CodeVerificationJsonParser().parse((JSONObject)it$iv);
                                                                }
                                                                Object object4 = codeVerification;
                                                                break;
                                                            }
                                                            case "owner": {
                                                                Source.Owner owner2;
                                                                Companion it$iv;
                                                                boolean bl3;
                                                                boolean bl4;
                                                                object2 = jsonObject.optJSONObject(SourceJsonParser.FIELD_OWNER);
                                                                if (object2 == null) {
                                                                    owner2 = null;
                                                                } else {
                                                                    object = object2;
                                                                    bl4 = false;
                                                                    bl3 = false;
                                                                    it$iv = object;
                                                                    boolean bl6 = false;
                                                                    owner2 = new OwnerJsonParser().parse((JSONObject)it$iv);
                                                                }
                                                                Object object4 = owner2;
                                                                break;
                                                            }
                                                            case "receiver": {
                                                                Source.Receiver receiver2;
                                                                Companion it$iv;
                                                                boolean bl3;
                                                                boolean bl4;
                                                                object2 = jsonObject.optJSONObject(SourceJsonParser.FIELD_RECEIVER);
                                                                if (object2 == null) {
                                                                    receiver2 = null;
                                                                } else {
                                                                    object = object2;
                                                                    bl4 = false;
                                                                    bl3 = false;
                                                                    it$iv = object;
                                                                    boolean bl7 = false;
                                                                    receiver2 = new ReceiverJsonParser().parse((JSONObject)it$iv);
                                                                }
                                                                Object object4 = receiver2;
                                                                break;
                                                            }
                                                            case "redirect": {
                                                                Source.Redirect redirect;
                                                                Companion it$iv;
                                                                boolean bl3;
                                                                boolean bl4;
                                                                object2 = jsonObject.optJSONObject(SourceJsonParser.FIELD_REDIRECT);
                                                                if (object2 == null) {
                                                                    redirect = null;
                                                                } else {
                                                                    object = object2;
                                                                    bl4 = false;
                                                                    bl3 = false;
                                                                    it$iv = object;
                                                                    boolean bl8 = false;
                                                                    redirect = new RedirectJsonParser().parse((JSONObject)it$iv);
                                                                }
                                                                Object object4 = redirect;
                                                                break;
                                                            }
                                                            case "card": {
                                                                SourceTypeModel.Card card;
                                                                Companion it$iv;
                                                                boolean bl3;
                                                                boolean bl4;
                                                                object2 = jsonObject.optJSONObject(SourceJsonParser.VALUE_CARD);
                                                                if (object2 == null) {
                                                                    card = null;
                                                                } else {
                                                                    object = object2;
                                                                    bl4 = false;
                                                                    bl3 = false;
                                                                    it$iv = object;
                                                                    boolean bl9 = false;
                                                                    card = new SourceCardDataJsonParser().parse((JSONObject)it$iv);
                                                                }
                                                                Object object4 = card;
                                                                break;
                                                            }
                                                            case "sepa_debit": {
                                                                SourceTypeModel.SepaDebit sepaDebit;
                                                                Companion it$iv;
                                                                boolean bl3;
                                                                boolean bl4;
                                                                object2 = jsonObject.optJSONObject("sepa_debit");
                                                                if (object2 == null) {
                                                                    sepaDebit = null;
                                                                } else {
                                                                    object = object2;
                                                                    bl4 = false;
                                                                    bl3 = false;
                                                                    it$iv = object;
                                                                    boolean bl10 = false;
                                                                    sepaDebit = new SourceSepaDebitDataJsonParser().parse((JSONObject)it$iv);
                                                                }
                                                                Object object4 = sepaDebit;
                                                                break;
                                                            }
                                                            default: {
                                                                Object object4 = model$iv4 = (StripeModel)null;
                                                            }
                                                        }
                                                        if (!((stripeModel14 = model$iv4) instanceof SourceTypeModel)) {
                                                            stripeModel14 = null;
                                                        }
                                                        stripeModel13 = (SourceTypeModel)stripeModel14;
                                                    }
                                                    sourceTypeModel2 = (SourceTypeModel)stripeModel13;
                                                    break block181;
                                                }
                                                sourceTypeModel2 = null;
                                            }
                                            sourceTypeModel = sourceTypeModel2;
                                            string3 = StripeJsonUtils.optString(jsonObject, SourceJsonParser.FIELD_ID);
                                            l = StripeJsonUtils.INSTANCE.optLong$payments_core_release(jsonObject, SourceJsonParser.FIELD_AMOUNT);
                                            string2 = StripeJsonUtils.optString(jsonObject, SourceJsonParser.FIELD_CLIENT_SECRET);
                                            object = this;
                                            string = SourceJsonParser.FIELD_CODE_VERIFICATION;
                                            boolean $i$f$optStripeJsonModel = false;
                                            if (jsonObject.has((String)key$iv4)) break block182;
                                            stripeModel10 = null;
                                            break block183;
                                        }
                                        switch (key$iv4) {
                                            case "code_verification": {
                                                Object it$iv;
                                                boolean bl11;
                                                boolean bl12;
                                                Source.CodeVerification codeVerification;
                                                JSONObject jSONObject3 = jsonObject.optJSONObject(SourceJsonParser.FIELD_CODE_VERIFICATION);
                                                if (jSONObject3 == null) {
                                                    codeVerification = null;
                                                } else {
                                                    model$iv4 = jSONObject3;
                                                    bl12 = false;
                                                    bl11 = false;
                                                    it$iv = model$iv4;
                                                    boolean bl13 = false;
                                                    codeVerification = new CodeVerificationJsonParser().parse((JSONObject)it$iv);
                                                }
                                                stripeModel12 = codeVerification;
                                                break;
                                            }
                                            case "owner": {
                                                Source.Owner owner3;
                                                Object it$iv;
                                                boolean bl11;
                                                boolean bl12;
                                                JSONObject jSONObject4 = jsonObject.optJSONObject(SourceJsonParser.FIELD_OWNER);
                                                if (jSONObject4 == null) {
                                                    owner3 = null;
                                                } else {
                                                    model$iv4 = jSONObject4;
                                                    bl12 = false;
                                                    bl11 = false;
                                                    it$iv = model$iv4;
                                                    boolean bl14 = false;
                                                    owner3 = new OwnerJsonParser().parse((JSONObject)it$iv);
                                                }
                                                stripeModel12 = owner3;
                                                break;
                                            }
                                            case "receiver": {
                                                Source.Receiver receiver3;
                                                Object it$iv;
                                                boolean bl11;
                                                boolean bl12;
                                                JSONObject jSONObject5 = jsonObject.optJSONObject(SourceJsonParser.FIELD_RECEIVER);
                                                if (jSONObject5 == null) {
                                                    receiver3 = null;
                                                } else {
                                                    model$iv4 = jSONObject5;
                                                    bl12 = false;
                                                    bl11 = false;
                                                    it$iv = model$iv4;
                                                    boolean bl15 = false;
                                                    receiver3 = new ReceiverJsonParser().parse((JSONObject)it$iv);
                                                }
                                                stripeModel12 = receiver3;
                                                break;
                                            }
                                            case "redirect": {
                                                Source.Redirect redirect;
                                                Object it$iv;
                                                boolean bl11;
                                                boolean bl12;
                                                JSONObject jSONObject6 = jsonObject.optJSONObject(SourceJsonParser.FIELD_REDIRECT);
                                                if (jSONObject6 == null) {
                                                    redirect = null;
                                                } else {
                                                    model$iv4 = jSONObject6;
                                                    bl12 = false;
                                                    bl11 = false;
                                                    it$iv = model$iv4;
                                                    boolean bl16 = false;
                                                    redirect = new RedirectJsonParser().parse((JSONObject)it$iv);
                                                }
                                                stripeModel12 = redirect;
                                                break;
                                            }
                                            case "card": {
                                                SourceTypeModel.Card card;
                                                Object it$iv;
                                                boolean bl11;
                                                boolean bl12;
                                                JSONObject jSONObject7 = jsonObject.optJSONObject(SourceJsonParser.VALUE_CARD);
                                                if (jSONObject7 == null) {
                                                    card = null;
                                                } else {
                                                    model$iv4 = jSONObject7;
                                                    bl12 = false;
                                                    bl11 = false;
                                                    it$iv = model$iv4;
                                                    boolean bl17 = false;
                                                    card = new SourceCardDataJsonParser().parse((JSONObject)it$iv);
                                                }
                                                stripeModel12 = card;
                                                break;
                                            }
                                            case "sepa_debit": {
                                                SourceTypeModel.SepaDebit sepaDebit;
                                                Object it$iv;
                                                boolean bl11;
                                                boolean bl12;
                                                JSONObject jSONObject8 = jsonObject.optJSONObject("sepa_debit");
                                                if (jSONObject8 == null) {
                                                    sepaDebit = null;
                                                } else {
                                                    model$iv4 = jSONObject8;
                                                    bl12 = false;
                                                    bl11 = false;
                                                    it$iv = model$iv4;
                                                    boolean bl18 = false;
                                                    sepaDebit = new SourceSepaDebitDataJsonParser().parse((JSONObject)it$iv);
                                                }
                                                stripeModel12 = sepaDebit;
                                                break;
                                            }
                                            default: {
                                                stripeModel12 = null;
                                            }
                                        }
                                        if (!((stripeModel11 = (model$iv5 = stripeModel12)) instanceof Source.CodeVerification)) {
                                            stripeModel11 = null;
                                        }
                                        stripeModel10 = (Source.CodeVerification)stripeModel11;
                                    }
                                    object2 = (Source.CodeVerification)stripeModel10;
                                    object = StripeJsonUtils.INSTANCE.optLong$payments_core_release(jsonObject, SourceJsonParser.FIELD_CREATED);
                                    string = StripeJsonUtils.optString(jsonObject, SourceJsonParser.FIELD_CURRENCY);
                                    flow = Source.Flow.Companion.fromCode(StripeJsonUtils.optString(jsonObject, SourceJsonParser.FIELD_FLOW));
                                    bl = jsonObject.optBoolean(SourceJsonParser.FIELD_LIVEMODE);
                                    model$iv4 = this;
                                    key$iv3 = SourceJsonParser.FIELD_OWNER;
                                    boolean $i$f$optStripeJsonModel = false;
                                    if (jsonObject.has((String)key$iv3)) break block185;
                                    stripeModel7 = null;
                                    break block186;
                                }
                                switch (key$iv3) {
                                    case "code_verification": {
                                        JSONObject it$iv;
                                        boolean bl19;
                                        Source.CodeVerification codeVerification;
                                        JSONObject bl18 = jsonObject.optJSONObject(SourceJsonParser.FIELD_CODE_VERIFICATION);
                                        if (bl18 == null) {
                                            codeVerification = null;
                                        } else {
                                            object3 = bl18;
                                            bl19 = false;
                                            bl2 = false;
                                            it$iv = object3;
                                            boolean bl20 = false;
                                            codeVerification = new CodeVerificationJsonParser().parse(it$iv);
                                        }
                                        stripeModel9 = codeVerification;
                                        break;
                                    }
                                    case "owner": {
                                        Source.Owner owner4;
                                        JSONObject it$iv;
                                        boolean bl19;
                                        JSONObject bl18 = jsonObject.optJSONObject(SourceJsonParser.FIELD_OWNER);
                                        if (bl18 == null) {
                                            owner4 = null;
                                        } else {
                                            object3 = bl18;
                                            bl19 = false;
                                            bl2 = false;
                                            it$iv = object3;
                                            boolean bl21 = false;
                                            owner4 = new OwnerJsonParser().parse(it$iv);
                                        }
                                        stripeModel9 = owner4;
                                        break;
                                    }
                                    case "receiver": {
                                        Source.Receiver receiver4;
                                        JSONObject it$iv;
                                        boolean bl19;
                                        JSONObject bl18 = jsonObject.optJSONObject(SourceJsonParser.FIELD_RECEIVER);
                                        if (bl18 == null) {
                                            receiver4 = null;
                                        } else {
                                            object3 = bl18;
                                            bl19 = false;
                                            bl2 = false;
                                            it$iv = object3;
                                            boolean bl22 = false;
                                            receiver4 = new ReceiverJsonParser().parse(it$iv);
                                        }
                                        stripeModel9 = receiver4;
                                        break;
                                    }
                                    case "redirect": {
                                        Source.Redirect redirect;
                                        JSONObject it$iv;
                                        boolean bl19;
                                        JSONObject bl18 = jsonObject.optJSONObject(SourceJsonParser.FIELD_REDIRECT);
                                        if (bl18 == null) {
                                            redirect = null;
                                        } else {
                                            object3 = bl18;
                                            bl19 = false;
                                            bl2 = false;
                                            it$iv = object3;
                                            boolean bl23 = false;
                                            redirect = new RedirectJsonParser().parse(it$iv);
                                        }
                                        stripeModel9 = redirect;
                                        break;
                                    }
                                    case "card": {
                                        SourceTypeModel.Card card;
                                        JSONObject it$iv;
                                        boolean bl19;
                                        JSONObject bl18 = jsonObject.optJSONObject(SourceJsonParser.VALUE_CARD);
                                        if (bl18 == null) {
                                            card = null;
                                        } else {
                                            object3 = bl18;
                                            bl19 = false;
                                            bl2 = false;
                                            it$iv = object3;
                                            boolean bl24 = false;
                                            card = new SourceCardDataJsonParser().parse(it$iv);
                                        }
                                        stripeModel9 = card;
                                        break;
                                    }
                                    case "sepa_debit": {
                                        SourceTypeModel.SepaDebit sepaDebit;
                                        JSONObject it$iv;
                                        boolean bl19;
                                        JSONObject bl18 = jsonObject.optJSONObject("sepa_debit");
                                        if (bl18 == null) {
                                            sepaDebit = null;
                                        } else {
                                            object3 = bl18;
                                            bl19 = false;
                                            bl2 = false;
                                            it$iv = object3;
                                            boolean bl25 = false;
                                            sepaDebit = new SourceSepaDebitDataJsonParser().parse(it$iv);
                                        }
                                        stripeModel9 = sepaDebit;
                                        break;
                                    }
                                    default: {
                                        stripeModel9 = null;
                                    }
                                }
                                if (!((stripeModel8 = (model$iv3 = stripeModel9)) instanceof Source.Owner)) {
                                    stripeModel8 = null;
                                }
                                stripeModel7 = (Source.Owner)stripeModel8;
                            }
                            owner = (Source.Owner)stripeModel7;
                            key$iv3 = this;
                            key$iv2 = SourceJsonParser.FIELD_RECEIVER;
                            boolean $i$f$optStripeJsonModel = false;
                            if (jsonObject.has((String)key$iv2)) break block188;
                            stripeModel4 = null;
                            break block189;
                        }
                        switch (key$iv2) {
                            case "code_verification": {
                                Source.CodeVerification codeVerification;
                                object3 = jsonObject.optJSONObject(SourceJsonParser.FIELD_CODE_VERIFICATION);
                                if (object3 == null) {
                                    codeVerification = null;
                                } else {
                                    Object object5 = object3;
                                    bl2 = false;
                                    boolean it$iv8 = false;
                                    Object it$iv2 = object5;
                                    boolean bl26 = false;
                                    codeVerification = new CodeVerificationJsonParser().parse((JSONObject)it$iv2);
                                }
                                stripeModel6 = codeVerification;
                                break;
                            }
                            case "owner": {
                                Source.Owner owner5;
                                object3 = jsonObject.optJSONObject(SourceJsonParser.FIELD_OWNER);
                                if (object3 == null) {
                                    owner5 = null;
                                } else {
                                    Object object6 = object3;
                                    bl2 = false;
                                    boolean it$iv8 = false;
                                    Object it$iv3 = object6;
                                    boolean bl27 = false;
                                    owner5 = new OwnerJsonParser().parse((JSONObject)it$iv3);
                                }
                                stripeModel6 = owner5;
                                break;
                            }
                            case "receiver": {
                                Source.Receiver receiver5;
                                object3 = jsonObject.optJSONObject(SourceJsonParser.FIELD_RECEIVER);
                                if (object3 == null) {
                                    receiver5 = null;
                                } else {
                                    Object object7 = object3;
                                    bl2 = false;
                                    boolean it$iv8 = false;
                                    Object it$iv4 = object7;
                                    boolean bl28 = false;
                                    receiver5 = new ReceiverJsonParser().parse((JSONObject)it$iv4);
                                }
                                stripeModel6 = receiver5;
                                break;
                            }
                            case "redirect": {
                                Source.Redirect redirect;
                                object3 = jsonObject.optJSONObject(SourceJsonParser.FIELD_REDIRECT);
                                if (object3 == null) {
                                    redirect = null;
                                } else {
                                    Object object8 = object3;
                                    bl2 = false;
                                    boolean it$iv8 = false;
                                    Object it$iv5 = object8;
                                    boolean bl29 = false;
                                    redirect = new RedirectJsonParser().parse((JSONObject)it$iv5);
                                }
                                stripeModel6 = redirect;
                                break;
                            }
                            case "card": {
                                SourceTypeModel.Card card;
                                object3 = jsonObject.optJSONObject(SourceJsonParser.VALUE_CARD);
                                if (object3 == null) {
                                    card = null;
                                } else {
                                    Object object9 = object3;
                                    bl2 = false;
                                    boolean it$iv8 = false;
                                    Object it$iv6 = object9;
                                    boolean bl30 = false;
                                    card = new SourceCardDataJsonParser().parse((JSONObject)it$iv6);
                                }
                                stripeModel6 = card;
                                break;
                            }
                            case "sepa_debit": {
                                SourceTypeModel.SepaDebit sepaDebit;
                                object3 = jsonObject.optJSONObject("sepa_debit");
                                if (object3 == null) {
                                    sepaDebit = null;
                                } else {
                                    Object object10 = object3;
                                    bl2 = false;
                                    boolean it$iv8 = false;
                                    Object it$iv7 = object10;
                                    boolean bl31 = false;
                                    sepaDebit = new SourceSepaDebitDataJsonParser().parse((JSONObject)it$iv7);
                                }
                                stripeModel6 = sepaDebit;
                                break;
                            }
                            default: {
                                stripeModel6 = null;
                            }
                        }
                        if (!((stripeModel5 = (model$iv2 = stripeModel6)) instanceof Source.Receiver)) {
                            stripeModel5 = null;
                        }
                        stripeModel4 = (Source.Receiver)stripeModel5;
                    }
                    receiver = (Source.Receiver)stripeModel4;
                    key$iv2 = this;
                    key$iv = SourceJsonParser.FIELD_REDIRECT;
                    boolean $i$f$optStripeJsonModel = false;
                    if (jsonObject.has(key$iv)) break block191;
                    stripeModel = null;
                    break block192;
                }
                switch (key$iv) {
                    case "code_verification": {
                        JSONObject it$iv;
                        Source.CodeVerification codeVerification;
                        JSONObject jSONObject9 = jsonObject.optJSONObject(SourceJsonParser.FIELD_CODE_VERIFICATION);
                        if (jSONObject9 == null) {
                            codeVerification = null;
                        } else {
                            JSONObject jSONObject10 = jSONObject9;
                            boolean it$iv8 = false;
                            boolean bl32 = false;
                            it$iv = jSONObject10;
                            boolean bl33 = false;
                            codeVerification = new CodeVerificationJsonParser().parse(it$iv);
                        }
                        stripeModel3 = codeVerification;
                        break;
                    }
                    case "owner": {
                        Source.Owner owner6;
                        JSONObject it$iv;
                        JSONObject jSONObject11 = jsonObject.optJSONObject(SourceJsonParser.FIELD_OWNER);
                        if (jSONObject11 == null) {
                            owner6 = null;
                        } else {
                            JSONObject jSONObject12 = jSONObject11;
                            boolean it$iv8 = false;
                            boolean bl34 = false;
                            it$iv = jSONObject12;
                            boolean bl35 = false;
                            owner6 = new OwnerJsonParser().parse(it$iv);
                        }
                        stripeModel3 = owner6;
                        break;
                    }
                    case "receiver": {
                        Source.Receiver receiver6;
                        JSONObject it$iv;
                        JSONObject jSONObject13 = jsonObject.optJSONObject(SourceJsonParser.FIELD_RECEIVER);
                        if (jSONObject13 == null) {
                            receiver6 = null;
                        } else {
                            JSONObject jSONObject14 = jSONObject13;
                            boolean it$iv8 = false;
                            boolean bl36 = false;
                            it$iv = jSONObject14;
                            boolean bl37 = false;
                            receiver6 = new ReceiverJsonParser().parse(it$iv);
                        }
                        stripeModel3 = receiver6;
                        break;
                    }
                    case "redirect": {
                        Source.Redirect redirect;
                        JSONObject it$iv;
                        JSONObject jSONObject15 = jsonObject.optJSONObject(SourceJsonParser.FIELD_REDIRECT);
                        if (jSONObject15 == null) {
                            redirect = null;
                        } else {
                            JSONObject jSONObject16 = jSONObject15;
                            boolean it$iv8 = false;
                            boolean bl38 = false;
                            it$iv = jSONObject16;
                            boolean bl39 = false;
                            redirect = new RedirectJsonParser().parse(it$iv);
                        }
                        stripeModel3 = redirect;
                        break;
                    }
                    case "card": {
                        SourceTypeModel.Card card;
                        JSONObject it$iv;
                        JSONObject jSONObject17 = jsonObject.optJSONObject(SourceJsonParser.VALUE_CARD);
                        if (jSONObject17 == null) {
                            card = null;
                        } else {
                            JSONObject jSONObject18 = jSONObject17;
                            boolean it$iv8 = false;
                            boolean bl40 = false;
                            it$iv = jSONObject18;
                            boolean bl41 = false;
                            card = new SourceCardDataJsonParser().parse(it$iv);
                        }
                        stripeModel3 = card;
                        break;
                    }
                    case "sepa_debit": {
                        SourceTypeModel.SepaDebit sepaDebit;
                        JSONObject it$iv;
                        JSONObject jSONObject19 = jsonObject.optJSONObject("sepa_debit");
                        if (jSONObject19 == null) {
                            sepaDebit = null;
                        } else {
                            JSONObject jSONObject20 = jSONObject19;
                            boolean it$iv8 = false;
                            boolean bl42 = false;
                            it$iv = jSONObject20;
                            boolean bl43 = false;
                            sepaDebit = new SourceSepaDebitDataJsonParser().parse(it$iv);
                        }
                        stripeModel3 = sepaDebit;
                        break;
                    }
                    default: {
                        stripeModel3 = null;
                    }
                }
                if (!((stripeModel2 = (model$iv = stripeModel3)) instanceof Source.Redirect)) {
                    stripeModel2 = null;
                }
                stripeModel = (Source.Redirect)stripeModel2;
            }
            Source.Redirect redirect = (Source.Redirect)stripeModel;
            Object object11 = jsonObject.optJSONObject(SourceJsonParser.FIELD_SOURCE_ORDER);
            if (object11 == null) {
                sourceOrder = null;
            } else {
                JSONObject jSONObject21 = object11;
                boolean bl44 = false;
                boolean bl45 = false;
                JSONObject it = jSONObject21;
                boolean bl46 = false;
                sourceOrder = new SourceOrderJsonParser().parse(it);
            }
            SourceOrder sourceOrder2 = sourceOrder;
            object11 = StripeJsonUtils.optString(jsonObject, SourceJsonParser.FIELD_STATEMENT_DESCRIPTOR);
            Source.Status status = Source.Status.Companion.fromCode(StripeJsonUtils.optString(jsonObject, SourceJsonParser.FIELD_STATUS));
            Source.Usage usage = Source.Usage.Companion.fromCode(StripeJsonUtils.optString(jsonObject, SourceJsonParser.FIELD_USAGE));
            WeChat weChat2 = Intrinsics.areEqual((Object)SourceJsonParser.FIELD_WECHAT, (Object)type) ? new WeChatJsonParser().parse((jSONObject2 = jsonObject.optJSONObject(SourceJsonParser.FIELD_WECHAT)) == null ? new JSONObject() : jSONObject2) : (weChat = (WeChat)null);
            Source.Klarna klarna = Intrinsics.areEqual((Object)SourceJsonParser.FIELD_KLARNA, (Object)type) ? new KlarnaJsonParser().parse((jSONObject = jsonObject.optJSONObject(SourceJsonParser.FIELD_KLARNA)) == null ? new JSONObject() : jSONObject) : (Source.Klarna)null;
            return new Source(string3, l, string2, (Source.CodeVerification)object2, (Long)object, string, flow, bl, owner, receiver, redirect, status, sourceTypeData, sourceTypeModel, type, typeRaw, usage, weChat, klarna, sourceOrder2, (String)object11);
        }

        private final /* synthetic */ <T extends StripeModel> T optStripeJsonModel(JSONObject jsonObject, @Size(min=1L) String key) {
            StripeModel stripeModel;
            boolean $i$f$optStripeJsonModel = false;
            if (!jsonObject.has(key)) {
                return null;
            }
            switch (key) {
                case "code_verification": {
                    JSONObject it;
                    boolean bl;
                    boolean bl2;
                    JSONObject jSONObject;
                    Source.CodeVerification codeVerification;
                    JSONObject jSONObject2 = jsonObject.optJSONObject(SourceJsonParser.FIELD_CODE_VERIFICATION);
                    if (jSONObject2 == null) {
                        codeVerification = null;
                    } else {
                        jSONObject = jSONObject2;
                        bl2 = false;
                        bl = false;
                        it = jSONObject;
                        boolean bl3 = false;
                        codeVerification = new CodeVerificationJsonParser().parse(it);
                    }
                    stripeModel = codeVerification;
                    break;
                }
                case "owner": {
                    Source.Owner owner;
                    JSONObject it;
                    boolean bl;
                    boolean bl2;
                    JSONObject jSONObject;
                    JSONObject jSONObject2 = jsonObject.optJSONObject(SourceJsonParser.FIELD_OWNER);
                    if (jSONObject2 == null) {
                        owner = null;
                    } else {
                        jSONObject = jSONObject2;
                        bl2 = false;
                        bl = false;
                        it = jSONObject;
                        boolean bl4 = false;
                        owner = new OwnerJsonParser().parse(it);
                    }
                    stripeModel = owner;
                    break;
                }
                case "receiver": {
                    Source.Receiver receiver;
                    JSONObject it;
                    boolean bl;
                    boolean bl2;
                    JSONObject jSONObject;
                    JSONObject jSONObject2 = jsonObject.optJSONObject(SourceJsonParser.FIELD_RECEIVER);
                    if (jSONObject2 == null) {
                        receiver = null;
                    } else {
                        jSONObject = jSONObject2;
                        bl2 = false;
                        bl = false;
                        it = jSONObject;
                        boolean bl5 = false;
                        receiver = new ReceiverJsonParser().parse(it);
                    }
                    stripeModel = receiver;
                    break;
                }
                case "redirect": {
                    Source.Redirect redirect;
                    JSONObject it;
                    boolean bl;
                    boolean bl2;
                    JSONObject jSONObject;
                    JSONObject jSONObject2 = jsonObject.optJSONObject(SourceJsonParser.FIELD_REDIRECT);
                    if (jSONObject2 == null) {
                        redirect = null;
                    } else {
                        jSONObject = jSONObject2;
                        bl2 = false;
                        bl = false;
                        it = jSONObject;
                        boolean bl6 = false;
                        redirect = new RedirectJsonParser().parse(it);
                    }
                    stripeModel = redirect;
                    break;
                }
                case "card": {
                    SourceTypeModel.Card card;
                    JSONObject it;
                    boolean bl;
                    boolean bl2;
                    JSONObject jSONObject;
                    JSONObject jSONObject2 = jsonObject.optJSONObject(SourceJsonParser.VALUE_CARD);
                    if (jSONObject2 == null) {
                        card = null;
                    } else {
                        jSONObject = jSONObject2;
                        bl2 = false;
                        bl = false;
                        it = jSONObject;
                        boolean bl7 = false;
                        card = new SourceCardDataJsonParser().parse(it);
                    }
                    stripeModel = card;
                    break;
                }
                case "sepa_debit": {
                    SourceTypeModel.SepaDebit sepaDebit;
                    JSONObject it;
                    boolean bl;
                    boolean bl2;
                    JSONObject jSONObject;
                    JSONObject jSONObject2 = jsonObject.optJSONObject("sepa_debit");
                    if (jSONObject2 == null) {
                        sepaDebit = null;
                    } else {
                        jSONObject = jSONObject2;
                        bl2 = false;
                        bl = false;
                        it = jSONObject;
                        boolean bl8 = false;
                        sepaDebit = new SourceSepaDebitDataJsonParser().parse(it);
                    }
                    stripeModel = sepaDebit;
                    break;
                }
                default: {
                    stripeModel = null;
                }
            }
            StripeModel model = stripeModel;
            Intrinsics.reifiedOperationMarker((int)2, (String)"T");
            return (T)model;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final String asSourceType(String sourceType) {
            String string = sourceType;
            if (string == null) return "unknown";
            int n = -1;
            switch (string.hashCode()) {
                case 38358441: {
                    if (string.equals("giropay")) {
                        n = 1;
                    }
                    break;
                }
                case 100048981: {
                    if (string.equals("ideal")) {
                        n = 2;
                    }
                    break;
                }
                case -1414960566: {
                    if (string.equals("alipay")) {
                        n = 3;
                    }
                    break;
                }
                case -791770330: {
                    if (string.equals(SourceJsonParser.FIELD_WECHAT)) {
                        n = 4;
                    }
                    break;
                }
                case 100648: {
                    if (string.equals("eps")) {
                        n = 5;
                    }
                    break;
                }
                case -896955097: {
                    if (string.equals("sofort")) {
                        n = 6;
                    }
                    break;
                }
                case -284840886: {
                    if (string.equals("unknown")) {
                        n = 7;
                    }
                    break;
                }
                case -1920743119: {
                    if (string.equals("bancontact")) {
                        n = 8;
                    }
                    break;
                }
                case 109234: {
                    if (string.equals("p24")) {
                        n = 9;
                    }
                    break;
                }
                case -1128905083: {
                    if (string.equals(SourceJsonParser.FIELD_KLARNA)) {
                        n = 10;
                    }
                    break;
                }
                case 1636477296: {
                    if (string.equals("sepa_debit")) {
                        n = 11;
                    }
                    break;
                }
                case -825238221: {
                    if (string.equals("three_d_secure")) {
                        n = 12;
                    }
                    break;
                }
                case 3046160: {
                    if (string.equals(SourceJsonParser.VALUE_CARD)) {
                        n = 13;
                    }
                    break;
                }
                case 1251821346: {
                    if (string.equals("multibanco")) {
                        n = 14;
                    }
                    break;
                }
            }
            switch (n) {
                case 13: {
                    return SourceJsonParser.VALUE_CARD;
                }
                case 12: {
                    return "three_d_secure";
                }
                case 1: {
                    return "giropay";
                }
                case 11: {
                    return "sepa_debit";
                }
                case 2: {
                    return "ideal";
                }
                case 6: {
                    return "sofort";
                }
                case 8: {
                    return "bancontact";
                }
                case 3: {
                    return "alipay";
                }
                case 5: {
                    return "eps";
                }
                case 9: {
                    return "p24";
                }
                case 14: {
                    return "multibanco";
                }
                case 4: {
                    return SourceJsonParser.FIELD_WECHAT;
                }
                case 7: {
                    return "unknown";
                }
                case 10: {
                    return SourceJsonParser.FIELD_KLARNA;
                }
                default: {
                    return "unknown";
                }
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

