/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.model;

import android.os.Parcel;
import android.os.Parcelable;
import com.stripe.android.model.StripeIntent;
import java.io.ByteArrayInputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlinx.parcelize.Parcelize;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0081\b\u0018\u00002\u00020\u0001:\u0001$B\u000f\b\u0010\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B'\b\u0000\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u0012\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\nH\u00c6\u0003J1\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u00062\b\b\u0002\u0010\b\u001a\u00020\u00062\b\b\u0002\u0010\t\u001a\u00020\nH\u00c6\u0001J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u00d6\u0003J\t\u0010\u001d\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u001e\u001a\u00020\u0006H\u00d6\u0001J\u0019\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0018H\u00d6\u0001R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\b\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000f\u00a8\u0006%"}, d2={"Lcom/stripe/android/model/Stripe3ds2Fingerprint;", "Landroid/os/Parcelable;", "sdkData", "Lcom/stripe/android/model/StripeIntent$NextActionData$SdkData$Use3DS2;", "(Lcom/stripe/android/model/StripeIntent$NextActionData$SdkData$Use3DS2;)V", "source", "", "directoryServerName", "serverTransactionId", "directoryServerEncryption", "Lcom/stripe/android/model/Stripe3ds2Fingerprint$DirectoryServerEncryption;", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lcom/stripe/android/model/Stripe3ds2Fingerprint$DirectoryServerEncryption;)V", "getDirectoryServerEncryption", "()Lcom/stripe/android/model/Stripe3ds2Fingerprint$DirectoryServerEncryption;", "getDirectoryServerName", "()Ljava/lang/String;", "getServerTransactionId", "getSource", "component1", "component2", "component3", "component4", "copy", "describeContents", "", "equals", "", "other", "", "hashCode", "toString", "writeToParcel", "", "parcel", "Landroid/os/Parcel;", "flags", "DirectoryServerEncryption", "payments-core_release"})
@Parcelize
public final class Stripe3ds2Fingerprint
implements Parcelable {
    @NotNull
    private final String source;
    @NotNull
    private final String directoryServerName;
    @NotNull
    private final String serverTransactionId;
    @NotNull
    private final DirectoryServerEncryption directoryServerEncryption;
    @NotNull
    public static final Parcelable.Creator<Stripe3ds2Fingerprint> CREATOR;

    public Stripe3ds2Fingerprint(@NotNull String source, @NotNull String directoryServerName, @NotNull String serverTransactionId, @NotNull DirectoryServerEncryption directoryServerEncryption) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)directoryServerName, (String)"directoryServerName");
        Intrinsics.checkNotNullParameter((Object)serverTransactionId, (String)"serverTransactionId");
        Intrinsics.checkNotNullParameter((Object)directoryServerEncryption, (String)"directoryServerEncryption");
        this.source = source;
        this.directoryServerName = directoryServerName;
        this.serverTransactionId = serverTransactionId;
        this.directoryServerEncryption = directoryServerEncryption;
    }

    @NotNull
    public final String getSource() {
        return this.source;
    }

    @NotNull
    public final String getDirectoryServerName() {
        return this.directoryServerName;
    }

    @NotNull
    public final String getServerTransactionId() {
        return this.serverTransactionId;
    }

    @NotNull
    public final DirectoryServerEncryption getDirectoryServerEncryption() {
        return this.directoryServerEncryption;
    }

    public Stripe3ds2Fingerprint(@NotNull StripeIntent.NextActionData.SdkData.Use3DS2 sdkData) throws CertificateException {
        Intrinsics.checkNotNullParameter((Object)sdkData, (String)"sdkData");
        this(sdkData.getSource(), sdkData.getServerName(), sdkData.getTransactionId(), new DirectoryServerEncryption(sdkData.getServerEncryption().getDirectoryServerId(), sdkData.getServerEncryption().getDsCertificateData(), sdkData.getServerEncryption().getRootCertsData(), sdkData.getServerEncryption().getKeyId()));
    }

    @NotNull
    public final String component1() {
        return this.source;
    }

    @NotNull
    public final String component2() {
        return this.directoryServerName;
    }

    @NotNull
    public final String component3() {
        return this.serverTransactionId;
    }

    @NotNull
    public final DirectoryServerEncryption component4() {
        return this.directoryServerEncryption;
    }

    @NotNull
    public final Stripe3ds2Fingerprint copy(@NotNull String source, @NotNull String directoryServerName, @NotNull String serverTransactionId, @NotNull DirectoryServerEncryption directoryServerEncryption) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)directoryServerName, (String)"directoryServerName");
        Intrinsics.checkNotNullParameter((Object)serverTransactionId, (String)"serverTransactionId");
        Intrinsics.checkNotNullParameter((Object)directoryServerEncryption, (String)"directoryServerEncryption");
        return new Stripe3ds2Fingerprint(source, directoryServerName, serverTransactionId, directoryServerEncryption);
    }

    public static /* synthetic */ Stripe3ds2Fingerprint copy$default(Stripe3ds2Fingerprint stripe3ds2Fingerprint, String string, String string2, String string3, DirectoryServerEncryption directoryServerEncryption, int n, Object object) {
        if ((n & 1) != 0) {
            string = stripe3ds2Fingerprint.source;
        }
        if ((n & 2) != 0) {
            string2 = stripe3ds2Fingerprint.directoryServerName;
        }
        if ((n & 4) != 0) {
            string3 = stripe3ds2Fingerprint.serverTransactionId;
        }
        if ((n & 8) != 0) {
            directoryServerEncryption = stripe3ds2Fingerprint.directoryServerEncryption;
        }
        return stripe3ds2Fingerprint.copy(string, string2, string3, directoryServerEncryption);
    }

    @NotNull
    public String toString() {
        return "Stripe3ds2Fingerprint(source=" + this.source + ", directoryServerName=" + this.directoryServerName + ", serverTransactionId=" + this.serverTransactionId + ", directoryServerEncryption=" + this.directoryServerEncryption + ')';
    }

    public int hashCode() {
        int result2 = this.source.hashCode();
        result2 = result2 * 31 + this.directoryServerName.hashCode();
        result2 = result2 * 31 + this.serverTransactionId.hashCode();
        result2 = result2 * 31 + this.directoryServerEncryption.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Stripe3ds2Fingerprint)) {
            return false;
        }
        Stripe3ds2Fingerprint stripe3ds2Fingerprint = (Stripe3ds2Fingerprint)other;
        if (!Intrinsics.areEqual((Object)this.source, (Object)stripe3ds2Fingerprint.source)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.directoryServerName, (Object)stripe3ds2Fingerprint.directoryServerName)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.serverTransactionId, (Object)stripe3ds2Fingerprint.serverTransactionId)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.directoryServerEncryption, (Object)stripe3ds2Fingerprint.directoryServerEncryption);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(@NotNull Parcel out, int flags) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        out.writeString(this.source);
        out.writeString(this.directoryServerName);
        out.writeString(this.serverTransactionId);
        this.directoryServerEncryption.writeToParcel(out, flags);
    }

    static {
        @Metadata(mv={1, 5, 1}, k=3, xi=48)
        public final class Creator
        implements Parcelable.Creator<Stripe3ds2Fingerprint> {
            @NotNull
            public final Stripe3ds2Fingerprint[] newArray(int size) {
                return new Stripe3ds2Fingerprint[size];
            }

            @NotNull
            public final Stripe3ds2Fingerprint createFromParcel(@NotNull Parcel parcel) {
                Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
                return new Stripe3ds2Fingerprint(parcel.readString(), parcel.readString(), parcel.readString(), (DirectoryServerEncryption)DirectoryServerEncryption.CREATOR.createFromParcel(parcel));
            }
        }
        CREATOR = new Creator();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0081\b\u0018\u0000 '2\u00020\u0001:\u0001'B/\b\u0010\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\bB/\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\n\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\rJ\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\nH\u00c6\u0003J\u000f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\f0\u0006H\u00c6\u0003J\u000b\u0010\u0018\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J9\u0010\u0019\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\t\u001a\u00020\n2\u000e\b\u0002\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001J\u0013\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u00d6\u0003J\t\u0010 \u001a\u00020\u001bH\u00d6\u0001J\t\u0010!\u001a\u00020\u0003H\u00d6\u0001J\u0019\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u001bH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000fR\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006("}, d2={"Lcom/stripe/android/model/Stripe3ds2Fingerprint$DirectoryServerEncryption;", "Landroid/os/Parcelable;", "directoryServerId", "", "dsCertificateData", "rootCertsData", "", "keyId", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/List;Ljava/lang/String;)V", "directoryServerPublicKey", "Ljava/security/PublicKey;", "rootCerts", "Ljava/security/cert/X509Certificate;", "(Ljava/lang/String;Ljava/security/PublicKey;Ljava/util/List;Ljava/lang/String;)V", "getDirectoryServerId", "()Ljava/lang/String;", "getDirectoryServerPublicKey", "()Ljava/security/PublicKey;", "getKeyId", "getRootCerts", "()Ljava/util/List;", "component1", "component2", "component3", "component4", "copy", "describeContents", "", "equals", "", "other", "", "hashCode", "toString", "writeToParcel", "", "parcel", "Landroid/os/Parcel;", "flags", "Companion", "payments-core_release"})
    @Parcelize
    public static final class DirectoryServerEncryption
    implements Parcelable {
        @NotNull
        private static final Companion Companion = new Companion(null);
        @NotNull
        private final String directoryServerId;
        @NotNull
        private final PublicKey directoryServerPublicKey;
        @NotNull
        private final List<X509Certificate> rootCerts;
        @Nullable
        private final String keyId;
        @NotNull
        public static final Parcelable.Creator<DirectoryServerEncryption> CREATOR;

        public DirectoryServerEncryption(@NotNull String directoryServerId, @NotNull PublicKey directoryServerPublicKey, @NotNull List<? extends X509Certificate> rootCerts, @Nullable String keyId) {
            Intrinsics.checkNotNullParameter((Object)directoryServerId, (String)"directoryServerId");
            Intrinsics.checkNotNullParameter((Object)directoryServerPublicKey, (String)"directoryServerPublicKey");
            Intrinsics.checkNotNullParameter(rootCerts, (String)"rootCerts");
            this.directoryServerId = directoryServerId;
            this.directoryServerPublicKey = directoryServerPublicKey;
            this.rootCerts = rootCerts;
            this.keyId = keyId;
        }

        @NotNull
        public final String getDirectoryServerId() {
            return this.directoryServerId;
        }

        @NotNull
        public final PublicKey getDirectoryServerPublicKey() {
            return this.directoryServerPublicKey;
        }

        @NotNull
        public final List<X509Certificate> getRootCerts() {
            return this.rootCerts;
        }

        @Nullable
        public final String getKeyId() {
            return this.keyId;
        }

        public DirectoryServerEncryption(@NotNull String directoryServerId, @NotNull String dsCertificateData, @NotNull List<String> rootCertsData, @Nullable String keyId) {
            Intrinsics.checkNotNullParameter((Object)directoryServerId, (String)"directoryServerId");
            Intrinsics.checkNotNullParameter((Object)dsCertificateData, (String)"dsCertificateData");
            Intrinsics.checkNotNullParameter(rootCertsData, (String)"rootCertsData");
            PublicKey publicKey = DirectoryServerEncryption.Companion.generateCertificate(dsCertificateData).getPublicKey();
            Intrinsics.checkNotNullExpressionValue((Object)publicKey, (String)"generateCertificate(dsCertificateData).publicKey");
            this(directoryServerId, publicKey, DirectoryServerEncryption.Companion.generateCertificates(rootCertsData), keyId);
        }

        @NotNull
        public final String component1() {
            return this.directoryServerId;
        }

        @NotNull
        public final PublicKey component2() {
            return this.directoryServerPublicKey;
        }

        @NotNull
        public final List<X509Certificate> component3() {
            return this.rootCerts;
        }

        @Nullable
        public final String component4() {
            return this.keyId;
        }

        @NotNull
        public final DirectoryServerEncryption copy(@NotNull String directoryServerId, @NotNull PublicKey directoryServerPublicKey, @NotNull List<? extends X509Certificate> rootCerts, @Nullable String keyId) {
            Intrinsics.checkNotNullParameter((Object)directoryServerId, (String)"directoryServerId");
            Intrinsics.checkNotNullParameter((Object)directoryServerPublicKey, (String)"directoryServerPublicKey");
            Intrinsics.checkNotNullParameter(rootCerts, (String)"rootCerts");
            return new DirectoryServerEncryption(directoryServerId, directoryServerPublicKey, rootCerts, keyId);
        }

        public static /* synthetic */ DirectoryServerEncryption copy$default(DirectoryServerEncryption directoryServerEncryption, String string, PublicKey publicKey, List list, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = directoryServerEncryption.directoryServerId;
            }
            if ((n & 2) != 0) {
                publicKey = directoryServerEncryption.directoryServerPublicKey;
            }
            if ((n & 4) != 0) {
                list = directoryServerEncryption.rootCerts;
            }
            if ((n & 8) != 0) {
                string2 = directoryServerEncryption.keyId;
            }
            return directoryServerEncryption.copy(string, publicKey, list, string2);
        }

        @NotNull
        public String toString() {
            return "DirectoryServerEncryption(directoryServerId=" + this.directoryServerId + ", directoryServerPublicKey=" + this.directoryServerPublicKey + ", rootCerts=" + this.rootCerts + ", keyId=" + this.keyId + ')';
        }

        public int hashCode() {
            int result2 = this.directoryServerId.hashCode();
            result2 = result2 * 31 + this.directoryServerPublicKey.hashCode();
            result2 = result2 * 31 + ((Object)this.rootCerts).hashCode();
            result2 = result2 * 31 + (this.keyId == null ? 0 : this.keyId.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof DirectoryServerEncryption)) {
                return false;
            }
            DirectoryServerEncryption directoryServerEncryption = (DirectoryServerEncryption)other;
            if (!Intrinsics.areEqual((Object)this.directoryServerId, (Object)directoryServerEncryption.directoryServerId)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.directoryServerPublicKey, (Object)directoryServerEncryption.directoryServerPublicKey)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.rootCerts, directoryServerEncryption.rootCerts)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.keyId, (Object)directoryServerEncryption.keyId);
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(@NotNull Parcel out, int flags) {
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            out.writeString(this.directoryServerId);
            out.writeSerializable((Serializable)this.directoryServerPublicKey);
            List<X509Certificate> list = this.rootCerts;
            out.writeInt(list.size());
            Iterator<X509Certificate> iterator = list.iterator();
            while (iterator.hasNext()) {
                out.writeSerializable((Serializable)iterator.next());
            }
            out.writeString(this.keyId);
        }

        static {
            @Metadata(mv={1, 5, 1}, k=3, xi=48)
            public final class Creator
            implements Parcelable.Creator<DirectoryServerEncryption> {
                @NotNull
                public final DirectoryServerEncryption[] newArray(int size) {
                    return new DirectoryServerEncryption[size];
                }

                @NotNull
                public final DirectoryServerEncryption createFromParcel(@NotNull Parcel parcel) {
                    Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
                    int n = parcel.readInt();
                    ArrayList<Serializable> arrayList = new ArrayList<Serializable>(n);
                    PublicKey publicKey = (PublicKey)parcel.readSerializable();
                    String string = parcel.readString();
                    for (int i = 0; i != n; ++i) {
                        arrayList.add(parcel.readSerializable());
                    }
                    String string2 = parcel.readString();
                    List list = arrayList;
                    PublicKey publicKey2 = publicKey;
                    String string3 = string;
                    return new DirectoryServerEncryption(string3, publicKey2, list, string2);
                }
            }
            CREATOR = new Creator();
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u001c\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\bH\u0002\u00a8\u0006\n"}, d2={"Lcom/stripe/android/model/Stripe3ds2Fingerprint$DirectoryServerEncryption$Companion;", "", "()V", "generateCertificate", "Ljava/security/cert/X509Certificate;", "certificateData", "", "generateCertificates", "", "certificatesData", "payments-core_release"})
        private static final class Companion {
            private Companion() {
            }

            /*
             * WARNING - void declaration
             */
            private final List<X509Certificate> generateCertificates(List<String> certificatesData) throws CertificateException {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = certificatesData;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    String string = (String)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    X509Certificate x509Certificate = Companion.generateCertificate((String)it);
                    collection.add(x509Certificate);
                }
                return (List)destination$iv$iv;
            }

            private final X509Certificate generateCertificate(String certificateData) throws CertificateException {
                CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                String string = certificateData;
                Charset charset = Charsets.UTF_8;
                boolean bl = false;
                String string2 = string;
                if (string2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                byte[] byArray = string2.getBytes(charset);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
                Certificate certificate = certificateFactory.generateCertificate(new ByteArrayInputStream(byArray));
                if (certificate == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.security.cert.X509Certificate");
                }
                return (X509Certificate)certificate;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

