/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.model;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.RestrictTo;
import androidx.compose.runtime.internal.StabilityInferred;
import com.stripe.android.model.Address;
import com.stripe.android.model.PaymentMethod;
import com.stripe.android.model.StripeIntent;
import com.stripe.android.model.StripeModel;
import com.stripe.android.model.parsers.PaymentIntentJsonParser;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlinx.parcelize.Parcelize;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u001b\n\u0002\u0018\u0002\n\u0002\b'\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u0087\b\u0018\u0000 x2\u00020\u0001:\u0007uvwxyz{B\u00f1\u0001\b\u0000\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0007\u0012\b\u0010\u0011\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0013\u001a\u00020\u0014\u0012\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u0016\u0012\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u001a\u0012\n\b\u0002\u0010\u001b\u001a\u0004\u0018\u00010\u001c\u0012\n\b\u0002\u0010\u001d\u001a\u0004\u0018\u00010\u001e\u0012\n\b\u0002\u0010\u001f\u001a\u0004\u0018\u00010 \u0012\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u0012\n\b\u0002\u0010\"\u001a\u0004\u0018\u00010#\u00a2\u0006\u0002\u0010$J\u000b\u0010O\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010P\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010Q\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010R\u001a\u00020\u0014H\u00c6\u0003J\u000b\u0010S\u001a\u0004\u0018\u00010\u0016H\u00c6\u0003J\u000b\u0010T\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010U\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010V\u001a\u0004\u0018\u00010\u001aH\u00c6\u0003J\u000b\u0010W\u001a\u0004\u0018\u00010\u001cH\u00c6\u0003J\u000b\u0010X\u001a\u0004\u0018\u00010\u001eH\u00c6\u0003J\u000b\u0010Y\u001a\u0004\u0018\u00010 H\u00c6\u0003J\u000f\u0010Z\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0003J\u000f\u0010[\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0003J\u000b\u0010\\\u001a\u0004\u0018\u00010#H\u00c6\u0003J\u0010\u0010]\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003\u00a2\u0006\u0002\u0010&J\t\u0010^\u001a\u00020\u0007H\u00c6\u0003J\u000b\u0010_\u001a\u0004\u0018\u00010\nH\u00c6\u0003J\t\u0010`\u001a\u00020\fH\u00c6\u0003J\u000b\u0010a\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010b\u001a\u00020\u000fH\u00c6\u0003J\t\u0010c\u001a\u00020\u0007H\u00c6\u0003J\u0088\u0002\u0010d\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\b\u0002\u0010\b\u001a\u00020\u00072\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n2\b\b\u0002\u0010\u000b\u001a\u00020\f2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u00072\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0013\u001a\u00020\u00142\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u00162\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\n\b\u0002\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\n\b\u0002\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\n\b\u0002\u0010\u001f\u001a\u0004\u0018\u00010 2\u000e\b\u0002\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00030\u00052\n\b\u0002\u0010\"\u001a\u0004\u0018\u00010#H\u00c6\u0001\u00a2\u0006\u0002\u0010eJ\t\u0010f\u001a\u00020gH\u00d6\u0001J\u0013\u0010h\u001a\u00020\u00142\b\u0010i\u001a\u0004\u0018\u00010jH\u00d6\u0003J\t\u0010k\u001a\u00020gH\u00d6\u0001J\b\u0010l\u001a\u00020\u0014H\u0007J\b\u0010m\u001a\u00020\u0014H\u0016J\b\u0010n\u001a\u00020\u0014H\u0016J\t\u0010o\u001a\u00020\u0003H\u00d6\u0001J\u0019\u0010p\u001a\u00020q2\u0006\u0010r\u001a\u00020s2\u0006\u0010t\u001a\u00020gH\u00d6\u0001R\u0015\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\n\n\u0002\u0010'\u001a\u0004\b%\u0010&R\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u0013\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010-R\u0016\u0010\r\u001a\u0004\u0018\u00010\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010/R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u00101R\u0014\u0010\u0010\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u0010)R\u0013\u0010\u0011\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u0010/R\u0016\u0010\u0012\u001a\u0004\u0018\u00010\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u0010/R\u0016\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u0010/R\u0014\u00106\u001a\u00020\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b6\u00107R\u0014\u0010\u0013\u001a\u00020\u0014X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u00107R\u0016\u00108\u001a\u0004\u0018\u00010\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b9\u0010/R\u0013\u0010\u001d\u001a\u0004\u0018\u00010\u001e\u00a2\u0006\b\n\u0000\u001a\u0004\b:\u0010;R\u0016\u0010\"\u001a\u0004\u0018\u00010#X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b<\u0010=R\u0016\u0010>\u001a\u0004\u0018\u00010?8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b@\u0010AR\u0016\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bB\u0010CR\u0016\u0010\u0017\u001a\u0004\u0018\u00010\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bD\u0010/R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bE\u0010FR\u0013\u0010\u0018\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\bG\u0010/R\u0013\u0010\u001b\u001a\u0004\u0018\u00010\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\bH\u0010IR\u0013\u0010\u001f\u001a\u0004\u0018\u00010 \u00a2\u0006\b\n\u0000\u001a\u0004\bJ\u0010KR\u0016\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bL\u0010MR\u001a\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bN\u0010F\u00a8\u0006|"}, d2={"Lcom/stripe/android/model/PaymentIntent;", "Lcom/stripe/android/model/StripeIntent;", "id", "", "paymentMethodTypes", "", "amount", "", "canceledAt", "cancellationReason", "Lcom/stripe/android/model/PaymentIntent$CancellationReason;", "captureMethod", "Lcom/stripe/android/model/PaymentIntent$CaptureMethod;", "clientSecret", "confirmationMethod", "Lcom/stripe/android/model/PaymentIntent$ConfirmationMethod;", "created", "currency", "description", "isLiveMode", "", "paymentMethod", "Lcom/stripe/android/model/PaymentMethod;", "paymentMethodId", "receiptEmail", "status", "Lcom/stripe/android/model/StripeIntent$Status;", "setupFutureUsage", "Lcom/stripe/android/model/StripeIntent$Usage;", "lastPaymentError", "Lcom/stripe/android/model/PaymentIntent$Error;", "shipping", "Lcom/stripe/android/model/PaymentIntent$Shipping;", "unactivatedPaymentMethods", "nextActionData", "Lcom/stripe/android/model/StripeIntent$NextActionData;", "(Ljava/lang/String;Ljava/util/List;Ljava/lang/Long;JLcom/stripe/android/model/PaymentIntent$CancellationReason;Lcom/stripe/android/model/PaymentIntent$CaptureMethod;Ljava/lang/String;Lcom/stripe/android/model/PaymentIntent$ConfirmationMethod;JLjava/lang/String;Ljava/lang/String;ZLcom/stripe/android/model/PaymentMethod;Ljava/lang/String;Ljava/lang/String;Lcom/stripe/android/model/StripeIntent$Status;Lcom/stripe/android/model/StripeIntent$Usage;Lcom/stripe/android/model/PaymentIntent$Error;Lcom/stripe/android/model/PaymentIntent$Shipping;Ljava/util/List;Lcom/stripe/android/model/StripeIntent$NextActionData;)V", "getAmount", "()Ljava/lang/Long;", "Ljava/lang/Long;", "getCanceledAt", "()J", "getCancellationReason", "()Lcom/stripe/android/model/PaymentIntent$CancellationReason;", "getCaptureMethod", "()Lcom/stripe/android/model/PaymentIntent$CaptureMethod;", "getClientSecret", "()Ljava/lang/String;", "getConfirmationMethod", "()Lcom/stripe/android/model/PaymentIntent$ConfirmationMethod;", "getCreated", "getCurrency", "getDescription", "getId", "isConfirmed", "()Z", "lastErrorMessage", "getLastErrorMessage", "getLastPaymentError", "()Lcom/stripe/android/model/PaymentIntent$Error;", "getNextActionData", "()Lcom/stripe/android/model/StripeIntent$NextActionData;", "nextActionType", "Lcom/stripe/android/model/StripeIntent$NextActionType;", "getNextActionType", "()Lcom/stripe/android/model/StripeIntent$NextActionType;", "getPaymentMethod", "()Lcom/stripe/android/model/PaymentMethod;", "getPaymentMethodId", "getPaymentMethodTypes", "()Ljava/util/List;", "getReceiptEmail", "getSetupFutureUsage", "()Lcom/stripe/android/model/StripeIntent$Usage;", "getShipping", "()Lcom/stripe/android/model/PaymentIntent$Shipping;", "getStatus", "()Lcom/stripe/android/model/StripeIntent$Status;", "getUnactivatedPaymentMethods", "component1", "component10", "component11", "component12", "component13", "component14", "component15", "component16", "component17", "component18", "component19", "component2", "component20", "component21", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "(Ljava/lang/String;Ljava/util/List;Ljava/lang/Long;JLcom/stripe/android/model/PaymentIntent$CancellationReason;Lcom/stripe/android/model/PaymentIntent$CaptureMethod;Ljava/lang/String;Lcom/stripe/android/model/PaymentIntent$ConfirmationMethod;JLjava/lang/String;Ljava/lang/String;ZLcom/stripe/android/model/PaymentMethod;Ljava/lang/String;Ljava/lang/String;Lcom/stripe/android/model/StripeIntent$Status;Lcom/stripe/android/model/StripeIntent$Usage;Lcom/stripe/android/model/PaymentIntent$Error;Lcom/stripe/android/model/PaymentIntent$Shipping;Ljava/util/List;Lcom/stripe/android/model/StripeIntent$NextActionData;)Lcom/stripe/android/model/PaymentIntent;", "describeContents", "", "equals", "other", "", "hashCode", "isSetupFutureUsageSet", "requiresAction", "requiresConfirmation", "toString", "writeToParcel", "", "parcel", "Landroid/os/Parcel;", "flags", "CancellationReason", "CaptureMethod", "ClientSecret", "Companion", "ConfirmationMethod", "Error", "Shipping", "payments-core_release"})
@Parcelize
@StabilityInferred(parameters=0)
public final class PaymentIntent
implements StripeIntent {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final String id;
    @NotNull
    private final List<String> paymentMethodTypes;
    @Nullable
    private final Long amount;
    private final long canceledAt;
    @Nullable
    private final CancellationReason cancellationReason;
    @NotNull
    private final CaptureMethod captureMethod;
    @Nullable
    private final String clientSecret;
    @NotNull
    private final ConfirmationMethod confirmationMethod;
    private final long created;
    @Nullable
    private final String currency;
    @Nullable
    private final String description;
    private final boolean isLiveMode;
    @Nullable
    private final PaymentMethod paymentMethod;
    @Nullable
    private final String paymentMethodId;
    @Nullable
    private final String receiptEmail;
    @Nullable
    private final StripeIntent.Status status;
    @Nullable
    private final StripeIntent.Usage setupFutureUsage;
    @Nullable
    private final Error lastPaymentError;
    @Nullable
    private final Shipping shipping;
    @NotNull
    private final List<String> unactivatedPaymentMethods;
    @Nullable
    private final StripeIntent.NextActionData nextActionData;
    @NotNull
    public static final Parcelable.Creator<PaymentIntent> CREATOR;
    public static final int $stable;

    public PaymentIntent(@Nullable String id2, @NotNull List<String> paymentMethodTypes, @Nullable Long amount, long canceledAt, @Nullable CancellationReason cancellationReason, @NotNull CaptureMethod captureMethod, @Nullable String clientSecret, @NotNull ConfirmationMethod confirmationMethod, long created, @Nullable String currency, @Nullable String description, boolean isLiveMode, @Nullable PaymentMethod paymentMethod, @Nullable String paymentMethodId, @Nullable String receiptEmail, @Nullable StripeIntent.Status status, @Nullable StripeIntent.Usage setupFutureUsage, @Nullable Error lastPaymentError, @Nullable Shipping shipping, @NotNull List<String> unactivatedPaymentMethods, @Nullable StripeIntent.NextActionData nextActionData) {
        Intrinsics.checkNotNullParameter(paymentMethodTypes, (String)"paymentMethodTypes");
        Intrinsics.checkNotNullParameter((Object)((Object)captureMethod), (String)"captureMethod");
        Intrinsics.checkNotNullParameter((Object)((Object)confirmationMethod), (String)"confirmationMethod");
        Intrinsics.checkNotNullParameter(unactivatedPaymentMethods, (String)"unactivatedPaymentMethods");
        this.id = id2;
        this.paymentMethodTypes = paymentMethodTypes;
        this.amount = amount;
        this.canceledAt = canceledAt;
        this.cancellationReason = cancellationReason;
        this.captureMethod = captureMethod;
        this.clientSecret = clientSecret;
        this.confirmationMethod = confirmationMethod;
        this.created = created;
        this.currency = currency;
        this.description = description;
        this.isLiveMode = isLiveMode;
        this.paymentMethod = paymentMethod;
        this.paymentMethodId = paymentMethodId;
        this.receiptEmail = receiptEmail;
        this.status = status;
        this.setupFutureUsage = setupFutureUsage;
        this.lastPaymentError = lastPaymentError;
        this.shipping = shipping;
        this.unactivatedPaymentMethods = unactivatedPaymentMethods;
        this.nextActionData = nextActionData;
    }

    public /* synthetic */ PaymentIntent(String string, List list, Long l, long l2, CancellationReason cancellationReason, CaptureMethod captureMethod, String string2, ConfirmationMethod confirmationMethod, long l3, String string3, String string4, boolean bl, PaymentMethod paymentMethod, String string5, String string6, StripeIntent.Status status, StripeIntent.Usage usage, Error error, Shipping shipping, List list2, StripeIntent.NextActionData nextActionData, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            l2 = 0L;
        }
        if ((n & 0x10) != 0) {
            cancellationReason = null;
        }
        if ((n & 0x20) != 0) {
            captureMethod = CaptureMethod.Automatic;
        }
        if ((n & 0x80) != 0) {
            confirmationMethod = ConfirmationMethod.Automatic;
        }
        if ((n & 0x400) != 0) {
            string4 = null;
        }
        if ((n & 0x1000) != 0) {
            paymentMethod = null;
        }
        if ((n & 0x2000) != 0) {
            string5 = null;
        }
        if ((n & 0x4000) != 0) {
            string6 = null;
        }
        if ((n & 0x8000) != 0) {
            status = null;
        }
        if ((n & 0x10000) != 0) {
            usage = null;
        }
        if ((n & 0x20000) != 0) {
            error = null;
        }
        if ((n & 0x40000) != 0) {
            shipping = null;
        }
        if ((n & 0x100000) != 0) {
            nextActionData = null;
        }
        this(string, list, l, l2, cancellationReason, captureMethod, string2, confirmationMethod, l3, string3, string4, bl, paymentMethod, string5, string6, status, usage, error, shipping, list2, nextActionData);
    }

    @Override
    @Nullable
    public String getId() {
        return this.id;
    }

    @Override
    @NotNull
    public List<String> getPaymentMethodTypes() {
        return this.paymentMethodTypes;
    }

    @Nullable
    public final Long getAmount() {
        return this.amount;
    }

    public final long getCanceledAt() {
        return this.canceledAt;
    }

    @Nullable
    public final CancellationReason getCancellationReason() {
        return this.cancellationReason;
    }

    @NotNull
    public final CaptureMethod getCaptureMethod() {
        return this.captureMethod;
    }

    @Override
    @Nullable
    public String getClientSecret() {
        return this.clientSecret;
    }

    @NotNull
    public final ConfirmationMethod getConfirmationMethod() {
        return this.confirmationMethod;
    }

    @Override
    public long getCreated() {
        return this.created;
    }

    @Nullable
    public final String getCurrency() {
        return this.currency;
    }

    @Override
    @Nullable
    public String getDescription() {
        return this.description;
    }

    @Override
    public boolean isLiveMode() {
        return this.isLiveMode;
    }

    @Override
    @Nullable
    public PaymentMethod getPaymentMethod() {
        return this.paymentMethod;
    }

    @Override
    @Nullable
    public String getPaymentMethodId() {
        return this.paymentMethodId;
    }

    @Nullable
    public final String getReceiptEmail() {
        return this.receiptEmail;
    }

    @Override
    @Nullable
    public StripeIntent.Status getStatus() {
        return this.status;
    }

    @Nullable
    public final StripeIntent.Usage getSetupFutureUsage() {
        return this.setupFutureUsage;
    }

    @Nullable
    public final Error getLastPaymentError() {
        return this.lastPaymentError;
    }

    @Nullable
    public final Shipping getShipping() {
        return this.shipping;
    }

    @Override
    @NotNull
    public List<String> getUnactivatedPaymentMethods() {
        return this.unactivatedPaymentMethods;
    }

    @Override
    @Nullable
    public StripeIntent.NextActionData getNextActionData() {
        return this.nextActionData;
    }

    @Override
    @Nullable
    public StripeIntent.NextActionType getNextActionType() {
        StripeIntent.NextActionData nextActionData = this.getNextActionData();
        return nextActionData instanceof StripeIntent.NextActionData.SdkData ? StripeIntent.NextActionType.UseStripeSdk : (nextActionData instanceof StripeIntent.NextActionData.RedirectToUrl ? StripeIntent.NextActionType.RedirectToUrl : (nextActionData instanceof StripeIntent.NextActionData.DisplayOxxoDetails ? StripeIntent.NextActionType.DisplayOxxoDetails : null));
    }

    @Override
    public boolean isConfirmed() {
        StripeIntent.Status[] statusArray = new StripeIntent.Status[]{StripeIntent.Status.Processing, StripeIntent.Status.RequiresCapture, StripeIntent.Status.Succeeded};
        return CollectionsKt.contains((Iterable)SetsKt.setOf((Object[])statusArray), (Object)((Object)this.getStatus()));
    }

    @Override
    @Nullable
    public String getLastErrorMessage() {
        Error error = this.lastPaymentError;
        return error == null ? null : error.getMessage();
    }

    @Override
    public boolean requiresAction() {
        return this.getStatus() == StripeIntent.Status.RequiresAction;
    }

    @Override
    public boolean requiresConfirmation() {
        return this.getStatus() == StripeIntent.Status.RequiresConfirmation;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public final boolean isSetupFutureUsageSet() {
        boolean bl;
        StripeIntent.Usage usage = this.setupFutureUsage;
        int n = usage == null ? -1 : WhenMappings.$EnumSwitchMapping$0[usage.ordinal()];
        switch (n) {
            case 1: {
                bl = true;
                break;
            }
            case 2: {
                bl = true;
                break;
            }
            case 3: {
                bl = false;
                break;
            }
            case -1: {
                bl = false;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return bl;
    }

    @Nullable
    public final String component1() {
        return this.getId();
    }

    @NotNull
    public final List<String> component2() {
        return this.getPaymentMethodTypes();
    }

    @Nullable
    public final Long component3() {
        return this.amount;
    }

    public final long component4() {
        return this.canceledAt;
    }

    @Nullable
    public final CancellationReason component5() {
        return this.cancellationReason;
    }

    @NotNull
    public final CaptureMethod component6() {
        return this.captureMethod;
    }

    @Nullable
    public final String component7() {
        return this.getClientSecret();
    }

    @NotNull
    public final ConfirmationMethod component8() {
        return this.confirmationMethod;
    }

    public final long component9() {
        return this.getCreated();
    }

    @Nullable
    public final String component10() {
        return this.currency;
    }

    @Nullable
    public final String component11() {
        return this.getDescription();
    }

    public final boolean component12() {
        return this.isLiveMode();
    }

    @Nullable
    public final PaymentMethod component13() {
        return this.getPaymentMethod();
    }

    @Nullable
    public final String component14() {
        return this.getPaymentMethodId();
    }

    @Nullable
    public final String component15() {
        return this.receiptEmail;
    }

    @Nullable
    public final StripeIntent.Status component16() {
        return this.getStatus();
    }

    @Nullable
    public final StripeIntent.Usage component17() {
        return this.setupFutureUsage;
    }

    @Nullable
    public final Error component18() {
        return this.lastPaymentError;
    }

    @Nullable
    public final Shipping component19() {
        return this.shipping;
    }

    @NotNull
    public final List<String> component20() {
        return this.getUnactivatedPaymentMethods();
    }

    @Nullable
    public final StripeIntent.NextActionData component21() {
        return this.getNextActionData();
    }

    @NotNull
    public final PaymentIntent copy(@Nullable String id2, @NotNull List<String> paymentMethodTypes, @Nullable Long amount, long canceledAt, @Nullable CancellationReason cancellationReason, @NotNull CaptureMethod captureMethod, @Nullable String clientSecret, @NotNull ConfirmationMethod confirmationMethod, long created, @Nullable String currency, @Nullable String description, boolean isLiveMode, @Nullable PaymentMethod paymentMethod, @Nullable String paymentMethodId, @Nullable String receiptEmail, @Nullable StripeIntent.Status status, @Nullable StripeIntent.Usage setupFutureUsage, @Nullable Error lastPaymentError, @Nullable Shipping shipping, @NotNull List<String> unactivatedPaymentMethods, @Nullable StripeIntent.NextActionData nextActionData) {
        Intrinsics.checkNotNullParameter(paymentMethodTypes, (String)"paymentMethodTypes");
        Intrinsics.checkNotNullParameter((Object)((Object)captureMethod), (String)"captureMethod");
        Intrinsics.checkNotNullParameter((Object)((Object)confirmationMethod), (String)"confirmationMethod");
        Intrinsics.checkNotNullParameter(unactivatedPaymentMethods, (String)"unactivatedPaymentMethods");
        return new PaymentIntent(id2, paymentMethodTypes, amount, canceledAt, cancellationReason, captureMethod, clientSecret, confirmationMethod, created, currency, description, isLiveMode, paymentMethod, paymentMethodId, receiptEmail, status, setupFutureUsage, lastPaymentError, shipping, unactivatedPaymentMethods, nextActionData);
    }

    public static /* synthetic */ PaymentIntent copy$default(PaymentIntent paymentIntent, String string, List list, Long l, long l2, CancellationReason cancellationReason, CaptureMethod captureMethod, String string2, ConfirmationMethod confirmationMethod, long l3, String string3, String string4, boolean bl, PaymentMethod paymentMethod, String string5, String string6, StripeIntent.Status status, StripeIntent.Usage usage, Error error, Shipping shipping, List list2, StripeIntent.NextActionData nextActionData, int n, Object object) {
        if ((n & 1) != 0) {
            string = paymentIntent.getId();
        }
        if ((n & 2) != 0) {
            list = paymentIntent.getPaymentMethodTypes();
        }
        if ((n & 4) != 0) {
            l = paymentIntent.amount;
        }
        if ((n & 8) != 0) {
            l2 = paymentIntent.canceledAt;
        }
        if ((n & 0x10) != 0) {
            cancellationReason = paymentIntent.cancellationReason;
        }
        if ((n & 0x20) != 0) {
            captureMethod = paymentIntent.captureMethod;
        }
        if ((n & 0x40) != 0) {
            string2 = paymentIntent.getClientSecret();
        }
        if ((n & 0x80) != 0) {
            confirmationMethod = paymentIntent.confirmationMethod;
        }
        if ((n & 0x100) != 0) {
            l3 = paymentIntent.getCreated();
        }
        if ((n & 0x200) != 0) {
            string3 = paymentIntent.currency;
        }
        if ((n & 0x400) != 0) {
            string4 = paymentIntent.getDescription();
        }
        if ((n & 0x800) != 0) {
            bl = paymentIntent.isLiveMode();
        }
        if ((n & 0x1000) != 0) {
            paymentMethod = paymentIntent.getPaymentMethod();
        }
        if ((n & 0x2000) != 0) {
            string5 = paymentIntent.getPaymentMethodId();
        }
        if ((n & 0x4000) != 0) {
            string6 = paymentIntent.receiptEmail;
        }
        if ((n & 0x8000) != 0) {
            status = paymentIntent.getStatus();
        }
        if ((n & 0x10000) != 0) {
            usage = paymentIntent.setupFutureUsage;
        }
        if ((n & 0x20000) != 0) {
            error = paymentIntent.lastPaymentError;
        }
        if ((n & 0x40000) != 0) {
            shipping = paymentIntent.shipping;
        }
        if ((n & 0x80000) != 0) {
            list2 = paymentIntent.getUnactivatedPaymentMethods();
        }
        if ((n & 0x100000) != 0) {
            nextActionData = paymentIntent.getNextActionData();
        }
        return paymentIntent.copy(string, list, l, l2, cancellationReason, captureMethod, string2, confirmationMethod, l3, string3, string4, bl, paymentMethod, string5, string6, status, usage, error, shipping, list2, nextActionData);
    }

    @NotNull
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("PaymentIntent(id=").append((Object)this.getId()).append(", paymentMethodTypes=").append(this.getPaymentMethodTypes()).append(", amount=").append(this.amount).append(", canceledAt=").append(this.canceledAt).append(", cancellationReason=").append((Object)this.cancellationReason).append(", captureMethod=").append((Object)this.captureMethod).append(", clientSecret=").append((Object)this.getClientSecret()).append(", confirmationMethod=").append((Object)this.confirmationMethod).append(", created=").append(this.getCreated()).append(", currency=").append((Object)this.currency).append(", description=").append((Object)this.getDescription()).append(", isLiveMode=");
        stringBuilder.append(this.isLiveMode()).append(", paymentMethod=").append(this.getPaymentMethod()).append(", paymentMethodId=").append((Object)this.getPaymentMethodId()).append(", receiptEmail=").append((Object)this.receiptEmail).append(", status=").append((Object)this.getStatus()).append(", setupFutureUsage=").append((Object)this.setupFutureUsage).append(", lastPaymentError=").append(this.lastPaymentError).append(", shipping=").append(this.shipping).append(", unactivatedPaymentMethods=").append(this.getUnactivatedPaymentMethods()).append(", nextActionData=").append(this.getNextActionData()).append(')');
        return stringBuilder.toString();
    }

    @Override
    public int hashCode() {
        int result2 = this.getId() == null ? 0 : this.getId().hashCode();
        result2 = result2 * 31 + ((Object)this.getPaymentMethodTypes()).hashCode();
        result2 = result2 * 31 + (this.amount == null ? 0 : ((Object)this.amount).hashCode());
        result2 = result2 * 31 + Long.hashCode(this.canceledAt);
        result2 = result2 * 31 + (this.cancellationReason == null ? 0 : this.cancellationReason.hashCode());
        result2 = result2 * 31 + this.captureMethod.hashCode();
        result2 = result2 * 31 + (this.getClientSecret() == null ? 0 : this.getClientSecret().hashCode());
        result2 = result2 * 31 + this.confirmationMethod.hashCode();
        result2 = result2 * 31 + Long.hashCode(this.getCreated());
        result2 = result2 * 31 + (this.currency == null ? 0 : this.currency.hashCode());
        result2 = result2 * 31 + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        int n = this.isLiveMode() ? 1 : 0;
        if (n != 0) {
            n = 1;
        }
        result2 = result2 * 31 + n;
        result2 = result2 * 31 + (this.getPaymentMethod() == null ? 0 : this.getPaymentMethod().hashCode());
        result2 = result2 * 31 + (this.getPaymentMethodId() == null ? 0 : this.getPaymentMethodId().hashCode());
        result2 = result2 * 31 + (this.receiptEmail == null ? 0 : this.receiptEmail.hashCode());
        result2 = result2 * 31 + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        result2 = result2 * 31 + (this.setupFutureUsage == null ? 0 : this.setupFutureUsage.hashCode());
        result2 = result2 * 31 + (this.lastPaymentError == null ? 0 : this.lastPaymentError.hashCode());
        result2 = result2 * 31 + (this.shipping == null ? 0 : this.shipping.hashCode());
        result2 = result2 * 31 + ((Object)this.getUnactivatedPaymentMethods()).hashCode();
        result2 = result2 * 31 + (this.getNextActionData() == null ? 0 : this.getNextActionData().hashCode());
        return result2;
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PaymentIntent)) {
            return false;
        }
        PaymentIntent paymentIntent = (PaymentIntent)other;
        if (!Intrinsics.areEqual((Object)this.getId(), (Object)paymentIntent.getId())) {
            return false;
        }
        if (!Intrinsics.areEqual(this.getPaymentMethodTypes(), paymentIntent.getPaymentMethodTypes())) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.amount, (Object)paymentIntent.amount)) {
            return false;
        }
        if (this.canceledAt != paymentIntent.canceledAt) {
            return false;
        }
        if (this.cancellationReason != paymentIntent.cancellationReason) {
            return false;
        }
        if (this.captureMethod != paymentIntent.captureMethod) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.getClientSecret(), (Object)paymentIntent.getClientSecret())) {
            return false;
        }
        if (this.confirmationMethod != paymentIntent.confirmationMethod) {
            return false;
        }
        if (this.getCreated() != paymentIntent.getCreated()) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.currency, (Object)paymentIntent.currency)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.getDescription(), (Object)paymentIntent.getDescription())) {
            return false;
        }
        if (this.isLiveMode() != paymentIntent.isLiveMode()) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.getPaymentMethod(), (Object)paymentIntent.getPaymentMethod())) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.getPaymentMethodId(), (Object)paymentIntent.getPaymentMethodId())) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.receiptEmail, (Object)paymentIntent.receiptEmail)) {
            return false;
        }
        if (this.getStatus() != paymentIntent.getStatus()) {
            return false;
        }
        if (this.setupFutureUsage != paymentIntent.setupFutureUsage) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.lastPaymentError, (Object)paymentIntent.lastPaymentError)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.shipping, (Object)paymentIntent.shipping)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.getUnactivatedPaymentMethods(), paymentIntent.getUnactivatedPaymentMethods())) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.getNextActionData(), (Object)paymentIntent.getNextActionData());
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(@NotNull Parcel out, int flags) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        out.writeString(this.id);
        out.writeStringList(this.paymentMethodTypes);
        Object object = this.amount;
        if (object == null) {
            out.writeInt(0);
        } else {
            out.writeInt(1);
            out.writeLong(((Long)object).longValue());
        }
        out.writeLong(this.canceledAt);
        object = this.cancellationReason;
        if (object == null) {
            out.writeInt(0);
        } else {
            out.writeInt(1);
            out.writeString(((Enum)object).name());
        }
        out.writeString(this.captureMethod.name());
        out.writeString(this.clientSecret);
        out.writeString(this.confirmationMethod.name());
        out.writeLong(this.created);
        out.writeString(this.currency);
        out.writeString(this.description);
        out.writeInt(this.isLiveMode ? 1 : 0);
        object = this.paymentMethod;
        if (object == null) {
            out.writeInt(0);
        } else {
            out.writeInt(1);
            ((PaymentMethod)object).writeToParcel(out, flags);
        }
        out.writeString(this.paymentMethodId);
        out.writeString(this.receiptEmail);
        object = this.status;
        if (object == null) {
            out.writeInt(0);
        } else {
            out.writeInt(1);
            out.writeString(((Enum)object).name());
        }
        object = this.setupFutureUsage;
        if (object == null) {
            out.writeInt(0);
        } else {
            out.writeInt(1);
            out.writeString(((Enum)object).name());
        }
        object = this.lastPaymentError;
        if (object == null) {
            out.writeInt(0);
        } else {
            out.writeInt(1);
            ((Error)object).writeToParcel(out, flags);
        }
        object = this.shipping;
        if (object == null) {
            out.writeInt(0);
        } else {
            out.writeInt(1);
            ((Shipping)object).writeToParcel(out, flags);
        }
        out.writeStringList(this.unactivatedPaymentMethods);
        out.writeParcelable((Parcelable)this.nextActionData, flags);
    }

    @JvmStatic
    @Nullable
    public static final PaymentIntent fromJson(@Nullable JSONObject jsonObject) {
        return Companion.fromJson(jsonObject);
    }

    static {
        @Metadata(mv={1, 5, 1}, k=3, xi=48)
        public final class Creator
        implements Parcelable.Creator<PaymentIntent> {
            @NotNull
            public final PaymentIntent[] newArray(int size) {
                return new PaymentIntent[size];
            }

            @NotNull
            public final PaymentIntent createFromParcel(@NotNull Parcel parcel) {
                Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
                return new PaymentIntent(parcel.readString(), parcel.createStringArrayList(), parcel.readInt() == 0 ? null : Long.valueOf(parcel.readLong()), parcel.readLong(), parcel.readInt() == 0 ? null : CancellationReason.valueOf(parcel.readString()), CaptureMethod.valueOf(parcel.readString()), parcel.readString(), ConfirmationMethod.valueOf(parcel.readString()), parcel.readLong(), parcel.readString(), parcel.readString(), parcel.readInt() != 0, (PaymentMethod)(parcel.readInt() == 0 ? null : PaymentMethod.CREATOR.createFromParcel(parcel)), parcel.readString(), parcel.readString(), parcel.readInt() == 0 ? null : StripeIntent.Status.valueOf(parcel.readString()), parcel.readInt() == 0 ? null : StripeIntent.Usage.valueOf(parcel.readString()), (Error)(parcel.readInt() == 0 ? null : Error.CREATOR.createFromParcel(parcel)), (Shipping)(parcel.readInt() == 0 ? null : Shipping.CREATOR.createFromParcel(parcel)), parcel.createStringArrayList(), (StripeIntent.NextActionData)parcel.readParcelable(PaymentIntent.class.getClassLoader()));
            }
        }
        CREATOR = new Creator();
        $stable = 8;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0016\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0087\b\u0018\u0000 /2\u00020\u0001:\u0002/0BW\b\u0000\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0002\u0010\rJ\u000b\u0010\u0019\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u001a\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u001b\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u001c\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u001d\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u001e\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u001f\u001a\u0004\u0018\u00010\nH\u00c6\u0003J\u000b\u0010 \u001a\u0004\u0018\u00010\fH\u00c6\u0003Ji\u0010!\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00c6\u0001J\t\u0010\"\u001a\u00020#H\u00d6\u0001J\u0013\u0010$\u001a\u00020%2\b\u0010&\u001a\u0004\u0018\u00010'H\u00d6\u0003J\t\u0010(\u001a\u00020#H\u00d6\u0001J\t\u0010)\u001a\u00020\u0003H\u00d6\u0001J\u0019\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020#H\u00d6\u0001R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000fR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000fR\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000fR\u0013\u0010\b\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u000fR\u0013\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0013\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u00061"}, d2={"Lcom/stripe/android/model/PaymentIntent$Error;", "Lcom/stripe/android/model/StripeModel;", "charge", "", "code", "declineCode", "docUrl", "message", "param", "paymentMethod", "Lcom/stripe/android/model/PaymentMethod;", "type", "Lcom/stripe/android/model/PaymentIntent$Error$Type;", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lcom/stripe/android/model/PaymentMethod;Lcom/stripe/android/model/PaymentIntent$Error$Type;)V", "getCharge", "()Ljava/lang/String;", "getCode", "getDeclineCode", "getDocUrl", "getMessage", "getParam", "getPaymentMethod", "()Lcom/stripe/android/model/PaymentMethod;", "getType", "()Lcom/stripe/android/model/PaymentIntent$Error$Type;", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "copy", "describeContents", "", "equals", "", "other", "", "hashCode", "toString", "writeToParcel", "", "parcel", "Landroid/os/Parcel;", "flags", "Companion", "Type", "payments-core_release"})
    @Parcelize
    @StabilityInferred(parameters=0)
    public static final class Error
    implements StripeModel {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @Nullable
        private final String charge;
        @Nullable
        private final String code;
        @Nullable
        private final String declineCode;
        @Nullable
        private final String docUrl;
        @Nullable
        private final String message;
        @Nullable
        private final String param;
        @Nullable
        private final PaymentMethod paymentMethod;
        @Nullable
        private final Type type;
        @NotNull
        public static final Parcelable.Creator<Error> CREATOR;
        public static final int $stable;
        @NotNull
        public static final String CODE_AUTHENTICATION_ERROR = "payment_intent_authentication_failure";

        public Error(@Nullable String charge, @Nullable String code, @Nullable String declineCode, @Nullable String docUrl, @Nullable String message, @Nullable String param, @Nullable PaymentMethod paymentMethod, @Nullable Type type) {
            this.charge = charge;
            this.code = code;
            this.declineCode = declineCode;
            this.docUrl = docUrl;
            this.message = message;
            this.param = param;
            this.paymentMethod = paymentMethod;
            this.type = type;
        }

        @Nullable
        public final String getCharge() {
            return this.charge;
        }

        @Nullable
        public final String getCode() {
            return this.code;
        }

        @Nullable
        public final String getDeclineCode() {
            return this.declineCode;
        }

        @Nullable
        public final String getDocUrl() {
            return this.docUrl;
        }

        @Nullable
        public final String getMessage() {
            return this.message;
        }

        @Nullable
        public final String getParam() {
            return this.param;
        }

        @Nullable
        public final PaymentMethod getPaymentMethod() {
            return this.paymentMethod;
        }

        @Nullable
        public final Type getType() {
            return this.type;
        }

        @Nullable
        public final String component1() {
            return this.charge;
        }

        @Nullable
        public final String component2() {
            return this.code;
        }

        @Nullable
        public final String component3() {
            return this.declineCode;
        }

        @Nullable
        public final String component4() {
            return this.docUrl;
        }

        @Nullable
        public final String component5() {
            return this.message;
        }

        @Nullable
        public final String component6() {
            return this.param;
        }

        @Nullable
        public final PaymentMethod component7() {
            return this.paymentMethod;
        }

        @Nullable
        public final Type component8() {
            return this.type;
        }

        @NotNull
        public final Error copy(@Nullable String charge, @Nullable String code, @Nullable String declineCode, @Nullable String docUrl, @Nullable String message, @Nullable String param, @Nullable PaymentMethod paymentMethod, @Nullable Type type) {
            return new Error(charge, code, declineCode, docUrl, message, param, paymentMethod, type);
        }

        public static /* synthetic */ Error copy$default(Error error, String string, String string2, String string3, String string4, String string5, String string6, PaymentMethod paymentMethod, Type type, int n, Object object) {
            if ((n & 1) != 0) {
                string = error.charge;
            }
            if ((n & 2) != 0) {
                string2 = error.code;
            }
            if ((n & 4) != 0) {
                string3 = error.declineCode;
            }
            if ((n & 8) != 0) {
                string4 = error.docUrl;
            }
            if ((n & 0x10) != 0) {
                string5 = error.message;
            }
            if ((n & 0x20) != 0) {
                string6 = error.param;
            }
            if ((n & 0x40) != 0) {
                paymentMethod = error.paymentMethod;
            }
            if ((n & 0x80) != 0) {
                type = error.type;
            }
            return error.copy(string, string2, string3, string4, string5, string6, paymentMethod, type);
        }

        @NotNull
        public String toString() {
            return "Error(charge=" + this.charge + ", code=" + this.code + ", declineCode=" + this.declineCode + ", docUrl=" + this.docUrl + ", message=" + this.message + ", param=" + this.param + ", paymentMethod=" + this.paymentMethod + ", type=" + (Object)((Object)this.type) + ')';
        }

        @Override
        public int hashCode() {
            int result2 = this.charge == null ? 0 : this.charge.hashCode();
            result2 = result2 * 31 + (this.code == null ? 0 : this.code.hashCode());
            result2 = result2 * 31 + (this.declineCode == null ? 0 : this.declineCode.hashCode());
            result2 = result2 * 31 + (this.docUrl == null ? 0 : this.docUrl.hashCode());
            result2 = result2 * 31 + (this.message == null ? 0 : this.message.hashCode());
            result2 = result2 * 31 + (this.param == null ? 0 : this.param.hashCode());
            result2 = result2 * 31 + (this.paymentMethod == null ? 0 : this.paymentMethod.hashCode());
            result2 = result2 * 31 + (this.type == null ? 0 : this.type.hashCode());
            return result2;
        }

        @Override
        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Error)) {
                return false;
            }
            Error error = (Error)other;
            if (!Intrinsics.areEqual((Object)this.charge, (Object)error.charge)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.code, (Object)error.code)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.declineCode, (Object)error.declineCode)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.docUrl, (Object)error.docUrl)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.message, (Object)error.message)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.param, (Object)error.param)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.paymentMethod, (Object)error.paymentMethod)) {
                return false;
            }
            return this.type == error.type;
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(@NotNull Parcel out, int flags) {
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            out.writeString(this.charge);
            out.writeString(this.code);
            out.writeString(this.declineCode);
            out.writeString(this.docUrl);
            out.writeString(this.message);
            out.writeString(this.param);
            Object object = this.paymentMethod;
            if (object == null) {
                out.writeInt(0);
            } else {
                out.writeInt(1);
                ((PaymentMethod)object).writeToParcel(out, flags);
            }
            object = this.type;
            if (object == null) {
                out.writeInt(0);
            } else {
                out.writeInt(1);
                out.writeString(((Enum)object).name());
            }
        }

        static {
            @Metadata(mv={1, 5, 1}, k=3, xi=48)
            public final class Creator
            implements Parcelable.Creator<Error> {
                @NotNull
                public final Error[] newArray(int size) {
                    return new Error[size];
                }

                @NotNull
                public final Error createFromParcel(@NotNull Parcel parcel) {
                    Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
                    return new Error(parcel.readString(), parcel.readString(), parcel.readString(), parcel.readString(), parcel.readString(), parcel.readString(), (PaymentMethod)(parcel.readInt() == 0 ? null : PaymentMethod.CREATOR.createFromParcel(parcel)), parcel.readInt() == 0 ? null : Type.valueOf(parcel.readString()));
                }
            }
            CREATOR = new Creator();
            $stable = 8;
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\b\u0086\u0001\u0018\u0000 \u000e2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u000eB\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\r\u00a8\u0006\u000f"}, d2={"Lcom/stripe/android/model/PaymentIntent$Error$Type;", "", "code", "", "(Ljava/lang/String;ILjava/lang/String;)V", "getCode", "()Ljava/lang/String;", "ApiConnectionError", "ApiError", "AuthenticationError", "CardError", "IdempotencyError", "InvalidRequestError", "RateLimitError", "Companion", "payments-core_release"})
        public static final class Type
        extends Enum<Type> {
            @NotNull
            public static final Companion Companion;
            @NotNull
            private final String code;
            public static final /* enum */ Type ApiConnectionError;
            public static final /* enum */ Type ApiError;
            public static final /* enum */ Type AuthenticationError;
            public static final /* enum */ Type CardError;
            public static final /* enum */ Type IdempotencyError;
            public static final /* enum */ Type InvalidRequestError;
            public static final /* enum */ Type RateLimitError;
            private static final /* synthetic */ Type[] $VALUES;

            private Type(String code) {
                this.code = code;
            }

            @NotNull
            public final String getCode() {
                return this.code;
            }

            public static Type[] values() {
                return (Type[])$VALUES.clone();
            }

            public static Type valueOf(String value) {
                return Enum.valueOf(Type.class, value);
            }

            static {
                ApiConnectionError = new Type("api_connection_error");
                ApiError = new Type("api_error");
                AuthenticationError = new Type("authentication_error");
                CardError = new Type("card_error");
                IdempotencyError = new Type("idempotency_error");
                InvalidRequestError = new Type("invalid_request_error");
                RateLimitError = new Type("rate_limit_error");
                $VALUES = typeArray = new Type[]{Type.ApiConnectionError, Type.ApiError, Type.AuthenticationError, Type.CardError, Type.IdempotencyError, Type.InvalidRequestError, Type.RateLimitError};
                Companion = new Companion(null);
            }

            @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/stripe/android/model/PaymentIntent$Error$Type$Companion;", "", "()V", "fromCode", "Lcom/stripe/android/model/PaymentIntent$Error$Type;", "typeCode", "", "payments-core_release"})
            public static final class Companion {
                private Companion() {
                }

                @Nullable
                public final Type fromCode(@Nullable String typeCode) {
                    Type type;
                    block1: {
                        Type[] $this$firstOrNull$iv = Type.values();
                        boolean $i$f$firstOrNull = false;
                        Type[] typeArray = $this$firstOrNull$iv;
                        int n = typeArray.length;
                        for (int i = 0; i < n; ++i) {
                            Type element$iv;
                            Type it = element$iv = typeArray[i];
                            boolean bl = false;
                            if (!Intrinsics.areEqual((Object)it.getCode(), (Object)typeCode)) continue;
                            type = element$iv;
                            break block1;
                        }
                        type = null;
                    }
                    return type;
                }

                public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                    this();
                }
            }
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/stripe/android/model/PaymentIntent$Error$Companion;", "", "()V", "CODE_AUTHENTICATION_ERROR", "", "payments-core_release"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0012\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0087\b\u0018\u00002\u00020\u0001B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\tJ\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0012\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000b\u0010\u0013\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000b\u0010\u0014\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000b\u0010\u0015\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003JC\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u00d6\u0003J\t\u0010\u001d\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u001e\u001a\u00020\u0005H\u00d6\u0001J\u0019\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0018H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0013\u0010\b\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\r\u00a8\u0006$"}, d2={"Lcom/stripe/android/model/PaymentIntent$Shipping;", "Lcom/stripe/android/model/StripeModel;", "address", "Lcom/stripe/android/model/Address;", "carrier", "", "name", "phone", "trackingNumber", "(Lcom/stripe/android/model/Address;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getAddress", "()Lcom/stripe/android/model/Address;", "getCarrier", "()Ljava/lang/String;", "getName", "getPhone", "getTrackingNumber", "component1", "component2", "component3", "component4", "component5", "copy", "describeContents", "", "equals", "", "other", "", "hashCode", "toString", "writeToParcel", "", "parcel", "Landroid/os/Parcel;", "flags", "payments-core_release"})
    @Parcelize
    @StabilityInferred(parameters=0)
    public static final class Shipping
    implements StripeModel {
        @NotNull
        private final Address address;
        @Nullable
        private final String carrier;
        @Nullable
        private final String name;
        @Nullable
        private final String phone;
        @Nullable
        private final String trackingNumber;
        @NotNull
        public static final Parcelable.Creator<Shipping> CREATOR;
        public static final int $stable;

        public Shipping(@NotNull Address address, @Nullable String carrier, @Nullable String name, @Nullable String phone, @Nullable String trackingNumber) {
            Intrinsics.checkNotNullParameter((Object)address, (String)"address");
            this.address = address;
            this.carrier = carrier;
            this.name = name;
            this.phone = phone;
            this.trackingNumber = trackingNumber;
        }

        public /* synthetic */ Shipping(Address address, String string, String string2, String string3, String string4, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                string = null;
            }
            if ((n & 4) != 0) {
                string2 = null;
            }
            if ((n & 8) != 0) {
                string3 = null;
            }
            if ((n & 0x10) != 0) {
                string4 = null;
            }
            this(address, string, string2, string3, string4);
        }

        @NotNull
        public final Address getAddress() {
            return this.address;
        }

        @Nullable
        public final String getCarrier() {
            return this.carrier;
        }

        @Nullable
        public final String getName() {
            return this.name;
        }

        @Nullable
        public final String getPhone() {
            return this.phone;
        }

        @Nullable
        public final String getTrackingNumber() {
            return this.trackingNumber;
        }

        @NotNull
        public final Address component1() {
            return this.address;
        }

        @Nullable
        public final String component2() {
            return this.carrier;
        }

        @Nullable
        public final String component3() {
            return this.name;
        }

        @Nullable
        public final String component4() {
            return this.phone;
        }

        @Nullable
        public final String component5() {
            return this.trackingNumber;
        }

        @NotNull
        public final Shipping copy(@NotNull Address address, @Nullable String carrier, @Nullable String name, @Nullable String phone, @Nullable String trackingNumber) {
            Intrinsics.checkNotNullParameter((Object)address, (String)"address");
            return new Shipping(address, carrier, name, phone, trackingNumber);
        }

        public static /* synthetic */ Shipping copy$default(Shipping shipping, Address address, String string, String string2, String string3, String string4, int n, Object object) {
            if ((n & 1) != 0) {
                address = shipping.address;
            }
            if ((n & 2) != 0) {
                string = shipping.carrier;
            }
            if ((n & 4) != 0) {
                string2 = shipping.name;
            }
            if ((n & 8) != 0) {
                string3 = shipping.phone;
            }
            if ((n & 0x10) != 0) {
                string4 = shipping.trackingNumber;
            }
            return shipping.copy(address, string, string2, string3, string4);
        }

        @NotNull
        public String toString() {
            return "Shipping(address=" + this.address + ", carrier=" + this.carrier + ", name=" + this.name + ", phone=" + this.phone + ", trackingNumber=" + this.trackingNumber + ')';
        }

        @Override
        public int hashCode() {
            int result2 = this.address.hashCode();
            result2 = result2 * 31 + (this.carrier == null ? 0 : this.carrier.hashCode());
            result2 = result2 * 31 + (this.name == null ? 0 : this.name.hashCode());
            result2 = result2 * 31 + (this.phone == null ? 0 : this.phone.hashCode());
            result2 = result2 * 31 + (this.trackingNumber == null ? 0 : this.trackingNumber.hashCode());
            return result2;
        }

        @Override
        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Shipping)) {
                return false;
            }
            Shipping shipping = (Shipping)other;
            if (!Intrinsics.areEqual((Object)this.address, (Object)shipping.address)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.carrier, (Object)shipping.carrier)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.name, (Object)shipping.name)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.phone, (Object)shipping.phone)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.trackingNumber, (Object)shipping.trackingNumber);
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(@NotNull Parcel out, int flags) {
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            this.address.writeToParcel(out, flags);
            out.writeString(this.carrier);
            out.writeString(this.name);
            out.writeString(this.phone);
            out.writeString(this.trackingNumber);
        }

        static {
            @Metadata(mv={1, 5, 1}, k=3, xi=48)
            public final class Creator
            implements Parcelable.Creator<Shipping> {
                @NotNull
                public final Shipping[] newArray(int size) {
                    return new Shipping[size];
                }

                @NotNull
                public final Shipping createFromParcel(@NotNull Parcel parcel) {
                    Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
                    return new Shipping((Address)Address.CREATOR.createFromParcel(parcel), parcel.readString(), parcel.readString(), parcel.readString(), parcel.readString());
                }
            }
            CREATOR = new Creator();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0080\b\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\t\u001a\u00020\u0003H\u00c0\u0003\u00a2\u0006\u0002\b\nJ\u0013\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0003H\u00d6\u0001R\u0014\u0010\u0005\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lcom/stripe/android/model/PaymentIntent$ClientSecret;", "", "value", "", "(Ljava/lang/String;)V", "paymentIntentId", "getPaymentIntentId$payments_core_release", "()Ljava/lang/String;", "getValue$payments_core_release", "component1", "component1$payments_core_release", "copy", "equals", "", "other", "hashCode", "", "toString", "Companion", "payments-core_release"})
    public static final class ClientSecret {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String value;
        @NotNull
        private final String paymentIntentId;
        private static final Pattern PATTERN = Pattern.compile("^pi_[^_]+_secret_[^_]+$");

        /*
         * WARNING - void declaration
         */
        public ClientSecret(@NotNull String value) {
            List list;
            void $this$dropLastWhile$iv;
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            this.value = value;
            Object object = this.value;
            String string = "_secret";
            int n = 0;
            string = new Regex(string);
            n = 0;
            boolean bl = false;
            object = string.split((CharSequence)object, n);
            ClientSecret clientSecret = this;
            boolean $i$f$dropLastWhile = false;
            if (!$this$dropLastWhile$iv.isEmpty()) {
                ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                while (iterator$iv.hasPrevious()) {
                    String it = (String)iterator$iv.previous();
                    boolean bl2 = false;
                    CharSequence charSequence = it;
                    boolean bl3 = false;
                    if (charSequence.length() == 0) continue;
                    list = CollectionsKt.take((Iterable)((Iterable)$this$dropLastWhile$iv), (int)(iterator$iv.nextIndex() + 1));
                    break;
                }
            } else {
                list = CollectionsKt.emptyList();
            }
            List list2 = list;
            Collection $this$toTypedArray$iv = list2;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            String[] stringArray = thisCollection$iv.toArray(new String[0]);
            if (stringArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            clientSecret.paymentIntentId = stringArray[0];
            boolean bl4 = Companion.isMatch(this.value);
            boolean bl5 = false;
            boolean bl6 = false;
            if (!bl4) {
                boolean bl7 = false;
                String string2 = Intrinsics.stringPlus((String)"Invalid Payment Intent client secret: ", (Object)this.getValue$payments_core_release());
                throw (Throwable)new IllegalArgumentException(string2.toString());
            }
        }

        @NotNull
        public final String getValue$payments_core_release() {
            return this.value;
        }

        @NotNull
        public final String getPaymentIntentId$payments_core_release() {
            return this.paymentIntentId;
        }

        @NotNull
        public final String component1$payments_core_release() {
            return this.value;
        }

        @NotNull
        public final ClientSecret copy(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return new ClientSecret(value);
        }

        public static /* synthetic */ ClientSecret copy$default(ClientSecret clientSecret, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = clientSecret.value;
            }
            return clientSecret.copy(string);
        }

        @NotNull
        public String toString() {
            return "ClientSecret(value=" + this.value + ')';
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ClientSecret)) {
                return false;
            }
            ClientSecret clientSecret = (ClientSecret)other;
            return Intrinsics.areEqual((Object)this.value, (Object)clientSecret.value);
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tR\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/stripe/android/model/PaymentIntent$ClientSecret$Companion;", "", "()V", "PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "isMatch", "", "value", "", "payments-core_release"})
        public static final class Companion {
            private Companion() {
            }

            public final boolean isMatch(@NotNull String value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                return PATTERN.matcher(value).matches();
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\b\u0086\u0001\u0018\u0000 \f2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\fB\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000b\u00a8\u0006\r"}, d2={"Lcom/stripe/android/model/PaymentIntent$CancellationReason;", "", "code", "", "(Ljava/lang/String;ILjava/lang/String;)V", "Duplicate", "Fraudulent", "RequestedByCustomer", "Abandoned", "FailedInvoice", "VoidInvoice", "Automatic", "Companion", "payments-core_release"})
    public static final class CancellationReason
    extends Enum<CancellationReason> {
        @NotNull
        public static final Companion Companion;
        @NotNull
        private final String code;
        public static final /* enum */ CancellationReason Duplicate;
        public static final /* enum */ CancellationReason Fraudulent;
        public static final /* enum */ CancellationReason RequestedByCustomer;
        public static final /* enum */ CancellationReason Abandoned;
        public static final /* enum */ CancellationReason FailedInvoice;
        public static final /* enum */ CancellationReason VoidInvoice;
        public static final /* enum */ CancellationReason Automatic;
        private static final /* synthetic */ CancellationReason[] $VALUES;

        private CancellationReason(String code) {
            this.code = code;
        }

        public static CancellationReason[] values() {
            return (CancellationReason[])$VALUES.clone();
        }

        public static CancellationReason valueOf(String value) {
            return Enum.valueOf(CancellationReason.class, value);
        }

        static {
            Duplicate = new CancellationReason("duplicate");
            Fraudulent = new CancellationReason("fraudulent");
            RequestedByCustomer = new CancellationReason("requested_by_customer");
            Abandoned = new CancellationReason("abandoned");
            FailedInvoice = new CancellationReason("failed_invoice");
            VoidInvoice = new CancellationReason("void_invoice");
            Automatic = new CancellationReason("automatic");
            $VALUES = cancellationReasonArray = new CancellationReason[]{CancellationReason.Duplicate, CancellationReason.Fraudulent, CancellationReason.RequestedByCustomer, CancellationReason.Abandoned, CancellationReason.FailedInvoice, CancellationReason.VoidInvoice, CancellationReason.Automatic};
            Companion = new Companion(null);
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/stripe/android/model/PaymentIntent$CancellationReason$Companion;", "", "()V", "fromCode", "Lcom/stripe/android/model/PaymentIntent$CancellationReason;", "code", "", "payments-core_release"})
        public static final class Companion {
            private Companion() {
            }

            @Nullable
            public final CancellationReason fromCode(@Nullable String code) {
                CancellationReason cancellationReason;
                block1: {
                    CancellationReason[] $this$firstOrNull$iv = CancellationReason.values();
                    boolean $i$f$firstOrNull = false;
                    CancellationReason[] cancellationReasonArray = $this$firstOrNull$iv;
                    int n = cancellationReasonArray.length;
                    for (int i = 0; i < n; ++i) {
                        CancellationReason element$iv;
                        CancellationReason it = element$iv = cancellationReasonArray[i];
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.code, (Object)code)) continue;
                        cancellationReason = element$iv;
                        break block1;
                    }
                    cancellationReason = null;
                }
                return cancellationReason;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0001\u0018\u0000 \u00072\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0007B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\b"}, d2={"Lcom/stripe/android/model/PaymentIntent$CaptureMethod;", "", "code", "", "(Ljava/lang/String;ILjava/lang/String;)V", "Automatic", "Manual", "Companion", "payments-core_release"})
    public static final class CaptureMethod
    extends Enum<CaptureMethod> {
        @NotNull
        public static final Companion Companion;
        @NotNull
        private final String code;
        public static final /* enum */ CaptureMethod Automatic;
        public static final /* enum */ CaptureMethod Manual;
        private static final /* synthetic */ CaptureMethod[] $VALUES;

        private CaptureMethod(String code) {
            this.code = code;
        }

        public static CaptureMethod[] values() {
            return (CaptureMethod[])$VALUES.clone();
        }

        public static CaptureMethod valueOf(String value) {
            return Enum.valueOf(CaptureMethod.class, value);
        }

        static {
            Automatic = new CaptureMethod("automatic");
            Manual = new CaptureMethod("manual");
            $VALUES = captureMethodArray = new CaptureMethod[]{CaptureMethod.Automatic, CaptureMethod.Manual};
            Companion = new Companion(null);
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/stripe/android/model/PaymentIntent$CaptureMethod$Companion;", "", "()V", "fromCode", "Lcom/stripe/android/model/PaymentIntent$CaptureMethod;", "code", "", "payments-core_release"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final CaptureMethod fromCode(@Nullable String code) {
                CaptureMethod captureMethod;
                block1: {
                    CaptureMethod[] $this$firstOrNull$iv = CaptureMethod.values();
                    boolean $i$f$firstOrNull = false;
                    CaptureMethod[] captureMethodArray = $this$firstOrNull$iv;
                    int n = captureMethodArray.length;
                    for (int i = 0; i < n; ++i) {
                        CaptureMethod element$iv;
                        CaptureMethod it = element$iv = captureMethodArray[i];
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.code, (Object)code)) continue;
                        captureMethod = element$iv;
                        break block1;
                    }
                    captureMethod = null;
                }
                CaptureMethod captureMethod2 = captureMethod;
                return captureMethod2 == null ? Automatic : captureMethod2;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0001\u0018\u0000 \u00072\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0007B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\b"}, d2={"Lcom/stripe/android/model/PaymentIntent$ConfirmationMethod;", "", "code", "", "(Ljava/lang/String;ILjava/lang/String;)V", "Automatic", "Manual", "Companion", "payments-core_release"})
    public static final class ConfirmationMethod
    extends Enum<ConfirmationMethod> {
        @NotNull
        public static final Companion Companion;
        @NotNull
        private final String code;
        public static final /* enum */ ConfirmationMethod Automatic;
        public static final /* enum */ ConfirmationMethod Manual;
        private static final /* synthetic */ ConfirmationMethod[] $VALUES;

        private ConfirmationMethod(String code) {
            this.code = code;
        }

        public static ConfirmationMethod[] values() {
            return (ConfirmationMethod[])$VALUES.clone();
        }

        public static ConfirmationMethod valueOf(String value) {
            return Enum.valueOf(ConfirmationMethod.class, value);
        }

        static {
            Automatic = new ConfirmationMethod("automatic");
            Manual = new ConfirmationMethod("manual");
            $VALUES = confirmationMethodArray = new ConfirmationMethod[]{ConfirmationMethod.Automatic, ConfirmationMethod.Manual};
            Companion = new Companion(null);
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/stripe/android/model/PaymentIntent$ConfirmationMethod$Companion;", "", "()V", "fromCode", "Lcom/stripe/android/model/PaymentIntent$ConfirmationMethod;", "code", "", "payments-core_release"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final ConfirmationMethod fromCode(@Nullable String code) {
                ConfirmationMethod confirmationMethod;
                block1: {
                    ConfirmationMethod[] $this$firstOrNull$iv = ConfirmationMethod.values();
                    boolean $i$f$firstOrNull = false;
                    ConfirmationMethod[] confirmationMethodArray = $this$firstOrNull$iv;
                    int n = confirmationMethodArray.length;
                    for (int i = 0; i < n; ++i) {
                        ConfirmationMethod element$iv;
                        ConfirmationMethod it = element$iv = confirmationMethodArray[i];
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.code, (Object)code)) continue;
                        confirmationMethod = element$iv;
                        break block1;
                    }
                    confirmationMethod = null;
                }
                ConfirmationMethod confirmationMethod2 = confirmationMethod;
                return confirmationMethod2 == null ? Automatic : confirmationMethod2;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\u0004\u0018\u00010\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Lcom/stripe/android/model/PaymentIntent$Companion;", "", "()V", "fromJson", "Lcom/stripe/android/model/PaymentIntent;", "jsonObject", "Lorg/json/JSONObject;", "payments-core_release"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @Nullable
        public final PaymentIntent fromJson(@Nullable JSONObject jsonObject) {
            PaymentIntent paymentIntent;
            JSONObject jSONObject = jsonObject;
            if (jSONObject == null) {
                paymentIntent = null;
            } else {
                JSONObject jSONObject2 = jSONObject;
                boolean bl = false;
                boolean bl2 = false;
                JSONObject it = jSONObject2;
                boolean bl3 = false;
                paymentIntent = new PaymentIntentJsonParser().parse(it);
            }
            return paymentIntent;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[StripeIntent.Usage.values().length];
            nArray[StripeIntent.Usage.OnSession.ordinal()] = 1;
            nArray[StripeIntent.Usage.OffSession.ordinal()] = 2;
            nArray[StripeIntent.Usage.OneTime.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

