/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.model;

import android.os.Parcel;
import android.os.Parcelable;
import com.stripe.android.cards.CardNumber;
import com.stripe.android.model.StripeModel;
import java.math.BigDecimal;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.parcelize.Parcelize;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0081\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\t\u0010\f\u001a\u00020\rH\u00d6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\rH\u00d6\u0001J\u0015\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0000\u00a2\u0006\u0002\b\u0016J\t\u0010\u0017\u001a\u00020\u0003H\u00d6\u0001J\u0019\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\rH\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u001d"}, d2={"Lcom/stripe/android/model/BinRange;", "Lcom/stripe/android/model/StripeModel;", "low", "", "high", "(Ljava/lang/String;Ljava/lang/String;)V", "getHigh", "()Ljava/lang/String;", "getLow", "component1", "component2", "copy", "describeContents", "", "equals", "", "other", "", "hashCode", "matches", "cardNumber", "Lcom/stripe/android/cards/CardNumber$Unvalidated;", "matches$payments_core_release", "toString", "writeToParcel", "", "parcel", "Landroid/os/Parcel;", "flags", "payments-core_release"})
@Parcelize
public final class BinRange
implements StripeModel {
    @NotNull
    private final String low;
    @NotNull
    private final String high;
    @NotNull
    public static final Parcelable.Creator<BinRange> CREATOR;

    public BinRange(@NotNull String low, @NotNull String high) {
        Intrinsics.checkNotNullParameter((Object)low, (String)"low");
        Intrinsics.checkNotNullParameter((Object)high, (String)"high");
        this.low = low;
        this.high = high;
    }

    @NotNull
    public final String getLow() {
        return this.low;
    }

    @NotNull
    public final String getHigh() {
        return this.high;
    }

    public final boolean matches$payments_core_release(@NotNull CardNumber.Unvalidated cardNumber) {
        boolean bl;
        boolean bl2;
        String string;
        boolean withinLowRange;
        boolean bl3;
        boolean bl4;
        String string2;
        Intrinsics.checkNotNullParameter((Object)cardNumber, (String)"cardNumber");
        String number = cardNumber.getNormalized();
        BigDecimal bigDecimal = StringsKt.toBigDecimalOrNull((String)number);
        if (bigDecimal == null) {
            return false;
        }
        BigDecimal numberBigDecimal = bigDecimal;
        if (number.length() < this.low.length()) {
            string2 = StringsKt.take((String)this.low, (int)number.length());
            bl4 = false;
            bl3 = numberBigDecimal.compareTo(new BigDecimal(string2)) >= 0;
        } else {
            string2 = StringsKt.take((String)number, (int)this.low.length());
            bl4 = false;
            BigDecimal bigDecimal2 = new BigDecimal(string2);
            string2 = this.low;
            bl4 = false;
            bl3 = withinLowRange = bigDecimal2.compareTo(new BigDecimal(string2)) >= 0;
        }
        if (number.length() < this.high.length()) {
            string = StringsKt.take((String)this.high, (int)number.length());
            bl2 = false;
            bl = numberBigDecimal.compareTo(new BigDecimal(string)) <= 0;
        } else {
            string = StringsKt.take((String)number, (int)this.high.length());
            bl2 = false;
            BigDecimal bigDecimal3 = new BigDecimal(string);
            string = this.high;
            bl2 = false;
            bl = bigDecimal3.compareTo(new BigDecimal(string)) <= 0;
        }
        boolean withinHighRange = bl;
        return withinLowRange && withinHighRange;
    }

    @NotNull
    public final String component1() {
        return this.low;
    }

    @NotNull
    public final String component2() {
        return this.high;
    }

    @NotNull
    public final BinRange copy(@NotNull String low, @NotNull String high) {
        Intrinsics.checkNotNullParameter((Object)low, (String)"low");
        Intrinsics.checkNotNullParameter((Object)high, (String)"high");
        return new BinRange(low, high);
    }

    public static /* synthetic */ BinRange copy$default(BinRange binRange, String string, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            string = binRange.low;
        }
        if ((n & 2) != 0) {
            string2 = binRange.high;
        }
        return binRange.copy(string, string2);
    }

    @NotNull
    public String toString() {
        return "BinRange(low=" + this.low + ", high=" + this.high + ')';
    }

    @Override
    public int hashCode() {
        int result2 = this.low.hashCode();
        result2 = result2 * 31 + this.high.hashCode();
        return result2;
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof BinRange)) {
            return false;
        }
        BinRange binRange = (BinRange)other;
        if (!Intrinsics.areEqual((Object)this.low, (Object)binRange.low)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.high, (Object)binRange.high);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(@NotNull Parcel out, int flags) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        out.writeString(this.low);
        out.writeString(this.high);
    }

    static {
        @Metadata(mv={1, 5, 1}, k=3, xi=48)
        public final class Creator
        implements Parcelable.Creator<BinRange> {
            @NotNull
            public final BinRange[] newArray(int size) {
                return new BinRange[size];
            }

            @NotNull
            public final BinRange createFromParcel(@NotNull Parcel parcel) {
                Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
                return new BinRange(parcel.readString(), parcel.readString());
            }
        }
        CREATOR = new Creator();
    }
}

