/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.auth;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.view.Window;
import androidx.activity.result.contract.ActivityResultContract;
import androidx.core.os.BundleKt;
import com.stripe.android.payments.DefaultReturnUrl;
import com.stripe.android.payments.PaymentFlowResult;
import com.stripe.android.payments.StripeBrowserLauncherActivity;
import com.stripe.android.stripe3ds2.init.ui.StripeToolbarCustomization;
import com.stripe.android.view.PaymentAuthWebViewActivity;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.parcelize.Parcelize;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\b\u0000\u0018\u0000 \u000f2\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0002\u000e\u000fB\u0005\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0002H\u0016J\u001c\u0010\n\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0006H\u0016\u00a8\u0006\u0010"}, d2={"Lcom/stripe/android/auth/PaymentBrowserAuthContract;", "Landroidx/activity/result/contract/ActivityResultContract;", "Lcom/stripe/android/auth/PaymentBrowserAuthContract$Args;", "Lcom/stripe/android/payments/PaymentFlowResult$Unvalidated;", "()V", "createIntent", "Landroid/content/Intent;", "context", "Landroid/content/Context;", "input", "parseResult", "resultCode", "", "intent", "Args", "Companion", "payments-core_release"})
public final class PaymentBrowserAuthContract
extends ActivityResultContract<Args, PaymentFlowResult.Unvalidated> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String EXTRA_ARGS = "extra_args";

    @NotNull
    public Intent createIntent(@NotNull Context context, @NotNull Args input) {
        Class clazz;
        Window window;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        DefaultReturnUrl defaultReturnUrl = DefaultReturnUrl.Companion.create(context);
        boolean shouldUseBrowser = input.hasDefaultReturnUrl$payments_core_release(defaultReturnUrl);
        Context context2 = context;
        Integer statusBarColor = context2 instanceof Activity ? ((window = ((Activity)context).getWindow()) == null ? null : Integer.valueOf(window.getStatusBarColor())) : null;
        Bundle extras = Args.copy$default(input, null, 0, null, null, null, false, null, null, false, false, statusBarColor, null, 3071, null).toBundle();
        boolean bl = shouldUseBrowser;
        if (bl) {
            clazz = StripeBrowserLauncherActivity.class;
        } else if (!bl) {
            clazz = PaymentAuthWebViewActivity.class;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        Intent intent = new Intent(context, clazz);
        boolean bl2 = false;
        boolean bl3 = false;
        Intent intent2 = intent;
        boolean bl4 = false;
        intent2.putExtras(extras);
        return intent;
    }

    @Nullable
    public PaymentFlowResult.Unvalidated parseResult(int resultCode, @Nullable Intent intent) {
        Intent intent2 = intent;
        return intent2 == null ? null : (PaymentFlowResult.Unvalidated)intent2.getParcelableExtra(EXTRA_ARGS);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b)\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0081\b\u0018\u00002\u00020\u0001B{\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f\u0012\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\u000e\u001a\u00020\n\u0012\b\b\u0002\u0010\u000f\u001a\u00020\n\u0012\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0011\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0012J\t\u0010%\u001a\u00020\u0003H\u00c6\u0003J\t\u0010&\u001a\u00020\nH\u00c6\u0003J\u0010\u0010'\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003\u00a2\u0006\u0002\u0010\u001fJ\t\u0010(\u001a\u00020\u0003H\u00c6\u0003J\t\u0010)\u001a\u00020\u0005H\u00c6\u0003J\t\u0010*\u001a\u00020\u0003H\u00c6\u0003J\t\u0010+\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010,\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010-\u001a\u00020\nH\u00c6\u0003J\u000b\u0010.\u001a\u0004\u0018\u00010\fH\u00c6\u0003J\u000b\u0010/\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u00100\u001a\u00020\nH\u00c6\u0003J\u008e\u0001\u00101\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\u00032\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\t\u001a\u00020\n2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u000e\u001a\u00020\n2\b\b\u0002\u0010\u000f\u001a\u00020\n2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\u0011\u001a\u00020\u0003H\u00c6\u0001\u00a2\u0006\u0002\u00102J\t\u00103\u001a\u00020\u0005H\u00d6\u0001J\u0013\u00104\u001a\u00020\n2\b\u00105\u001a\u0004\u0018\u000106H\u00d6\u0003J\u0015\u00107\u001a\u00020\n2\u0006\u00108\u001a\u000209H\u0000\u00a2\u0006\u0002\b:J\t\u0010;\u001a\u00020\u0005H\u00d6\u0001J\u0006\u0010<\u001a\u00020=J\t\u0010>\u001a\u00020\u0003H\u00d6\u0001J\u0019\u0010?\u001a\u00020@2\u0006\u0010A\u001a\u00020B2\u0006\u0010C\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0014R\u0011\u0010\u0011\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0014R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0013\u0010\b\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0014R\u0011\u0010\u000f\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0016R\u0011\u0010\u000e\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0016R\u0015\u0010\u0010\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\n\n\u0002\u0010 \u001a\u0004\b\u001e\u0010\u001fR\u0013\u0010\r\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u0014R\u0013\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\u0014\u00a8\u0006D"}, d2={"Lcom/stripe/android/auth/PaymentBrowserAuthContract$Args;", "Landroid/os/Parcelable;", "objectId", "", "requestCode", "", "clientSecret", "url", "returnUrl", "enableLogging", "", "toolbarCustomization", "Lcom/stripe/android/stripe3ds2/init/ui/StripeToolbarCustomization;", "stripeAccountId", "shouldCancelSource", "shouldCancelIntentOnUserNavigation", "statusBarColor", "publishableKey", "(Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;ZLcom/stripe/android/stripe3ds2/init/ui/StripeToolbarCustomization;Ljava/lang/String;ZZLjava/lang/Integer;Ljava/lang/String;)V", "getClientSecret", "()Ljava/lang/String;", "getEnableLogging", "()Z", "getObjectId", "getPublishableKey", "getRequestCode", "()I", "getReturnUrl", "getShouldCancelIntentOnUserNavigation", "getShouldCancelSource", "getStatusBarColor", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "getStripeAccountId", "getToolbarCustomization", "()Lcom/stripe/android/stripe3ds2/init/ui/StripeToolbarCustomization;", "getUrl", "component1", "component10", "component11", "component12", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "(Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;ZLcom/stripe/android/stripe3ds2/init/ui/StripeToolbarCustomization;Ljava/lang/String;ZZLjava/lang/Integer;Ljava/lang/String;)Lcom/stripe/android/auth/PaymentBrowserAuthContract$Args;", "describeContents", "equals", "other", "", "hasDefaultReturnUrl", "defaultReturnUrl", "Lcom/stripe/android/payments/DefaultReturnUrl;", "hasDefaultReturnUrl$payments_core_release", "hashCode", "toBundle", "Landroid/os/Bundle;", "toString", "writeToParcel", "", "parcel", "Landroid/os/Parcel;", "flags", "payments-core_release"})
    @Parcelize
    public static final class Args
    implements Parcelable {
        @NotNull
        private final String objectId;
        private final int requestCode;
        @NotNull
        private final String clientSecret;
        @NotNull
        private final String url;
        @Nullable
        private final String returnUrl;
        private final boolean enableLogging;
        @Nullable
        private final StripeToolbarCustomization toolbarCustomization;
        @Nullable
        private final String stripeAccountId;
        private final boolean shouldCancelSource;
        private final boolean shouldCancelIntentOnUserNavigation;
        @Nullable
        private final Integer statusBarColor;
        @NotNull
        private final String publishableKey;
        @NotNull
        public static final Parcelable.Creator<Args> CREATOR;

        public Args(@NotNull String objectId, int requestCode, @NotNull String clientSecret, @NotNull String url, @Nullable String returnUrl, boolean enableLogging, @Nullable StripeToolbarCustomization toolbarCustomization, @Nullable String stripeAccountId2, boolean shouldCancelSource, boolean shouldCancelIntentOnUserNavigation, @Nullable Integer statusBarColor, @NotNull String publishableKey2) {
            Intrinsics.checkNotNullParameter((Object)objectId, (String)"objectId");
            Intrinsics.checkNotNullParameter((Object)clientSecret, (String)"clientSecret");
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Intrinsics.checkNotNullParameter((Object)publishableKey2, (String)"publishableKey");
            this.objectId = objectId;
            this.requestCode = requestCode;
            this.clientSecret = clientSecret;
            this.url = url;
            this.returnUrl = returnUrl;
            this.enableLogging = enableLogging;
            this.toolbarCustomization = toolbarCustomization;
            this.stripeAccountId = stripeAccountId2;
            this.shouldCancelSource = shouldCancelSource;
            this.shouldCancelIntentOnUserNavigation = shouldCancelIntentOnUserNavigation;
            this.statusBarColor = statusBarColor;
            this.publishableKey = publishableKey2;
        }

        public /* synthetic */ Args(String string, int n, String string2, String string3, String string4, boolean bl, StripeToolbarCustomization stripeToolbarCustomization, String string5, boolean bl2, boolean bl3, Integer n2, String string6, int n3, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n3 & 0x10) != 0) {
                string4 = null;
            }
            if ((n3 & 0x20) != 0) {
                bl = false;
            }
            if ((n3 & 0x40) != 0) {
                stripeToolbarCustomization = null;
            }
            if ((n3 & 0x80) != 0) {
                string5 = null;
            }
            if ((n3 & 0x100) != 0) {
                bl2 = false;
            }
            if ((n3 & 0x200) != 0) {
                bl3 = true;
            }
            if ((n3 & 0x400) != 0) {
                n2 = null;
            }
            this(string, n, string2, string3, string4, bl, stripeToolbarCustomization, string5, bl2, bl3, n2, string6);
        }

        @NotNull
        public final String getObjectId() {
            return this.objectId;
        }

        public final int getRequestCode() {
            return this.requestCode;
        }

        @NotNull
        public final String getClientSecret() {
            return this.clientSecret;
        }

        @NotNull
        public final String getUrl() {
            return this.url;
        }

        @Nullable
        public final String getReturnUrl() {
            return this.returnUrl;
        }

        public final boolean getEnableLogging() {
            return this.enableLogging;
        }

        @Nullable
        public final StripeToolbarCustomization getToolbarCustomization() {
            return this.toolbarCustomization;
        }

        @Nullable
        public final String getStripeAccountId() {
            return this.stripeAccountId;
        }

        public final boolean getShouldCancelSource() {
            return this.shouldCancelSource;
        }

        public final boolean getShouldCancelIntentOnUserNavigation() {
            return this.shouldCancelIntentOnUserNavigation;
        }

        @Nullable
        public final Integer getStatusBarColor() {
            return this.statusBarColor;
        }

        @NotNull
        public final String getPublishableKey() {
            return this.publishableKey;
        }

        public final boolean hasDefaultReturnUrl$payments_core_release(@NotNull DefaultReturnUrl defaultReturnUrl) {
            Intrinsics.checkNotNullParameter((Object)defaultReturnUrl, (String)"defaultReturnUrl");
            return Intrinsics.areEqual((Object)this.returnUrl, (Object)defaultReturnUrl.getValue());
        }

        @NotNull
        public final Bundle toBundle() {
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)PaymentBrowserAuthContract.EXTRA_ARGS, (Object)this)};
            return BundleKt.bundleOf((Pair[])pairArray);
        }

        @NotNull
        public final String component1() {
            return this.objectId;
        }

        public final int component2() {
            return this.requestCode;
        }

        @NotNull
        public final String component3() {
            return this.clientSecret;
        }

        @NotNull
        public final String component4() {
            return this.url;
        }

        @Nullable
        public final String component5() {
            return this.returnUrl;
        }

        public final boolean component6() {
            return this.enableLogging;
        }

        @Nullable
        public final StripeToolbarCustomization component7() {
            return this.toolbarCustomization;
        }

        @Nullable
        public final String component8() {
            return this.stripeAccountId;
        }

        public final boolean component9() {
            return this.shouldCancelSource;
        }

        public final boolean component10() {
            return this.shouldCancelIntentOnUserNavigation;
        }

        @Nullable
        public final Integer component11() {
            return this.statusBarColor;
        }

        @NotNull
        public final String component12() {
            return this.publishableKey;
        }

        @NotNull
        public final Args copy(@NotNull String objectId, int requestCode, @NotNull String clientSecret, @NotNull String url, @Nullable String returnUrl, boolean enableLogging, @Nullable StripeToolbarCustomization toolbarCustomization, @Nullable String stripeAccountId2, boolean shouldCancelSource, boolean shouldCancelIntentOnUserNavigation, @Nullable Integer statusBarColor, @NotNull String publishableKey2) {
            Intrinsics.checkNotNullParameter((Object)objectId, (String)"objectId");
            Intrinsics.checkNotNullParameter((Object)clientSecret, (String)"clientSecret");
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Intrinsics.checkNotNullParameter((Object)publishableKey2, (String)"publishableKey");
            return new Args(objectId, requestCode, clientSecret, url, returnUrl, enableLogging, toolbarCustomization, stripeAccountId2, shouldCancelSource, shouldCancelIntentOnUserNavigation, statusBarColor, publishableKey2);
        }

        public static /* synthetic */ Args copy$default(Args args2, String string, int n, String string2, String string3, String string4, boolean bl, StripeToolbarCustomization stripeToolbarCustomization, String string5, boolean bl2, boolean bl3, Integer n2, String string6, int n3, Object object) {
            if ((n3 & 1) != 0) {
                string = args2.objectId;
            }
            if ((n3 & 2) != 0) {
                n = args2.requestCode;
            }
            if ((n3 & 4) != 0) {
                string2 = args2.clientSecret;
            }
            if ((n3 & 8) != 0) {
                string3 = args2.url;
            }
            if ((n3 & 0x10) != 0) {
                string4 = args2.returnUrl;
            }
            if ((n3 & 0x20) != 0) {
                bl = args2.enableLogging;
            }
            if ((n3 & 0x40) != 0) {
                stripeToolbarCustomization = args2.toolbarCustomization;
            }
            if ((n3 & 0x80) != 0) {
                string5 = args2.stripeAccountId;
            }
            if ((n3 & 0x100) != 0) {
                bl2 = args2.shouldCancelSource;
            }
            if ((n3 & 0x200) != 0) {
                bl3 = args2.shouldCancelIntentOnUserNavigation;
            }
            if ((n3 & 0x400) != 0) {
                n2 = args2.statusBarColor;
            }
            if ((n3 & 0x800) != 0) {
                string6 = args2.publishableKey;
            }
            return args2.copy(string, n, string2, string3, string4, bl, stripeToolbarCustomization, string5, bl2, bl3, n2, string6);
        }

        @NotNull
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Args(objectId=").append(this.objectId).append(", requestCode=").append(this.requestCode).append(", clientSecret=").append(this.clientSecret).append(", url=").append(this.url).append(", returnUrl=").append((Object)this.returnUrl).append(", enableLogging=").append(this.enableLogging).append(", toolbarCustomization=").append(this.toolbarCustomization).append(", stripeAccountId=").append((Object)this.stripeAccountId).append(", shouldCancelSource=").append(this.shouldCancelSource).append(", shouldCancelIntentOnUserNavigation=").append(this.shouldCancelIntentOnUserNavigation).append(", statusBarColor=").append(this.statusBarColor).append(", publishableKey=");
            stringBuilder.append(this.publishableKey).append(')');
            return stringBuilder.toString();
        }

        public int hashCode() {
            int result2 = this.objectId.hashCode();
            result2 = result2 * 31 + Integer.hashCode(this.requestCode);
            result2 = result2 * 31 + this.clientSecret.hashCode();
            result2 = result2 * 31 + this.url.hashCode();
            result2 = result2 * 31 + (this.returnUrl == null ? 0 : this.returnUrl.hashCode());
            int n = this.enableLogging ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            result2 = result2 * 31 + n;
            result2 = result2 * 31 + (this.toolbarCustomization == null ? 0 : this.toolbarCustomization.hashCode());
            result2 = result2 * 31 + (this.stripeAccountId == null ? 0 : this.stripeAccountId.hashCode());
            int n2 = this.shouldCancelSource ? 1 : 0;
            if (n2 != 0) {
                n2 = 1;
            }
            result2 = result2 * 31 + n2;
            int n3 = this.shouldCancelIntentOnUserNavigation ? 1 : 0;
            if (n3 != 0) {
                n3 = 1;
            }
            result2 = result2 * 31 + n3;
            result2 = result2 * 31 + (this.statusBarColor == null ? 0 : ((Object)this.statusBarColor).hashCode());
            result2 = result2 * 31 + this.publishableKey.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Args)) {
                return false;
            }
            Args args2 = (Args)other;
            if (!Intrinsics.areEqual((Object)this.objectId, (Object)args2.objectId)) {
                return false;
            }
            if (this.requestCode != args2.requestCode) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.clientSecret, (Object)args2.clientSecret)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.url, (Object)args2.url)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.returnUrl, (Object)args2.returnUrl)) {
                return false;
            }
            if (this.enableLogging != args2.enableLogging) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.toolbarCustomization, (Object)args2.toolbarCustomization)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.stripeAccountId, (Object)args2.stripeAccountId)) {
                return false;
            }
            if (this.shouldCancelSource != args2.shouldCancelSource) {
                return false;
            }
            if (this.shouldCancelIntentOnUserNavigation != args2.shouldCancelIntentOnUserNavigation) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.statusBarColor, (Object)args2.statusBarColor)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.publishableKey, (Object)args2.publishableKey);
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(@NotNull Parcel out, int flags) {
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            out.writeString(this.objectId);
            out.writeInt(this.requestCode);
            out.writeString(this.clientSecret);
            out.writeString(this.url);
            out.writeString(this.returnUrl);
            out.writeInt(this.enableLogging ? 1 : 0);
            out.writeParcelable((Parcelable)this.toolbarCustomization, flags);
            out.writeString(this.stripeAccountId);
            out.writeInt(this.shouldCancelSource ? 1 : 0);
            out.writeInt(this.shouldCancelIntentOnUserNavigation ? 1 : 0);
            Integer n = this.statusBarColor;
            if (n == null) {
                out.writeInt(0);
            } else {
                out.writeInt(1);
                out.writeInt(n.intValue());
            }
            out.writeString(this.publishableKey);
        }

        static {
            @Metadata(mv={1, 5, 1}, k=3, xi=48)
            public final class Creator
            implements Parcelable.Creator<Args> {
                @NotNull
                public final Args[] newArray(int size) {
                    return new Args[size];
                }

                @NotNull
                public final Args createFromParcel(@NotNull Parcel parcel) {
                    Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
                    return new Args(parcel.readString(), parcel.readInt(), parcel.readString(), parcel.readString(), parcel.readString(), parcel.readInt() != 0, (StripeToolbarCustomization)parcel.readParcelable(Args.class.getClassLoader()), parcel.readString(), parcel.readInt() != 0, parcel.readInt() != 0, parcel.readInt() == 0 ? null : Integer.valueOf(parcel.readInt()), parcel.readString());
                }
            }
            CREATOR = new Creator();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0017\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\tR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/stripe/android/auth/PaymentBrowserAuthContract$Companion;", "", "()V", "EXTRA_ARGS", "", "parseArgs", "Lcom/stripe/android/auth/PaymentBrowserAuthContract$Args;", "intent", "Landroid/content/Intent;", "parseArgs$payments_core_release", "payments-core_release"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final Args parseArgs$payments_core_release(@NotNull Intent intent) {
            Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
            return (Args)intent.getParcelableExtra(PaymentBrowserAuthContract.EXTRA_ARGS);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

