/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android;

import android.content.Context;
import android.content.Intent;
import androidx.activity.result.ActivityResultCallback;
import androidx.activity.result.ActivityResultCaller;
import androidx.activity.result.ActivityResultLauncher;
import androidx.activity.result.contract.ActivityResultContract;
import androidx.annotation.VisibleForTesting;
import com.stripe.android.AlipayAuthenticator;
import com.stripe.android.Logger;
import com.stripe.android.PaymentController;
import com.stripe.android.PaymentIntentResult;
import com.stripe.android.PaymentRelayContract;
import com.stripe.android.PaymentRelayStarter;
import com.stripe.android.SetupIntentResult;
import com.stripe.android.StripePaymentController;
import com.stripe.android.exception.APIConnectionException;
import com.stripe.android.exception.APIException;
import com.stripe.android.exception.AuthenticationException;
import com.stripe.android.exception.InvalidRequestException;
import com.stripe.android.exception.StripeException;
import com.stripe.android.model.AlipayAuthResult;
import com.stripe.android.model.ConfirmPaymentIntentParams;
import com.stripe.android.model.ConfirmSetupIntentParams;
import com.stripe.android.model.ConfirmStripeIntentParams;
import com.stripe.android.model.PaymentIntent;
import com.stripe.android.model.SetupIntent;
import com.stripe.android.model.Source;
import com.stripe.android.model.StripeIntent;
import com.stripe.android.model.WeChatPayNextAction;
import com.stripe.android.networking.AlipayRepository;
import com.stripe.android.networking.AnalyticsEvent;
import com.stripe.android.networking.AnalyticsRequestExecutor;
import com.stripe.android.networking.AnalyticsRequestFactory;
import com.stripe.android.networking.ApiRequest;
import com.stripe.android.networking.DefaultAlipayRepository;
import com.stripe.android.networking.DefaultAnalyticsRequestExecutor;
import com.stripe.android.networking.StripeRepository;
import com.stripe.android.payments.DefaultReturnUrl;
import com.stripe.android.payments.PaymentFlowFailureMessageFactory;
import com.stripe.android.payments.PaymentFlowResult;
import com.stripe.android.payments.PaymentIntentFlowResultProcessor;
import com.stripe.android.payments.SetupIntentFlowResultProcessor;
import com.stripe.android.payments.core.authentication.DefaultPaymentAuthenticatorRegistry;
import com.stripe.android.payments.core.authentication.PaymentAuthenticatorRegistry;
import com.stripe.android.view.AuthActivityStarterHost;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.inject.Provider;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0084\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 j2\u00020\u0001:\u0001jB_\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u0012\b\b\u0002\u0010\r\u001a\u00020\u000e\u0012\b\b\u0002\u0010\u000f\u001a\u00020\u0010\u0012\b\b\u0002\u0010\u0011\u001a\u00020\u0012\u0012\b\b\u0002\u0010\u0013\u001a\u00020\f\u00a2\u0006\u0002\u0010\u0014J)\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00100J)\u00101\u001a\u00020)2\u0006\u00102\u001a\u0002032\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00104J!\u00105\u001a\u00020+2\u0006\u00106\u001a\u0002032\u0006\u0010.\u001a\u00020/H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00107J!\u00108\u001a\u0002092\u0006\u00106\u001a\u00020:2\u0006\u0010.\u001a\u00020/H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010;J!\u0010<\u001a\u00020=2\u0006\u00102\u001a\u0002032\u0006\u0010.\u001a\u00020/H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00107J\u0019\u0010>\u001a\u00020?2\u0006\u0010@\u001a\u00020AH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010BJ\u0019\u0010C\u001a\u00020)2\u0006\u0010@\u001a\u00020AH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010BJ\u0019\u0010D\u001a\u00020E2\u0006\u0010@\u001a\u00020AH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010BJ)\u0010F\u001a\u00020G2\u0006\u0010H\u001a\u00020\"2\u0006\u0010I\u001a\u00020J2\u0006\u0010K\u001a\u00020LH\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010MJ)\u0010N\u001a\u00020G2\u0006\u0010H\u001a\u00020\"2\u0006\u0010O\u001a\u00020P2\u0006\u0010.\u001a\u00020/H\u0097@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010QJ\u0012\u0010R\u001a\u00020G2\b\u0010S\u001a\u0004\u0018\u00010\u0006H\u0002J)\u0010T\u001a\u00020G2\u0006\u0010H\u001a\u00020\"2\u0006\u0010U\u001a\u00020?2\u0006\u0010.\u001a\u00020/H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010VJ\u001e\u0010W\u001a\u00020G2\u0006\u0010X\u001a\u00020Y2\f\u0010Z\u001a\b\u0012\u0004\u0012\u00020\\0[H\u0016J\u001a\u0010]\u001a\u00020\n2\u0006\u0010I\u001a\u00020J2\b\u0010@\u001a\u0004\u0018\u00010AH\u0016J\u001a\u0010^\u001a\u00020\n2\u0006\u0010I\u001a\u00020J2\b\u0010@\u001a\u0004\u0018\u00010AH\u0016J\u001a\u0010_\u001a\u00020\n2\u0006\u0010I\u001a\u00020J2\b\u0010@\u001a\u0004\u0018\u00010AH\u0016J1\u0010`\u001a\u00020G2\u0006\u0010H\u001a\u00020\"2\u0006\u0010a\u001a\u00020\u00062\u0006\u0010.\u001a\u00020/2\u0006\u0010b\u001a\u00020cH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010dJ)\u0010e\u001a\u00020G2\u0006\u0010H\u001a\u00020\"2\u0006\u0010U\u001a\u00020?2\u0006\u0010.\u001a\u00020/H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010VJ)\u0010f\u001a\u00020G2\u0006\u0010H\u001a\u00020\"2\u0006\u00106\u001a\u00020g2\u0006\u0010.\u001a\u00020/H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010hJ\b\u0010i\u001a\u00020GH\u0016R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001d\u001a\n\u0012\u0004\u0012\u00020\u001f\u0018\u00010\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020#0!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010&\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006k"}, d2={"Lcom/stripe/android/StripePaymentController;", "Lcom/stripe/android/PaymentController;", "context", "Landroid/content/Context;", "publishableKeyProvider", "Lkotlin/Function0;", "", "stripeRepository", "Lcom/stripe/android/networking/StripeRepository;", "enableLogging", "", "workContext", "Lkotlin/coroutines/CoroutineContext;", "analyticsRequestExecutor", "Lcom/stripe/android/networking/AnalyticsRequestExecutor;", "analyticsRequestFactory", "Lcom/stripe/android/networking/AnalyticsRequestFactory;", "alipayRepository", "Lcom/stripe/android/networking/AlipayRepository;", "uiContext", "(Landroid/content/Context;Lkotlin/jvm/functions/Function0;Lcom/stripe/android/networking/StripeRepository;ZLkotlin/coroutines/CoroutineContext;Lcom/stripe/android/networking/AnalyticsRequestExecutor;Lcom/stripe/android/networking/AnalyticsRequestFactory;Lcom/stripe/android/networking/AlipayRepository;Lkotlin/coroutines/CoroutineContext;)V", "authenticatorRegistry", "Lcom/stripe/android/payments/core/authentication/PaymentAuthenticatorRegistry;", "defaultReturnUrl", "Lcom/stripe/android/payments/DefaultReturnUrl;", "failureMessageFactory", "Lcom/stripe/android/payments/PaymentFlowFailureMessageFactory;", "paymentIntentFlowResultProcessor", "Lcom/stripe/android/payments/PaymentIntentFlowResultProcessor;", "paymentRelayLauncher", "Landroidx/activity/result/ActivityResultLauncher;", "Lcom/stripe/android/PaymentRelayStarter$Args;", "paymentRelayStarterFactory", "Lkotlin/Function1;", "Lcom/stripe/android/view/AuthActivityStarterHost;", "Lcom/stripe/android/PaymentRelayStarter;", "setupIntentFlowResultProcessor", "Lcom/stripe/android/payments/SetupIntentFlowResultProcessor;", "threeDs1IntentReturnUrlMap", "", "authenticateAlipay", "Lcom/stripe/android/PaymentIntentResult;", "paymentIntent", "Lcom/stripe/android/model/PaymentIntent;", "authenticator", "Lcom/stripe/android/AlipayAuthenticator;", "requestOptions", "Lcom/stripe/android/networking/ApiRequest$Options;", "(Lcom/stripe/android/model/PaymentIntent;Lcom/stripe/android/AlipayAuthenticator;Lcom/stripe/android/networking/ApiRequest$Options;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "confirmAndAuthenticateAlipay", "confirmPaymentIntentParams", "Lcom/stripe/android/model/ConfirmPaymentIntentParams;", "(Lcom/stripe/android/model/ConfirmPaymentIntentParams;Lcom/stripe/android/AlipayAuthenticator;Lcom/stripe/android/networking/ApiRequest$Options;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "confirmPaymentIntent", "confirmStripeIntentParams", "(Lcom/stripe/android/model/ConfirmPaymentIntentParams;Lcom/stripe/android/networking/ApiRequest$Options;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "confirmSetupIntent", "Lcom/stripe/android/model/SetupIntent;", "Lcom/stripe/android/model/ConfirmSetupIntentParams;", "(Lcom/stripe/android/model/ConfirmSetupIntentParams;Lcom/stripe/android/networking/ApiRequest$Options;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "confirmWeChatPay", "Lcom/stripe/android/model/WeChatPayNextAction;", "getAuthenticateSourceResult", "Lcom/stripe/android/model/Source;", "data", "Landroid/content/Intent;", "(Landroid/content/Intent;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getPaymentIntentResult", "getSetupIntentResult", "Lcom/stripe/android/SetupIntentResult;", "handleError", "", "host", "requestCode", "", "throwable", "", "(Lcom/stripe/android/view/AuthActivityStarterHost;ILjava/lang/Throwable;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "handleNextAction", "stripeIntent", "Lcom/stripe/android/model/StripeIntent;", "(Lcom/stripe/android/view/AuthActivityStarterHost;Lcom/stripe/android/model/StripeIntent;Lcom/stripe/android/networking/ApiRequest$Options;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "logReturnUrl", "returnUrl", "onSourceRetrieved", "source", "(Lcom/stripe/android/view/AuthActivityStarterHost;Lcom/stripe/android/model/Source;Lcom/stripe/android/networking/ApiRequest$Options;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "registerLaunchersWithActivityResultCaller", "activityResultCaller", "Landroidx/activity/result/ActivityResultCaller;", "activityResultCallback", "Landroidx/activity/result/ActivityResultCallback;", "Lcom/stripe/android/payments/PaymentFlowResult$Unvalidated;", "shouldHandlePaymentResult", "shouldHandleSetupResult", "shouldHandleSourceResult", "startAuth", "clientSecret", "type", "Lcom/stripe/android/PaymentController$StripeIntentType;", "(Lcom/stripe/android/view/AuthActivityStarterHost;Ljava/lang/String;Lcom/stripe/android/networking/ApiRequest$Options;Lcom/stripe/android/PaymentController$StripeIntentType;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "startAuthenticateSource", "startConfirmAndAuth", "Lcom/stripe/android/model/ConfirmStripeIntentParams;", "(Lcom/stripe/android/view/AuthActivityStarterHost;Lcom/stripe/android/model/ConfirmStripeIntentParams;Lcom/stripe/android/networking/ApiRequest$Options;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "unregisterLaunchers", "Companion", "payments-core_release"})
public final class StripePaymentController
implements PaymentController {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Function0<String> publishableKeyProvider;
    @NotNull
    private final StripeRepository stripeRepository;
    private final boolean enableLogging;
    @NotNull
    private final AnalyticsRequestExecutor analyticsRequestExecutor;
    @NotNull
    private final AnalyticsRequestFactory analyticsRequestFactory;
    @NotNull
    private final AlipayRepository alipayRepository;
    @NotNull
    private final CoroutineContext uiContext;
    @NotNull
    private final PaymentFlowFailureMessageFactory failureMessageFactory;
    @NotNull
    private final PaymentIntentFlowResultProcessor paymentIntentFlowResultProcessor;
    @NotNull
    private final SetupIntentFlowResultProcessor setupIntentFlowResultProcessor;
    @NotNull
    private final DefaultReturnUrl defaultReturnUrl;
    @Nullable
    private ActivityResultLauncher<PaymentRelayStarter.Args> paymentRelayLauncher;
    @NotNull
    private final Function1<AuthActivityStarterHost, PaymentRelayStarter> paymentRelayStarterFactory;
    @NotNull
    private final Map<String, String> threeDs1IntentReturnUrlMap;
    @NotNull
    private final PaymentAuthenticatorRegistry authenticatorRegistry;
    public static final int PAYMENT_REQUEST_CODE = 50000;
    public static final int SETUP_REQUEST_CODE = 50001;
    public static final int SOURCE_REQUEST_CODE = 50002;
    @NotNull
    private static final List<String> EXPAND_PAYMENT_METHOD = CollectionsKt.listOf((Object)"payment_method");
    private static final long CHALLENGE_DELAY = TimeUnit.SECONDS.toMillis(2L);
    @NotNull
    private static final String REQUIRED_ERROR = "API request returned an invalid response.";

    public StripePaymentController(@NotNull Context context, @NotNull Function0<String> publishableKeyProvider, @NotNull StripeRepository stripeRepository2, boolean enableLogging, @NotNull CoroutineContext workContext, @NotNull AnalyticsRequestExecutor analyticsRequestExecutor, @NotNull AnalyticsRequestFactory analyticsRequestFactory2, @NotNull AlipayRepository alipayRepository, @NotNull CoroutineContext uiContext) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(publishableKeyProvider, (String)"publishableKeyProvider");
        Intrinsics.checkNotNullParameter((Object)stripeRepository2, (String)"stripeRepository");
        Intrinsics.checkNotNullParameter((Object)workContext, (String)"workContext");
        Intrinsics.checkNotNullParameter((Object)analyticsRequestExecutor, (String)"analyticsRequestExecutor");
        Intrinsics.checkNotNullParameter((Object)analyticsRequestFactory2, (String)"analyticsRequestFactory");
        Intrinsics.checkNotNullParameter((Object)alipayRepository, (String)"alipayRepository");
        Intrinsics.checkNotNullParameter((Object)uiContext, (String)"uiContext");
        this.publishableKeyProvider = publishableKeyProvider;
        this.stripeRepository = stripeRepository2;
        this.enableLogging = enableLogging;
        this.analyticsRequestExecutor = analyticsRequestExecutor;
        this.analyticsRequestFactory = analyticsRequestFactory2;
        this.alipayRepository = alipayRepository;
        this.uiContext = uiContext;
        this.failureMessageFactory = new PaymentFlowFailureMessageFactory(context);
        this.paymentIntentFlowResultProcessor = new PaymentIntentFlowResultProcessor(context, this.publishableKeyProvider, this.stripeRepository, Logger.Companion.getInstance(this.enableLogging), workContext);
        this.setupIntentFlowResultProcessor = new SetupIntentFlowResultProcessor(context, this.publishableKeyProvider, this.stripeRepository, Logger.Companion.getInstance(this.enableLogging), workContext);
        this.defaultReturnUrl = DefaultReturnUrl.Companion.create(context);
        this.paymentRelayStarterFactory = (Function1)new Function1<AuthActivityStarterHost, PaymentRelayStarter>(this){
            final /* synthetic */ StripePaymentController this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final PaymentRelayStarter invoke(@NotNull AuthActivityStarterHost host) {
                PaymentRelayStarter.Modern modern;
                Intrinsics.checkNotNullParameter((Object)host, (String)"host");
                ActivityResultLauncher activityResultLauncher = StripePaymentController.access$getPaymentRelayLauncher$p(this.this$0);
                if (activityResultLauncher == null) {
                    modern = null;
                } else {
                    ActivityResultLauncher activityResultLauncher2 = activityResultLauncher;
                    boolean bl = false;
                    boolean bl2 = false;
                    ActivityResultLauncher it = activityResultLauncher2;
                    boolean bl3 = false;
                    modern = new PaymentRelayStarter.Modern((ActivityResultLauncher<PaymentRelayStarter.Args>)it);
                }
                PaymentRelayStarter.Modern modern2 = modern;
                return modern2 == null ? (PaymentRelayStarter)new PaymentRelayStarter.Legacy(host) : (PaymentRelayStarter)modern2;
            }
        };
        boolean bl = false;
        this.threeDs1IntentReturnUrlMap = new LinkedHashMap();
        this.authenticatorRegistry = DefaultPaymentAuthenticatorRegistry.Companion.createInstance(context, this.stripeRepository, this.analyticsRequestExecutor, this.analyticsRequestFactory, this.enableLogging, workContext, this.uiContext, this.threeDs1IntentReturnUrlMap, this.publishableKeyProvider, this.analyticsRequestFactory.getDefaultProductUsageTokens$payments_core_release());
    }

    public /* synthetic */ StripePaymentController(Context context, Function0 function0, StripeRepository stripeRepository2, boolean bl, CoroutineContext coroutineContext, AnalyticsRequestExecutor analyticsRequestExecutor, AnalyticsRequestFactory analyticsRequestFactory2, AlipayRepository alipayRepository, CoroutineContext coroutineContext2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            bl = false;
        }
        if ((n & 0x10) != 0) {
            coroutineContext = (CoroutineContext)Dispatchers.getIO();
        }
        if ((n & 0x20) != 0) {
            analyticsRequestExecutor = new DefaultAnalyticsRequestExecutor(Logger.Companion.getInstance(bl), coroutineContext);
        }
        if ((n & 0x40) != 0) {
            Context context2 = context.getApplicationContext();
            Intrinsics.checkNotNullExpressionValue((Object)context2, (String)new StringBuilder(18807).append("constructor(\n    context: Context,\n    private val publishableKeyProvider: () -> String,\n    private val stripeRepository: StripeRepository,\n    private val enableLogging: Boolean = false,\n    workContext: CoroutineContext = Dispatchers.IO,\n    private val analyticsRequestExecutor: AnalyticsRequestExecutor =\n        DefaultAnalyticsRequestExecutor(Logger.getInstance(enableLogging), workContext),\n    private val analyticsRequestFactory: AnalyticsRequestFactory =\n        AnalyticsRequestFactory(context.applicationContext, publishableKeyProvider),\n    private val alipayRepository: AlipayRepository = DefaultAlipayRepository(stripeRepository),\n    private val uiContext: CoroutineContext = Dispatchers.Main\n) : PaymentController {\n\n    private val failureMessageFactory = PaymentFlowFailureMessageFactory(context)\n    private val paymentIntentFlowResultProcessor = PaymentIntentFlowResultProcessor(\n        context,\n        publishableKeyProvider,\n        stripeRepository,\n        Logger.getInstance(enableLogging),\n        workContext\n    )\n    private val setupIntentFlowResultProcessor = SetupIntentFlowResultProcessor(\n        context,\n        publishableKeyProvider,\n        stripeRepository,\n        Logger.getInstance(enableLogging),\n        workContext\n    )\n\n    private val defaultReturnUrl = DefaultReturnUrl.create(context)\n\n    /**\n     * [paymentRelayLauncher] is mutable and might be updated during\n     * through [registerLaunchersWithActivityResultCaller]\n     */\n    private var paymentRelayLauncher: ActivityResultLauncher<PaymentRelayStarter.Args>? = null\n    private val paymentRelayStarterFactory = { host: AuthActivityStarterHost ->\n        paymentRelayLauncher?.let {\n            PaymentRelayStarter.Modern(it)\n        } ?: PaymentRelayStarter.Legacy(host)\n    }\n\n    /**\n     * A map between 3ds1 [StripeIntent] ids to its corresponding returnUrl.\n     * An entry will be removed once the [StripeIntent] is confirmed.\n     */\n    private val threeDs1IntentReturnUrlMap = mutableMapOf<String, String>()\n\n    private val authenticatorRegistry: PaymentAuthenticatorRegistry =\n        DefaultPaymentAuthenticatorRegistry.createInstance(\n            context,\n            stripeRepository,\n            analyticsRequestExecutor,\n            analyticsRequestFactory,\n            enableLogging,\n            workContext,\n            uiContext,\n            threeDs1IntentReturnUrlMap,\n            publishableKeyProvider,\n            analyticsRequestFactory.defaultProductUsageTokens\n        )\n\n    override fun registerLaunchersWithActivityResultCaller(\n        activityResultCaller: ActivityResultCaller,\n        activityResultCallback: ActivityResultCallback<PaymentFlowResult.Unvalidated>\n    ) {\n        paymentRelayLauncher = activityResultCaller.registerForActivityResult(\n            PaymentRelayContract(),\n            activityResultCallback\n        )\n        authenticatorRegistry.onNewActivityResultCaller(\n            activityResultCaller,\n            activityResultCallback\n        )\n    }\n\n    override fun unregisterLaunchers() {\n        paymentRelayLauncher?.unregister()\n        paymentRelayLauncher = null\n        authenticatorRegistry.onLauncherInvalidated()\n    }\n\n    /**\n     * Confirm the Stripe Intent and resolve any next actions\n     */\n    override suspend fun startConfirmAndAuth(\n        host: AuthActivityStarterHost,\n        confirmStripeIntentParams: ConfirmStripeIntentParams,\n        requestOptions: ApiRequest.Options\n    ) {\n        logReturnUrl(confirmStripeIntentParams.returnUrl)\n\n        val returnUrl = confirmStripeIntentParams.returnUrl.takeUnless { it.isNullOrBlank() }\n            ?: defaultReturnUrl.value\n\n        runCatching {\n            when (confirmStripeIntentParams) {\n                is ConfirmPaymentIntentParams -> {\n                    confirmPaymentIntent(\n                        confirmStripeIntentParams.also {\n                            it.returnUrl = returnUrl\n                        },\n                        requestOptions\n                    )\n                }\n                is ConfirmSetupIntentParams -> {\n                    confirmSetupIntent(\n                        confirmStripeIntentParams.also {\n                            it.returnUrl = returnUrl\n                        },\n                        requestOptions\n                    )\n                }\n            }\n        }.fold(\n            onSuccess = { intent ->\n                intent.nextActionData?.let {\n                    if (it is StripeIntent.NextActionData.SdkData.Use3DS1) {\n                        intent.id?.let { intentId ->\n                            threeDs1IntentReturnUrlMap[intentId] = returnUrl\n                        }\n                    }\n                }\n                handleNextAction(\n                    host,\n                    intent,\n                    requestOptions\n                )\n            },\n            onFailure = {\n                handleError(\n                    host,\n                    getRequestCode(confirmStripeIntentParams),\n                    it\n                )\n            }\n        )\n    }\n\n    override suspend fun confirmAndAuthenticateAlipay(\n        confirmPaymentIntentParams: ConfirmPaymentIntentParams,\n        authenticator: AlipayAuthenticator,\n        requestOptions: ApiRequest.Options\n    ): PaymentIntentResult {\n        return authenticateAlipay(\n            confirmPaymentIntent(\n                confirmPaymentIntentParams,\n                requestOptions\n            ),\n            authenticator,\n            requestOptions\n        )\n    }\n\n    override suspend fun confirmWeChatPay(\n        confirmPaymentIntentParams: ConfirmPaymentIntentParams,\n        requestOptions: ApiRequest.Options\n    ): WeChatPayNextAction {\n        confirmPaymentIntent(\n            confirmPaymentIntentParams,\n            requestOptions\n        ).let { paymentIntent ->\n            require(paymentIntent.nextActionData is StripeIntent.NextActionData.WeChatPayRedirect) {\n                \"Unable to confirm Payment Intent with WeChatPay SDK\"\n            }\n            return WeChatPayNextAction(\n                paymentIntent,\n                paymentIntent.nextActionData.weChat,\n            )\n        }\n    }\n\n    private suspend fun confirmPaymentIntent(\n        confirmStripeIntentParams: ConfirmPaymentIntentParams,\n        requestOptions: ApiRequest.Options\n    ): PaymentIntent {\n        return requireNotNull(\n            stripeRepository.confirmPaymentIntent(\n                // mark this request as `use_stripe_sdk=true`\n                confirmStripeIntentParams\n                    .withShouldUseStripeSdk(shouldUseStripeSdk = true),\n                requestOptions,\n                expandFields = EXPAND_PAYMENT_METHOD\n            )\n        ) {\n            REQUIRED_ERROR\n        }\n    }\n\n    private suspend fun confirmSetupIntent(\n        confirmStripeIntentParams: ConfirmSetupIntentParams,\n        requestOptions: ApiRequest.Options\n    ): SetupIntent {\n        return requireNotNull(\n            stripeRepository.confirmSetupIntent(\n                // mark this request as `use_stripe_sdk=true`\n                confirmStripeIntentParams\n                    .withShouldUseStripeSdk(shouldUseStripeSdk = true),\n                requestOptions,\n                expandFields = EXPAND_PAYMENT_METHOD\n            )\n        ) {\n            REQUIRED_ERROR\n        }\n    }\n\n    override suspend fun startAuth(\n        host: AuthActivityStarterHost,\n        clientSecret: String,\n        requestOptions: ApiRequest.Options,\n        type: PaymentController.StripeIntentType\n    ) {\n        runCatching {\n            val stripeIntent = when (type) {\n                PaymentController.StripeIntentType.PaymentIntent -> {\n                    stripeRepository.retrievePaymentIntent(\n                        clientSecret,\n                        requestOptions\n                    )\n                }\n                PaymentController.StripeIntentType.SetupIntent -> {\n                    stripeRepository.retrieveSetupIntent(\n                        clientSecret,\n                        requestOptions\n                    )\n                }\n            }\n            requireNotNull(stripeIntent)\n        }.fold(\n            onSuccess = { stripeIntent ->\n                handleNextAction(\n                    host = host,\n                    stripeIntent = stripeIntent,\n                    requestOptions = requestOptions\n                )\n            },\n            onFailure = {\n                handleError(\n                    host,\n                    when (type) {\n                        PaymentController.StripeIntentType.PaymentIntent -> {\n                            PAYMENT_REQUEST_CODE\n                        }\n                        PaymentController.StripeIntentType.SetupIntent -> {\n                            SETUP_REQUEST_CODE\n                        }\n                    },\n                    it\n                )\n            }\n        )\n    }\n\n    override suspend fun startAuthenticateSource(\n        host: AuthActivityStarterHost,\n        source: Source,\n        requestOptions: ApiRequest.Options\n    ) {\n        analyticsRequestExecutor.executeAsync(\n            analyticsRequestFactory.createRequest(AnalyticsEvent.AuthSourceStart)\n        )\n\n        runCatching {\n            requireNotNull(\n                stripeRepository.retrieveSource(\n                    sourceId = source.id.orEmpty(),\n                    clientSecret = source.clientSecret.orEmpty(),\n                    options = requestOptions\n                )\n            )\n        }.fold(\n            onSuccess = { retrievedSourced ->\n                onSourceRetrieved(host, retrievedSourced, requestOptions)\n            },\n            onFailure = {\n                handleError(\n                    host,\n                    SOURCE_REQUEST_CODE,\n                    it\n                )\n            }\n        )\n    }\n\n    private suspend fun onSourceRetrieved(\n        host: AuthActivityStarterHost,\n        source: Source,\n        requestOptions: ApiRequest.Options\n    ) {\n\n        authenticatorRegistry.getAuthenticator(source).authenticate(\n            host,\n            source,\n            requestOptions\n        )\n    }\n\n    /**\n     * Decide whether [getPaymentIntentResult] should be called.\n     */\n    override fun shouldHandlePaymentResult(requestCode: Int, data: Intent?): Boolean {\n        return requestCode == PAYMENT_REQUEST_CODE && data != null\n    }\n\n    /**\n     * Decide whether [getSetupIntentResult] should be called.\n     */\n    override fun shouldHandleSetupResult(requestCode: Int, data: Intent?): Boolean {\n        return requestCode == SETUP_REQUEST_CODE && data != null\n    }\n\n    override fun shouldHandleSourceResult(requestCode: Int, data: Intent?): Boolean {\n        return requestCode == SOURCE_REQUEST_CODE && data != null\n    }\n\n    /**\n     * Get the PaymentIntent's client_secret from {@param data} and use to retrieve\n     * the PaymentIntent object with updated status.\n     *\n     * @param data the result Intent\n     * @return the [PaymentIntentResult] object\n     *\n     * @throws AuthenticationException failure to properly authenticate yourself (check your key)\n     * @throws InvalidRequestException your request has invalid parameters\n     * @throws APIConnectionException failure to connect to Stripe's API\n     * @throws APIException any other type of problem (for instance, a temporary issue with Stripe's servers)\n     * @throws IllegalArgumentException if the response's JsonParser returns null\n     */\n    @Throws(\n        AuthenticationException::class,\n        InvalidRequestException::class,\n        APIConnectionException::class,\n        APIException::class,\n        IllegalArgumentException::class\n    )\n    override suspend fun getPaymentIntentResult(data: Intent) =\n        paymentIntentFlowResultProcessor.processResult(\n            PaymentFlowResult.Unvalidated.fromIntent(data)\n        )\n\n    /**\n     * Get the SetupIntent's client_secret from {@param data} and use to retrieve\n     * the PaymentIntent object with updated status.\n     *\n     * @param data the result Intent\n     * @return the [SetupIntentResult] object\n     *\n     * @throws AuthenticationException failure to properly authenticate yourself (check your key)\n     * @throws InvalidRequestException your request has invalid parameters\n     * @throws APIConnectionException failure to connect to Stripe's API\n     * @throws APIException any other type of problem (for instance, a temporary issue with Stripe's servers)\n     * @throws IllegalArgumentException if the response's JsonParser returns null\n     */\n    @Throws(\n        AuthenticationException::class,\n        InvalidRequestException::class,\n        APIConnectionException::class,\n        APIException::class,\n        IllegalArgumentException::class\n    )\n    override suspend fun getSetupIntentResult(data: Intent) =\n        setupIntentFlowResultProcessor.processResult(\n            PaymentFlowResult.Unvalidated.fromIntent(data)\n        )\n\n    /**\n     * Get the Source's client_secret from {@param data} and use to retrieve\n     * the Source object with updated status.\n     *\n     * @param data the result Intent\n     * @return the [Source] object\n     *\n     * @throws AuthenticationException failure to properly authenticate yourself (check your key)\n     * @throws InvalidRequestException your request has invalid parameters\n     * @throws APIConnectionException failure to connect to Stripe's API\n     * @throws APIException any other type of problem (for instance, a temporary issue with Stripe's servers)\n     * @throws IllegalArgumentException if the Source response's JsonParser returns null\n     */\n    @Throws(\n        AuthenticationException::class,\n        InvalidRequestException::class,\n        APIConnectionException::class,\n        APIException::class,\n        IllegalArgumentException::class\n    )\n    override suspend fun getAuthenticateSourceResult(data: Intent): Source {\n        val result = PaymentFlowResult.Unvalidated.fromIntent(data)\n        val sourceId = result.sourceId.orEmpty()\n        val clientSecret = result.clientSecret.orEmpty()\n\n        val requestOptions = ApiRequest.Options(\n            apiKey = publishableKeyProvider(),\n            stripeAccount = result.stripeAccountId\n        )\n\n        analyticsRequestExecutor.executeAsync(\n            analyticsRequestFactory.createRequest(AnalyticsEvent.AuthSourceResult)\n        )\n\n        return requireNotNull(\n            stripeRepository.retrieveSource(\n                sourceId,\n                clientSecret,\n                requestOptions\n            )\n        )\n    }\n\n    private suspend fun authenticateAlipay(\n        paymentIntent: PaymentIntent,\n        authenticator: AlipayAuthenticator,\n        requestOptions: ApiRequest.Options\n    ): PaymentIntentResult {\n        val outcome =\n            alipayRepository.authenticate(paymentIntent, authenticator, requestOptions).outcome\n        val refreshedPaymentIntent = requireNotNull(\n            stripeRepository.retrievePaymentIntent(\n                paymentIntent.clientSecret.orEmpty(),\n                requestOptions,\n                expandFields = EXPAND_PAYMENT_METHOD\n            )\n        )\n\n        return PaymentIntentResult(\n            refreshedPaymentIntent,\n            outcome,\n            failureMessageFactory.create(refreshedPaymentIntent, outcome)\n        )\n    }\n\n    private suspend fun handleError(\n        host: AuthActivityStarterHost,\n        requestCode: Int,\n        throwable: Throwable\n    ) = withContext(uiContext) {\n        paymentRelayStarterFactory(host)\n            .start(\n                PaymentRelayStarter.Args.ErrorArgs(\n                    StripeException.create(throwable),\n                    requestCode\n                )\n            )\n    }\n\n    /**\n     * Determine which authentication mechanism should be used, or bypass authentication\n     * if it is not needed.\n     */\n    @VisibleForTesting\n    override suspend fun handleNextAction(\n        host: AuthActivityStarterHost,\n        stripeIntent: StripeIntent,\n        requestOptions: ApiRequest.Options\n    ) {\n        authenticatorRegistry.getAuthenticator(stripeIntent).authenticate(\n            host,\n            stripeIntent,\n            requestOptions\n        )\n    }\n\n    private fun logReturnUrl(returnUrl: String?) {\n        when (r").append("eturnUrl) {\n            defaultReturnUrl.value -> {\n                AnalyticsEvent.ConfirmReturnUrlDefault\n            }\n            null -> {\n                AnalyticsEvent.ConfirmReturnUrlNull\n            }\n            else -> {\n                AnalyticsEvent.ConfirmReturnUrlCustom\n            }\n        }.let { event ->\n            analyticsRequestExecutor.executeAsync(\n                analyticsRequestFactory.createRequest(event)\n            )\n        }\n    }\n\n    internal companion object {\n        internal const val PAYMENT_REQUEST_CODE = 50000\n        internal const val SETUP_REQUEST_CODE = 50001\n        internal const val SOURCE_REQUEST_CODE = 50002\n\n        /**\n         * Get the appropriate request code for the given stripe intent type\n         *\n         * @param intent the [StripeIntent] to get the request code for\n         * @return PAYMENT_REQUEST_CODE or SETUP_REQUEST_CODE\n         */\n        @JvmSynthetic\n        internal fun getRequestCode(intent: StripeIntent): Int {\n            return if (intent is PaymentIntent) {\n                PAYMENT_REQUEST_CODE\n            } else {\n                SETUP_REQUEST_CODE\n            }\n        }\n\n        /**\n         * Get the appropriate request code for the given stripe intent params type\n         *\n         * @param params the [ConfirmStripeIntentParams] to get the request code for\n         * @return PAYMENT_REQUEST_CODE or SETUP_REQUEST_CODE\n         */\n        @JvmSynthetic\n        internal fun getRequestCode(params: ConfirmStripeIntentParams): Int {\n            return when (params) {\n                is ConfirmPaymentIntentParams -> PAYMENT_REQUEST_CODE\n                is ConfirmSetupIntentParams -> SETUP_REQUEST_CODE\n            }\n        }\n\n        @JvmStatic\n        @JvmOverloads\n        fun create(\n            context: Context,\n            publishableKey: String,\n            stripeRepository: StripeRepository,\n            enableLogging: Boolean = false\n        ): PaymentController {\n            return StripePaymentController(\n                context.applicationContext,\n                { publishableKey },\n                stripeRepository,\n                enableLogging\n            )\n        }\n\n        internal val EXPAND_PAYMENT_METHOD = listOf(\"payment_method\")\n        internal val CHALLENGE_DELAY = TimeUnit.SECONDS.toMillis(2L)\n\n        private const val REQUIRED_ERROR = \"API request returned an invalid response.\"\n    }\n}").toString());
            Context context3 = context2;
            context2 = function0;
            analyticsRequestFactory2 = new AnalyticsRequestFactory(context3, (Provider<String>)((Provider)() -> StripePaymentController._init_$lambda-0((Function0)context2)));
        }
        if ((n & 0x80) != 0) {
            alipayRepository = new DefaultAlipayRepository(stripeRepository2);
        }
        if ((n & 0x100) != 0) {
            coroutineContext2 = (CoroutineContext)Dispatchers.getMain();
        }
        this(context, (Function0<String>)function0, stripeRepository2, bl, coroutineContext, analyticsRequestExecutor, analyticsRequestFactory2, alipayRepository, coroutineContext2);
    }

    @Override
    public void registerLaunchersWithActivityResultCaller(@NotNull ActivityResultCaller activityResultCaller, @NotNull ActivityResultCallback<PaymentFlowResult.Unvalidated> activityResultCallback) {
        Intrinsics.checkNotNullParameter((Object)activityResultCaller, (String)"activityResultCaller");
        Intrinsics.checkNotNullParameter(activityResultCallback, (String)"activityResultCallback");
        this.paymentRelayLauncher = activityResultCaller.registerForActivityResult((ActivityResultContract)new PaymentRelayContract(), activityResultCallback);
        this.authenticatorRegistry.onNewActivityResultCaller(activityResultCaller, activityResultCallback);
    }

    @Override
    public void unregisterLaunchers() {
        ActivityResultLauncher<PaymentRelayStarter.Args> activityResultLauncher = this.paymentRelayLauncher;
        if (activityResultLauncher != null) {
            activityResultLauncher.unregister();
        }
        this.paymentRelayLauncher = null;
        this.authenticatorRegistry.onLauncherInvalidated();
    }

    /*
     * Exception decompiling
     */
    @Override
    @Nullable
    public Object startConfirmAndAuth(@NotNull AuthActivityStarterHost var1_1, @NotNull ConfirmStripeIntentParams var2_2, @NotNull ApiRequest.Options var3_3, @NotNull Continuation<? super Unit> var4_4) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[CASE], 3[SWITCH]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object confirmAndAuthenticateAlipay(@NotNull ConfirmPaymentIntentParams var1_1, @NotNull AlipayAuthenticator var2_2, @NotNull ApiRequest.Options var3_3, @NotNull Continuation<? super PaymentIntentResult> var4_4) {
        if (!(var4_4 instanceof confirmAndAuthenticateAlipay.1)) ** GOTO lbl-1000
        var8_5 = var4_4;
        if ((var8_5.label & -2147483648) != 0) {
            var8_5.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var4_4){
                Object L$0;
                Object L$1;
                Object L$2;
                /* synthetic */ Object result;
                final /* synthetic */ StripePaymentController this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.confirmAndAuthenticateAlipay(null, null, null, (Continuation<? super PaymentIntentResult>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var9_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                var5_8 = this;
                $continuation.L$0 = authenticator;
                $continuation.L$1 = requestOptions;
                $continuation.L$2 = var5_8;
                $continuation.label = 1;
                v0 = this.confirmPaymentIntent((ConfirmPaymentIntentParams)confirmPaymentIntentParams, requestOptions, (Continuation<? super PaymentIntent>)$continuation);
                if (v0 == var9_7) {
                    return var9_7;
                }
                ** GOTO lbl27
            }
            case 1: {
                var5_8 = (StripePaymentController)$continuation.L$2;
                requestOptions = (ApiRequest.Options)$continuation.L$1;
                authenticator = (AlipayAuthenticator)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl27:
                // 2 sources

                var6_9 = v0;
                $continuation.L$0 = null;
                $continuation.L$1 = null;
                $continuation.L$2 = null;
                $continuation.label = 2;
                v1 = var5_8.authenticateAlipay((PaymentIntent)var6_9, authenticator, requestOptions, (Continuation<? super PaymentIntentResult>)$continuation);
                if (v1 == var9_7) {
                    return var9_7;
                }
                ** GOTO lbl39
            }
            case 2: {
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl39:
                // 2 sources

                return v1;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object confirmWeChatPay(@NotNull ConfirmPaymentIntentParams var1_1, @NotNull ApiRequest.Options var2_2, @NotNull Continuation<? super WeChatPayNextAction> var3_3) {
        if (!(var3_3 instanceof confirmWeChatPay.1)) ** GOTO lbl-1000
        var14_4 = var3_3;
        if ((var14_4.label & -2147483648) != 0) {
            var14_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var3_3){
                /* synthetic */ Object result;
                final /* synthetic */ StripePaymentController this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.confirmWeChatPay(null, null, (Continuation<? super WeChatPayNextAction>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var15_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.label = 1;
                v0 = this.confirmPaymentIntent((ConfirmPaymentIntentParams)confirmPaymentIntentParams, (ApiRequest.Options)requestOptions, (Continuation<? super PaymentIntent>)$continuation);
                if (v0 == var15_6) {
                    return var15_6;
                }
                ** GOTO lbl20
            }
            case 1: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl20:
                // 2 sources

                var4_7 = v0;
                var5_8 = false;
                var6_9 = false;
                paymentIntent = (PaymentIntent)var4_7;
                $i$a$-let-StripePaymentController$confirmWeChatPay$2 = false;
                var9_12 = paymentIntent.getNextActionData() instanceof StripeIntent.NextActionData.WeChatPayRedirect;
                var10_13 = false;
                var11_14 = false;
                if (!var9_12) {
                    $i$a$-require-StripePaymentController$confirmWeChatPay$2$1 = false;
                    var11_15 = "Unable to confirm Payment Intent with WeChatPay SDK";
                    throw (Throwable)new IllegalArgumentException(var11_15.toString());
                }
                return new WeChatPayNextAction(paymentIntent, ((StripeIntent.NextActionData.WeChatPayRedirect)paymentIntent.getNextActionData()).getWeChat());
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private final Object confirmPaymentIntent(ConfirmPaymentIntentParams var1_1, ApiRequest.Options var2_2, Continuation<? super PaymentIntent> var3_3) {
        if (!(var3_3 instanceof confirmPaymentIntent.1)) ** GOTO lbl-1000
        var9_4 = var3_3;
        if ((var9_4.label & -2147483648) != 0) {
            var9_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var3_3){
                /* synthetic */ Object result;
                final /* synthetic */ StripePaymentController this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return StripePaymentController.access$confirmPaymentIntent(this.this$0, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var10_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.label = 1;
                v0 = this.stripeRepository.confirmPaymentIntent$payments_core_release(confirmStripeIntentParams.withShouldUseStripeSdk(true), (ApiRequest.Options)requestOptions, StripePaymentController.EXPAND_PAYMENT_METHOD, (Continuation<? super PaymentIntent>)$continuation);
                if (v0 == var10_6) {
                    return var10_6;
                }
                ** GOTO lbl20
            }
            case 1: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl20:
                // 2 sources

                var4_7 = v0;
                var5_8 = false;
                var6_9 = false;
                if (var4_7 == null) {
                    $i$a$-requireNotNull-StripePaymentController$confirmPaymentIntent$2 = false;
                    var6_10 = "API request returned an invalid response.";
                    throw (Throwable)new IllegalArgumentException(var6_10.toString());
                }
                return var4_7;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private final Object confirmSetupIntent(ConfirmSetupIntentParams var1_1, ApiRequest.Options var2_2, Continuation<? super SetupIntent> var3_3) {
        if (!(var3_3 instanceof confirmSetupIntent.1)) ** GOTO lbl-1000
        var9_4 = var3_3;
        if ((var9_4.label & -2147483648) != 0) {
            var9_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var3_3){
                /* synthetic */ Object result;
                final /* synthetic */ StripePaymentController this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return StripePaymentController.access$confirmSetupIntent(this.this$0, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var10_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.label = 1;
                v0 = this.stripeRepository.confirmSetupIntent$payments_core_release(confirmStripeIntentParams.withShouldUseStripeSdk(true), (ApiRequest.Options)requestOptions, StripePaymentController.EXPAND_PAYMENT_METHOD, (Continuation<? super SetupIntent>)$continuation);
                if (v0 == var10_6) {
                    return var10_6;
                }
                ** GOTO lbl20
            }
            case 1: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl20:
                // 2 sources

                var4_7 = v0;
                var5_8 = false;
                var6_9 = false;
                if (var4_7 == null) {
                    $i$a$-requireNotNull-StripePaymentController$confirmSetupIntent$2 = false;
                    var6_10 = "API request returned an invalid response.";
                    throw (Throwable)new IllegalArgumentException(var6_10.toString());
                }
                return var4_7;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Exception decompiling
     */
    @Override
    @Nullable
    public Object startAuth(@NotNull AuthActivityStarterHost var1_1, @NotNull String var2_2, @NotNull ApiRequest.Options var3_3, @NotNull PaymentController.StripeIntentType var4_4, @NotNull Continuation<? super Unit> var5_5) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Extractable last case doesn't follow previous, and can't clone.
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.examineSwitchContiguity(SwitchReplacer.java:611)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:94)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Override
    @Nullable
    public Object startAuthenticateSource(@NotNull AuthActivityStarterHost var1_1, @NotNull Source var2_2, @NotNull ApiRequest.Options var3_3, @NotNull Continuation<? super Unit> var4_4) {
        if (!(var4_4 instanceof startAuthenticateSource.1)) ** GOTO lbl-1000
        var16_5 = var4_4;
        if ((var16_5.label & -2147483648) != 0) {
            var16_5.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var4_4){
                Object L$0;
                Object L$1;
                Object L$2;
                /* synthetic */ Object result;
                final /* synthetic */ StripePaymentController this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.startAuthenticateSource(null, null, null, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var17_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                this.analyticsRequestExecutor.executeAsync(AnalyticsRequestFactory.createRequest$payments_core_release$default(this.analyticsRequestFactory, AnalyticsEvent.AuthSourceStart, null, null, null, null, 30, null));
                var5_8 = this;
                var6_9 = false;
                var7_10 /* !! */  = Result.Companion;
                $this$startAuthenticateSource_u24lambda_u2d16 = var5_8;
                $i$a$-runCatching-StripePaymentController$startAuthenticateSource$2 = false;
                v0 = $this$startAuthenticateSource_u24lambda_u2d16.stripeRepository;
                var10_21 = source.getId();
                var11_23 = false;
                v1 = var10_21;
                if (v1 == null) {
                    v1 = "";
                }
                var10_21 = source.getClientSecret();
                var11_23 = false;
                v2 = var10_21;
                if (v2 == null) {
                    v2 = "";
                }
                $continuation.L$0 = this;
                $continuation.L$1 = host;
                $continuation.L$2 = requestOptions;
                $continuation.label = 1;
                v3 = v0.retrieveSource$payments_core_release((String)v1, (String)v2, requestOptions, (Continuation<? super Source>)$continuation);
                ** if (v3 != var17_7) goto lbl38
lbl37:
                // 1 sources

                return var17_7;
lbl38:
                // 1 sources

                ** GOTO lbl48
            }
            case 1: {
                $i$a$-runCatching-StripePaymentController$startAuthenticateSource$2 = false;
                requestOptions = (ApiRequest.Options)$continuation.L$2;
                host = (AuthActivityStarterHost)$continuation.L$1;
                this = (StripePaymentController)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v3 = $result;
lbl48:
                    // 2 sources

                    var10_21 = v3;
                    var11_23 = false;
                    var12_24 = false;
                    var12_24 = false;
                    var13_25 = false;
                    if (var10_21 == null) {
                        var14_27 = false;
                        var13_26 = "Required value was null.";
                        throw (Throwable)new IllegalArgumentException(var13_26.toString());
                    }
                    $this$startAuthenticateSource_u24lambda_u2d16 = (Source)var10_21;
                    $i$a$-runCatching-StripePaymentController$startAuthenticateSource$2 = false;
                    var7_10 /* !! */  = Result.constructor-impl((Object)$this$startAuthenticateSource_u24lambda_u2d16);
                }
                catch (Throwable $this$startAuthenticateSource_u24lambda_u2d16) {
                    $i$a$-runCatching-StripePaymentController$startAuthenticateSource$2 = Result.Companion;
                    var10_22 = false;
                    var7_10 /* !! */  = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)$this$startAuthenticateSource_u24lambda_u2d16));
                }
                var5_8 = var7_10 /* !! */ ;
                var6_9 = false;
                var7_11 = false;
                var7_12 = Result.exceptionOrNull-impl((Object)var5_8);
                if (var7_12 != null) break;
                retrievedSourced = (Source)var5_8;
                $i$a$-fold-StripePaymentController$startAuthenticateSource$3 = false;
                $continuation.L$0 = null;
                $continuation.L$1 = null;
                $continuation.L$2 = null;
                $continuation.label = 2;
                v4 = this.onSourceRetrieved(host, retrievedSourced, requestOptions, (Continuation<? super Unit>)$continuation);
                if (v4 == var17_7) {
                    return var17_7;
                }
                ** GOTO lbl100
            }
            case 2: {
                $i$a$-fold-StripePaymentController$startAuthenticateSource$3 = false;
                ResultKt.throwOnFailure((Object)$result);
                v4 = $result;
                ** GOTO lbl100
            }
        }
        it = var7_12;
        $i$a$-fold-StripePaymentController$startAuthenticateSource$4 = false;
        $continuation.L$0 = null;
        $continuation.L$1 = null;
        $continuation.L$2 = null;
        $continuation.label = 3;
        v5 = this.handleError(var1_1, 50002, it, (Continuation<? super Unit>)$continuation);
        if (v5 == var17_7) {
            return var17_7;
        }
        ** GOTO lbl100
        {
            case 3: {
                $i$a$-fold-StripePaymentController$startAuthenticateSource$4 = false;
                ResultKt.throwOnFailure((Object)$result);
                v5 = $result;
lbl100:
                // 4 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final Object onSourceRetrieved(AuthActivityStarterHost host, Source source, ApiRequest.Options requestOptions, Continuation<? super Unit> $completion) {
        Object object = this.authenticatorRegistry.getAuthenticator(source).authenticate(host, source, requestOptions, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Override
    public boolean shouldHandlePaymentResult(int requestCode, @Nullable Intent data) {
        return requestCode == 50000 && data != null;
    }

    @Override
    public boolean shouldHandleSetupResult(int requestCode, @Nullable Intent data) {
        return requestCode == 50001 && data != null;
    }

    @Override
    public boolean shouldHandleSourceResult(int requestCode, @Nullable Intent data) {
        return requestCode == 50002 && data != null;
    }

    @Override
    @Nullable
    public Object getPaymentIntentResult(@NotNull Intent data, @NotNull Continuation<? super PaymentIntentResult> $completion) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException, IllegalArgumentException {
        return this.paymentIntentFlowResultProcessor.processResult(PaymentFlowResult.Unvalidated.Companion.fromIntent(data), $completion);
    }

    @Override
    @Nullable
    public Object getSetupIntentResult(@NotNull Intent data, @NotNull Continuation<? super SetupIntentResult> $completion) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException, IllegalArgumentException {
        return this.setupIntentFlowResultProcessor.processResult(PaymentFlowResult.Unvalidated.Companion.fromIntent(data), $completion);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object getAuthenticateSourceResult(@NotNull Intent var1_1, @NotNull Continuation<? super Source> var2_2) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException, IllegalArgumentException {
        if (!(var2_2 instanceof getAuthenticateSourceResult.1)) ** GOTO lbl-1000
        var13_3 = var2_2;
        if ((var13_3.label & -2147483648) != 0) {
            var13_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var2_2){
                /* synthetic */ Object result;
                final /* synthetic */ StripePaymentController this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.getAuthenticateSourceResult(null, (Continuation<? super Source>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var14_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                result = PaymentFlowResult.Unvalidated.Companion.fromIntent((Intent)data);
                var5_7 = result.getSourceId$payments_core_release();
                var6_8 = false;
                v0 = var5_7;
                if (v0 == null) {
                    v0 = "";
                }
                sourceId = v0;
                var6_9 = result.getClientSecret();
                var7_11 = false;
                v1 = var6_9;
                if (v1 == null) {
                    v1 = "";
                }
                clientSecret = v1;
                requestOptions = new ApiRequest.Options((String)this.publishableKeyProvider.invoke(), result.getStripeAccountId$payments_core_release(), null, 4, null);
                this.analyticsRequestExecutor.executeAsync(AnalyticsRequestFactory.createRequest$payments_core_release$default(this.analyticsRequestFactory, AnalyticsEvent.AuthSourceResult, null, null, null, null, 30, null));
                $continuation.label = 1;
                v2 = this.stripeRepository.retrieveSource$payments_core_release(sourceId, clientSecret, requestOptions, (Continuation<? super Source>)$continuation);
                if (v2 == var14_5) {
                    return var14_5;
                }
                ** GOTO lbl35
            }
            case 1: {
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl35:
                // 2 sources

                var7_12 = v2;
                var8_13 = false;
                var9_14 = false;
                var9_14 = false;
                var10_15 = false;
                if (var7_12 == null) {
                    var11_17 = false;
                    var10_16 = "Required value was null.";
                    throw (Throwable)new IllegalArgumentException(var10_16.toString());
                }
                return var7_12;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private final Object authenticateAlipay(PaymentIntent var1_1, AlipayAuthenticator var2_2, ApiRequest.Options var3_3, Continuation<? super PaymentIntentResult> var4_4) {
        if (!(var4_4 instanceof authenticateAlipay.1)) ** GOTO lbl-1000
        var13_5 = var4_4;
        if ((var13_5.label & -2147483648) != 0) {
            var13_5.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var4_4){
                Object L$0;
                Object L$1;
                Object L$2;
                int I$0;
                /* synthetic */ Object result;
                final /* synthetic */ StripePaymentController this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return StripePaymentController.access$authenticateAlipay(this.this$0, null, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var14_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = this;
                $continuation.L$1 = paymentIntent;
                $continuation.L$2 = requestOptions;
                $continuation.label = 1;
                v0 = this.alipayRepository.authenticate(paymentIntent, (AlipayAuthenticator)authenticator, requestOptions, (Continuation<? super AlipayAuthResult>)$continuation);
                if (v0 == var14_7) {
                    return var14_7;
                }
                ** GOTO lbl26
            }
            case 1: {
                requestOptions = (ApiRequest.Options)$continuation.L$2;
                paymentIntent = (PaymentIntent)$continuation.L$1;
                this = (StripePaymentController)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl26:
                // 2 sources

                outcome = ((AlipayAuthResult)v0).getOutcome();
                var7_9 = paymentIntent.getClientSecret();
                var8_10 = false;
                v1 = var7_9;
                if (v1 == null) {
                    v1 = "";
                }
                $continuation.L$0 = this;
                $continuation.L$1 = null;
                $continuation.L$2 = null;
                $continuation.I$0 = outcome;
                $continuation.label = 2;
                v2 = this.stripeRepository.retrievePaymentIntent((String)v1, requestOptions, StripePaymentController.EXPAND_PAYMENT_METHOD, (Continuation<? super PaymentIntent>)$continuation);
                if (v2 == var14_7) {
                    return var14_7;
                }
                ** GOTO lbl46
            }
            case 2: {
                var5_8 = $continuation.I$0;
                this = (StripePaymentController)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl46:
                // 2 sources

                var7_9 = v2;
                var8_10 = false;
                var9_11 = false;
                var9_11 = false;
                var10_12 = false;
                if (var7_9 == null) {
                    var11_14 = false;
                    var10_13 = "Required value was null.";
                    throw (Throwable)new IllegalArgumentException(var10_13.toString());
                }
                refreshedPaymentIntent = (PaymentIntent)var7_9;
                return new PaymentIntentResult(refreshedPaymentIntent, var5_8, this.failureMessageFactory.create(refreshedPaymentIntent, var5_8));
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final Object handleError(AuthActivityStarterHost host, int requestCode, Throwable throwable, Continuation<? super Unit> $completion) {
        Object object = BuildersKt.withContext((CoroutineContext)this.uiContext, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, host, throwable, requestCode, null){
            int label;
            final /* synthetic */ StripePaymentController this$0;
            final /* synthetic */ AuthActivityStarterHost $host;
            final /* synthetic */ Throwable $throwable;
            final /* synthetic */ int $requestCode;
            {
                this.this$0 = $receiver;
                this.$host = $host;
                this.$throwable = $throwable;
                this.$requestCode = $requestCode;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        ((PaymentRelayStarter)StripePaymentController.access$getPaymentRelayStarterFactory$p(this.this$0).invoke((Object)this.$host)).start(new PaymentRelayStarter.Args.ErrorArgs(StripeException.Companion.create(this.$throwable), this.$requestCode));
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Override
    @VisibleForTesting
    @Nullable
    public Object handleNextAction(@NotNull AuthActivityStarterHost host, @NotNull StripeIntent stripeIntent, @NotNull ApiRequest.Options requestOptions, @NotNull Continuation<? super Unit> $completion) {
        Object object = this.authenticatorRegistry.getAuthenticator(stripeIntent).authenticate(host, stripeIntent, requestOptions, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private final void logReturnUrl(String returnUrl) {
        Object object = returnUrl;
        object = Intrinsics.areEqual((Object)object, (Object)this.defaultReturnUrl.getValue()) ? AnalyticsEvent.ConfirmReturnUrlDefault : (object == null ? AnalyticsEvent.ConfirmReturnUrlNull : AnalyticsEvent.ConfirmReturnUrlCustom);
        boolean bl = false;
        boolean bl2 = false;
        Object event = object;
        boolean bl3 = false;
        this.analyticsRequestExecutor.executeAsync(AnalyticsRequestFactory.createRequest$payments_core_release$default(this.analyticsRequestFactory, (AnalyticsEvent)((Object)event), null, null, null, null, 30, null));
    }

    private static final String _init_$lambda-0(Function0 $tmp0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (String)$tmp0.invoke();
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final PaymentController create(@NotNull Context context, @NotNull String publishableKey2, @NotNull StripeRepository stripeRepository2, boolean enableLogging) {
        return Companion.create(context, publishableKey2, stripeRepository2, enableLogging);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final PaymentController create(@NotNull Context context, @NotNull String publishableKey2, @NotNull StripeRepository stripeRepository2) {
        return Companion.create(context, publishableKey2, stripeRepository2);
    }

    public static final /* synthetic */ Object access$confirmPaymentIntent(StripePaymentController $this, ConfirmPaymentIntentParams confirmStripeIntentParams, ApiRequest.Options requestOptions, Continuation $completion) {
        return $this.confirmPaymentIntent(confirmStripeIntentParams, requestOptions, (Continuation<? super PaymentIntent>)$completion);
    }

    public static final /* synthetic */ Object access$confirmSetupIntent(StripePaymentController $this, ConfirmSetupIntentParams confirmStripeIntentParams, ApiRequest.Options requestOptions, Continuation $completion) {
        return $this.confirmSetupIntent(confirmStripeIntentParams, requestOptions, (Continuation<? super SetupIntent>)$completion);
    }

    public static final /* synthetic */ Object access$onSourceRetrieved(StripePaymentController $this, AuthActivityStarterHost host, Source source, ApiRequest.Options requestOptions, Continuation $completion) {
        return $this.onSourceRetrieved(host, source, requestOptions, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$authenticateAlipay(StripePaymentController $this, PaymentIntent paymentIntent, AlipayAuthenticator authenticator, ApiRequest.Options requestOptions, Continuation $completion) {
        return $this.authenticateAlipay(paymentIntent, authenticator, requestOptions, (Continuation<? super PaymentIntentResult>)$completion);
    }

    public static final /* synthetic */ Object access$handleError(StripePaymentController $this, AuthActivityStarterHost host, int requestCode, Throwable throwable, Continuation $completion) {
        return $this.handleError(host, requestCode, throwable, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Function1 access$getPaymentRelayStarterFactory$p(StripePaymentController $this) {
        return $this.paymentRelayStarterFactory;
    }

    public static final /* synthetic */ ActivityResultLauncher access$getPaymentRelayLauncher$p(StripePaymentController $this) {
        return $this.paymentRelayLauncher;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u00172\b\b\u0002\u0010\u0018\u001a\u00020\u0019H\u0007J\u0015\u0010\u001a\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\u001cH\u0000\u00a2\u0006\u0002\b\u001dJ\u0015\u0010\u001a\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\u001fH\u0000\u00a2\u0006\u0002\b\u001dR\u0014\u0010\u0003\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\rX\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\rX\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/stripe/android/StripePaymentController$Companion;", "", "()V", "CHALLENGE_DELAY", "", "getCHALLENGE_DELAY$payments_core_release", "()J", "EXPAND_PAYMENT_METHOD", "", "", "getEXPAND_PAYMENT_METHOD$payments_core_release", "()Ljava/util/List;", "PAYMENT_REQUEST_CODE", "", "REQUIRED_ERROR", "SETUP_REQUEST_CODE", "SOURCE_REQUEST_CODE", "create", "Lcom/stripe/android/PaymentController;", "context", "Landroid/content/Context;", "publishableKey", "stripeRepository", "Lcom/stripe/android/networking/StripeRepository;", "enableLogging", "", "getRequestCode", "params", "Lcom/stripe/android/model/ConfirmStripeIntentParams;", "getRequestCode$payments_core_release", "intent", "Lcom/stripe/android/model/StripeIntent;", "payments-core_release"})
    public static final class Companion {
        private Companion() {
        }

        public final /* synthetic */ int getRequestCode$payments_core_release(StripeIntent intent) {
            Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
            return intent instanceof PaymentIntent ? 50000 : 50001;
        }

        public final /* synthetic */ int getRequestCode$payments_core_release(ConfirmStripeIntentParams params) {
            int n;
            Intrinsics.checkNotNullParameter((Object)params, (String)"params");
            ConfirmStripeIntentParams confirmStripeIntentParams = params;
            if (confirmStripeIntentParams instanceof ConfirmPaymentIntentParams) {
                n = 50000;
            } else if (confirmStripeIntentParams instanceof ConfirmSetupIntentParams) {
                n = 50001;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return n;
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final PaymentController create(@NotNull Context context, @NotNull String publishableKey2, @NotNull StripeRepository stripeRepository2, boolean enableLogging) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)publishableKey2, (String)"publishableKey");
            Intrinsics.checkNotNullParameter((Object)stripeRepository2, (String)"stripeRepository");
            Context context2 = context.getApplicationContext();
            Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"context.applicationContext");
            return new StripePaymentController(context2, (Function0)new Function0<String>(publishableKey2){
                final /* synthetic */ String $publishableKey;
                {
                    this.$publishableKey = $publishableKey;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return this.$publishableKey;
                }
            }, stripeRepository2, enableLogging, null, null, null, null, null, 496, null);
        }

        public static /* synthetic */ PaymentController create$default(Companion companion, Context context, String string, StripeRepository stripeRepository2, boolean bl, int n, Object object) {
            if ((n & 8) != 0) {
                bl = false;
            }
            return companion.create(context, string, stripeRepository2, bl);
        }

        @NotNull
        public final List<String> getEXPAND_PAYMENT_METHOD$payments_core_release() {
            return EXPAND_PAYMENT_METHOD;
        }

        public final long getCHALLENGE_DELAY$payments_core_release() {
            return CHALLENGE_DELAY;
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final PaymentController create(@NotNull Context context, @NotNull String publishableKey2, @NotNull StripeRepository stripeRepository2) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)publishableKey2, (String)"publishableKey");
            Intrinsics.checkNotNullParameter((Object)stripeRepository2, (String)"stripeRepository");
            return com.stripe.android.StripePaymentController$Companion.create$default(this, context, publishableKey2, stripeRepository2, false, 8, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PaymentController.StripeIntentType.values().length];
            nArray[PaymentController.StripeIntentType.PaymentIntent.ordinal()] = 1;
            nArray[PaymentController.StripeIntentType.SetupIntent.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

