/*
 * Decompiled with CFR 0.152.
 */
package com.streamxhub.streamx.flink.proxy;

import com.streamxhub.streamx.common.domain.FlinkVersion;
import com.streamxhub.streamx.common.util.ClassLoaderUtils$;
import com.streamxhub.streamx.common.util.Logger;
import com.streamxhub.streamx.common.util.Utils$;
import com.streamxhub.streamx.flink.proxy.ChildFirstClassLoader;
import com.streamxhub.streamx.flink.proxy.ClassLoaderObjectInputStream;
import com.streamxhub.streamx.flink.proxy.FlinkShimsProxy$;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.ObjectOutputStream;
import java.net.URL;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;

public final class FlinkShimsProxy$
implements com.streamxhub.streamx.common.util.Logger {
    public static final FlinkShimsProxy$ MODULE$;
    public final Pattern com$streamxhub$streamx$flink$proxy$FlinkShimsProxy$$EXCLUDE_PATTERN;
    public final Pattern com$streamxhub$streamx$flink$proxy$FlinkShimsProxy$$SHIMS_PATTERN;
    private final Map<String, ClassLoader> SHIMS_CLASS_LOADER_CACHE;
    private transient Logger com$streamxhub$streamx$common$util$Logger$$_logger;
    private final String com$streamxhub$streamx$common$util$Logger$$prefix;

    static {
        new FlinkShimsProxy$();
    }

    public Logger com$streamxhub$streamx$common$util$Logger$$_logger() {
        return this.com$streamxhub$streamx$common$util$Logger$$_logger;
    }

    public void com$streamxhub$streamx$common$util$Logger$$_logger_$eq(Logger x$1) {
        this.com$streamxhub$streamx$common$util$Logger$$_logger = x$1;
    }

    public String com$streamxhub$streamx$common$util$Logger$$prefix() {
        return this.com$streamxhub$streamx$common$util$Logger$$prefix;
    }

    public void com$streamxhub$streamx$common$util$Logger$_setter_$com$streamxhub$streamx$common$util$Logger$$prefix_$eq(String x$1) {
        this.com$streamxhub$streamx$common$util$Logger$$prefix = x$1;
    }

    public String logName() {
        return Logger.class.logName((com.streamxhub.streamx.common.util.Logger)this);
    }

    public Logger logger() {
        return Logger.class.logger((com.streamxhub.streamx.common.util.Logger)this);
    }

    public void logInfo(Function0<String> msg) {
        Logger.class.logInfo((com.streamxhub.streamx.common.util.Logger)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logger.class.logInfo((com.streamxhub.streamx.common.util.Logger)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logger.class.logDebug((com.streamxhub.streamx.common.util.Logger)this, msg);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logger.class.logDebug((com.streamxhub.streamx.common.util.Logger)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logger.class.logTrace((com.streamxhub.streamx.common.util.Logger)this, msg);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logger.class.logTrace((com.streamxhub.streamx.common.util.Logger)this, msg, (Throwable)throwable);
    }

    public void logWarn(Function0<String> msg) {
        Logger.class.logWarn((com.streamxhub.streamx.common.util.Logger)this, msg);
    }

    public void logWarn(Function0<String> msg, Throwable throwable) {
        Logger.class.logWarn((com.streamxhub.streamx.common.util.Logger)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logger.class.logError((com.streamxhub.streamx.common.util.Logger)this, msg);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logger.class.logError((com.streamxhub.streamx.common.util.Logger)this, msg, (Throwable)throwable);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logger.class.initializeLogIfNecessary((com.streamxhub.streamx.common.util.Logger)this, (boolean)isInterpreter);
    }

    public Pattern com$streamxhub$streamx$flink$proxy$FlinkShimsProxy$$getFlinkShimsResourcePattern(String flinkLargeVersion) {
        return Pattern.compile(new StringBuilder().append((Object)"flink-(.*)-").append((Object)flinkLargeVersion).append((Object)"(.*).jar").toString(), 34);
    }

    public <T> T proxy(FlinkVersion flinkVersion, Function1<ClassLoader, T> func) {
        ClassLoader shimsClassLoader = this.getFlinkShimsClassLoader(flinkVersion);
        return (T)ClassLoaderUtils$.MODULE$.runAsClassLoader(shimsClassLoader, (Function0)new Serializable(func, shimsClassLoader){
            public static final long serialVersionUID = 0L;
            private final Function1 func$1;
            private final ClassLoader shimsClassLoader$1;

            public final T apply() {
                return (T)this.func$1.apply((Object)this.shimsClassLoader$1);
            }
            {
                this.func$1 = func$1;
                this.shimsClassLoader$1 = shimsClassLoader$1;
            }
        });
    }

    public <T> T proxy(FlinkVersion flinkVersion, Function<ClassLoader, T> func) {
        ClassLoader shimsClassLoader = this.getFlinkShimsClassLoader(flinkVersion);
        return (T)ClassLoaderUtils$.MODULE$.runAsClassLoader(shimsClassLoader, new Supplier<T>(func, shimsClassLoader){
            private final Function func$2;
            private final ClassLoader shimsClassLoader$2;

            public T get() {
                return (T)this.func$2.apply(this.shimsClassLoader$2);
            }
            {
                this.func$2 = func$2;
                this.shimsClassLoader$2 = shimsClassLoader$2;
            }
        });
    }

    private ClassLoader getFlinkShimsClassLoader(FlinkVersion flinkVersion) {
        String majorVersion = flinkVersion.majorVersion();
        this.logInfo((Function0<String>)new Serializable(flinkVersion){
            public static final long serialVersionUID = 0L;
            private final FlinkVersion flinkVersion$1;

            public final String apply() {
                return this.flinkVersion$1.toString();
            }
            {
                this.flinkVersion$1 = flinkVersion$1;
            }
        });
        return (ClassLoader)this.SHIMS_CLASS_LOADER_CACHE.getOrElseUpdate((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{flinkVersion.fullVersion()})), (Function0)new Serializable(flinkVersion, majorVersion){
            public static final long serialVersionUID = 0L;
            private final FlinkVersion flinkVersion$1;
            public final String majorVersion$1;

            public final ChildFirstClassLoader apply() {
                List<URL> libURL = FlinkShimsProxy$.MODULE$.com$streamxhub$streamx$flink$proxy$FlinkShimsProxy$$getFlinkHomeLib(this.flinkVersion$1.flinkHome());
                ListBuffer shimsUrls = (ListBuffer)ListBuffer$.MODULE$.apply(libURL);
                String appHome = System.getProperty("app.home");
                Predef$.MODULE$.require(appHome != null, (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "app.home is not found on System env.";
                    }
                });
                File libPath = new File(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/lib"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{appHome})));
                Predef$.MODULE$.require(libPath.exists());
                Predef$.MODULE$.refArrayOps((Object[])libPath.listFiles()).foreach((Function1)new Serializable(this, shimsUrls){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.getFlinkShimsClassLoader.2 $outer;
                    private final ListBuffer shimsUrls$1;

                    public final Object apply(File jar) {
                        Object object;
                        try {
                            Matcher shimsMatcher = FlinkShimsProxy$.MODULE$.com$streamxhub$streamx$flink$proxy$FlinkShimsProxy$$SHIMS_PATTERN.matcher(jar.getName());
                            if (shimsMatcher.matches()) {
                                object = this.$outer.majorVersion$1 != null && this.$outer.majorVersion$1.equals(shimsMatcher.group(1)) ? this.shimsUrls$1.$plus$eq((Object)jar.toURI().toURL()) : BoxedUnit.UNIT;
                            } else if (FlinkShimsProxy$.MODULE$.com$streamxhub$streamx$flink$proxy$FlinkShimsProxy$$EXCLUDE_PATTERN.matcher(jar.getName()).matches()) {
                                FlinkShimsProxy$.MODULE$.logInfo((Function0<String>)new Serializable(this, jar){
                                    public static final long serialVersionUID = 0L;
                                    private final File jar$1;

                                    public final String apply() {
                                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"exclude ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.jar$1.getName()}));
                                    }
                                    {
                                        this.jar$1 = jar$1;
                                    }
                                });
                                object = BoxedUnit.UNIT;
                            } else {
                                object = this.shimsUrls$1.$plus$eq((Object)jar.toURI().toURL());
                            }
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                            object = BoxedUnit.UNIT;
                        }
                        return object;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.shimsUrls$1 = shimsUrls$1;
                    }
                });
                return new ChildFirstClassLoader((URL[])shimsUrls.toArray(ClassTag$.MODULE$.apply(URL.class)), Thread.currentThread().getContextClassLoader(), FlinkShimsProxy$.MODULE$.com$streamxhub$streamx$flink$proxy$FlinkShimsProxy$$getFlinkShimsResourcePattern(this.majorVersion$1));
            }
            {
                this.flinkVersion$1 = flinkVersion$1;
                this.majorVersion$1 = majorVersion$1;
            }
        });
    }

    public List<URL> com$streamxhub$streamx$flink$proxy$FlinkShimsProxy$$getFlinkHomeLib(String flinkHome) {
        File file = new File(flinkHome, "lib");
        Predef$.MODULE$.require(file.isDirectory(), (Function0)new Serializable(file){
            public static final long serialVersionUID = 0L;
            private final File file$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"FLINK_HOME ", " does not exist"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.file$1}));
            }
            {
                this.file$1 = file$1;
            }
        });
        return Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])file.listFiles()).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(File x$1) {
                return !x$1.getName().startsWith("log4j");
            }
        })).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final URL apply(File x$2) {
                return x$2.toURI().toURL();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(URL.class)))).toList();
    }

    public <T> T getObject(ClassLoader loader, Object obj) throws Exception {
        ByteArrayOutputStream arrayOutputStream = new ByteArrayOutputStream();
        Object result = Utils$.MODULE$.tryWithResource((AutoCloseable)new ObjectOutputStream(arrayOutputStream), (Function1)new Serializable(loader, obj, arrayOutputStream){
            public static final long serialVersionUID = 0L;
            private final ClassLoader loader$1;
            private final Object obj$1;
            private final ByteArrayOutputStream arrayOutputStream$1;

            public final Object apply(ObjectOutputStream objectOutputStream) {
                objectOutputStream.writeObject(this.obj$1);
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.arrayOutputStream$1.toByteArray());
                return Utils$.MODULE$.tryWithResource((AutoCloseable)new ClassLoaderObjectInputStream(this.loader$1, byteArrayInputStream), (Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Object apply(ClassLoaderObjectInputStream x$3) {
                        return x$3.readObject();
                    }
                });
            }
            {
                this.loader$1 = loader$1;
                this.obj$1 = obj$1;
                this.arrayOutputStream$1 = arrayOutputStream$1;
            }
        });
        return (T)result;
    }

    private FlinkShimsProxy$() {
        MODULE$ = this;
        Logger.class.$init$((com.streamxhub.streamx.common.util.Logger)this);
        this.com$streamxhub$streamx$flink$proxy$FlinkShimsProxy$$EXCLUDE_PATTERN = Pattern.compile("(flink|scala)-(.*).jar", 34);
        this.com$streamxhub$streamx$flink$proxy$FlinkShimsProxy$$SHIMS_PATTERN = Pattern.compile("streamx-flink-shims_flink-(1.12|1.13|1.14)-(.*).jar", 34);
        this.SHIMS_CLASS_LOADER_CACHE = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
    }
}

