/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories.s3;

import com.amazonaws.util.json.Jackson;
import java.security.AccessController;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.elasticsearch.SpecialPermission;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.env.Environment;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.plugins.RepositoryPlugin;
import org.elasticsearch.repositories.Repository;
import org.elasticsearch.repositories.s3.AwsS3Service;
import org.elasticsearch.repositories.s3.InternalAwsS3Service;
import org.elasticsearch.repositories.s3.S3ClientSettings;
import org.elasticsearch.repositories.s3.S3Repository;

public class S3RepositoryPlugin
extends Plugin
implements RepositoryPlugin {
    private final Map<String, S3ClientSettings> clientsSettings;

    public S3RepositoryPlugin(Settings settings) {
        this.clientsSettings = S3ClientSettings.load(settings);
        assert (!this.clientsSettings.isEmpty()) : "always at least have 'default'";
    }

    protected AwsS3Service createStorageService(Settings settings) {
        return new InternalAwsS3Service(settings, this.clientsSettings);
    }

    public Map<String, Repository.Factory> getRepositories(Environment env, NamedXContentRegistry namedXContentRegistry) {
        return Collections.singletonMap("s3", metadata -> new S3Repository(metadata, env.settings(), namedXContentRegistry, this.createStorageService(env.settings())));
    }

    public List<Setting<?>> getSettings() {
        return Arrays.asList(S3ClientSettings.ACCESS_KEY_SETTING, S3ClientSettings.SECRET_KEY_SETTING, S3ClientSettings.ENDPOINT_SETTING, S3ClientSettings.PROTOCOL_SETTING, S3ClientSettings.PROXY_HOST_SETTING, S3ClientSettings.PROXY_PORT_SETTING, S3ClientSettings.PROXY_USERNAME_SETTING, S3ClientSettings.PROXY_PASSWORD_SETTING, S3ClientSettings.READ_TIMEOUT_SETTING, S3ClientSettings.MAX_RETRIES_SETTING, S3ClientSettings.USE_THROTTLE_RETRIES_SETTING);
    }

    static {
        SpecialPermission.check();
        AccessController.doPrivileged(() -> {
            try {
                Jackson.jsonNodeOf((String)"{}");
                Class.forName("com.amazonaws.ClientConfiguration");
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
            return null;
        });
    }
}

