/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest.geoip;

import com.fasterxml.jackson.databind.JsonNode;
import com.maxmind.db.NodeCache;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.cache.Cache;
import org.elasticsearch.common.cache.CacheBuilder;

final class GeoIpCache
implements NodeCache {
    private final Cache<Integer, JsonNode> cache;

    GeoIpCache(long maxSize) {
        this.cache = CacheBuilder.builder().setMaximumWeight(maxSize).build();
    }

    public JsonNode get(int key, NodeCache.Loader loader) throws IOException {
        try {
            return (JsonNode)this.cache.computeIfAbsent((Object)key, arg_0 -> ((NodeCache.Loader)loader).load(arg_0));
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause() != null ? e.getCause() : e;
            throw new ElasticsearchException(cause);
        }
    }
}

