/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest.geoip;

import com.maxmind.db.NoCache;
import com.maxmind.db.NodeCache;
import com.maxmind.geoip2.DatabaseReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import java.util.zip.GZIPInputStream;
import org.apache.lucene.util.IOUtils;
import org.elasticsearch.common.CheckedSupplier;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.ingest.Processor;
import org.elasticsearch.ingest.geoip.DatabaseReaderLazyLoader;
import org.elasticsearch.ingest.geoip.GeoIpCache;
import org.elasticsearch.ingest.geoip.GeoIpProcessor;
import org.elasticsearch.plugins.IngestPlugin;
import org.elasticsearch.plugins.Plugin;

public class IngestGeoIpPlugin
extends Plugin
implements IngestPlugin,
Closeable {
    public static final Setting<Long> CACHE_SIZE = Setting.longSetting((String)"ingest.geoip.cache_size", (long)1000L, (long)0L, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    private Map<String, DatabaseReaderLazyLoader> databaseReaders;

    public List<Setting<?>> getSettings() {
        return Arrays.asList(CACHE_SIZE);
    }

    public Map<String, Processor.Factory> getProcessors(Processor.Parameters parameters) {
        if (this.databaseReaders != null) {
            throw new IllegalStateException("getProcessors called twice for geoip plugin!!");
        }
        Path geoIpConfigDirectory = parameters.env.configFile().resolve("ingest-geoip");
        long cacheSize = (Long)CACHE_SIZE.get(parameters.env.settings());
        Object cache = cacheSize > 0L ? new GeoIpCache(cacheSize) : NoCache.getInstance();
        try {
            this.databaseReaders = IngestGeoIpPlugin.loadDatabaseReaders(geoIpConfigDirectory, (NodeCache)cache);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return Collections.singletonMap("geoip", new GeoIpProcessor.Factory(this.databaseReaders));
    }

    static Map<String, DatabaseReaderLazyLoader> loadDatabaseReaders(Path geoIpConfigDirectory, NodeCache cache) throws IOException {
        if (!Files.exists(geoIpConfigDirectory, new LinkOption[0]) && Files.isDirectory(geoIpConfigDirectory, new LinkOption[0])) {
            throw new IllegalStateException("the geoip directory [" + geoIpConfigDirectory + "] containing databases doesn't exist");
        }
        HashMap<String, DatabaseReaderLazyLoader> databaseReaders = new HashMap<String, DatabaseReaderLazyLoader>();
        try (Stream<Path> databaseFiles = Files.list(geoIpConfigDirectory);){
            PathMatcher pathMatcher = geoIpConfigDirectory.getFileSystem().getPathMatcher("glob:**.mmdb.gz");
            Iterator iterator = databaseFiles.iterator();
            while (iterator.hasNext()) {
                Path databasePath = (Path)iterator.next();
                if (!Files.isRegularFile(databasePath, new LinkOption[0]) || !pathMatcher.matches(databasePath)) continue;
                String databaseFileName = databasePath.getFileName().toString();
                DatabaseReaderLazyLoader holder = new DatabaseReaderLazyLoader(databaseFileName, (CheckedSupplier<DatabaseReader, IOException>)((CheckedSupplier)() -> {
                    GZIPInputStream inputStream = new GZIPInputStream(Files.newInputStream(databasePath, StandardOpenOption.READ));
                    Throwable throwable = null;
                    try {
                        DatabaseReader databaseReader = new DatabaseReader.Builder((InputStream)inputStream).withCache(cache).build();
                        return databaseReader;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        IngestGeoIpPlugin.$closeResource(throwable, inputStream);
                    }
                }));
                databaseReaders.put(databaseFileName, holder);
            }
        }
        return Collections.unmodifiableMap(databaseReaders);
    }

    @Override
    public void close() throws IOException {
        if (this.databaseReaders != null) {
            IOUtils.close(this.databaseReaders.values());
        }
    }
}

