/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest.geoip;

import com.maxmind.geoip2.DatabaseReader;
import java.io.Closeable;
import java.io.IOException;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.common.CheckedSupplier;
import org.elasticsearch.common.logging.Loggers;

final class DatabaseReaderLazyLoader
implements Closeable {
    private static final Logger LOGGER = Loggers.getLogger(DatabaseReaderLazyLoader.class);
    private final String databaseFileName;
    private final CheckedSupplier<DatabaseReader, IOException> loader;
    final SetOnce<DatabaseReader> databaseReader;

    DatabaseReaderLazyLoader(String databaseFileName, CheckedSupplier<DatabaseReader, IOException> loader) {
        this.databaseFileName = databaseFileName;
        this.loader = loader;
        this.databaseReader = new SetOnce();
    }

    synchronized DatabaseReader get() throws IOException {
        if (this.databaseReader.get() == null) {
            this.databaseReader.set((Object)((DatabaseReader)this.loader.get()));
            LOGGER.debug("Loaded [{}] geoip database", (Object)this.databaseFileName);
        }
        return (DatabaseReader)this.databaseReader.get();
    }

    @Override
    public synchronized void close() throws IOException {
        IOUtils.close((Closeable[])new Closeable[]{(Closeable)this.databaseReader.get()});
    }
}

