/*
 * Decompiled with CFR 0.152.
 */
package com.strangegizmo.cdb;

import com.strangegizmo.cdb.Cdb;
import com.strangegizmo.cdb.CdbHashPointer;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.Vector;

public final class CdbMake {
    private RandomAccessFile file_ = null;
    private Vector hashPointers_ = null;
    private int[] tableCount_ = null;
    private int[] tableStart_ = null;
    private int pos_ = -1;

    public void start(String string) throws IOException {
        this.hashPointers_ = new Vector();
        this.tableCount_ = new int[256];
        this.tableStart_ = new int[256];
        for (int i = 0; i < 256; ++i) {
            this.tableCount_[i] = 0;
        }
        this.file_ = new RandomAccessFile(string, "rw");
        this.pos_ = 2048;
        this.file_.seek(this.pos_);
    }

    public void add(byte[] byArray, byte[] byArray2) throws IOException {
        this.writeLeInt(byArray.length);
        this.writeLeInt(byArray2.length);
        this.file_.write(byArray);
        this.file_.write(byArray2);
        int n = Cdb.hash(byArray);
        this.hashPointers_.addElement(new CdbHashPointer(n, this.pos_));
        int n2 = n & 0xFF;
        this.tableCount_[n2] = this.tableCount_[n2] + 1;
        this.posplus(8);
        this.posplus(byArray.length);
        this.posplus(byArray2.length);
    }

    public void finish() throws IOException {
        int n = 0;
        for (int i = 0; i < 256; ++i) {
            this.tableStart_[i] = n += this.tableCount_[i];
        }
        CdbHashPointer[] cdbHashPointerArray = new CdbHashPointer[this.hashPointers_.size()];
        Object object = this.hashPointers_.elements();
        while (object.hasMoreElements()) {
            CdbHashPointer cdbHashPointer = (CdbHashPointer)object.nextElement();
            int n2 = cdbHashPointer.hash & 0xFF;
            int n3 = this.tableStart_[n2] - 1;
            this.tableStart_[n2] = n3;
            cdbHashPointerArray[n3] = cdbHashPointer;
        }
        object = new byte[2048];
        for (int i = 0; i < 256; ++i) {
            CdbHashPointer cdbHashPointer;
            int n4;
            int n5 = this.tableCount_[i] * 2;
            object[i * 8 + 0] = (byte)(this.pos_ & 0xFF);
            object[i * 8 + 1] = (byte)(this.pos_ >>> 8 & 0xFF);
            object[i * 8 + 2] = (byte)(this.pos_ >>> 16 & 0xFF);
            object[i * 8 + 3] = (byte)(this.pos_ >>> 24 & 0xFF);
            object[i * 8 + 4 + 0] = (byte)(n5 & 0xFF);
            object[i * 8 + 4 + 1] = (byte)(n5 >>> 8 & 0xFF);
            object[i * 8 + 4 + 2] = (byte)(n5 >>> 16 & 0xFF);
            object[i * 8 + 4 + 3] = (byte)(n5 >>> 24 & 0xFF);
            int n6 = this.tableStart_[i];
            CdbHashPointer[] cdbHashPointerArray2 = new CdbHashPointer[n5];
            for (n4 = 0; n4 < this.tableCount_[i]; ++n4) {
                cdbHashPointer = cdbHashPointerArray[n6++];
                int n7 = (cdbHashPointer.hash >>> 8) % n5;
                while (cdbHashPointerArray2[n7] != null) {
                    if (++n7 != n5) continue;
                    n7 = 0;
                }
                cdbHashPointerArray2[n7] = cdbHashPointer;
            }
            for (n4 = 0; n4 < n5; ++n4) {
                cdbHashPointer = cdbHashPointerArray2[n4];
                if (cdbHashPointer != null) {
                    this.writeLeInt(cdbHashPointerArray2[n4].hash);
                    this.writeLeInt(cdbHashPointerArray2[n4].pos);
                } else {
                    this.writeLeInt(0);
                    this.writeLeInt(0);
                }
                this.posplus(8);
            }
        }
        this.file_.seek(0L);
        this.file_.write((byte[])object);
        this.file_.close();
    }

    private void writeLeInt(int n) throws IOException {
        this.file_.writeByte((byte)(n & 0xFF));
        this.file_.writeByte((byte)(n >>> 8 & 0xFF));
        this.file_.writeByte((byte)(n >>> 16 & 0xFF));
        this.file_.writeByte((byte)(n >>> 24 & 0xFF));
    }

    private void posplus(int n) throws IOException {
        int n2 = this.pos_ + n;
        if (n2 < n) {
            throw new IOException("CDB file is too big.");
        }
        this.pos_ = n2;
    }

    public static void make(String string, String string2, String string3) throws IOException {
        CdbMake.make(string, string2, string3, null);
    }

    public static void make(String string, String string2, String string3, Cdb cdb) throws IOException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(string));
        CdbMake.make(bufferedInputStream, string2, string3, cdb);
        try {
            bufferedInputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void make(InputStream inputStream, String string, String string2) throws IOException {
        CdbMake.make(inputStream, string, string2, null);
    }

    public static void make(InputStream inputStream, String string, String string2, Cdb cdb) throws IOException {
        int n;
        CdbMake cdbMake = new CdbMake();
        cdbMake.start(string2);
        while ((n = inputStream.read()) != -1 && n != 10) {
            if (n != 43) {
                throw new IllegalArgumentException("input file not in correct format");
            }
            int n2 = 0;
            while ((n = inputStream.read()) != 44) {
                if (n < 48 || n > 57) {
                    throw new IllegalArgumentException("input file not in correct format");
                }
                if (n2 > 0x19999990) {
                    throw new IllegalArgumentException("key length is too big");
                }
                n2 = n2 * 10 + (n - 48);
            }
            int n3 = 0;
            while ((n = inputStream.read()) != 58) {
                if (n < 48 || n > 57) {
                    throw new IllegalArgumentException("input file not in correct format");
                }
                if (n3 > 0x19999990) {
                    throw new IllegalArgumentException("data length is too big");
                }
                n3 = n3 * 10 + (n - 48);
            }
            byte[] byArray = new byte[n2];
            for (int i = 0; i < n2; ++i) {
                n = inputStream.read();
                if (n == -1) {
                    throw new IllegalArgumentException("input file is truncated");
                }
                byArray[i] = (byte)(n & 0xFF);
            }
            n = inputStream.read();
            if (n != 45) {
                throw new IllegalArgumentException("input file not in correct format");
            }
            n = inputStream.read();
            if (n != 62) {
                throw new IllegalArgumentException("input file not in correct format");
            }
            byte[] byArray2 = new byte[n3];
            for (int i = 0; i < n3; ++i) {
                n = inputStream.read();
                if (n == -1) {
                    throw new IllegalArgumentException("input file is truncated");
                }
                byArray2[i] = (byte)(n & 0xFF);
            }
            if (cdb == null || cdb.find(byArray2) == null) {
                cdbMake.add(byArray, byArray2);
            }
            if ((n = inputStream.read()) == 10) continue;
            throw new IllegalArgumentException("input file not in correct format");
        }
        cdbMake.finish();
        File file = new File(string2);
        File file2 = new File(string);
        file.renameTo(file2);
    }
}

