/*
 * Decompiled with CFR 0.152.
 */
package com.strangegizmo.cdb;

import com.strangegizmo.cdb.CdbElement;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.Enumeration;

public class Cdb {
    private RandomAccessFile file_ = null;
    private int[] slotTable_ = null;
    private int loop_ = 0;
    private int khash_ = 0;
    private int hslots_ = 0;
    private int hpos_ = 0;
    private int kpos_ = 0;

    public Cdb(String string) throws IOException {
        this.file_ = new RandomAccessFile(string, "r");
        try {
            byte[] byArray = new byte[2048];
            this.file_.readFully(byArray);
            this.slotTable_ = new int[512];
            int n = 0;
            for (int i = 0; i < 256; ++i) {
                int n2 = byArray[n++] & 0xFF | (byArray[n++] & 0xFF) << 8 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 24;
                int n3 = byArray[n++] & 0xFF | (byArray[n++] & 0xFF) << 8 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 24;
                this.slotTable_[i << 1] = n2;
                this.slotTable_[(i << 1) + 1] = n3;
            }
        }
        catch (IOException iOException) {
            this.slotTable_ = null;
        }
    }

    public final void close() {
        try {
            this.file_.close();
            this.file_ = null;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static final int hash(byte[] byArray) {
        long l = 5381L;
        for (int i = 0; i < byArray.length; ++i) {
            long l2 = l << 5;
            l += l2 & 0xFFFFFFFFL;
            l &= 0xFFFFFFFFL;
            int n = byArray[i];
            n = n + 256 & 0xFF;
            l ^= (long)n;
        }
        return (int)(l & 0xFFFFFFFFL);
    }

    public final void findstart(byte[] byArray) {
        this.loop_ = 0;
    }

    public final synchronized byte[] find(byte[] byArray) {
        this.findstart(byArray);
        return this.findnext(byArray);
    }

    public final synchronized byte[] findnext(byte[] byArray) {
        int n;
        int n2;
        if (this.slotTable_ == null) {
            return null;
        }
        if (this.loop_ == 0) {
            n2 = Cdb.hash(byArray);
            n = n2 & 0xFF;
            this.hslots_ = this.slotTable_[(n << 1) + 1];
            if (this.hslots_ == 0) {
                return null;
            }
            this.hpos_ = this.slotTable_[n << 1];
            this.khash_ = n2;
            n2 >>>= 8;
            n2 %= this.hslots_;
            this.kpos_ = this.hpos_ + (n2 <<= 3);
        }
        try {
            while (this.loop_ < this.hslots_) {
                this.file_.seek(this.kpos_);
                n2 = this.file_.readUnsignedByte() | this.file_.readUnsignedByte() << 8 | this.file_.readUnsignedByte() << 16 | this.file_.readUnsignedByte() << 24;
                n = this.file_.readUnsignedByte() | this.file_.readUnsignedByte() << 8 | this.file_.readUnsignedByte() << 16 | this.file_.readUnsignedByte() << 24;
                if (n == 0) {
                    return null;
                }
                ++this.loop_;
                this.kpos_ += 8;
                if (this.kpos_ == this.hpos_ + (this.hslots_ << 3)) {
                    this.kpos_ = this.hpos_;
                }
                if (n2 != this.khash_) continue;
                this.file_.seek(n);
                int n3 = this.file_.readUnsignedByte() | this.file_.readUnsignedByte() << 8 | this.file_.readUnsignedByte() << 16 | this.file_.readUnsignedByte() << 24;
                if (n3 != byArray.length) continue;
                int n4 = this.file_.readUnsignedByte() | this.file_.readUnsignedByte() << 8 | this.file_.readUnsignedByte() << 16 | this.file_.readUnsignedByte() << 24;
                boolean bl = true;
                byte[] byArray2 = new byte[n3];
                this.file_.readFully(byArray2);
                for (int i = 0; i < byArray2.length; ++i) {
                    if (byArray2[i] == byArray[i]) continue;
                    bl = false;
                    break;
                }
                if (!bl) continue;
                byte[] byArray3 = new byte[n4];
                this.file_.readFully(byArray3);
                return byArray3;
            }
        }
        catch (IOException iOException) {
            return null;
        }
        return null;
    }

    public static Enumeration elements(String string) throws IOException {
        final BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(string));
        final int n = ((InputStream)bufferedInputStream).read() & 0xFF | (((InputStream)bufferedInputStream).read() & 0xFF) << 8 | (((InputStream)bufferedInputStream).read() & 0xFF) << 16 | (((InputStream)bufferedInputStream).read() & 0xFF) << 24;
        ((InputStream)bufferedInputStream).skip(2044L);
        return new Enumeration(){
            int pos = 2048;

            protected void finalize() {
                try {
                    bufferedInputStream.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }

            public boolean hasMoreElements() {
                return this.pos < n;
            }

            public synchronized Object nextElement() {
                try {
                    int n5;
                    int n2;
                    int n3 = this.readLeInt();
                    this.pos += 4;
                    int n4 = this.readLeInt();
                    this.pos += 4;
                    byte[] byArray = new byte[n3];
                    for (int i = 0; i < n3; i += n2) {
                        n2 = bufferedInputStream.read(byArray, i, n3 - i);
                        if (n2 != -1) continue;
                        throw new IllegalArgumentException("invalid cdb format");
                    }
                    this.pos += n3;
                    byte[] byArray2 = new byte[n4];
                    for (n2 = 0; n2 < n4; n2 += n5) {
                        n5 = bufferedInputStream.read(byArray2, n2, n4 - n2);
                        if (n5 != -1) continue;
                        throw new IllegalArgumentException("invalid cdb format");
                    }
                    this.pos += n4;
                    return new CdbElement(byArray, byArray2);
                }
                catch (IOException iOException) {
                    throw new IllegalArgumentException("invalid cdb format");
                }
            }

            private int readLeInt() throws IOException {
                return bufferedInputStream.read() & 0xFF | (bufferedInputStream.read() & 0xFF) << 8 | (bufferedInputStream.read() & 0xFF) << 16 | (bufferedInputStream.read() & 0xFF) << 24;
            }
        };
    }
}

