/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.android;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.SharedPreferences;
import com.stormpath.sdk.PreferenceStore;

public class SharedPrefsStore
implements PreferenceStore {
    public static final String KEY_ACCESS_TOKEN = "stormpath-access-token";
    public static final String KEY_REFRESH_TOKEN = "stormpath-refresh-token";
    private final SharedPreferences sharedPreferences;

    public SharedPrefsStore(Context appContext) {
        this.sharedPreferences = appContext.getSharedPreferences("stormpath-shared-prefs", 0);
    }

    @SuppressLint(value={"CommitPrefEdits"})
    private void saveStringPreference(String key, String value) {
        this.sharedPreferences.edit().putString(key, value).commit();
    }

    @SuppressLint(value={"CommitPrefEdits"})
    private void removeStringPreference(String key) {
        this.sharedPreferences.edit().remove(key).commit();
    }

    @Override
    public void setAccessToken(String accessToken) {
        this.saveStringPreference(KEY_ACCESS_TOKEN, accessToken);
    }

    @Override
    public String getAccessToken() {
        return this.sharedPreferences.getString(KEY_ACCESS_TOKEN, null);
    }

    @Override
    public void clearAccessToken() {
        this.removeStringPreference(KEY_ACCESS_TOKEN);
    }

    @Override
    public void setRefreshToken(String refreshToken) {
        this.saveStringPreference(KEY_REFRESH_TOKEN, refreshToken);
    }

    @Override
    public String getRefreshToken() {
        return this.sharedPreferences.getString(KEY_REFRESH_TOKEN, null);
    }

    @Override
    public void clearRefreshToken() {
        this.removeStringPreference(KEY_REFRESH_TOKEN);
    }
}

