/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.android;

import android.annotation.TargetApi;
import android.content.Context;
import android.util.Log;
import com.stormpath.sdk.PreferenceStore;
import java.io.ByteArrayOutputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.interfaces.RSAPublicKey;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.crypto.Cipher;
import javax.crypto.CipherOutputStream;

public class SystemKeyStore
implements PreferenceStore {
    public static String KEY_ACCESS_TOKEN = "";
    public static String KEY_REFRESH_TOKEN = "";
    static final String CIPHER_TYPE = "RSA/ECB/PKCS1Padding";
    static final String CIPHER_PROVIDER = "AndroidKeyStoreBCWorkaround";
    public static final String TAG = "SystemKeyStore";
    private KeyStore keyStore;
    List<String> keyAliases;

    public SystemKeyStore(Context context) {
        try {
            KEY_ACCESS_TOKEN = context.getPackageName() + ".stormpath-access-token";
            KEY_REFRESH_TOKEN = context.getPackageName() + ".stormpath-refresh-token";
            this.keyStore = KeyStore.getInstance("AndroidKeyStore");
            this.keyStore.load(null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void refreshKeys() {
        this.keyAliases = new ArrayList<String>();
        try {
            Enumeration<String> aliases = this.keyStore.aliases();
            while (aliases.hasMoreElements()) {
                this.keyAliases.add(aliases.nextElement());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void encryptKey(String key, String value) {
        try {
            KeyStore.PrivateKeyEntry privateKeyEntry = (KeyStore.PrivateKeyEntry)this.keyStore.getEntry(key, null);
            RSAPublicKey publicKey = (RSAPublicKey)privateKeyEntry.getCertificate().getPublicKey();
            Cipher inCipher = Cipher.getInstance(CIPHER_TYPE, CIPHER_PROVIDER);
            inCipher.init(1, publicKey);
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            CipherOutputStream cipherOutputStream = new CipherOutputStream(outputStream, inCipher);
            cipherOutputStream.write(value.getBytes("UTF-8"));
            cipherOutputStream.close();
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)Log.getStackTraceString((Throwable)e));
        }
    }

    @TargetApi(value=8)
    private String decryptKey(String key, String encryptedText) {
        try {
            KeyStore.PrivateKeyEntry privateKeyEntry = (KeyStore.PrivateKeyEntry)this.keyStore.getEntry(key, null);
            Cipher output = Cipher.getInstance(CIPHER_TYPE, CIPHER_PROVIDER);
            output.init(2, privateKeyEntry.getPrivateKey());
            byte[] value = output.doFinal(privateKeyEntry.getPrivateKey().getEncoded());
            return new String(value, 0, value.length, "UTF-8");
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)Log.getStackTraceString((Throwable)e));
            return "";
        }
    }

    private void removeKey(String key) {
        try {
            this.keyStore.deleteEntry(key);
            this.refreshKeys();
        }
        catch (KeyStoreException e) {
            Log.e((String)TAG, (String)Log.getStackTraceString((Throwable)e));
        }
    }

    @Override
    public void setAccessToken(String accessToken) {
        this.encryptKey(KEY_ACCESS_TOKEN, accessToken);
    }

    @Override
    public String getAccessToken() {
        return this.decryptKey(KEY_ACCESS_TOKEN, null);
    }

    @Override
    public void clearAccessToken() {
        this.removeKey(KEY_ACCESS_TOKEN);
    }

    @Override
    public void setRefreshToken(String refreshToken) {
        this.encryptKey(KEY_REFRESH_TOKEN, refreshToken);
    }

    @Override
    public String getRefreshToken() {
        return this.decryptKey(KEY_REFRESH_TOKEN, null);
    }

    @Override
    public void clearRefreshToken() {
        this.removeKey(KEY_REFRESH_TOKEN);
    }
}

