/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.android;

import android.app.Activity;
import android.content.Context;
import android.net.Uri;
import android.os.Bundle;
import android.support.customtabs.CustomTabsClient;
import android.support.customtabs.CustomTabsIntent;
import android.support.customtabs.CustomTabsServiceConnection;
import android.support.customtabs.CustomTabsSession;
import com.stormpath.sdk.android.CustomTabsHelper;
import com.stormpath.sdk.android.ServiceConnection;
import com.stormpath.sdk.android.ServiceConnectionCallback;
import java.util.List;

public class CustomTabActivityHelper
implements ServiceConnectionCallback {
    private CustomTabsSession mCustomTabsSession;
    private CustomTabsClient mClient;
    private CustomTabsServiceConnection mConnection;
    private ConnectionCallback mConnectionCallback;

    public static void openCustomTab(Activity activity, CustomTabsIntent customTabsIntent, Uri uri, CustomTabFallback fallback) {
        String packageName = CustomTabsHelper.getPackageNameToUse((Context)activity);
        if (packageName == null) {
            if (fallback != null) {
                fallback.openUri(activity, uri);
            }
        } else {
            customTabsIntent.intent.setPackage(packageName);
            customTabsIntent.intent.setFlags(0x10000000);
            customTabsIntent.launchUrl(activity, uri);
        }
    }

    public void unbindCustomTabsService(Activity activity) {
        if (this.mConnection == null) {
            return;
        }
        activity.unbindService((android.content.ServiceConnection)this.mConnection);
        this.mClient = null;
        this.mCustomTabsSession = null;
        this.mConnection = null;
    }

    public CustomTabsSession getSession() {
        if (this.mClient == null) {
            this.mCustomTabsSession = null;
        } else if (this.mCustomTabsSession == null) {
            this.mCustomTabsSession = this.mClient.newSession(null);
        }
        return this.mCustomTabsSession;
    }

    public void setConnectionCallback(ConnectionCallback connectionCallback) {
        this.mConnectionCallback = connectionCallback;
    }

    public void bindCustomTabsService(Activity activity) {
        if (this.mClient != null) {
            return;
        }
        String packageName = CustomTabsHelper.getPackageNameToUse((Context)activity);
        if (packageName == null) {
            return;
        }
        this.mConnection = new ServiceConnection(this);
        CustomTabsClient.bindCustomTabsService((Context)activity, (String)packageName, (CustomTabsServiceConnection)this.mConnection);
    }

    public boolean mayLaunchUrl(Uri uri, Bundle extras, List<Bundle> otherLikelyBundles) {
        if (this.mClient == null) {
            return false;
        }
        CustomTabsSession session = this.getSession();
        if (session == null) {
            return false;
        }
        return session.mayLaunchUrl(uri, extras, otherLikelyBundles);
    }

    @Override
    public void onServiceConnected(CustomTabsClient client) {
        this.mClient = client;
        this.mClient.warmup(0L);
        if (this.mConnectionCallback != null) {
            this.mConnectionCallback.onCustomTabsConnected();
        }
    }

    @Override
    public void onServiceDisconnected() {
        this.mClient = null;
        this.mCustomTabsSession = null;
        if (this.mConnectionCallback != null) {
            this.mConnectionCallback.onCustomTabsDisconnected();
        }
    }

    public static interface CustomTabFallback {
        public void openUri(Activity var1, Uri var2);
    }

    public static interface ConnectionCallback {
        public void onCustomTabsConnected();

        public void onCustomTabsDisconnected();
    }
}

