/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk;

public class StormpathConfiguration {
    public static final String VERSION = "1.0.5";
    private final String loginPath;
    private final String baseUrl;
    private final String oauthPath;
    private final String registerPath;
    private final String verifyEmailPath;
    private final String passwordResetPath;
    private final String logoutPath;
    private final String userProfilePath;
    private final String socialProvidersPath;

    StormpathConfiguration(Builder builder) {
        this.baseUrl = StormpathConfiguration.normalizeUrl(builder.baseUrl);
        this.oauthPath = StormpathConfiguration.normalizePath(builder.oauthPath);
        this.loginPath = StormpathConfiguration.normalizePath(builder.loginPath);
        this.registerPath = StormpathConfiguration.normalizePath(builder.registerPath);
        this.verifyEmailPath = StormpathConfiguration.normalizePath(builder.verifyEmailPath);
        this.passwordResetPath = StormpathConfiguration.normalizePath(builder.passwordResetPath);
        this.logoutPath = StormpathConfiguration.normalizePath(builder.logoutPath);
        this.userProfilePath = StormpathConfiguration.normalizePath(builder.userProfilePath);
        this.socialProvidersPath = StormpathConfiguration.normalizePath(builder.socialProvidersPath);
    }

    String baseUrl() {
        return this.baseUrl;
    }

    String oauthPath() {
        return this.oauthPath;
    }

    String loginPath() {
        return this.loginPath;
    }

    String registerPath() {
        return this.registerPath;
    }

    String verifyEmailPath() {
        return this.verifyEmailPath;
    }

    String passwordResetPath() {
        return this.passwordResetPath;
    }

    String logoutPath() {
        return this.logoutPath;
    }

    String userProfilePath() {
        return this.userProfilePath;
    }

    String socialProvidersPath() {
        return this.socialProvidersPath;
    }

    String oauthUrl() {
        return this.baseUrl + this.oauthPath;
    }

    String loginUrl() {
        return this.baseUrl + this.loginPath;
    }

    String registerUrl() {
        return this.baseUrl + this.registerPath;
    }

    String verifyEmailUrl() {
        return this.baseUrl + this.verifyEmailPath;
    }

    String passwordResetUrl() {
        return this.baseUrl + this.passwordResetPath;
    }

    String logoutUrl() {
        return this.baseUrl + this.logoutPath;
    }

    String userProfileUrl() {
        return this.baseUrl + this.userProfilePath;
    }

    String socialProvidersUrl() {
        return this.baseUrl + this.socialProvidersPath;
    }

    private static String normalizePath(String path) {
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        return path;
    }

    private static String normalizeUrl(String url) {
        if (url.endsWith("/")) {
            url = url.substring(0, url.length() - 1);
        }
        return url;
    }

    public static class Builder {
        String baseUrl;
        String oauthPath = "/oauth/token";
        String loginPath = "/login";
        String registerPath = "/register";
        String verifyEmailPath = "/verify";
        String passwordResetPath = "/forgot";
        String logoutPath = "/logout";
        String userProfilePath = "/me";
        String socialProvidersPath = "/spa-config";

        public Builder baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        public Builder oauthPath(String oauthPath) {
            this.oauthPath = oauthPath;
            return this;
        }

        public Builder loginPath(String loginPath) {
            this.loginPath = loginPath;
            return this;
        }

        public Builder registerPath(String registerPath) {
            this.registerPath = registerPath;
            return this;
        }

        public Builder verifyEmailPath(String verifyEmailPath) {
            this.verifyEmailPath = verifyEmailPath;
            return this;
        }

        public Builder passwordResetPath(String passwordResetPath) {
            this.passwordResetPath = passwordResetPath;
            return this;
        }

        public Builder logoutPath(String logoutPath) {
            this.logoutPath = logoutPath;
            return this;
        }

        public Builder userProfilePath(String userProfilePath) {
            this.userProfilePath = userProfilePath;
            return this;
        }

        public Builder socialProvidersPath(String socialProvidersPath) {
            this.socialProvidersPath = socialProvidersPath;
            return this;
        }

        public StormpathConfiguration build() {
            if (this.baseUrl == null) {
                throw new IllegalStateException("baseUrl == null");
            }
            if (this.oauthPath == null) {
                throw new IllegalStateException("oauthPath == null");
            }
            if (this.loginPath == null) {
                throw new IllegalStateException("loginPath == null");
            }
            if (this.registerPath == null) {
                throw new IllegalStateException("registerPath == null");
            }
            if (this.verifyEmailPath == null) {
                throw new IllegalStateException("verifyEmailPath == null");
            }
            if (this.passwordResetPath == null) {
                throw new IllegalStateException("passwordResetPath == null");
            }
            if (this.logoutPath == null) {
                throw new IllegalStateException("logoutPath == null");
            }
            if (this.userProfilePath == null) {
                throw new IllegalStateException("userProfilePath == null");
            }
            if (this.socialProvidersPath == null) {
                throw new IllegalStateException("socialProvidersPath == null");
            }
            return new StormpathConfiguration(this);
        }
    }
}

