/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk;

import com.squareup.moshi.Json;
import com.squareup.moshi.Moshi;
import com.stormpath.sdk.Platform;
import com.stormpath.sdk.PreferenceStore;
import com.stormpath.sdk.Stormpath;
import com.stormpath.sdk.StormpathCallback;
import com.stormpath.sdk.StormpathConfiguration;
import com.stormpath.sdk.models.RegisterParams;
import com.stormpath.sdk.models.SessionTokens;
import com.stormpath.sdk.models.SocialProvidersResponse;
import com.stormpath.sdk.models.StormpathError;
import com.stormpath.sdk.models.UserProfile;
import com.stormpath.sdk.utils.StringUtils;
import java.io.IOException;
import java.io.Serializable;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Dispatcher;
import okhttp3.FormBody;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.logging.HttpLoggingInterceptor;

public class ApiManager {
    public static final Pattern ACCESS_TOKEN_COOKIE_PATTERN = Pattern.compile("access_token=(.*?);.*");
    public static final Pattern REFRESH_TOKEN_COOKIE_PATTERN = Pattern.compile("refresh_token=(.*?);.*");
    private final Platform platform;
    private final OkHttpClient okHttpClient;
    private final Executor callbackExecutor;
    private final StormpathConfiguration config;
    private final PreferenceStore preferenceStore;
    private final Moshi moshi = new Moshi.Builder().build();

    ApiManager(StormpathConfiguration config, Platform platform) {
        this.config = config;
        this.preferenceStore = platform.preferenceStore();
        this.callbackExecutor = platform.callbackExecutor();
        HttpLoggingInterceptor httpLoggingInterceptor = new HttpLoggingInterceptor(new HttpLoggingInterceptor.Logger(){

            public void log(String message) {
                Stormpath.logger().d(message, new Object[0]);
            }
        });
        httpLoggingInterceptor.setLevel(HttpLoggingInterceptor.Level.BODY);
        this.okHttpClient = new OkHttpClient.Builder().dispatcher(new Dispatcher(platform.httpExecutorService())).addNetworkInterceptor((Interceptor)httpLoggingInterceptor).build();
        this.platform = platform;
    }

    void login(String username, String password, StormpathCallback<Void> callback) {
        FormBody formBody = new FormBody.Builder().add("username", username).add("password", password).add("grant_type", "password").build();
        Request request = new Request.Builder().url(this.config.oauthUrl()).headers(this.buildStandardHeaders()).post((RequestBody)formBody).build();
        this.okHttpClient.newCall(request).enqueue((Callback)new OkHttpCallback<Void>(callback){

            @Override
            protected void onSuccess(Response response, StormpathCallback<Void> callback) {
                try {
                    SessionTokens sessionTokens = (SessionTokens)ApiManager.this.moshi.adapter(SessionTokens.class).fromJson(response.body().source());
                    if (StringUtils.isBlank(sessionTokens.getAccessToken())) {
                        this.failureCallback(new RuntimeException("access_token was not found in response. See debug logs for details."));
                        return;
                    }
                    if (StringUtils.isBlank(sessionTokens.getRefreshToken())) {
                        Stormpath.logger().e("There was no refresh_token in the login response!", new Object[0]);
                    }
                    ApiManager.this.preferenceStore.setAccessToken(sessionTokens.getAccessToken());
                    ApiManager.this.preferenceStore.setRefreshToken(sessionTokens.getRefreshToken());
                    this.successCallback(null);
                }
                catch (Throwable t) {
                    this.failureCallback(t);
                }
            }
        });
    }

    public void register(RegisterParams registerParams, StormpathCallback<Void> callback) {
        RequestBody body = RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)this.moshi.adapter(RegisterParams.class).toJson((Object)registerParams));
        Request request = new Request.Builder().url(this.config.registerUrl()).headers(this.buildStandardHeaders()).post(body).build();
        this.okHttpClient.newCall(request).enqueue((Callback)new OkHttpCallback<Void>(callback){

            @Override
            protected void onSuccess(Response response, StormpathCallback<Void> callback) {
                try {
                    String[] sessionTokens = ApiManager.this.parseSessionTokens(response);
                    String accessToken = sessionTokens[0];
                    String refreshToken = sessionTokens[1];
                    if (StringUtils.isNotBlank(accessToken)) {
                        ApiManager.this.preferenceStore.setAccessToken(accessToken);
                        if (StringUtils.isNotBlank(refreshToken)) {
                            ApiManager.this.preferenceStore.setRefreshToken(refreshToken);
                        }
                    } else {
                        Stormpath.logger().i("There was no access_token in the register cookies, if you want to skip the login after registration, enable the autologin in your Stormpath server app.", new Object[0]);
                    }
                    this.successCallback(null);
                }
                catch (Throwable t) {
                    this.failureCallback(t);
                }
            }
        });
    }

    public void refreshAccessToken(final StormpathCallback<Void> callback) {
        String refreshToken = this.preferenceStore.getRefreshToken();
        if (StringUtils.isBlank(refreshToken)) {
            this.callbackExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    callback.onFailure(new StormpathError(ApiManager.this.platform.unknownErrorMessage(), new IllegalStateException("refresh_token was not found, did you forget to login? See debug logs for details.")));
                }
            });
            return;
        }
        FormBody formBody = new FormBody.Builder().add("refresh_token", refreshToken).add("grant_type", "refresh_token").build();
        Request request = new Request.Builder().url(this.config.oauthUrl()).headers(this.buildStandardHeaders()).post((RequestBody)formBody).build();
        this.okHttpClient.newCall(request).enqueue((Callback)new OkHttpCallback<Void>(callback){

            @Override
            protected void onSuccess(Response response, StormpathCallback<Void> callback) {
                try {
                    SessionTokens sessionTokens = (SessionTokens)ApiManager.this.moshi.adapter(SessionTokens.class).fromJson(response.body().source());
                    if (StringUtils.isBlank(sessionTokens.getAccessToken())) {
                        this.failureCallback(new RuntimeException("access_token was not found in response. See debug logs for details."));
                        return;
                    }
                    if (StringUtils.isBlank(sessionTokens.getRefreshToken())) {
                        Stormpath.logger().e("There was no refresh_token in the login response!", new Object[0]);
                    }
                    ApiManager.this.preferenceStore.setAccessToken(sessionTokens.getAccessToken());
                    ApiManager.this.preferenceStore.setRefreshToken(sessionTokens.getRefreshToken());
                    this.successCallback(null);
                }
                catch (Throwable t) {
                    this.failureCallback(t);
                }
            }
        });
    }

    public void getUserProfile(final StormpathCallback<UserProfile> callback) {
        String accessToken = this.preferenceStore.getAccessToken();
        if (StringUtils.isBlank(accessToken)) {
            this.callbackExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    callback.onFailure(new StormpathError(ApiManager.this.platform.unknownErrorMessage(), new IllegalStateException("access_token was not found, did you forget to login? See debug logs for details.")));
                }
            });
            return;
        }
        Request request = new Request.Builder().url(this.config.userProfileUrl()).headers(this.buildStandardHeaders(accessToken)).get().build();
        this.okHttpClient.newCall(request).enqueue((Callback)new OkHttpCallback<UserProfile>(callback){

            @Override
            protected void onSuccess(Response response, StormpathCallback<UserProfile> callback) {
                try {
                    UserProfileResponse userProfileResponse = (UserProfileResponse)ApiManager.this.moshi.adapter(UserProfileResponse.class).fromJson(response.body().source());
                    this.successCallback(userProfileResponse.userProfile);
                }
                catch (Throwable t) {
                    this.failureCallback(t);
                }
            }
        });
    }

    public void resetPassword(String email, StormpathCallback<Void> callback) {
        RequestBody body = RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)("{\"email\":\"" + email + "\"}"));
        Request request = new Request.Builder().url(this.config.passwordResetUrl()).headers(this.buildStandardHeaders()).post(body).build();
        this.okHttpClient.newCall(request).enqueue((Callback)new OkHttpCallback<Void>(callback){

            @Override
            protected void onSuccess(Response response, StormpathCallback<Void> callback) {
                this.successCallback(null);
            }
        });
    }

    public void logout() {
        String accessToken = this.preferenceStore.getAccessToken();
        if (StringUtils.isBlank(accessToken)) {
            Stormpath.logger().e("access_token was not found, did you forget to login? See debug logs for details.", new Object[0]);
            return;
        }
        Request request = new Request.Builder().url(this.config.logoutUrl()).headers(this.buildStandardHeaders(accessToken)).post(RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)"")).build();
        this.preferenceStore.clearAccessToken();
        this.preferenceStore.clearRefreshToken();
        this.okHttpClient.newCall(request).enqueue(new Callback(){

            public void onResponse(Call call, Response response) throws IOException {
            }

            public void onFailure(Call call, IOException e) {
            }
        });
    }

    public void verifyEmail(String sptoken, StormpathCallback<Void> callback) {
        HttpUrl url = HttpUrl.parse((String)this.config.verifyEmailUrl()).newBuilder().addQueryParameter("sptoken", sptoken).build();
        Request request = new Request.Builder().url(url).headers(this.buildStandardHeaders()).get().build();
        this.okHttpClient.newCall(request).enqueue((Callback)new OkHttpCallback<Void>(callback){

            @Override
            protected void onSuccess(Response response, StormpathCallback<Void> callback) {
                this.successCallback(null);
            }
        });
    }

    public void resendVerificationEmail(String email, StormpathCallback<Void> callback) {
        FormBody body = new FormBody.Builder().add("login", email).build();
        Request request = new Request.Builder().url(this.config.verifyEmailUrl()).headers(this.buildStandardHeaders()).post((RequestBody)body).build();
        this.okHttpClient.newCall(request).enqueue((Callback)new OkHttpCallback<Void>(callback){

            @Override
            protected void onSuccess(Response response, StormpathCallback<Void> callback) {
                this.successCallback(null);
            }
        });
    }

    public void getSocialProviders(StormpathCallback<SocialProvidersResponse> callback) {
        String accessToken = this.preferenceStore.getAccessToken();
        Request request = new Request.Builder().url(this.config.socialProvidersUrl()).headers(this.buildStandardHeaders(accessToken)).get().build();
        this.okHttpClient.newCall(request).enqueue((Callback)new OkHttpCallback<SocialProvidersResponse>(callback){

            @Override
            protected void onSuccess(Response response, StormpathCallback<SocialProvidersResponse> callback) {
                try {
                    SocialProvidersResponse socialProvidersResponse = (SocialProvidersResponse)ApiManager.this.moshi.adapter(SocialProvidersResponse.class).fromJson(response.body().source());
                    this.successCallback(socialProvidersResponse);
                }
                catch (Throwable t) {
                    this.failureCallback(t);
                }
            }
        });
    }

    void socialLogin(String providerId, String accessToken, String code, StormpathCallback<Void> callback) {
        SocialLoginRequest socialLoginRequest = new SocialLoginRequest(providerId, accessToken, code);
        String bodyJson = this.moshi.adapter(SocialLoginRequest.class).toJson((Object)socialLoginRequest);
        RequestBody body = RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)bodyJson);
        Request request = new Request.Builder().url(this.config.loginUrl()).headers(this.buildStandardHeaders()).post(body).build();
        this.okHttpClient.newCall(request).enqueue((Callback)new OkHttpCallback<Void>(callback){

            @Override
            protected void onSuccess(Response response, StormpathCallback<Void> callback) {
                try {
                    String[] sessionTokens = ApiManager.this.parseSessionTokens(response);
                    String accessToken = sessionTokens[0];
                    String refreshToken = sessionTokens[1];
                    if (StringUtils.isBlank(accessToken)) {
                        this.failureCallback(new RuntimeException("access_token was not found in response. See debug logs for details."));
                        return;
                    }
                    if (StringUtils.isBlank(refreshToken)) {
                        Stormpath.logger().e("There was no refresh_token in the response!", new Object[0]);
                    }
                    ApiManager.this.preferenceStore.setAccessToken(accessToken);
                    ApiManager.this.preferenceStore.setRefreshToken(refreshToken);
                    this.successCallback(null);
                }
                catch (Throwable t) {
                    this.failureCallback(t);
                }
            }
        });
    }

    private String[] parseSessionTokens(Response response) {
        List cookies = response.headers("Set-Cookie");
        String accessToken = null;
        String refreshToken = null;
        for (String cookieHeader : cookies) {
            Matcher refreshTokenMatcher;
            Matcher accessTokenMatcher = ACCESS_TOKEN_COOKIE_PATTERN.matcher(cookieHeader);
            if (accessTokenMatcher.find()) {
                accessToken = accessTokenMatcher.group(1);
            }
            if (!(refreshTokenMatcher = REFRESH_TOKEN_COOKIE_PATTERN.matcher(cookieHeader)).find()) continue;
            refreshToken = refreshTokenMatcher.group(1);
        }
        return new String[]{accessToken, refreshToken};
    }

    private Headers buildStandardHeaders() {
        return this.buildStandardHeaders(null);
    }

    private Headers buildStandardHeaders(String accessToken) {
        Headers.Builder builder = new Headers.Builder();
        builder.add("Accept", "application/json");
        if (StringUtils.isNotBlank(accessToken)) {
            builder.add("Authorization", "Bearer " + accessToken);
        }
        return builder.build();
    }

    private static class SocialLoginRequest
    implements Serializable {
        @Json(name="providerData")
        private Map<String, String> providerData = new LinkedHashMap<String, String>();

        public SocialLoginRequest(String providerId, String accessToken, String code) {
            this.providerData.put("providerId", providerId);
            if (StringUtils.isNotBlank(accessToken)) {
                this.providerData.put("accessToken", accessToken);
            }
            if (StringUtils.isNotBlank(code)) {
                this.providerData.put("code", code);
            }
        }
    }

    private static class UserProfileResponse
    implements Serializable {
        @Json(name="account")
        private UserProfile userProfile;

        private UserProfileResponse() {
        }
    }

    private abstract class OkHttpCallback<T>
    implements Callback {
        private StormpathCallback<T> stormpathCallback;

        public OkHttpCallback(StormpathCallback<T> stormpathCallback) {
            this.stormpathCallback = stormpathCallback;
        }

        public void onFailure(Call call, IOException e) {
            if (e instanceof UnknownHostException || e instanceof SocketTimeoutException || e instanceof SocketException) {
                this.failureCallback(new StormpathError(ApiManager.this.platform.networkErrorMessage(), e));
            } else {
                this.failureCallback(e);
            }
        }

        public void onResponse(Call call, Response response) throws IOException {
            if (response.isSuccessful()) {
                this.onSuccess(response, this.stormpathCallback);
            } else {
                try {
                    StormpathError error = (StormpathError)ApiManager.this.moshi.adapter(StormpathError.class).fromJson(response.body().source());
                    this.failureCallback(error);
                }
                catch (Throwable t) {
                    this.failureCallback(t);
                }
            }
        }

        protected abstract void onSuccess(Response var1, StormpathCallback<T> var2);

        void successCallback(final T t) {
            ApiManager.this.callbackExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    OkHttpCallback.this.stormpathCallback.onSuccess(t);
                }
            });
        }

        void failureCallback(Throwable t) {
            this.failureCallback(new StormpathError(ApiManager.this.platform.unknownErrorMessage(), t));
        }

        void failureCallback(final StormpathError error) {
            ApiManager.this.callbackExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    OkHttpCallback.this.stormpathCallback.onFailure(error);
                }
            });
        }
    }
}

