/*
 * Decompiled with CFR 0.152.
 */
package com.steve.view;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.content.Context;
import android.content.res.TypedArray;
import android.os.Build;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import android.support.v4.content.ContextCompat;
import android.support.v7.appcompat.R;
import android.support.v7.widget.SearchView;
import android.support.v7.widget.Toolbar;
import android.util.AttributeSet;
import android.util.Log;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewAnimationUtils;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.steve.view.R;
import java.lang.reflect.Field;

public class SearchToolBar
extends LinearLayout {
    private static final String TAG = SearchToolBar.class.getSimpleName();
    private MenuItem itemSearch;
    private Toolbar toolbar;
    private int mPositionFromRight;
    private SearchToolBarListener mListener;

    public SearchToolBar(Context context) {
        this(context, null);
    }

    public SearchToolBar(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public boolean hasOverlappingRendering() {
        return false;
    }

    public SearchToolBar(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.SearchToolBar);
        this.mPositionFromRight = a.getInteger(R.styleable.SearchToolBar_search_position, 0);
        a.recycle();
        SearchToolBar.inflate((Context)this.getContext(), (int)R.layout.toolbar_search_view, (ViewGroup)this);
        this.toolbar = (Toolbar)this.findViewById(R.id.toolbar_search);
        this.toolbar.inflateMenu(R.menu.toolbar_search_menu);
        Menu searchMenu = this.toolbar.getMenu();
        this.itemSearch = searchMenu.findItem(R.id.action_toolbar_search);
        this.itemSearch.setOnActionExpandListener(new MenuItem.OnActionExpandListener(){

            public boolean onMenuItemActionExpand(MenuItem item) {
                if (SearchToolBar.this.toolbar.getVisibility() != 0) {
                    if (Build.VERSION.SDK_INT >= 21) {
                        SearchToolBar.this.createToolbarSearchReveal(true);
                    } else {
                        SearchToolBar.this.toolbar.setVisibility(0);
                    }
                    return SearchToolBar.this.mListener.onMenuItemActionExpand(item);
                }
                return true;
            }

            public boolean onMenuItemActionCollapse(MenuItem item) {
                if (Build.VERSION.SDK_INT >= 21) {
                    SearchToolBar.this.createToolbarSearchReveal(false);
                } else {
                    SearchToolBar.this.toolbar.setVisibility(4);
                }
                return SearchToolBar.this.mListener.onMenuItemActionCollapse(item);
            }
        });
        this.toolbar.setNavigationOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                SearchToolBar.this.itemSearch.collapseActionView();
            }
        });
        this.setUpSearchView(this.itemSearch);
    }

    public void expand() {
        this.itemSearch.expandActionView();
    }

    public boolean isExpanded() {
        return this.itemSearch.isActionViewExpanded();
    }

    public void collapse() {
        this.itemSearch.collapseActionView();
    }

    private void setUpSearchView(MenuItem itemSearch) {
        SearchView searchView = (SearchView)itemSearch.getActionView();
        View v = searchView.findViewById(R.id.search_plate);
        v.setBackgroundColor(0);
        searchView.setSubmitButtonEnabled(false);
        ImageView closeBtn = (ImageView)searchView.findViewById(R.id.search_close_btn);
        closeBtn.setImageDrawable(ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.ic_close_grey_700_24dp));
        EditText editText = (EditText)searchView.findViewById(R.id.search_src_text);
        editText.setHint(R.string.action_search);
        editText.setHintTextColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.grey_400));
        editText.setTextColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.grey_700));
        editText.setOnFocusChangeListener(new View.OnFocusChangeListener(){

            public void onFocusChange(View v, boolean hasFocus) {
                if (!hasFocus) {
                    SearchToolBar.this.collapse();
                }
            }
        });
        try {
            Field mCursorDrawableRes = TextView.class.getDeclaredField("mCursorDrawableRes");
            mCursorDrawableRes.setAccessible(true);
            mCursorDrawableRes.set(editText, R.drawable.toolbar_search_cursor);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"setUpSearchView: ", (Throwable)e);
        }
        searchView.setOnQueryTextListener(new SearchView.OnQueryTextListener(){

            public boolean onQueryTextSubmit(String query) {
                if (SearchToolBar.this.mListener == null) {
                    throw new RuntimeException("Null listener for searchView");
                }
                SearchToolBar.this.mListener.onQueryTextChange(query);
                return true;
            }

            public boolean onQueryTextChange(String newText) {
                if (SearchToolBar.this.mListener == null) {
                    throw new RuntimeException("Null listener for searchView");
                }
                SearchToolBar.this.mListener.onQueryTextChange(newText);
                return true;
            }
        });
    }

    @RequiresApi(api=21)
    public void createToolbarSearchReveal(boolean show) {
        int width = this.toolbar.getWidth();
        int height = this.toolbar.getHeight();
        int b = this.toolbar.getContext().getResources().getDimensionPixelSize(R.dimen.abc_action_button_min_width_material);
        if (this.mPositionFromRight > 0) {
            width -= this.mPositionFromRight * b;
        }
        int cx = width -= b / 2;
        int cy = height / 2;
        final Animator animator = ViewAnimationUtils.createCircularReveal((View)this.toolbar, (int)cx, (int)cy, (float)(show ? 0.0f : (float)width), (float)(show ? (float)width : 0.0f));
        animator.setDuration(240L);
        if (!show) {
            animator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationEnd(Animator animation) {
                    SearchToolBar.this.toolbar.setVisibility(4);
                    animator.removeListener((Animator.AnimatorListener)this);
                }
            });
        } else {
            this.toolbar.setVisibility(0);
        }
        animator.start();
    }

    public void setSearchToolbarListener(SearchToolBarListener mListener) {
        this.mListener = mListener;
    }

    public static interface SearchToolBarListener {
        public void onQueryTextChange(String var1);

        public boolean onMenuItemActionExpand(MenuItem var1);

        public boolean onMenuItemActionCollapse(MenuItem var1);
    }
}

