/*
 * Decompiled with CFR 0.152.
 */
package com.steve.task.storage;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.util.Log;
import com.steve.task.Task;
import com.steve.task.storage.TaskSerializer;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;

public class TaskStorage {
    private static final String _ID = "_id";
    private static final String COLUMN_TASK = "task";
    private static final String TABLE_NAME = "adwa_task";
    private static final String TAG = TaskStorage.class.getSimpleName();
    private Context context;
    private TaskSerializer<Task> serializer;
    private DatabaseHelper databaseHelper;

    public TaskStorage(Context context, String name, TaskSerializer<Task> serializer) {
        this.context = context;
        this.serializer = serializer;
        this.databaseHelper = new DatabaseHelper(context, name);
    }

    public void persist(Task task) throws IOException {
        ContentValues values = new ContentValues();
        values.put(COLUMN_TASK, this.serializer.serialize(task));
        long id = this.databaseHelper.getWritableDatabase().insert(TABLE_NAME, null, values);
        task.setStorageId(id);
    }

    public List<Task> getAllTasks() {
        LinkedList<Task> list = new LinkedList<Task>();
        Cursor cursor = this.databaseHelper.getReadableDatabase().query(TABLE_NAME, null, null, null, null, null, null);
        if (cursor != null) {
            while (cursor.moveToNext()) {
                long id = cursor.getLong(cursor.getColumnIndexOrThrow(_ID));
                String serTask = cursor.getString(cursor.getColumnIndexOrThrow(COLUMN_TASK));
                try {
                    Task task = this.serializer.deserialize(serTask);
                    task.setContext(this.context);
                    list.add(task);
                }
                catch (IOException e) {
                    Log.e((String)TAG, (String)"getAllTasks: ", (Throwable)e);
                    this.remove(id);
                }
            }
            cursor.close();
        }
        return list;
    }

    public void remove(long id) {
        this.databaseHelper.getWritableDatabase().delete(TABLE_NAME, "_id=?", new String[]{String.valueOf(id)});
    }

    private class DatabaseHelper
    extends SQLiteOpenHelper {
        private static final int DB_VERSION = 1;

        DatabaseHelper(Context context, String name) {
            super(context, name + "_Tasks", null, 1);
        }

        public void onCreate(SQLiteDatabase db) {
            String SQL_CREATE_ADWA_TASK_TABLE = "CREATE TABLE adwa_task (_id INTEGER PRIMARY KEY,task TEXT NOT NULL)";
            db.execSQL("CREATE TABLE adwa_task (_id INTEGER PRIMARY KEY,task TEXT NOT NULL)");
        }

        public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        }
    }
}

