/*
 * Decompiled with CFR 0.152.
 */
package com.steve.task;

import com.steve.task.Task;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;

class TaskQueue {
    private final Set<String> activeGroupIds = new HashSet<String>();
    private final LinkedList<Task> taskQueue = new LinkedList();

    TaskQueue() {
    }

    synchronized void onConditionChanged() {
        this.notifyAll();
    }

    synchronized void add(Task task) {
        this.taskQueue.add(task);
        this.notifyAll();
    }

    synchronized void addAll(List<Task> tasks) {
        this.taskQueue.addAll(tasks);
        this.notifyAll();
    }

    synchronized void push(Task task) {
        this.taskQueue.addFirst(task);
    }

    synchronized Task getNextTask() {
        try {
            Task nextTask;
            while ((nextTask = this.getNextAvailableTask()) == null) {
                this.wait();
            }
            return nextTask;
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            throw new AssertionError((Object)e);
        }
    }

    private synchronized Task getNextAvailableTask() {
        if (this.taskQueue.isEmpty()) {
            return null;
        }
        ListIterator iterator = this.taskQueue.listIterator();
        while (iterator.hasNext()) {
            Task task = (Task)iterator.next();
            if (!task.isAllConditionsOK() || !this.isGroupAvailable(task.getGroupId())) continue;
            iterator.remove();
            this.setGroupIdUnavailable(task.getGroupId());
            return task;
        }
        return null;
    }

    private void setGroupIdUnavailable(String groupId) {
        if (groupId != null) {
            this.activeGroupIds.add(groupId);
        }
    }

    private boolean isGroupAvailable(String groupId) {
        return groupId == null || !this.activeGroupIds.contains(groupId);
    }

    synchronized void setGroupIdAvailable(String groupId) {
        if (groupId != null) {
            this.activeGroupIds.remove(groupId);
            this.notifyAll();
        }
    }
}

