/*
 * Decompiled with CFR 0.152.
 */
package com.steve.task;

import android.content.Context;
import android.os.PowerManager;
import com.steve.task.Task;
import com.steve.task.TaskConsumer;
import com.steve.task.TaskQueue;
import com.steve.task.condition.TaskConditionListener;
import com.steve.task.condition.TaskConditionProvider;
import com.steve.task.storage.TaskSerializer;
import com.steve.task.storage.TaskStorage;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;

public class TaskManager
implements TaskConditionListener {
    private final TaskQueue taskQueue = new TaskQueue();
    private final Executor eventExecutor = Executors.newSingleThreadExecutor();
    private Context context;
    private TaskStorage storage;

    private TaskManager(Context context, String name, int consumers, TaskSerializer<Task> serializer, List<TaskConditionProvider> conditionProviders) {
        this.context = context;
        this.storage = new TaskStorage(context, name, serializer);
        this.eventExecutor.execute(new Runnable(){

            @Override
            public void run() {
                TaskManager.this.taskQueue.addAll(TaskManager.this.storage.getAllTasks());
            }
        });
        if (conditionProviders != null && !conditionProviders.isEmpty()) {
            for (TaskConditionProvider provider : conditionProviders) {
                provider.setListener(this);
            }
        }
        for (int i = 0; i < consumers; ++i) {
            new TaskConsumer("Consumer-" + i, this.taskQueue, this.storage).start();
        }
    }

    public void addTaskToQueue(final Task task) {
        if (task.needsWakeLock()) {
            task.setWakeLock(this.acquireWakeLock(this.context, task.toString(), task.getWakeLockTimeOut()));
        }
        this.eventExecutor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    if (task.isPersistent()) {
                        TaskManager.this.storage.persist(task);
                    }
                    task.setContext(TaskManager.this.context);
                    task.onTaskAddedToQueue();
                    TaskManager.this.taskQueue.add(task);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private PowerManager.WakeLock acquireWakeLock(Context context, String tag, long timeOut) {
        PowerManager pm = (PowerManager)context.getSystemService("power");
        assert (pm != null);
        PowerManager.WakeLock wakeLock = pm.newWakeLock(1, tag);
        if (timeOut == 0L) {
            wakeLock.acquire(600000L);
        } else {
            wakeLock.acquire(timeOut);
        }
        return wakeLock;
    }

    public static Builder builder(Context context) {
        return new Builder(context);
    }

    @Override
    public void onConditionChanged() {
        this.eventExecutor.execute(new Runnable(){

            @Override
            public void run() {
                TaskManager.this.taskQueue.onConditionChanged();
            }
        });
    }

    public static class Builder {
        private Context context;
        private String name;
        private int consumers;
        private TaskSerializer<Task> serializer;
        private List<TaskConditionProvider> conditionProviders;

        public Builder(Context context) {
            this.context = context;
            this.consumers = 3;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setConsumers(int consumers) {
            this.consumers = consumers;
            return this;
        }

        public Builder setSerializer(TaskSerializer<Task> serializer) {
            this.serializer = serializer;
            return this;
        }

        public Builder setConditions(TaskConditionProvider ... providers) {
            this.conditionProviders = Arrays.asList(providers);
            return this;
        }

        public TaskManager build() {
            if (this.name == null) {
                this.name = "Default";
            }
            if (this.conditionProviders == null) {
                this.conditionProviders = new LinkedList<TaskConditionProvider>();
            }
            return new TaskManager(this.context, this.name, this.consumers, this.serializer, this.conditionProviders);
        }
    }
}

