/*
 * Decompiled with CFR 0.152.
 */
package com.steve.task;

import android.util.Log;
import com.steve.task.Task;
import com.steve.task.TaskQueue;
import com.steve.task.storage.TaskStorage;

class TaskConsumer
extends Thread {
    private static final String TAG = TaskConsumer.class.getSimpleName();
    private final TaskQueue taskQueue;
    private final TaskStorage storage;

    TaskConsumer(String name, TaskQueue taskQueue, TaskStorage storage) {
        super(name);
        this.taskQueue = taskQueue;
        this.storage = storage;
    }

    @Override
    public void run() {
        super.run();
        while (true) {
            Task task;
            AdwaTaskResult result;
            if ((result = this.runTask(task = this.taskQueue.getNextTask())) == AdwaTaskResult.DEFERRED) {
                this.taskQueue.push(task);
            } else {
                if (result == AdwaTaskResult.FAILURE) {
                    task.onTaskCancelled();
                }
                if (task.isPersistent()) {
                    this.storage.remove(task.getStorageId());
                }
                if (task.getWakeLock() != null && task.getWakeLockTimeOut() == 0L) {
                    task.getWakeLock().release();
                }
            }
            if (task.getGroupId() == null) continue;
            this.taskQueue.setGroupIdAvailable(task.getGroupId());
        }
    }

    private AdwaTaskResult runTask(Task task) {
        int retryCount = task.getRetryCount();
        for (int runIteration = task.getRunIteration(); runIteration < retryCount; ++runIteration) {
            try {
                task.onTaskExecute();
                return AdwaTaskResult.SUCCESS;
            }
            catch (Exception e) {
                e.printStackTrace();
                Log.e((String)TAG, (String)"runTask: ", (Throwable)e);
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                if (!task.shouldRetry(e)) {
                    return AdwaTaskResult.FAILURE;
                }
                if (task.isAllConditionsOK()) continue;
                task.setRunIteration(runIteration + 1);
                return AdwaTaskResult.DEFERRED;
            }
        }
        return AdwaTaskResult.FAILURE;
    }

    static enum AdwaTaskResult {
        SUCCESS,
        FAILURE,
        DEFERRED;

    }
}

