/*
 * Decompiled with CFR 0.152.
 */
package com.steve.task;

import android.content.Context;
import android.os.PowerManager;
import com.steve.task.ContextRequired;
import com.steve.task.TaskParams;
import com.steve.task.condition.TaskCondition;
import java.io.Serializable;
import java.util.List;

public abstract class Task
implements Serializable {
    private final TaskParams params;
    private transient long storageId;
    private transient int runIteration;
    private transient PowerManager.WakeLock wakeLock;

    public Task(TaskParams params) {
        this.params = params;
    }

    public List<TaskCondition> getConditions() {
        return this.params.getConditions();
    }

    public boolean isPersistent() {
        return this.params.isPersistent();
    }

    public int getRetryCount() {
        return this.params.getRetryCount();
    }

    public int getRunIteration() {
        return this.runIteration;
    }

    public boolean needsWakeLock() {
        return this.params.isWakeLock();
    }

    public PowerManager.WakeLock getWakeLock() {
        return this.wakeLock;
    }

    public void setWakeLock(PowerManager.WakeLock wakeLock) {
        this.wakeLock = wakeLock;
    }

    public void setStorageId(long storageId) {
        this.storageId = storageId;
    }

    public long getStorageId() {
        return this.storageId;
    }

    public void setContext(Context context) {
        for (TaskCondition condition : this.getConditions()) {
            if (!(condition instanceof ContextRequired)) continue;
            ((ContextRequired)((Object)condition)).setContext(context);
        }
    }

    public abstract void onTaskAddedToQueue();

    public abstract void onTaskExecute() throws Exception;

    public abstract boolean shouldRetry(Exception var1);

    public abstract void onTaskCancelled();

    public String getGroupId() {
        return this.params.getGroupId();
    }

    public boolean isAllConditionsOK() {
        for (TaskCondition condition : this.getConditions()) {
            if (condition.isOk()) continue;
            return false;
        }
        return true;
    }

    public void setRunIteration(int runIteration) {
        this.runIteration = runIteration;
    }

    public long getWakeLockTimeOut() {
        return this.params.getWakeLockTimeOut();
    }
}

