/*
 * Decompiled with CFR 0.152.
 */
package com.steve.imagepicker;

import android.app.Activity;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.os.Bundle;
import android.os.Environment;
import android.os.Parcelable;
import android.provider.MediaStore;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.design.widget.BottomSheetDialogFragment;
import android.support.design.widget.Snackbar;
import android.support.v4.app.ActivityCompat;
import android.support.v4.app.Fragment;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.Toast;
import com.steve.imagepicker.ImagePickerPresenter;
import com.steve.imagepicker.ImagePickerView;
import com.steve.imagepicker.R;
import com.theartofdev.edmodo.cropper.CropImage;
import com.theartofdev.edmodo.cropper.CropImageView;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

public class ImagePickerFragment
extends BottomSheetDialogFragment
implements ImagePickerView,
View.OnClickListener {
    public static final String TAG = ImagePickerFragment.class.getSimpleName();
    private static final int RC_GALLERY = 1;
    private static final int RC_CAMERA = 2;
    private static final int RC_WRITE_STORAGE = 3;
    private static final String DO_CROP_KEY = "mDoCropAction";
    private static String title;
    private boolean mDoCropAction;
    private Uri mImageCaptureUri;
    private Bitmap originalBitmap;
    private ImagePickerResult mImagePickerResult;
    private ImagePickerPresenter<ImagePickerView> mPresenter;
    private LinearLayout sheetContainer;
    private static String actionText;
    private static String descText;
    private static boolean shouldUseDefaultConfig;

    public static ImagePickerFragment newInstance(Boolean doCropAction) {
        shouldUseDefaultConfig = true;
        ImagePickerFragment fragment = new ImagePickerFragment();
        Bundle bundle = new Bundle();
        bundle.putBoolean(DO_CROP_KEY, doCropAction.booleanValue());
        fragment.setArguments(bundle);
        return fragment;
    }

    public static ImagePickerFragment newInstance(boolean doCrop, String title, String deniedActionDescText, String actionText) {
        shouldUseDefaultConfig = false;
        ImagePickerFragment.actionText = actionText;
        ImagePickerFragment.title = title;
        descText = deniedActionDescText;
        return ImagePickerFragment.newInstance(doCrop);
    }

    public void onAttach(Context context) {
        super.onAttach(context);
        if (!(context instanceof ImagePickerResult)) {
            throw new ClassCastException("Activity must implement ImagePickerResult");
        }
        this.mImagePickerResult = (ImagePickerResult)context;
    }

    public void onDetach() {
        super.onDetach();
        this.mImagePickerResult = null;
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.mPresenter = new ImagePickerPresenter<ImagePickerFragment>(this);
        this.mDoCropAction = this.getArguments().getBoolean(DO_CROP_KEY);
    }

    @Nullable
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.picture_chooser, container, false);
        view.findViewById(R.id.pick_camera).setOnClickListener((View.OnClickListener)this);
        view.findViewById(R.id.pick_gallery).setOnClickListener((View.OnClickListener)this);
        this.sheetContainer = (LinearLayout)view.findViewById(R.id.sheet_container);
        if (!shouldUseDefaultConfig) {
            TextView textView = (TextView)view.findViewById(R.id.title);
            textView.setText((CharSequence)title);
        }
        return view;
    }

    public void onClick(View view) {
        int i = view.getId();
        if (i == R.id.pick_camera) {
            this.mPresenter.onPickCameraClicked();
        } else if (i == R.id.pick_gallery) {
            this.mPresenter.onPickGalleryClicked();
        }
    }

    @Override
    public void pickFromGallery() {
        Intent intent = new Intent("android.intent.action.GET_CONTENT");
        intent.setType("image/*");
        this.startActivityForResult(intent, 1);
    }

    @Override
    public void pickFromCamera() {
        if (ActivityCompat.checkSelfPermission((Context)this.getContext(), (String)"android.permission.WRITE_EXTERNAL_STORAGE") == 0) {
            Intent intent = new Intent("android.media.action.IMAGE_CAPTURE");
            this.mImageCaptureUri = this.getTmpFile();
            Log.i((String)TAG, (String)("pickFromCamera: path " + String.valueOf(this.mImageCaptureUri)));
            intent.putExtra("output", (Parcelable)this.mImageCaptureUri);
            intent.putExtra("return-data", true);
            this.startActivityForResult(intent, 2);
        } else if (ActivityCompat.shouldShowRequestPermissionRationale((Activity)this.getActivity(), (String)"android.permission.WRITE_EXTERNAL_STORAGE")) {
            Snackbar.make((View)this.sheetContainer, (CharSequence)(shouldUseDefaultConfig ? "Permission previously refused; do you want to grant it ?" : descText), (int)0).setAction((CharSequence)(shouldUseDefaultConfig ? "Grant" : actionText), new View.OnClickListener(){

                public void onClick(View v) {
                    ImagePickerFragment.this.requestPermission();
                }
            }).show();
        } else {
            this.requestPermission();
        }
    }

    private void requestPermission() {
        this.requestPermissions(new String[]{"android.permission.WRITE_EXTERNAL_STORAGE"}, 3);
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        int grantResult = grantResults[0];
        if (grantResult == 0) {
            this.pickFromCamera();
        } else {
            Toast.makeText((Context)this.getContext(), (CharSequence)"Permission denied", (int)0).show();
        }
    }

    private Uri getTmpFile() {
        File root = this.getRootDirectory();
        String fileName = "tmp_avatar_" + String.valueOf(System.currentTimeMillis()) + ".jpg";
        return Uri.fromFile((File)new File(root, fileName));
    }

    private File getRootDirectory() {
        File file;
        if (ActivityCompat.checkSelfPermission((Context)this.getContext(), (String)"android.permission.WRITE_EXTERNAL_STORAGE") == 0 && Environment.getExternalStorageState().equals("mounted") && (double)(file = Environment.getExternalStorageDirectory()).getFreeSpace() > 5.0 * Math.pow(1024.0, 2.0)) {
            return Environment.getExternalStorageDirectory();
        }
        return this.getContext().getCacheDir();
    }

    private void performCrop(Uri uri) {
        if (!this.mDoCropAction) {
            this.mImagePickerResult.onChooserSuccess(this.originalBitmap, null, false);
            this.dismiss();
            return;
        }
        CropImage.activity((Uri)uri).setAspectRatio(4, 3).setActivityTitle((CharSequence)this.getString(R.string.app_name)).setRequestedSize(1024, 1024, CropImageView.RequestSizeOptions.RESIZE_INSIDE).start(this.getContext(), (Fragment)this);
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        CropImage.ActivityResult result;
        super.onActivityResult(requestCode, resultCode, data);
        if (resultCode == -1) {
            if (requestCode == 2) {
                File f = new File(this.mImageCaptureUri.getPath());
                BitmapFactory.Options options = new BitmapFactory.Options();
                options.inPreferredConfig = Bitmap.Config.ARGB_8888;
                try {
                    this.originalBitmap = BitmapFactory.decodeStream((InputStream)new FileInputStream(f), null, (BitmapFactory.Options)options);
                }
                catch (FileNotFoundException e) {
                    this.mImagePickerResult.onChooserError(e.getMessage());
                }
                this.performCrop(this.mImageCaptureUri);
            }
            if (requestCode == 1) {
                try {
                    this.originalBitmap = MediaStore.Images.Media.getBitmap((ContentResolver)this.getContext().getContentResolver(), (Uri)data.getData());
                }
                catch (IOException e) {
                    this.mImagePickerResult.onChooserError(e.getMessage());
                }
                this.performCrop(data.getData());
            }
            if (requestCode == 203) {
                result = CropImage.getActivityResult((Intent)data);
                Uri resultUri = result.getUri();
                try {
                    FileInputStream inputStream = new FileInputStream(new File(resultUri.getPath()));
                    BitmapFactory.Options options = new BitmapFactory.Options();
                    options.inPreferredConfig = Bitmap.Config.ARGB_8888;
                    Bitmap crp = BitmapFactory.decodeStream((InputStream)inputStream, null, (BitmapFactory.Options)options);
                    this.mImagePickerResult.onChooserSuccess(this.originalBitmap, crp, true);
                }
                catch (FileNotFoundException e) {
                    this.mImagePickerResult.onChooserError(e.getMessage());
                }
                Log.e((String)TAG, (String)("onActivityResult: resultUri : " + result.getBitmap()));
                this.dismiss();
            }
        }
        if (resultCode == 204) {
            result = CropImage.getActivityResult((Intent)data);
            Exception error = result.getError();
            this.mImagePickerResult.onChooserError(error.getMessage());
            this.dismiss();
        }
    }

    public static interface ImagePickerResult {
        public void onChooserError(String var1);

        public void onChooserSuccess(Bitmap var1, Bitmap var2, boolean var3);
    }
}

