/*
 * Decompiled with CFR 0.152.
 */
package org.videolan.libvlc;

import android.os.Handler;
import android.os.Looper;
import java.lang.ref.WeakReference;
import org.videolan.libvlc.LibVLC;
import org.videolan.libvlc.VLCEvent;

abstract class VLCObject<T extends VLCEvent> {
    final LibVLC mLibVLC;
    private VLCEvent.Listener<T> mEventListener = null;
    private Handler mHandler = null;
    private int mNativeRefCount = 1;
    private long mInstance = 0L;

    protected VLCObject(LibVLC libvlc) {
        this.mLibVLC = libvlc;
    }

    protected VLCObject(VLCObject parent) {
        this.mLibVLC = parent.mLibVLC;
    }

    protected VLCObject() {
        this.mLibVLC = null;
    }

    private static void dispatchEventFromWeakNative(Object weak, int eventType, long arg1, long arg2, float argf1) {
        VLCObject obj = (VLCObject)((WeakReference)weak).get();
        if (obj != null) {
            obj.dispatchEventFromNative(eventType, arg1, arg2, argf1);
        }
    }

    public synchronized boolean isReleased() {
        return this.mNativeRefCount == 0;
    }

    public final synchronized boolean retain() {
        if (this.mNativeRefCount > 0) {
            ++this.mNativeRefCount;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void release() {
        int refCount = -1;
        VLCObject vLCObject = this;
        synchronized (vLCObject) {
            if (this.mNativeRefCount == 0) {
                return;
            }
            if (this.mNativeRefCount > 0) {
                refCount = --this.mNativeRefCount;
            }
            if (refCount == 0) {
                this.setEventListener(null);
            }
        }
        if (refCount == 0) {
            this.nativeDetachEvents();
            vLCObject = this;
            synchronized (vLCObject) {
                this.onReleaseNative();
            }
        }
    }

    protected synchronized void setEventListener(VLCEvent.Listener<T> listener) {
        this.setEventListener(listener, null);
    }

    protected synchronized void setEventListener(VLCEvent.Listener<T> listener, Handler handler) {
        if (this.mHandler != null) {
            this.mHandler.removeCallbacksAndMessages(null);
        }
        this.mEventListener = listener;
        if (this.mEventListener == null) {
            this.mHandler = null;
        } else if (this.mHandler == null) {
            this.mHandler = handler != null ? handler : new Handler(Looper.getMainLooper());
        }
    }

    protected abstract T onEventNative(int var1, long var2, long var4, float var6);

    protected abstract void onReleaseNative();

    private synchronized void dispatchEventFromNative(int eventType, long arg1, long arg2, float argf1) {
        if (this.isReleased()) {
            return;
        }
        T event = this.onEventNative(eventType, arg1, arg2, argf1);
        if (event != null && this.mEventListener != null && this.mHandler != null) {
            class EventRunnable
            implements Runnable {
                private final VLCEvent.Listener<T> listener;
                private final T event;

                EventRunnable(VLCEvent.Listener<T> listener, T event) {
                    this.listener = listener;
                    this.event = event;
                }

                @Override
                public void run() {
                    this.listener.onEvent(this.event);
                }
            }
            this.mHandler.post((Runnable)new EventRunnable(this.mEventListener, event));
        }
    }

    private native void nativeDetachEvents();

    private Object getWeakReference() {
        return new WeakReference<VLCObject>(this);
    }
}

