/*
 * Decompiled with CFR 0.152.
 */
package org.videolan.libvlc.util;

import android.net.Uri;
import android.support.annotation.MainThread;
import java.util.ArrayList;
import org.videolan.libvlc.LibVLC;
import org.videolan.libvlc.Media;
import org.videolan.libvlc.MediaPlayer;

public class Dumper {
    private final LibVLC mLibVLC;
    private final MediaPlayer mMediaPlayer;
    private final Listener mListener;

    @MainThread
    public Dumper(Uri uri, String filepath, Listener listener) {
        if (uri == null || filepath == null || listener == null) {
            throw new IllegalArgumentException("arguments shouldn't be null");
        }
        this.mListener = listener;
        ArrayList<String> options = new ArrayList<String>(8);
        options.add("--demux");
        options.add("dump2,none");
        options.add("--demuxdump-file");
        options.add(filepath);
        options.add("--no-video");
        options.add("--no-audio");
        options.add("--no-spu");
        options.add("-vvv");
        this.mLibVLC = new LibVLC(options);
        Media media = new Media(this.mLibVLC, uri);
        this.mMediaPlayer = new MediaPlayer(media);
        this.mMediaPlayer.setEventListener(new MediaPlayer.EventListener(){

            @Override
            public void onEvent(MediaPlayer.Event event) {
                switch (event.type) {
                    case 259: {
                        Dumper.this.mListener.onProgress(event.getBuffering());
                        break;
                    }
                    case 265: 
                    case 266: {
                        Dumper.this.mListener.onFinish(event.type == 265);
                        Dumper.this.cancel();
                    }
                }
            }
        });
        media.release();
    }

    @MainThread
    public void start() {
        this.mMediaPlayer.play();
    }

    @MainThread
    public void cancel() {
        this.mMediaPlayer.stop();
        this.mMediaPlayer.release();
        this.mLibVLC.release();
    }

    public static interface Listener {
        public void onFinish(boolean var1);

        public void onProgress(float var1);
    }
}

