/*
 * Decompiled with CFR 0.152.
 */
package org.videolan.libvlc;

import android.os.Handler;
import android.os.Looper;
import android.support.annotation.MainThread;
import org.videolan.libvlc.LibVLC;

public abstract class Dialog {
    public static final int TYPE_ERROR = 0;
    public static final int TYPE_LOGIN = 1;
    public static final int TYPE_QUESTION = 2;
    public static final int TYPE_PROGRESS = 3;
    protected final int mType;
    private final String mTitle;
    protected String mText;
    private Object mContext;
    private static Handler sHandler = null;
    private static Callbacks sCallbacks = null;

    protected Dialog(int type, String title, String text) {
        this.mType = type;
        this.mTitle = title;
        this.mText = text;
    }

    @MainThread
    public int getType() {
        return this.mType;
    }

    @MainThread
    public String getTitle() {
        return this.mTitle;
    }

    @MainThread
    public String getText() {
        return this.mText;
    }

    @MainThread
    public void setContext(Object context) {
        this.mContext = context;
    }

    @MainThread
    public Object getContext() {
        return this.mContext;
    }

    @MainThread
    public void dismiss() {
    }

    @MainThread
    public static void setCallbacks(LibVLC libVLC, Callbacks callbacks) {
        if (callbacks != null && sHandler == null) {
            sHandler = new Handler(Looper.getMainLooper());
        }
        sCallbacks = callbacks;
        Dialog.nativeSetCallbacks(libVLC, callbacks != null);
    }

    private static void displayErrorFromNative(String title, String text) {
        final ErrorMessage dialog = new ErrorMessage(title, text);
        sHandler.post(new Runnable(){

            @Override
            public void run() {
                if (sCallbacks != null) {
                    sCallbacks.onDisplay(dialog);
                }
            }
        });
    }

    private static Dialog displayLoginFromNative(long id, String title, String text, String defaultUsername, boolean askStore) {
        final LoginDialog dialog = new LoginDialog(id, title, text, defaultUsername, askStore);
        sHandler.post(new Runnable(){

            @Override
            public void run() {
                if (sCallbacks != null) {
                    sCallbacks.onDisplay(dialog);
                }
            }
        });
        return dialog;
    }

    private static Dialog displayQuestionFromNative(long id, String title, String text, int type, String cancelText, String action1Text, String action2Text) {
        final QuestionDialog dialog = new QuestionDialog(id, title, text, type, cancelText, action1Text, action2Text);
        sHandler.post(new Runnable(){

            @Override
            public void run() {
                if (sCallbacks != null) {
                    sCallbacks.onDisplay(dialog);
                }
            }
        });
        return dialog;
    }

    private static Dialog displayProgressFromNative(long id, String title, String text, boolean indeterminate, float position, String cancelText) {
        final ProgressDialog dialog = new ProgressDialog(id, title, text, indeterminate, position, cancelText);
        sHandler.post(new Runnable(){

            @Override
            public void run() {
                if (sCallbacks != null) {
                    sCallbacks.onDisplay(dialog);
                }
            }
        });
        return dialog;
    }

    private static void cancelFromNative(final Dialog dialog) {
        sHandler.post(new Runnable(){

            @Override
            public void run() {
                if (dialog instanceof IdDialog) {
                    ((IdDialog)dialog).dismiss();
                }
                if (sCallbacks != null) {
                    sCallbacks.onCanceled(dialog);
                }
            }
        });
    }

    private static void updateProgressFromNative(final Dialog dialog, final float position, final String text) {
        sHandler.post(new Runnable(){

            @Override
            public void run() {
                if (dialog.getType() != 3) {
                    throw new IllegalArgumentException("dialog is not a progress dialog");
                }
                ProgressDialog progressDialog = (ProgressDialog)dialog;
                progressDialog.update(position, text);
                if (sCallbacks != null) {
                    sCallbacks.onProgressUpdate(progressDialog);
                }
            }
        });
    }

    private static native void nativeSetCallbacks(LibVLC var0, boolean var1);

    public static class ProgressDialog
    extends IdDialog {
        private final boolean mIndeterminate;
        private float mPosition;
        private final String mCancelText;

        private ProgressDialog(long id, String title, String text, boolean indeterminate, float position, String cancelText) {
            super(id, 3, title, text);
            this.mIndeterminate = indeterminate;
            this.mPosition = position;
            this.mCancelText = cancelText;
        }

        @MainThread
        public boolean isIndeterminate() {
            return this.mIndeterminate;
        }

        @MainThread
        public boolean isCancelable() {
            return this.mCancelText != null;
        }

        @MainThread
        public float getPosition() {
            return this.mPosition;
        }

        @MainThread
        public String getCancelText() {
            return this.mCancelText;
        }

        private void update(float position, String text) {
            this.mPosition = position;
            this.mText = text;
        }
    }

    public static class QuestionDialog
    extends IdDialog {
        public static final int TYPE_NORMAL = 0;
        public static final int TYPE_WARNING = 1;
        public static final int TYPE_ERROR = 2;
        private final int mQuestionType;
        private final String mCancelText;
        private final String mAction1Text;
        private final String mAction2Text;

        private QuestionDialog(long id, String title, String text, int type, String cancelText, String action1Text, String action2Text) {
            super(id, 2, title, text);
            this.mQuestionType = type;
            this.mCancelText = cancelText;
            this.mAction1Text = action1Text;
            this.mAction2Text = action2Text;
        }

        @MainThread
        public int getQuestionType() {
            return this.mQuestionType;
        }

        @MainThread
        public String getCancelText() {
            return this.mCancelText;
        }

        @MainThread
        public String getAction1Text() {
            return this.mAction1Text;
        }

        @MainThread
        public String getAction2Text() {
            return this.mAction2Text;
        }

        @MainThread
        public void postAction(int action) {
            if (this.mId != 0L) {
                this.nativePostAction(this.mId, action);
                this.mId = 0L;
            }
        }

        private native void nativePostAction(long var1, int var3);
    }

    public static class LoginDialog
    extends IdDialog {
        private final String mDefaultUsername;
        private final boolean mAskStore;

        private LoginDialog(long id, String title, String text, String defaultUsername, boolean askStore) {
            super(id, 1, title, text);
            this.mDefaultUsername = defaultUsername;
            this.mAskStore = askStore;
        }

        @MainThread
        public String getDefaultUsername() {
            return this.mDefaultUsername;
        }

        @MainThread
        public boolean asksStore() {
            return this.mAskStore;
        }

        @MainThread
        public void postLogin(String username, String password, boolean store) {
            if (this.mId != 0L) {
                this.nativePostLogin(this.mId, username, password, store);
                this.mId = 0L;
            }
        }

        private native void nativePostLogin(long var1, String var3, String var4, boolean var5);
    }

    protected static abstract class IdDialog
    extends Dialog {
        protected long mId;

        protected IdDialog(long id, int type, String title, String text) {
            super(type, title, text);
            this.mId = id;
        }

        @Override
        @MainThread
        public void dismiss() {
            if (this.mId != 0L) {
                this.nativeDismiss(this.mId);
                this.mId = 0L;
            }
        }

        private native void nativeDismiss(long var1);
    }

    public static class ErrorMessage
    extends Dialog {
        private ErrorMessage(String title, String text) {
            super(0, title, text);
        }
    }

    public static interface Callbacks {
        @MainThread
        public void onDisplay(ErrorMessage var1);

        @MainThread
        public void onDisplay(LoginDialog var1);

        @MainThread
        public void onDisplay(QuestionDialog var1);

        @MainThread
        public void onDisplay(ProgressDialog var1);

        @MainThread
        public void onCanceled(Dialog var1);

        @MainThread
        public void onProgressUpdate(ProgressDialog var1);
    }
}

