/*
 * Decompiled with CFR 0.152.
 */
package com.stefanosiano.powerfulimageview.shape.drawers;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import com.stefanosiano.powerfulimageview.shape.PivShapeScaleType;
import com.stefanosiano.powerfulimageview.shape.ShapeOptions;
import com.stefanosiano.powerfulimageview.shape.drawers.ShapeDrawer;

final class SolidOvalShapeDrawer
implements ShapeDrawer {
    private final Paint mBackPaint;
    private final Paint mFrontPaint;
    private final Paint mBorderPaint;
    private final RectF mSolidRect;
    private Matrix mMatrix;
    private Drawable mDrawable;
    private Drawable mBackgroundDrawable;
    private Drawable mForegroundDrawable;
    private PivShapeScaleType mScaleType;
    private final Paint mSolidPaint;

    SolidOvalShapeDrawer(Drawable drawable) {
        this.mDrawable = drawable;
        this.mBackPaint = new Paint();
        this.mFrontPaint = new Paint();
        this.mBorderPaint = new Paint();
        this.mSolidRect = new RectF();
        this.mMatrix = new Matrix();
        this.mSolidPaint = new Paint();
    }

    @Override
    public boolean requireBitmap() {
        return false;
    }

    @Override
    public void changeBitmap(Bitmap bitmap) {
    }

    @Override
    public void changeDrawable(Drawable drawable) {
        this.mDrawable = drawable;
    }

    @Override
    public void setMatrix(PivShapeScaleType scaleType, Matrix matrix) {
        this.mScaleType = scaleType;
        this.mMatrix = matrix;
    }

    @Override
    public void setup(ShapeOptions shapeOptions) {
        this.mBackPaint.setColor(shapeOptions.getBackgroundColor());
        this.mBackPaint.setAntiAlias(true);
        this.mBackPaint.setStyle(Paint.Style.FILL_AND_STROKE);
        this.mFrontPaint.setColor(shapeOptions.getForegroundColor());
        this.mFrontPaint.setAntiAlias(true);
        this.mFrontPaint.setStyle(Paint.Style.FILL_AND_STROKE);
        this.mForegroundDrawable = shapeOptions.getForegroundDrawable();
        this.mBackgroundDrawable = shapeOptions.getBackgroundDrawable();
        this.mBorderPaint.setColor(shapeOptions.getBorderColor());
        this.mBorderPaint.setAntiAlias(true);
        this.mBorderPaint.setStyle(Paint.Style.STROKE);
        this.mBorderPaint.setStrokeWidth((float)shapeOptions.getBorderWidth());
        this.mSolidPaint.setColor(shapeOptions.getSolidColor());
        this.mSolidPaint.setAntiAlias(true);
        this.mSolidPaint.setStyle(Paint.Style.STROKE);
        float width = (shapeOptions.getViewBounds().width() + shapeOptions.getViewBounds().height() - shapeOptions.getBorderBounds().width()) / 2.0f;
        this.mSolidPaint.setStrokeWidth(width);
        this.mSolidRect.set(shapeOptions.getBorderBounds());
        this.mSolidRect.inset(-width / 2.0f - (float)(shapeOptions.getBorderWidth() / 2), -width / 2.0f - (float)(shapeOptions.getBorderWidth() / 2));
    }

    @Override
    public void draw(Canvas canvas, RectF borderBounds, RectF shapeBounds, RectF imageBounds) {
        if (this.mBackPaint.getColor() != 0) {
            canvas.drawOval(shapeBounds, this.mBackPaint);
        }
        if (this.mDrawable != null) {
            if (this.mScaleType != null && this.mScaleType == PivShapeScaleType.FIT_XY) {
                this.mDrawable.setBounds((int)imageBounds.left, (int)imageBounds.top, (int)imageBounds.right, (int)imageBounds.bottom);
                if (this.mBackgroundDrawable != null) {
                    this.mBackgroundDrawable.setBounds(this.mDrawable.getBounds());
                    this.mBackgroundDrawable.draw(canvas);
                }
                this.mDrawable.draw(canvas);
                if (this.mForegroundDrawable != null) {
                    this.mForegroundDrawable.setBounds(this.mDrawable.getBounds());
                    this.mForegroundDrawable.draw(canvas);
                }
            } else {
                int saveCount = canvas.getSaveCount();
                canvas.save();
                if (this.mScaleType != PivShapeScaleType.FIT_XY) {
                    canvas.concat(this.mMatrix);
                }
                if (this.mBackgroundDrawable != null) {
                    this.mBackgroundDrawable.setBounds(this.mDrawable.getBounds());
                    this.mBackgroundDrawable.draw(canvas);
                }
                this.mDrawable.draw(canvas);
                if (this.mForegroundDrawable != null) {
                    this.mForegroundDrawable.setBounds(this.mDrawable.getBounds());
                    this.mForegroundDrawable.draw(canvas);
                }
                canvas.restoreToCount(saveCount);
            }
        }
        if (this.mFrontPaint.getColor() != 0) {
            canvas.drawOval(shapeBounds, this.mFrontPaint);
        }
        if (this.mBorderPaint.getStrokeWidth() > 0.0f && this.mBorderPaint.getColor() != 0) {
            canvas.drawOval(borderBounds, this.mBorderPaint);
        }
        canvas.drawOval(this.mSolidRect, this.mSolidPaint);
    }
}

