/*
 * Decompiled with CFR 0.152.
 */
package com.stefanosiano.powerfulimageview.shape.drawers;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Parcelable;
import android.view.View;
import com.stefanosiano.powerfulimageview.shape.PivShapeMode;
import com.stefanosiano.powerfulimageview.shape.PivShapeScaleType;
import com.stefanosiano.powerfulimageview.shape.ShapeOptions;
import com.stefanosiano.powerfulimageview.shape.drawers.CircleShapeDrawer;
import com.stefanosiano.powerfulimageview.shape.drawers.NormalShapeDrawer;
import com.stefanosiano.powerfulimageview.shape.drawers.OvalShapeDrawer;
import com.stefanosiano.powerfulimageview.shape.drawers.RoundedRectangleShapeDrawer;
import com.stefanosiano.powerfulimageview.shape.drawers.ShapeDrawer;
import com.stefanosiano.powerfulimageview.shape.drawers.SolidCircleShapeDrawer;
import com.stefanosiano.powerfulimageview.shape.drawers.SolidOvalShapeDrawer;
import com.stefanosiano.powerfulimageview.shape.drawers.SolidRoundedRectangleShapeDrawer;
import java.lang.ref.WeakReference;

public class ShapeDrawerManager
implements ShapeOptions.ShapeOptionsListener {
    private final WeakReference<View> mView;
    private final RectF mShapeBounds;
    private final RectF mBorderBounds;
    private final RectF mImageBounds;
    private final Matrix mShaderMatrix;
    private Matrix mImageMatrix;
    private PivShapeScaleType mScaleType;
    private Drawable mDrawable;
    private Bitmap mLastBitmap;
    private float mMeasuredWidth;
    private float mMeasuredHeight;
    private CircleShapeDrawer mCircleShapeDrawer;
    private NormalShapeDrawer mNormalShapeDrawer;
    private OvalShapeDrawer mOvalShapeDrawer;
    private SolidCircleShapeDrawer mSolidCircleShapeDrawer;
    private RoundedRectangleShapeDrawer mRoundedRectangleShapeDrawer;
    private SolidOvalShapeDrawer mSolidOvalShapeDrawer;
    private SolidRoundedRectangleShapeDrawer mSolidRoundedRectangleShapeDrawer;
    private ShapeDrawer mShapeDrawer;
    private PivShapeMode mShapeMode = null;
    private ShapeOptions mShapeOptions;

    public ShapeDrawerManager(View view, ShapeOptions shapeOptions) {
        this.mView = new WeakReference<View>(view);
        this.mShapeBounds = new RectF();
        this.mBorderBounds = new RectF();
        this.mImageBounds = new RectF();
        this.mShapeOptions = shapeOptions;
        this.mShapeOptions.setListener(this);
        this.mShaderMatrix = new Matrix();
        this.mShaderMatrix.reset();
        this.mShapeDrawer = new NormalShapeDrawer(null);
    }

    public void changeDrawable(Drawable drawable) {
        Drawable mLastDrawable = this.mDrawable;
        this.mDrawable = drawable;
        this.mShapeDrawer.changeDrawable(drawable);
        if (this.mShapeDrawer.requireBitmap()) {
            this.mLastBitmap = this.getBitmapFromDrawable(mLastDrawable, drawable);
            this.mShapeDrawer.changeBitmap(this.mLastBitmap);
        } else {
            this.mLastBitmap = null;
        }
        this.setScaleType(this.mScaleType);
    }

    private Bitmap getBitmapFromDrawable(Drawable mLastDrawable, Drawable drawable) {
        if (drawable == null || this.mMeasuredWidth <= 0.0f || this.mMeasuredHeight <= 0.0f) {
            return null;
        }
        if (drawable instanceof BitmapDrawable) {
            return ((BitmapDrawable)drawable).getBitmap();
        }
        try {
            Bitmap bitmap;
            if (drawable.getIntrinsicWidth() <= 0 || drawable.getIntrinsicHeight() <= 0) {
                bitmap = Bitmap.createBitmap((int)1, (int)1, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            } else if (drawable instanceof ColorDrawable) {
                bitmap = Bitmap.createBitmap((int)1, (int)1, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            } else {
                int sizeY;
                int sizeX;
                float ratio = (float)drawable.getIntrinsicWidth() / (float)drawable.getIntrinsicHeight();
                int maxWidth = (int)Math.max(this.mImageBounds.width(), this.mImageBounds.height() * ratio);
                int maxHeight = (int)Math.max(this.mImageBounds.height(), this.mImageBounds.width() / ratio);
                if (drawable.getIntrinsicWidth() > maxWidth && maxWidth > 0 && drawable.getIntrinsicHeight() > maxHeight && maxHeight > 0) {
                    sizeX = maxWidth;
                    sizeY = maxHeight;
                } else {
                    sizeX = drawable.getIntrinsicWidth();
                    sizeY = drawable.getIntrinsicHeight();
                }
                if (drawable.getClass().getName().equals("android.graphics.drawable.VectorDrawable")) {
                    sizeX = maxWidth;
                    sizeY = maxHeight;
                }
                if (sizeX > 0 && sizeY > 0 && this.mLastBitmap != null && mLastDrawable == this.mDrawable) {
                    return this.mLastBitmap;
                }
                if (this.mLastBitmap != null) {
                    this.mLastBitmap.recycle();
                }
                bitmap = Bitmap.createBitmap((int)sizeX, (int)sizeY, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            }
            Canvas canvas = new Canvas(bitmap);
            drawable.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
            drawable.draw(canvas);
            return bitmap;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private void updateDrawers(PivShapeMode shapeMode) {
        if (shapeMode == null) {
            shapeMode = PivShapeMode.NORMAL;
        }
        switch (shapeMode) {
            case CIRCLE: {
                if (this.mCircleShapeDrawer == null) {
                    this.mCircleShapeDrawer = new CircleShapeDrawer(this.getBitmapFromDrawable(this.mDrawable, this.mDrawable));
                }
                this.mShapeDrawer = this.mCircleShapeDrawer;
                break;
            }
            case SQUARE: {
                if (this.mNormalShapeDrawer == null) {
                    this.mNormalShapeDrawer = new NormalShapeDrawer(this.mDrawable);
                }
                this.mShapeDrawer = this.mNormalShapeDrawer;
                break;
            }
            case RECTANGLE: {
                if (this.mNormalShapeDrawer == null) {
                    this.mNormalShapeDrawer = new NormalShapeDrawer(this.mDrawable);
                }
                this.mShapeDrawer = this.mNormalShapeDrawer;
                break;
            }
            case OVAL: {
                if (this.mOvalShapeDrawer == null) {
                    this.mOvalShapeDrawer = new OvalShapeDrawer(this.getBitmapFromDrawable(this.mDrawable, this.mDrawable));
                }
                this.mShapeDrawer = this.mOvalShapeDrawer;
                break;
            }
            case ROUNDED_RECTANGLE: {
                if (this.mRoundedRectangleShapeDrawer == null) {
                    this.mRoundedRectangleShapeDrawer = new RoundedRectangleShapeDrawer(this.getBitmapFromDrawable(this.mDrawable, this.mDrawable));
                }
                this.mShapeDrawer = this.mRoundedRectangleShapeDrawer;
                break;
            }
            case SOLID_CIRCLE: {
                if (this.mSolidCircleShapeDrawer == null) {
                    this.mSolidCircleShapeDrawer = new SolidCircleShapeDrawer(this.mDrawable);
                }
                this.mShapeDrawer = this.mSolidCircleShapeDrawer;
                break;
            }
            case SOLID_OVAL: {
                if (this.mSolidOvalShapeDrawer == null) {
                    this.mSolidOvalShapeDrawer = new SolidOvalShapeDrawer(this.mDrawable);
                }
                this.mShapeDrawer = this.mSolidOvalShapeDrawer;
                break;
            }
            case SOLID_ROUNDED_RECTANGLE: {
                if (this.mSolidRoundedRectangleShapeDrawer == null) {
                    this.mSolidRoundedRectangleShapeDrawer = new SolidRoundedRectangleShapeDrawer(this.mDrawable);
                }
                this.mShapeDrawer = this.mSolidRoundedRectangleShapeDrawer;
                break;
            }
            default: {
                if (this.mNormalShapeDrawer == null) {
                    this.mNormalShapeDrawer = new NormalShapeDrawer(this.mDrawable);
                }
                this.mShapeDrawer = this.mNormalShapeDrawer;
            }
        }
    }

    public final void onSizeChanged(int w, int h, int paddingLeft, int paddingTop, int paddingRight, int paddingBottom) {
        this.mShapeOptions.calculateBounds(w, h, paddingLeft, paddingTop, paddingRight, paddingBottom, this.mShapeMode);
        this.onSizeUpdated(this.mShapeOptions);
    }

    public void onMeasure(float w, float h, int wMode, int hMode, View view) {
        float usedRatio;
        float drawableWidth = this.mDrawable == null ? 0.0f : (float)(this.mDrawable.getIntrinsicWidth() + view.getPaddingLeft() + view.getPaddingRight());
        float drawableHeight = this.mDrawable == null ? 0.0f : (float)(this.mDrawable.getIntrinsicHeight() + view.getPaddingTop() + view.getPaddingBottom());
        switch (this.mShapeMode) {
            case CIRCLE: 
            case SQUARE: 
            case SOLID_CIRCLE: {
                usedRatio = 1.0f;
                break;
            }
            default: {
                usedRatio = this.mShapeOptions.getRatio() <= 0.0f ? w / h : this.mShapeOptions.getRatio();
            }
        }
        switch (wMode) {
            case 0x40000000: {
                this.mMeasuredWidth = w;
                this.mMeasuredHeight = w / usedRatio;
                if (hMode == 0x40000000) {
                    this.mMeasuredHeight = h;
                }
                if (hMode == Integer.MIN_VALUE) {
                    this.mMeasuredHeight = Math.min(w / usedRatio, h);
                }
                if (hMode != 0) break;
                this.mMeasuredHeight = w / usedRatio;
                break;
            }
            case -2147483648: {
                this.mMeasuredWidth = w;
                this.mMeasuredHeight = w / usedRatio;
                if (hMode == 0x40000000) {
                    this.mMeasuredWidth = Math.min(h * usedRatio, w);
                    this.mMeasuredHeight = h;
                }
                if (hMode == Integer.MIN_VALUE) {
                    w = drawableWidth > 0.0f ? Math.min(drawableWidth, w) : w;
                    h = drawableHeight > 0.0f ? Math.min(drawableHeight, h) : h;
                    this.mMeasuredWidth = Math.min(h * usedRatio, w);
                    this.mMeasuredHeight = Math.min(h, w / usedRatio);
                }
                if (hMode != 0) break;
                this.mMeasuredWidth = w = drawableWidth > 0.0f ? Math.min(drawableWidth, w) : w;
                this.mMeasuredHeight = w / usedRatio;
                break;
            }
            default: {
                this.mMeasuredWidth = w = drawableWidth > 0.0f ? drawableWidth : w;
                this.mMeasuredHeight = w / usedRatio;
                if (hMode == 0x40000000) {
                    this.mMeasuredWidth = h * usedRatio;
                    this.mMeasuredHeight = h;
                }
                if (hMode == Integer.MIN_VALUE) {
                    h = drawableHeight > 0.0f ? Math.min(drawableHeight, h) : h;
                    this.mMeasuredWidth = h * usedRatio;
                    this.mMeasuredHeight = h;
                }
                if (hMode != 0) break;
                this.mMeasuredWidth = w = drawableWidth > 0.0f ? drawableWidth : w;
                this.mMeasuredHeight = w / usedRatio;
            }
        }
    }

    public void setImageMatrix(Matrix matrix) {
        this.mImageMatrix = matrix;
        this.setScaleType(PivShapeScaleType.MATRIX);
    }

    public void setScaleType(PivShapeScaleType scaleType) {
        this.mScaleType = scaleType;
        if (this.mImageBounds == null || this.mDrawable == null || scaleType == null) {
            return;
        }
        this.mShaderMatrix.reset();
        float scaleX = 1.0f;
        float scaleY = 1.0f;
        int dWidth = this.mDrawable.getIntrinsicWidth();
        int dHeight = this.mDrawable.getIntrinsicHeight();
        if (this.mLastBitmap != null) {
            scaleX = (float)dWidth / (float)this.mLastBitmap.getWidth();
            scaleY = (float)dHeight / (float)this.mLastBitmap.getHeight();
        }
        float vWidth = this.mImageBounds.width();
        float vHeight = this.mImageBounds.height();
        Rect padding = new Rect(0, 0, 0, 0);
        if (this.mView.get() != null) {
            padding.set(((View)this.mView.get()).getPaddingLeft(), ((View)this.mView.get()).getPaddingBottom(), ((View)this.mView.get()).getPaddingRight(), ((View)this.mView.get()).getPaddingTop());
        }
        switch (scaleType) {
            case CENTER_CROP: {
                float dy;
                float dx;
                float scale;
                if ((float)dWidth * vHeight > vWidth * (float)dHeight) {
                    scale = vHeight / (float)dHeight;
                    dx = (vWidth - (float)dWidth * scale) * 0.5f;
                    dy = 0.0f;
                } else {
                    scale = vWidth / (float)dWidth;
                    dy = (vHeight - (float)dHeight * scale) * 0.5f;
                    dx = 0.0f;
                }
                this.mShaderMatrix.setScale(scale * scaleX, scale * scaleY);
                this.mShaderMatrix.postTranslate(dx + this.mImageBounds.left, dy + this.mImageBounds.top);
                break;
            }
            case TOP_CROP: {
                float dy;
                float dx;
                float scale;
                if ((float)dWidth * vHeight > vWidth * (float)dHeight) {
                    scale = vHeight / (float)dHeight;
                    dx = (vWidth - (float)dWidth * scale) * 0.5f;
                    dy = 0.0f;
                } else {
                    scale = vWidth / (float)dWidth;
                    dy = 0.0f;
                    dx = 0.0f;
                }
                this.mShaderMatrix.setScale(scale * scaleX, scale * scaleY);
                this.mShaderMatrix.postTranslate(dx + this.mImageBounds.left, dy + this.mImageBounds.top);
                break;
            }
            case BOTTOM_CROP: {
                float dy;
                float dx;
                float scale;
                if ((float)dWidth * vHeight > vWidth * (float)dHeight) {
                    scale = vHeight / (float)dHeight;
                    dx = (vWidth - (float)dWidth * scale) * 0.5f;
                    dy = 0.0f;
                } else {
                    scale = vWidth / (float)dWidth;
                    dy = vHeight - (float)dHeight * scale;
                    dx = 0.0f;
                }
                this.mShaderMatrix.setScale(scale * scaleX, scale * scaleY);
                this.mShaderMatrix.postTranslate(dx + this.mImageBounds.left, dy + this.mImageBounds.top);
                break;
            }
            case CENTER_INSIDE: {
                float scale = (float)dWidth <= vWidth && (float)dHeight <= vHeight ? 1.0f : Math.min(vWidth / (float)dWidth, vHeight / (float)dHeight);
                float dx = (vWidth - (float)dWidth * scale) * 0.5f;
                float dy = (vHeight - (float)dHeight * scale) * 0.5f;
                this.mShaderMatrix.setScale(scale * scaleX, scale * scaleY);
                this.mShaderMatrix.postTranslate(dx + this.mImageBounds.left, dy + this.mImageBounds.top);
                break;
            }
            case FIT_CENTER: {
                if (this.mLastBitmap != null) {
                    this.mShaderMatrix.setRectToRect(new RectF(0.0f, 0.0f, (float)this.mLastBitmap.getWidth(), (float)this.mLastBitmap.getHeight()), this.mImageBounds, Matrix.ScaleToFit.CENTER);
                    break;
                }
                this.mShaderMatrix.setRectToRect(new RectF(0.0f, 0.0f, (float)dWidth, (float)dHeight), this.mImageBounds, Matrix.ScaleToFit.CENTER);
                break;
            }
            case FIT_END: {
                if (this.mLastBitmap != null) {
                    this.mShaderMatrix.setRectToRect(new RectF(0.0f, 0.0f, (float)this.mLastBitmap.getWidth(), (float)this.mLastBitmap.getHeight()), this.mImageBounds, Matrix.ScaleToFit.END);
                    break;
                }
                this.mShaderMatrix.setRectToRect(new RectF(0.0f, 0.0f, (float)dWidth, (float)dHeight), this.mImageBounds, Matrix.ScaleToFit.END);
                break;
            }
            case FIT_START: {
                if (this.mLastBitmap != null) {
                    this.mShaderMatrix.setRectToRect(new RectF(0.0f, 0.0f, (float)this.mLastBitmap.getWidth(), (float)this.mLastBitmap.getHeight()), this.mImageBounds, Matrix.ScaleToFit.START);
                    break;
                }
                this.mShaderMatrix.setRectToRect(new RectF(0.0f, 0.0f, (float)dWidth, (float)dHeight), this.mImageBounds, Matrix.ScaleToFit.START);
                break;
            }
            case FIT_XY: {
                if (this.mLastBitmap != null) {
                    this.mShaderMatrix.setRectToRect(new RectF(0.0f, 0.0f, (float)this.mLastBitmap.getWidth(), (float)this.mLastBitmap.getHeight()), this.mImageBounds, Matrix.ScaleToFit.FILL);
                    break;
                }
                this.mShaderMatrix.setRectToRect(new RectF(0.0f, 0.0f, (float)dWidth, (float)dHeight), this.mImageBounds, Matrix.ScaleToFit.FILL);
                break;
            }
            case MATRIX: {
                this.mShaderMatrix.preScale(scaleX, scaleY);
                if (this.mImageMatrix != null) {
                    this.mShaderMatrix.set(this.mImageMatrix);
                }
                this.mShaderMatrix.postTranslate(this.mImageBounds.left, this.mImageBounds.top);
                break;
            }
            default: {
                this.mShaderMatrix.setScale(scaleX, scaleY);
                this.mShaderMatrix.postTranslate((vWidth - (float)dWidth) * 0.5f + this.mImageBounds.left, (vHeight - (float)dHeight) * 0.5f + this.mImageBounds.top);
            }
        }
        this.mShapeDrawer.setMatrix(scaleType, this.mShaderMatrix);
    }

    public final void changeShapeMode(PivShapeMode shapeMode) {
        if (this.mShapeMode != null && this.mShapeMode == shapeMode) {
            return;
        }
        this.mShapeMode = shapeMode;
        this.updateDrawers(this.mShapeMode);
        this.mShapeDrawer.setup(this.mShapeOptions);
        if (this.mView.get() != null) {
            ((View)this.mView.get()).postInvalidate();
        }
    }

    public final void onDraw(Canvas canvas) {
        this.mShapeDrawer.draw(canvas, this.mBorderBounds, this.mShapeBounds, this.mImageBounds);
    }

    public final ShapeOptions getShapeOptions() {
        return this.mShapeOptions;
    }

    @Override
    public void onRequestMeasure(ShapeOptions options) {
        this.mShapeOptions = options;
        if (this.mView.get() != null) {
            ((View)this.mView.get()).requestLayout();
        }
        this.mShapeDrawer.setup(options);
    }

    @Override
    public void onOptionsUpdated(ShapeOptions options) {
        this.mShapeOptions = options;
        this.mShapeDrawer.setup(options);
        if (this.mView.get() != null) {
            ((View)this.mView.get()).postInvalidate();
        }
    }

    @Override
    public void onSizeUpdated(ShapeOptions options) {
        this.mShapeOptions = options;
        this.mShapeBounds.set(this.mShapeOptions.getShapeBounds());
        this.mBorderBounds.set(this.mShapeOptions.getBorderBounds());
        this.mImageBounds.set(this.mShapeOptions.getImageBounds());
        this.changeDrawable(this.mDrawable);
        this.mShapeDrawer.setup(this.mShapeOptions);
        if (this.mView.get() != null) {
            ((View)this.mView.get()).postInvalidate();
        }
    }

    public int getMeasuredHeight() {
        return (int)this.mMeasuredHeight;
    }

    public int getMeasuredWidth() {
        return (int)this.mMeasuredWidth;
    }

    public PivShapeMode getShapeMode() {
        return this.mShapeMode;
    }

    public Bundle saveInstanceState() {
        Bundle bundle = new Bundle();
        bundle.putParcelable("shape_options", (Parcelable)this.mShapeOptions);
        bundle.putInt("shape_mode", this.mShapeMode.getValue());
        return bundle;
    }

    public void restoreInstanceState(Bundle state) {
        if (state == null) {
            return;
        }
        this.mShapeOptions.setOptions((ShapeOptions)state.getParcelable("shape_options"));
        PivShapeMode shapeMode = PivShapeMode.fromValue(state.getInt("shape_mode"));
        this.onSizeUpdated(this.mShapeOptions);
        this.changeShapeMode(shapeMode);
    }
}

