/*
 * Decompiled with CFR 0.152.
 */
package com.stefanosiano.powerfulimageview.shape.drawers;

import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.drawable.Drawable;
import com.stefanosiano.powerfulimageview.shape.PivShapeScaleType;
import com.stefanosiano.powerfulimageview.shape.ShapeOptions;
import com.stefanosiano.powerfulimageview.shape.drawers.ShapeDrawer;

final class OvalShapeDrawer
implements ShapeDrawer {
    private BitmapShader mBitmapShader;
    private final Paint mBitmapPaint;
    private final Paint mBackPaint;
    private final Paint mBorderPaint;
    private final Paint mFrontPaint;
    private Drawable mBackgroundDrawable;
    private Drawable mForegroundDrawable;
    private Matrix mMatrix;

    OvalShapeDrawer(Bitmap bitmap) {
        if (bitmap != null) {
            this.mBitmapShader = new BitmapShader(bitmap, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP);
            this.mBitmapShader.setLocalMatrix(this.mMatrix);
        }
        this.mBitmapPaint = new Paint();
        this.mBackPaint = new Paint();
        this.mBorderPaint = new Paint();
        this.mFrontPaint = new Paint();
    }

    @Override
    public void changeDrawable(Drawable drawable) {
    }

    @Override
    public boolean requireBitmap() {
        return true;
    }

    @Override
    public void changeBitmap(Bitmap bitmap) {
        this.mBitmapShader = null;
        if (bitmap != null) {
            this.mBitmapShader = new BitmapShader(bitmap, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP);
            this.mBitmapShader.setLocalMatrix(this.mMatrix);
        }
        this.mBitmapPaint.setShader((Shader)this.mBitmapShader);
        this.mBitmapPaint.setAntiAlias(true);
        this.mBitmapPaint.setStyle(Paint.Style.FILL);
    }

    @Override
    public void setMatrix(PivShapeScaleType scaleType, Matrix matrix) {
        this.mMatrix = matrix;
        if (this.mBitmapShader != null) {
            this.mBitmapShader.setLocalMatrix(matrix);
        }
    }

    @Override
    public void setup(ShapeOptions shapeOptions) {
        this.mForegroundDrawable = shapeOptions.getForegroundDrawable();
        this.mBackgroundDrawable = shapeOptions.getBackgroundDrawable();
        this.mBackPaint.setColor(shapeOptions.getBackgroundColor());
        this.mBackPaint.setAntiAlias(true);
        this.mBackPaint.setStyle(Paint.Style.FILL);
        this.mBorderPaint.setColor(shapeOptions.getBorderColor());
        this.mBorderPaint.setAntiAlias(true);
        this.mBorderPaint.setStyle(Paint.Style.STROKE);
        this.mBorderPaint.setStrokeWidth((float)shapeOptions.getBorderWidth());
        this.mFrontPaint.setColor(shapeOptions.getForegroundColor());
        this.mFrontPaint.setAntiAlias(true);
        this.mFrontPaint.setStyle(Paint.Style.FILL);
    }

    @Override
    public void draw(Canvas canvas, RectF borderBounds, RectF shapeBounds, RectF imageBounds) {
        if (this.mBackPaint.getColor() != 0) {
            canvas.drawOval(shapeBounds, this.mBackPaint);
        }
        if (this.mBackgroundDrawable != null) {
            this.mBackgroundDrawable.setBounds((int)imageBounds.left, (int)imageBounds.top, (int)imageBounds.right, (int)imageBounds.bottom);
            this.mBackgroundDrawable.draw(canvas);
        }
        canvas.drawOval(imageBounds, this.mBitmapPaint);
        if (this.mForegroundDrawable != null) {
            this.mForegroundDrawable.setBounds((int)imageBounds.left, (int)imageBounds.top, (int)imageBounds.right, (int)imageBounds.bottom);
            this.mForegroundDrawable.draw(canvas);
        }
        if (this.mFrontPaint.getColor() != 0) {
            canvas.drawOval(shapeBounds, this.mFrontPaint);
        }
        if (this.mBorderPaint.getStrokeWidth() > 0.0f && this.mBorderPaint.getColor() != 0) {
            canvas.drawOval(borderBounds, this.mBorderPaint);
        }
    }
}

