/*
 * Decompiled with CFR 0.152.
 */
package com.stefanosiano.powerfulimageview.shape;

import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.os.Parcel;
import android.os.Parcelable;
import com.stefanosiano.powerfulimageview.shape.PivShapeMode;
import java.lang.ref.WeakReference;

public final class ShapeOptions
implements Parcelable {
    private int mBackgroundColor;
    private int mForegroundColor;
    private int mInnerPadding;
    private float mInnerPaddingPercent;
    private boolean mBorderOverlay;
    private int mBorderColor;
    private int mBorderWidth;
    private float mRatio;
    private float mRadiusX;
    private float mRadiusY;
    private int mSolidColor;
    private Drawable mForegroundDrawable;
    private Drawable mBackgroundDrawable;
    private final RectF mShapeBounds;
    private final RectF mImageBounds;
    private final RectF mBorderBounds;
    private final RectF mViewBounds;
    private float mCalculatedInnerPadding;
    private int mCalculatedLastPaddingLeft;
    private int mCalculatedLastPaddingTop;
    private int mCalculatedLastPaddingRight;
    private int mCalculatedLastPaddingBottom;
    private int mCalculatedLastW;
    private int mCalculatedLastH;
    private PivShapeMode mCalculatedLastMode;
    private WeakReference<ShapeOptionsListener> listener;
    public static final Parcelable.Creator<ShapeOptions> CREATOR = new Parcelable.Creator<ShapeOptions>(){

        public ShapeOptions createFromParcel(Parcel in) {
            return new ShapeOptions(in);
        }

        public ShapeOptions[] newArray(int size) {
            return new ShapeOptions[size];
        }
    };

    public ShapeOptions(int backgroundColor, int foregroundColor, int innerPadding, float innerPaddingPercent, boolean borderOverlay, int borderColor, int borderWidth, float ratio, float radiusX, float radiusY, int solidColor, Drawable backgroundDrawable, Drawable foregroundDrawable) {
        this.mBackgroundColor = backgroundColor;
        this.mForegroundColor = foregroundColor;
        this.mInnerPadding = innerPadding;
        this.mInnerPaddingPercent = innerPaddingPercent;
        this.mBorderOverlay = borderOverlay;
        this.mBorderColor = borderColor;
        this.mBorderWidth = borderWidth;
        this.mRatio = ratio;
        this.mRadiusX = radiusX;
        this.mRadiusY = radiusY;
        this.mSolidColor = solidColor;
        this.mBackgroundDrawable = backgroundDrawable;
        this.mForegroundDrawable = foregroundDrawable;
        this.mShapeBounds = new RectF(0.0f, 0.0f, 0.0f, 0.0f);
        this.mBorderBounds = new RectF(0.0f, 0.0f, 0.0f, 0.0f);
        this.mViewBounds = new RectF(0.0f, 0.0f, 0.0f, 0.0f);
        this.mImageBounds = new RectF(0.0f, 0.0f, 0.0f, 0.0f);
        this.mCalculatedInnerPadding = 0.0f;
        this.mCalculatedLastW = 0;
        this.mCalculatedLastH = 0;
        this.mCalculatedLastPaddingLeft = 0;
        this.mCalculatedLastPaddingTop = 0;
        this.mCalculatedLastPaddingRight = 0;
        this.mCalculatedLastPaddingBottom = 0;
        this.mCalculatedLastMode = PivShapeMode.NORMAL;
        this.listener = new WeakReference<Object>(null);
    }

    public void setOptions(ShapeOptions other) {
        this.mBackgroundColor = other.mBackgroundColor;
        this.mForegroundColor = other.mForegroundColor;
        this.mForegroundDrawable = other.mForegroundDrawable;
        this.mBackgroundDrawable = other.mBackgroundDrawable;
        this.mInnerPadding = other.mInnerPadding;
        this.mInnerPaddingPercent = other.mInnerPaddingPercent;
        this.mBorderOverlay = other.mBorderOverlay;
        this.mBorderColor = other.mBorderColor;
        this.mBorderWidth = other.mBorderWidth;
        this.mRatio = other.mRatio;
        this.mRadiusX = other.mRadiusX;
        this.mRadiusY = other.mRadiusY;
        this.mSolidColor = other.mSolidColor;
        this.mShapeBounds.set(other.mShapeBounds);
        this.mImageBounds.set(other.mImageBounds);
        this.mBorderBounds.set(other.mBorderBounds);
        this.mViewBounds.set(other.mViewBounds);
        this.mCalculatedInnerPadding = other.mCalculatedInnerPadding;
        this.mCalculatedLastW = other.mCalculatedLastW;
        this.mCalculatedLastH = other.mCalculatedLastH;
        this.mCalculatedLastMode = other.mCalculatedLastMode;
        this.mCalculatedLastPaddingLeft = other.mCalculatedLastPaddingLeft;
        this.mCalculatedLastPaddingTop = other.mCalculatedLastPaddingTop;
        this.mCalculatedLastPaddingRight = other.mCalculatedLastPaddingRight;
        this.mCalculatedLastPaddingBottom = other.mCalculatedLastPaddingBottom;
        this.listener = other.listener;
    }

    public void calculateBounds(int w, int h, int paddingLeft, int paddingTop, int paddingRight, int paddingBottom, PivShapeMode mode) {
        float smallSize;
        this.mCalculatedLastW = w;
        this.mCalculatedLastH = h;
        this.mCalculatedLastMode = mode;
        this.mCalculatedLastPaddingLeft = paddingLeft;
        this.mCalculatedLastPaddingTop = paddingTop;
        this.mCalculatedLastPaddingRight = paddingRight;
        this.mCalculatedLastPaddingBottom = paddingBottom;
        this.mViewBounds.set(0.0f, 0.0f, (float)w, (float)h);
        float usedRatio = this.mRatio <= 0.0f ? (float)w / (float)h : this.mRatio;
        switch (mode) {
            case CIRCLE: 
            case SQUARE: 
            case SOLID_CIRCLE: {
                smallSize = Math.min(h, w);
                this.mShapeBounds.set(((float)w - smallSize) / 2.0f, ((float)h - smallSize) / 2.0f, ((float)w + smallSize) / 2.0f, ((float)h + smallSize) / 2.0f);
                break;
            }
            case RECTANGLE: 
            case ROUNDED_RECTANGLE: 
            case SOLID_ROUNDED_RECTANGLE: 
            case OVAL: 
            case SOLID_OVAL: {
                float smallX = (int)Math.min((float)w, (float)h * usedRatio);
                float smallY = (int)Math.min((float)h, (float)w / usedRatio);
                smallSize = (int)Math.min(smallX, smallY);
                this.mShapeBounds.set(((float)w - smallX) / 2.0f, ((float)h - smallY) / 2.0f, ((float)w + smallX) / 2.0f, ((float)h + smallY) / 2.0f);
                break;
            }
            default: {
                this.mShapeBounds.set(0.0f, 0.0f, (float)w, (float)h);
                smallSize = Math.min(w, h);
            }
        }
        this.mShapeBounds.set(this.mShapeBounds.left + (float)paddingLeft, this.mShapeBounds.top + (float)paddingTop, this.mShapeBounds.right - (float)paddingRight, this.mShapeBounds.bottom - (float)paddingBottom);
        if ((float)this.mBorderWidth > this.mShapeBounds.width() / 2.0f) {
            this.mBorderWidth = (int)this.mShapeBounds.width() / 2;
        }
        this.mBorderBounds.set(this.mShapeBounds);
        this.mBorderBounds.inset((float)(this.mBorderWidth / 2), (float)(this.mBorderWidth / 2));
        if (!this.mBorderOverlay) {
            this.mShapeBounds.inset((float)this.mBorderWidth, (float)this.mBorderWidth);
        }
        this.mCalculatedInnerPadding = smallSize * this.mInnerPaddingPercent / 100.0f;
        if (this.mInnerPadding >= 0) {
            this.mCalculatedInnerPadding = this.mInnerPadding;
        }
        if (this.mCalculatedInnerPadding >= smallSize / 2.0f) {
            this.mCalculatedInnerPadding = smallSize / 2.0f - 1.0f;
        }
        this.mImageBounds.set(this.mShapeBounds);
        this.mImageBounds.inset(this.mCalculatedInnerPadding, this.mCalculatedInnerPadding);
    }

    public void setListener(ShapeOptionsListener listener) {
        this.listener = new WeakReference<ShapeOptionsListener>(listener);
    }

    public RectF getShapeBounds() {
        return this.mShapeBounds;
    }

    public RectF getBorderBounds() {
        return this.mBorderBounds;
    }

    public RectF getViewBounds() {
        return this.mViewBounds;
    }

    public RectF getImageBounds() {
        return this.mImageBounds;
    }

    public int getBorderWidth() {
        return this.mBorderWidth;
    }

    public void setBackgroundColor(int backgroundColor) {
        this.mBackgroundColor = backgroundColor;
        if (this.listener.get() != null) {
            ((ShapeOptionsListener)this.listener.get()).onOptionsUpdated(this);
        }
    }

    public void setForegroundColor(int foregroundColor) {
        this.mForegroundColor = foregroundColor;
        if (this.listener.get() != null) {
            ((ShapeOptionsListener)this.listener.get()).onOptionsUpdated(this);
        }
    }

    public void setForegroundDrawable(Drawable foregroundDrawable) {
        this.mForegroundDrawable = foregroundDrawable;
        if (this.listener.get() != null) {
            ((ShapeOptionsListener)this.listener.get()).onOptionsUpdated(this);
        }
    }

    public void setBackgroundDrawable(Drawable backgroundDrawable) {
        this.mBackgroundDrawable = backgroundDrawable;
        if (this.listener.get() != null) {
            ((ShapeOptionsListener)this.listener.get()).onOptionsUpdated(this);
        }
    }

    public int getBackgroundColor() {
        return this.mBackgroundColor;
    }

    public int getForegroundColor() {
        return this.mForegroundColor;
    }

    public Drawable getForegroundDrawable() {
        return this.mForegroundDrawable;
    }

    public Drawable getBackgroundDrawable() {
        return this.mBackgroundDrawable;
    }

    public int getBorderColor() {
        return this.mBorderColor;
    }

    public float getRatio() {
        return this.mRatio;
    }

    public float getRadiusX() {
        return this.mRadiusX;
    }

    public float getRadiusY() {
        return this.mRadiusY;
    }

    public int getInnerPadding() {
        return this.mInnerPadding;
    }

    public float getInnerPaddingPercent() {
        return this.mInnerPaddingPercent;
    }

    public boolean isBorderOverlay() {
        return this.mBorderOverlay;
    }

    public void setBorderColor(int borderColor) {
        this.mBorderColor = borderColor;
        if (this.listener.get() != null) {
            ((ShapeOptionsListener)this.listener.get()).onOptionsUpdated(this);
        }
    }

    public float getCalculatedInnerPadding() {
        return this.mCalculatedInnerPadding;
    }

    public int getSolidColor() {
        return this.mSolidColor;
    }

    public void setInnerPadding(int innerPadding) {
        this.mInnerPadding = innerPadding;
        this.calculateBounds(this.mCalculatedLastW, this.mCalculatedLastH, this.mCalculatedLastPaddingLeft, this.mCalculatedLastPaddingTop, this.mCalculatedLastPaddingRight, this.mCalculatedLastPaddingBottom, this.mCalculatedLastMode);
        if (this.listener.get() != null) {
            ((ShapeOptionsListener)this.listener.get()).onSizeUpdated(this);
        }
    }

    public void setInnerPadding(float innerPaddingPercent) {
        this.mInnerPadding = -1;
        this.mInnerPaddingPercent = innerPaddingPercent;
        this.calculateBounds(this.mCalculatedLastW, this.mCalculatedLastH, this.mCalculatedLastPaddingLeft, this.mCalculatedLastPaddingTop, this.mCalculatedLastPaddingRight, this.mCalculatedLastPaddingBottom, this.mCalculatedLastMode);
        if (this.listener.get() != null) {
            ((ShapeOptionsListener)this.listener.get()).onSizeUpdated(this);
        }
    }

    public void setBorderOverlay(boolean borderOverlay) {
        this.mBorderOverlay = borderOverlay;
        this.calculateBounds(this.mCalculatedLastW, this.mCalculatedLastH, this.mCalculatedLastPaddingLeft, this.mCalculatedLastPaddingTop, this.mCalculatedLastPaddingRight, this.mCalculatedLastPaddingBottom, this.mCalculatedLastMode);
        if (this.listener.get() != null) {
            ((ShapeOptionsListener)this.listener.get()).onSizeUpdated(this);
        }
    }

    public void setBorderWidth(int borderWidth) {
        this.mBorderWidth = borderWidth;
        this.calculateBounds(this.mCalculatedLastW, this.mCalculatedLastH, this.mCalculatedLastPaddingLeft, this.mCalculatedLastPaddingTop, this.mCalculatedLastPaddingRight, this.mCalculatedLastPaddingBottom, this.mCalculatedLastMode);
        if (this.listener.get() != null) {
            ((ShapeOptionsListener)this.listener.get()).onSizeUpdated(this);
        }
    }

    public void setRatio(float ratio) {
        this.mRatio = ratio;
        this.calculateBounds(this.mCalculatedLastW, this.mCalculatedLastH, this.mCalculatedLastPaddingLeft, this.mCalculatedLastPaddingTop, this.mCalculatedLastPaddingRight, this.mCalculatedLastPaddingBottom, this.mCalculatedLastMode);
        if (this.listener.get() != null) {
            ((ShapeOptionsListener)this.listener.get()).onRequestMeasure(this);
        }
    }

    public void setRadiusX(float radiusX) {
        this.mRadiusX = radiusX;
        if (this.listener.get() != null) {
            ((ShapeOptionsListener)this.listener.get()).onOptionsUpdated(this);
        }
    }

    public void setRadiusY(float radiusY) {
        this.mRadiusY = radiusY;
        if (this.listener.get() != null) {
            ((ShapeOptionsListener)this.listener.get()).onOptionsUpdated(this);
        }
    }

    public void setSolidColor(int solidColor) {
        this.mSolidColor = solidColor;
        if (this.listener.get() != null) {
            ((ShapeOptionsListener)this.listener.get()).onOptionsUpdated(this);
        }
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mBackgroundColor);
        dest.writeInt(this.mForegroundColor);
        dest.writeInt(this.mInnerPadding);
        dest.writeFloat(this.mInnerPaddingPercent);
        dest.writeByte((byte)(this.mBorderOverlay ? 1 : 0));
        dest.writeInt(this.mBorderColor);
        dest.writeInt(this.mBorderWidth);
        dest.writeFloat(this.mRatio);
        dest.writeFloat(this.mRadiusX);
        dest.writeFloat(this.mRadiusY);
        dest.writeInt(this.mSolidColor);
        dest.writeParcelable((Parcelable)this.mShapeBounds, flags);
        dest.writeParcelable((Parcelable)this.mImageBounds, flags);
        dest.writeParcelable((Parcelable)this.mBorderBounds, flags);
        dest.writeParcelable((Parcelable)this.mViewBounds, flags);
        dest.writeFloat(this.mCalculatedInnerPadding);
        dest.writeInt(this.mCalculatedLastPaddingLeft);
        dest.writeInt(this.mCalculatedLastPaddingTop);
        dest.writeInt(this.mCalculatedLastPaddingRight);
        dest.writeInt(this.mCalculatedLastPaddingBottom);
        dest.writeInt(this.mCalculatedLastW);
        dest.writeInt(this.mCalculatedLastH);
    }

    private ShapeOptions(Parcel in) {
        this.mBackgroundColor = in.readInt();
        this.mForegroundColor = in.readInt();
        this.mInnerPadding = in.readInt();
        this.mInnerPaddingPercent = in.readFloat();
        this.mBorderOverlay = in.readByte() != 0;
        this.mBorderColor = in.readInt();
        this.mBorderWidth = in.readInt();
        this.mRatio = in.readFloat();
        this.mRadiusX = in.readFloat();
        this.mRadiusY = in.readFloat();
        this.mSolidColor = in.readInt();
        this.mShapeBounds = (RectF)in.readParcelable(RectF.class.getClassLoader());
        this.mImageBounds = (RectF)in.readParcelable(RectF.class.getClassLoader());
        this.mBorderBounds = (RectF)in.readParcelable(RectF.class.getClassLoader());
        this.mViewBounds = (RectF)in.readParcelable(RectF.class.getClassLoader());
        this.mCalculatedInnerPadding = in.readFloat();
        this.mCalculatedLastPaddingLeft = in.readInt();
        this.mCalculatedLastPaddingTop = in.readInt();
        this.mCalculatedLastPaddingRight = in.readInt();
        this.mCalculatedLastPaddingBottom = in.readInt();
        this.mCalculatedLastW = in.readInt();
        this.mCalculatedLastH = in.readInt();
    }

    public static interface ShapeOptionsListener {
        public void onOptionsUpdated(ShapeOptions var1);

        public void onSizeUpdated(ShapeOptions var1);

        public void onRequestMeasure(ShapeOptions var1);
    }
}

