/*
 * Decompiled with CFR 0.152.
 */
package com.stefanosiano.powerfulimageview.shape;

import android.widget.ImageView;

public enum PivShapeScaleType {
    MATRIX(0),
    FIT_XY(1),
    FIT_START(2),
    FIT_CENTER(3),
    FIT_END(4),
    CENTER(5),
    CENTER_CROP(6),
    CENTER_INSIDE(7),
    TOP_CROP(8),
    BOTTOM_CROP(9);

    private final int value;

    private PivShapeScaleType(int value) {
        this.value = value;
    }

    public final int getValue() {
        return this.value;
    }

    public static PivShapeScaleType getFromScaleType(ImageView.ScaleType scaleType) {
        if (scaleType == null) {
            return CENTER;
        }
        switch (scaleType) {
            default: {
                return MATRIX;
            }
            case FIT_XY: {
                return FIT_XY;
            }
            case FIT_START: {
                return FIT_START;
            }
            case FIT_CENTER: {
                return FIT_CENTER;
            }
            case FIT_END: {
                return FIT_END;
            }
            case CENTER: {
                return CENTER;
            }
            case CENTER_CROP: {
                return CENTER_CROP;
            }
            case CENTER_INSIDE: 
        }
        return CENTER_INSIDE;
    }

    public static PivShapeScaleType fromValue(int value) {
        switch (value) {
            case 0: {
                return MATRIX;
            }
            case 1: {
                return FIT_XY;
            }
            case 2: {
                return FIT_START;
            }
            case 3: {
                return FIT_CENTER;
            }
            case 4: {
                return FIT_END;
            }
            case 6: {
                return CENTER_CROP;
            }
            case 7: {
                return CENTER_INSIDE;
            }
            case 8: {
                return TOP_CROP;
            }
            case 9: {
                return BOTTOM_CROP;
            }
        }
        return CENTER;
    }
}

