/*
 * Decompiled with CFR 0.152.
 */
package com.stefanosiano.powerfulimageview.shape;

public enum PivShapeMode {
    NORMAL(0),
    CIRCLE(1),
    SQUARE(2),
    RECTANGLE(3),
    OVAL(4),
    ROUNDED_RECTANGLE(5),
    SOLID_CIRCLE(6),
    SOLID_OVAL(7),
    SOLID_ROUNDED_RECTANGLE(8);

    private final int value;

    private PivShapeMode(int value) {
        this.value = value;
    }

    public final int getValue() {
        return this.value;
    }

    public static PivShapeMode fromValue(int value) {
        switch (value) {
            case 1: {
                return CIRCLE;
            }
            case 2: {
                return SQUARE;
            }
            case 3: {
                return RECTANGLE;
            }
            case 4: {
                return OVAL;
            }
            case 5: {
                return ROUNDED_RECTANGLE;
            }
            case 6: {
                return SOLID_CIRCLE;
            }
            case 7: {
                return SOLID_OVAL;
            }
            case 8: {
                return SOLID_ROUNDED_RECTANGLE;
            }
        }
        return NORMAL;
    }

    public boolean isRounded() {
        return this == CIRCLE || this == OVAL || this == ROUNDED_RECTANGLE;
    }

    public boolean isSolid() {
        return this == SOLID_CIRCLE || this == SOLID_OVAL || this == SOLID_ROUNDED_RECTANGLE;
    }

    public boolean isRectangular() {
        return this == NORMAL || this == SQUARE || this == RECTANGLE;
    }
}

