/*
 * Decompiled with CFR 0.152.
 */
package com.stefanosiano.powerfulimageview.progress.drawers;

import android.graphics.Canvas;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Parcelable;
import android.view.View;
import com.stefanosiano.powerfulimageview.progress.PivProgressMode;
import com.stefanosiano.powerfulimageview.progress.ProgressOptions;
import com.stefanosiano.powerfulimageview.progress.drawers.CircularIndeterminateProgressDrawer;
import com.stefanosiano.powerfulimageview.progress.drawers.CircularProgressDrawer;
import com.stefanosiano.powerfulimageview.progress.drawers.CircularShadowDrawer;
import com.stefanosiano.powerfulimageview.progress.drawers.DummyProgressDrawer;
import com.stefanosiano.powerfulimageview.progress.drawers.DummyShadowDrawer;
import com.stefanosiano.powerfulimageview.progress.drawers.HorizontalIndeterminateProgressDrawer;
import com.stefanosiano.powerfulimageview.progress.drawers.HorizontalProgressDrawer;
import com.stefanosiano.powerfulimageview.progress.drawers.ProgressDrawer;
import com.stefanosiano.powerfulimageview.progress.drawers.RectangularShadowDrawer;
import com.stefanosiano.powerfulimageview.progress.drawers.ShadowDrawer;
import java.lang.ref.WeakReference;

public final class ProgressDrawerManager
implements ProgressOptions.ProgressOptionsListener {
    private final WeakReference<View> mView;
    private final RectF mProgressBounds;
    private final RectF mProgressShadowBorderBounds;
    private final RectF mProgressShadowBounds;
    private DummyProgressDrawer mDummyProgressDrawer;
    private CircularProgressDrawer mCircularProgressDrawer;
    private HorizontalProgressDrawer mHorizontalProgressDrawer;
    private HorizontalIndeterminateProgressDrawer mHorizontalIndeterminateProgressDrawer;
    private CircularIndeterminateProgressDrawer mCircularIndeterminateProgressDrawer;
    private DummyShadowDrawer mDummyCancelDrawer;
    private RectangularShadowDrawer mRectangularShadowDrawer;
    private CircularShadowDrawer mCircularShadowDrawer;
    private ShadowDrawer mShadowDrawer;
    private ProgressDrawer mProgressDrawer;
    private PivProgressMode mProgressMode = null;
    private ProgressOptions mProgressOptions;
    private final ProgressDrawerListener listener;

    public ProgressDrawerManager(View view, ProgressOptions progressOptions) {
        this.mView = new WeakReference<View>(view);
        this.mProgressBounds = new RectF();
        this.mProgressShadowBorderBounds = new RectF();
        this.mProgressShadowBounds = new RectF();
        this.mProgressOptions = progressOptions;
        this.listener = new ProgressDrawerListener(){

            @Override
            public void onRequestInvalidate() {
                if (ProgressDrawerManager.this.mView.get() != null) {
                    ((View)ProgressDrawerManager.this.mView.get()).postInvalidate((int)((ProgressDrawerManager)ProgressDrawerManager.this).mProgressBounds.left - 1, (int)((ProgressDrawerManager)ProgressDrawerManager.this).mProgressBounds.top - 1, (int)((ProgressDrawerManager)ProgressDrawerManager.this).mProgressBounds.right + 1, (int)((ProgressDrawerManager)ProgressDrawerManager.this).mProgressBounds.bottom + 1);
                }
            }
        };
        this.mProgressOptions.setListener(this);
        this.mProgressDrawer = new DummyProgressDrawer();
    }

    private void updateDrawers(PivProgressMode progressMode) {
        if (progressMode == null) {
            progressMode = PivProgressMode.NONE;
        }
        switch (progressMode) {
            case CIRCULAR: {
                if (this.mProgressOptions.isIndeterminate()) {
                    if (this.mCircularIndeterminateProgressDrawer == null) {
                        this.mCircularIndeterminateProgressDrawer = new CircularIndeterminateProgressDrawer();
                    }
                    this.mProgressDrawer = this.mCircularIndeterminateProgressDrawer;
                } else {
                    if (this.mCircularProgressDrawer == null) {
                        this.mCircularProgressDrawer = new CircularProgressDrawer();
                    }
                    this.mProgressDrawer = this.mCircularProgressDrawer;
                }
                if (this.mProgressOptions.isShadowEnabled()) {
                    if (this.mCircularShadowDrawer == null) {
                        this.mCircularShadowDrawer = new CircularShadowDrawer();
                    }
                    this.mShadowDrawer = this.mCircularShadowDrawer;
                    break;
                }
                if (this.mDummyCancelDrawer == null) {
                    this.mDummyCancelDrawer = new DummyShadowDrawer();
                }
                this.mShadowDrawer = this.mDummyCancelDrawer;
                break;
            }
            case HORIZONTAL: {
                if (this.mProgressOptions.isIndeterminate()) {
                    if (this.mHorizontalIndeterminateProgressDrawer == null) {
                        this.mHorizontalIndeterminateProgressDrawer = new HorizontalIndeterminateProgressDrawer();
                    }
                    this.mProgressDrawer = this.mHorizontalIndeterminateProgressDrawer;
                } else {
                    if (this.mHorizontalProgressDrawer == null) {
                        this.mHorizontalProgressDrawer = new HorizontalProgressDrawer();
                    }
                    this.mProgressDrawer = this.mHorizontalProgressDrawer;
                }
                if (this.mProgressOptions.isShadowEnabled()) {
                    if (this.mRectangularShadowDrawer == null) {
                        this.mRectangularShadowDrawer = new RectangularShadowDrawer();
                    }
                    this.mShadowDrawer = this.mRectangularShadowDrawer;
                    break;
                }
                if (this.mDummyCancelDrawer == null) {
                    this.mDummyCancelDrawer = new DummyShadowDrawer();
                }
                this.mShadowDrawer = this.mDummyCancelDrawer;
                break;
            }
            default: {
                if (this.mDummyProgressDrawer == null) {
                    this.mDummyProgressDrawer = new DummyProgressDrawer();
                }
                this.mProgressDrawer = this.mDummyProgressDrawer;
                if (this.mDummyCancelDrawer == null) {
                    this.mDummyCancelDrawer = new DummyShadowDrawer();
                }
                this.mShadowDrawer = this.mDummyCancelDrawer;
            }
        }
        this.mProgressDrawer.setListener(this.listener);
    }

    public final void onSizeChanged(int w, int h) {
        this.mProgressOptions.calculateBounds(w, h, this.mProgressMode);
        this.onSizeUpdated(this.mProgressOptions);
    }

    public final void changeDrawable(Drawable drawable) {
        if (this.mProgressOptions.isRemovedOnChange()) {
            this.changeProgressMode(PivProgressMode.NONE, false);
        }
    }

    public final void changeProgressMode(PivProgressMode progressMode, boolean forceUpdate) {
        if (this.mProgressMode != null && this.mProgressMode == progressMode && !forceUpdate) {
            return;
        }
        if (this.mProgressDrawer != null) {
            this.mProgressDrawer.stopIndeterminateAnimation();
        }
        this.mProgressMode = progressMode;
        this.updateDrawers(this.mProgressMode);
        this.mProgressDrawer.setup(this.mProgressOptions);
        this.mShadowDrawer.setup(this.mProgressOptions);
        this.mProgressDrawer.startIndeterminateAnimation();
    }

    public final void onDraw(Canvas canvas) {
        this.mShadowDrawer.draw(canvas, this.mProgressShadowBorderBounds, this.mProgressShadowBounds);
        this.mProgressDrawer.draw(canvas, this.mProgressBounds);
    }

    public final ProgressOptions getProgressOptions() {
        return this.mProgressOptions;
    }

    public PivProgressMode getProgressMode() {
        return this.mProgressMode;
    }

    @Override
    public void onOptionsUpdated(ProgressOptions options) {
        this.mShadowDrawer.setup(options);
        this.mProgressDrawer.setup(options);
        this.mProgressOptions = options;
    }

    @Override
    public void onModeUpdated(ProgressOptions options) {
        this.mProgressOptions = options;
        this.changeProgressMode(this.mProgressMode, true);
    }

    @Override
    public void onSizeUpdated(ProgressOptions options) {
        this.mProgressOptions = options;
        this.mProgressBounds.set(this.mProgressOptions.getRect());
        this.mProgressShadowBorderBounds.set(this.mProgressOptions.getShadowBorderRect());
        this.mProgressShadowBounds.set(this.mProgressOptions.getShadowRect());
        this.mProgressDrawer.setup(this.mProgressOptions);
        this.mShadowDrawer.setup(this.mProgressOptions);
    }

    public Bundle saveInstanceState() {
        Bundle bundle = new Bundle();
        bundle.putParcelable("progress_options", (Parcelable)this.mProgressOptions);
        bundle.putInt("progress_mode", this.mProgressMode.getValue());
        return bundle;
    }

    public void restoreInstanceState(Bundle state) {
        if (state == null) {
            return;
        }
        this.mProgressOptions.setOptions((ProgressOptions)state.getParcelable("progress_options"));
        PivProgressMode progressMode = PivProgressMode.fromValue(state.getInt("progress_mode"));
        this.onSizeUpdated(this.mProgressOptions);
        this.changeProgressMode(progressMode, false);
    }

    static interface ProgressDrawerListener {
        public void onRequestInvalidate();
    }
}

