/*
 * Decompiled with CFR 0.152.
 */
package com.stefanosiano.powerfulimageview.progress.drawers;

import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.view.animation.LinearInterpolator;
import com.stefanosiano.powerfulimageview.progress.ProgressOptions;
import com.stefanosiano.powerfulimageview.progress.drawers.ProgressDrawer;
import com.stefanosiano.powerfulimageview.progress.drawers.ProgressDrawerManager;

final class HorizontalProgressDrawer
implements ProgressDrawer {
    private final long DEFAULT_ANIMATION_DURATION = 100L;
    private float mLeft;
    private float mRight;
    private Paint mProgressFrontPaint;
    private Paint mProgressBackPaint;
    private ValueAnimator mProgressAnimator;
    private long mProgressAnimationDuration = -1L;
    private boolean mUseProgressAnimation;
    private float mProgress;
    private float mCurrentProgress;
    private float mOldProgress;
    private float mCurrentFrontX;
    private boolean mIsProgressReversed;
    private ProgressDrawerManager.ProgressDrawerListener listener;

    HorizontalProgressDrawer() {
    }

    private void setRealProgress(float progress) {
        this.mCurrentProgress = progress;
        this.mCurrentFrontX = this.mLeft + (this.mRight - this.mLeft) * (progress / 100.0f);
        this.listener.onRequestInvalidate();
    }

    @Override
    public void setProgressPercent(float progressPercent) {
        float mProgress = progressPercent;
        if (mProgress > 100.0f) {
            mProgress %= 100.0f;
        }
        this.mOldProgress = this.mCurrentProgress;
        this.mProgress = mProgress;
        if (this.mUseProgressAnimation) {
            if (this.mProgressAnimator != null) {
                this.mProgressAnimator.cancel();
            }
            this.createAnimationIfNeeded();
            this.mProgressAnimator.start();
        } else {
            this.setRealProgress(mProgress);
        }
    }

    @Override
    public void setAnimationEnabled(boolean enabled) {
        this.mUseProgressAnimation = enabled;
    }

    @Override
    public void setAnimationDuration(long millis) {
        this.mProgressAnimationDuration = millis;
        this.createAnimationIfNeeded();
        this.mProgressAnimator.setDuration(millis);
        if (this.mProgressAnimator.isRunning()) {
            this.mProgressAnimator.cancel();
            this.mProgressAnimator.start();
        }
    }

    @Override
    public void setListener(ProgressDrawerManager.ProgressDrawerListener listener) {
        this.listener = listener;
    }

    @Override
    public void setup(ProgressOptions progressOptions) {
        if (this.mProgressFrontPaint == null) {
            this.mProgressFrontPaint = new Paint();
        }
        if (this.mProgressBackPaint == null) {
            this.mProgressBackPaint = new Paint();
        }
        this.mProgressFrontPaint.setColor(progressOptions.getFrontColor());
        this.mProgressFrontPaint.setStyle(Paint.Style.FILL_AND_STROKE);
        this.mProgressBackPaint.setColor(progressOptions.getBackColor());
        this.mProgressBackPaint.setStyle(Paint.Style.FILL_AND_STROKE);
        this.mLeft = progressOptions.getRect().left;
        this.mRight = progressOptions.getRect().right;
        this.mUseProgressAnimation = progressOptions.isDeterminateAnimationEnabled();
        this.mIsProgressReversed = progressOptions.isProgressReversed();
        this.setProgressPercent(progressOptions.getValuePercent());
    }

    @Override
    public void startIndeterminateAnimation() {
    }

    @Override
    public void draw(Canvas canvas, RectF progressBounds) {
        if (!this.mIsProgressReversed) {
            canvas.drawRect(this.mCurrentFrontX, progressBounds.top, progressBounds.right, progressBounds.bottom, this.mProgressBackPaint);
            canvas.drawRect(progressBounds.left, progressBounds.top, this.mCurrentFrontX, progressBounds.bottom, this.mProgressFrontPaint);
        } else {
            canvas.drawRect(progressBounds.left, progressBounds.top, progressBounds.right - this.mCurrentFrontX, progressBounds.bottom, this.mProgressBackPaint);
            canvas.drawRect(progressBounds.right - this.mCurrentFrontX, progressBounds.top, progressBounds.right, progressBounds.bottom, this.mProgressFrontPaint);
        }
    }

    @Override
    public void stopIndeterminateAnimation() {
    }

    private float getOldProgress() {
        return this.mOldProgress;
    }

    private float getProgress() {
        return this.mProgress;
    }

    private void createAnimationIfNeeded() {
        if (this.mProgressAnimator != null) {
            return;
        }
        this.mProgressAnimator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
        this.mProgressAnimator.setInterpolator((TimeInterpolator)new LinearInterpolator());
        this.mProgressAnimator.setDuration(this.mProgressAnimationDuration < 0L ? 100L : this.mProgressAnimationDuration);
        this.mProgressAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                HorizontalProgressDrawer.this.setRealProgress(HorizontalProgressDrawer.this.getOldProgress() + (HorizontalProgressDrawer.this.getProgress() - HorizontalProgressDrawer.this.getOldProgress()) * animation.getAnimatedFraction());
            }
        });
    }
}

