/*
 * Decompiled with CFR 0.152.
 */
package com.stefanosiano.powerfulimageview.progress.drawers;

import android.animation.Animator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.view.animation.AccelerateDecelerateInterpolator;
import com.stefanosiano.powerfulimageview.progress.ProgressOptions;
import com.stefanosiano.powerfulimageview.progress.drawers.ProgressDrawer;
import com.stefanosiano.powerfulimageview.progress.drawers.ProgressDrawerManager;

final class HorizontalIndeterminateProgressDrawer
implements ProgressDrawer {
    private final long DEFAULT_ANIMATION_DURATION = 1000L;
    private float mLeft;
    private float mRight;
    private Paint mProgressPaint;
    private ValueAnimator mProgressAnimator;
    private float mStartX = 0.0f;
    private float mEndX = 0.0f;
    private boolean isShrinking = false;
    private boolean mIsProgressReversed;
    private long mProgressAnimationDuration = -1L;
    private ProgressDrawerManager.ProgressDrawerListener listener;

    HorizontalIndeterminateProgressDrawer() {
    }

    @Override
    public void setProgressPercent(float progressPercent) {
    }

    @Override
    public void setAnimationEnabled(boolean enabled) {
    }

    @Override
    public void setup(ProgressOptions progressOptions) {
        this.createAnimationIfNeeded();
        if (this.mProgressPaint == null) {
            this.mProgressPaint = new Paint();
        }
        this.mProgressPaint.setColor(progressOptions.getIndeterminateColor());
        this.mProgressPaint.setStyle(Paint.Style.FILL_AND_STROKE);
        this.mLeft = progressOptions.getRect().left;
        this.mRight = progressOptions.getRect().right;
        this.setProgressValues(this.isShrinking ? this.mStartX : this.mEndX);
        this.mIsProgressReversed = progressOptions.isProgressReversed();
    }

    private void setProgressValues(float currentX) {
        if (this.isShrinking) {
            this.mStartX = currentX;
            this.mEndX = this.mRight;
        } else {
            this.mStartX = this.mLeft;
            this.mEndX = currentX;
        }
        this.listener.onRequestInvalidate();
    }

    @Override
    public void startIndeterminateAnimation() {
        if (this.mProgressAnimator != null) {
            this.mProgressAnimator.cancel();
        }
        this.isShrinking = false;
        this.setProgressValues(this.mLeft);
        this.mProgressAnimator.start();
    }

    @Override
    public void draw(Canvas canvas, RectF progressBounds) {
        if (!this.mIsProgressReversed) {
            canvas.drawRect(this.mStartX, progressBounds.top, this.mEndX, progressBounds.bottom, this.mProgressPaint);
        } else {
            canvas.drawRect(progressBounds.right - this.mEndX, progressBounds.top, progressBounds.right + progressBounds.left - this.mStartX, progressBounds.bottom, this.mProgressPaint);
        }
    }

    @Override
    public void stopIndeterminateAnimation() {
        if (this.mProgressAnimator != null) {
            this.mProgressAnimator.cancel();
        }
    }

    @Override
    public void setAnimationDuration(long millis) {
        this.mProgressAnimationDuration = millis;
        this.createAnimationIfNeeded();
        this.mProgressAnimator.setDuration(millis);
        if (this.mProgressAnimator.isRunning()) {
            this.mProgressAnimator.cancel();
            this.mProgressAnimator.start();
        }
    }

    @Override
    public void setListener(ProgressDrawerManager.ProgressDrawerListener listener) {
        this.listener = listener;
    }

    private void createAnimationIfNeeded() {
        if (this.mProgressAnimator != null) {
            return;
        }
        this.mProgressAnimator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
        this.mProgressAnimator.setDuration(this.mProgressAnimationDuration < 0L ? 1000L : this.mProgressAnimationDuration);
        this.mProgressAnimator.setInterpolator((TimeInterpolator)new AccelerateDecelerateInterpolator());
        this.mProgressAnimator.setRepeatCount(-1);
        this.mProgressAnimator.addListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animation) {
            }

            public void onAnimationEnd(Animator animation) {
            }

            public void onAnimationCancel(Animator animation) {
            }

            public void onAnimationRepeat(Animator animation) {
                HorizontalIndeterminateProgressDrawer.this.isShrinking = !HorizontalIndeterminateProgressDrawer.this.isShrinking;
            }
        });
        this.mProgressAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                HorizontalIndeterminateProgressDrawer.this.setProgressValues(HorizontalIndeterminateProgressDrawer.this.mLeft + (HorizontalIndeterminateProgressDrawer.this.mRight - HorizontalIndeterminateProgressDrawer.this.mLeft) * animation.getAnimatedFraction());
            }
        });
    }
}

