/*
 * Decompiled with CFR 0.152.
 */
package com.stefanosiano.powerfulimageview.progress.drawers;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import com.stefanosiano.powerfulimageview.progress.ProgressOptions;
import com.stefanosiano.powerfulimageview.progress.drawers.ShadowDrawer;

final class CircularShadowDrawer
implements ShadowDrawer {
    private Paint mShadowPaint;
    private Paint mShadowBorderPaint;

    CircularShadowDrawer() {
    }

    @Override
    public void setup(ProgressOptions progressOptions) {
        if (this.mShadowPaint == null) {
            this.mShadowPaint = new Paint();
        }
        if (this.mShadowBorderPaint == null) {
            this.mShadowBorderPaint = new Paint();
        }
        this.mShadowPaint.setColor(progressOptions.getShadowColor());
        this.mShadowPaint.setStrokeWidth(0.0f);
        this.mShadowPaint.setAntiAlias(true);
        this.mShadowPaint.setStyle(Paint.Style.FILL);
        this.mShadowBorderPaint.setColor(progressOptions.getShadowBorderColor());
        this.mShadowBorderPaint.setStrokeWidth(progressOptions.getShadowBorderWidth());
        this.mShadowBorderPaint.setAntiAlias(true);
        this.mShadowBorderPaint.setStyle(Paint.Style.STROKE);
    }

    @Override
    public void draw(Canvas canvas, RectF shadowBorderBounds, RectF shadowBounds) {
        canvas.drawArc(shadowBounds, 0.0f, 360.0f, true, this.mShadowPaint);
        canvas.drawArc(shadowBorderBounds, 0.0f, 360.0f, false, this.mShadowBorderPaint);
    }
}

