/*
 * Decompiled with CFR 0.152.
 */
package com.stefanosiano.powerfulimageview.progress;

import android.graphics.RectF;
import android.os.Parcel;
import android.os.Parcelable;
import com.stefanosiano.powerfulimageview.progress.PivProgressGravity;
import com.stefanosiano.powerfulimageview.progress.PivProgressMode;
import java.lang.ref.WeakReference;

public final class ProgressOptions
implements Parcelable {
    private boolean mDeterminateAnimationEnabled;
    private int mBorderWidth;
    private float mBorderWidthPercent;
    private float mValuePercent;
    private int mFrontColor;
    private int mBackColor;
    private int mIndeterminateColor;
    private boolean mDrawWedge;
    private boolean mShadowEnabled;
    private int mShadowColor;
    private int mShadowPadding;
    private float mShadowPaddingPercent;
    private float mShadowBorderWidth;
    private float mCalculatedShadowBorderWidth;
    private int mShadowBorderColor;
    private int mSize;
    private int mPadding;
    private float mSizePercent;
    private PivProgressGravity mGravity;
    private boolean mIsProgressReversed;
    private boolean mIsRemovedOnChange;
    private boolean mIsRtl;
    private boolean mIsRtlDisabled;
    private boolean mIsIndeterminate;
    private float mCalculatedSize;
    private int mCalculatedShadowPadding;
    private int mCalculatedBorderWidth;
    private final RectF mRect;
    private final RectF mShadowRect;
    private final RectF mShadowBorderRect;
    private int mCalculatedLastW;
    private int mCalculatedLastH;
    private PivProgressMode mCalculatedLastMode;
    private WeakReference<ProgressOptionsListener> listener;
    public static final Parcelable.Creator<ProgressOptions> CREATOR = new Parcelable.Creator<ProgressOptions>(){

        public ProgressOptions createFromParcel(Parcel in) {
            return new ProgressOptions(in);
        }

        public ProgressOptions[] newArray(int size) {
            return new ProgressOptions[size];
        }
    };

    public ProgressOptions(boolean determinateAnimationEnabled, int borderWidth, float borderWidthPercent, int size, float sizePercent, int padding, float valuePercent, int frontColor, int backColor, int indeterminateColor, int gravity, boolean rtl, boolean disableRtlSupport, boolean isIndeterminate, boolean drawWedge, boolean shadowEnabled, int shadowColor, int shadowPadding, float shadowPaddingPercent, float shadowBorderWidth, int shadowBorderColor, boolean isProgressReversed, boolean isRemovedOnChange) {
        this.mDeterminateAnimationEnabled = determinateAnimationEnabled;
        this.mBorderWidth = borderWidth;
        this.mBorderWidthPercent = borderWidthPercent;
        if (this.mBorderWidthPercent > 100.0f) {
            this.mBorderWidthPercent %= 100.0f;
        }
        this.mSize = size;
        this.mPadding = padding;
        this.mSizePercent = sizePercent;
        this.mValuePercent = valuePercent;
        this.mFrontColor = frontColor;
        this.mBackColor = backColor;
        this.mIndeterminateColor = indeterminateColor;
        this.mGravity = PivProgressGravity.fromValue(gravity);
        this.mIsRtl = rtl;
        this.mIsRtlDisabled = disableRtlSupport;
        this.mIsIndeterminate = isIndeterminate;
        this.mDrawWedge = drawWedge;
        this.mShadowEnabled = shadowEnabled;
        this.mShadowColor = shadowColor;
        this.mShadowPadding = shadowPadding;
        this.mShadowPaddingPercent = shadowPaddingPercent;
        this.mShadowBorderWidth = shadowBorderWidth;
        this.mShadowBorderColor = shadowBorderColor;
        this.mIsProgressReversed = isProgressReversed;
        this.mIsRemovedOnChange = isRemovedOnChange;
        this.mCalculatedSize = 0.0f;
        this.mCalculatedShadowPadding = 0;
        this.mCalculatedBorderWidth = 0;
        this.mCalculatedLastW = 0;
        this.mCalculatedLastH = 0;
        this.mRect = new RectF(0.0f, 0.0f, 0.0f, 0.0f);
        this.mShadowRect = new RectF(0.0f, 0.0f, 0.0f, 0.0f);
        this.mShadowBorderRect = new RectF(0.0f, 0.0f, 0.0f, 0.0f);
        this.mCalculatedLastMode = PivProgressMode.NONE;
        this.listener = new WeakReference<Object>(null);
    }

    public void setOptions(ProgressOptions other) {
        this.mDeterminateAnimationEnabled = other.mDeterminateAnimationEnabled;
        this.mBorderWidth = other.mBorderWidth;
        this.mBorderWidthPercent = other.mBorderWidthPercent;
        this.mValuePercent = other.mValuePercent;
        this.mFrontColor = other.mFrontColor;
        this.mBackColor = other.mBackColor;
        this.mIndeterminateColor = other.mIndeterminateColor;
        this.mDrawWedge = other.mDrawWedge;
        this.mShadowEnabled = other.mShadowEnabled;
        this.mShadowColor = other.mShadowColor;
        this.mShadowPadding = other.mShadowPadding;
        this.mShadowPaddingPercent = other.mShadowPaddingPercent;
        this.mShadowBorderWidth = other.mShadowBorderWidth;
        this.mCalculatedShadowBorderWidth = other.mCalculatedShadowBorderWidth;
        this.mShadowBorderColor = other.mShadowBorderColor;
        this.mSize = other.mSize;
        this.mPadding = other.mPadding;
        this.mSizePercent = other.mSizePercent;
        this.mGravity = other.mGravity;
        this.mIsRtl = other.mIsRtl;
        this.mIsRtlDisabled = other.mIsRtlDisabled;
        this.mIsIndeterminate = other.mIsIndeterminate;
        this.mCalculatedSize = other.mCalculatedSize;
        this.mCalculatedShadowPadding = other.mCalculatedShadowPadding;
        this.mCalculatedBorderWidth = other.mCalculatedBorderWidth;
        this.mRect.set(other.mRect);
        this.mShadowRect.set(this.mShadowRect);
        this.mShadowBorderRect.set(this.mShadowBorderRect);
        this.mCalculatedLastW = other.mCalculatedLastW;
        this.mCalculatedLastH = other.mCalculatedLastH;
        this.mCalculatedLastMode = other.mCalculatedLastMode;
        this.mIsProgressReversed = other.mIsProgressReversed;
        this.listener = other.listener;
    }

    public final void calculateBounds(int w, int h, PivProgressMode mode) {
        this.mCalculatedLastW = w;
        this.mCalculatedLastH = h;
        this.mCalculatedLastMode = mode;
        float f = this.mCalculatedShadowBorderWidth = this.mShadowEnabled ? this.mShadowBorderWidth : 0.0f;
        if (mode == PivProgressMode.NONE) {
            this.mRect.set(0.0f, 0.0f, 0.0f, 0.0f);
            this.mShadowRect.set(0.0f, 0.0f, 0.0f, 0.0f);
            this.mShadowBorderRect.set(0.0f, 0.0f, 0.0f, 0.0f);
            return;
        }
        int maxSize = w < h ? w : h;
        switch (mode) {
            case CIRCULAR: {
                maxSize = w < h ? w : h;
                break;
            }
            case HORIZONTAL: {
                maxSize = w;
                break;
            }
            default: {
                this.mSize = 0;
            }
        }
        float calculatedShadowBorderWidthHalf = this.mCalculatedShadowBorderWidth / 2.0f;
        this.mCalculatedSize = (float)maxSize * this.mSizePercent / 100.0f;
        if (this.mSize >= 0) {
            this.mCalculatedSize = this.mSize;
        }
        if (this.mCalculatedSize > (float)(maxSize - this.mPadding - this.mPadding)) {
            this.mCalculatedSize = maxSize - this.mPadding - this.mPadding;
        }
        this.mCalculatedShadowPadding = (int)((this.mCalculatedSize - this.mCalculatedShadowBorderWidth * 2.0f) * this.mShadowPaddingPercent / 100.0f);
        if (this.mShadowPadding >= 0) {
            this.mCalculatedShadowPadding = this.mShadowPadding;
        }
        if (!this.mShadowEnabled) {
            this.mCalculatedShadowPadding = 0;
        }
        this.mCalculatedBorderWidth = Math.round((this.mCalculatedSize - this.mCalculatedShadowBorderWidth * 2.0f) * this.mBorderWidthPercent / 100.0f);
        if (this.mBorderWidth >= 0) {
            this.mCalculatedBorderWidth = this.mBorderWidth;
        }
        if (this.mCalculatedBorderWidth < 1) {
            this.mCalculatedBorderWidth = 1;
        }
        switch (mode) {
            case CIRCULAR: {
                float left = this.mGravity.isGravityLeft(this.mIsRtl && !this.mIsRtlDisabled) ? (float)this.mPadding : (this.mGravity.isGravityRight(this.mIsRtl && !this.mIsRtlDisabled) ? (float)w - this.mCalculatedSize - (float)this.mPadding : ((float)w - this.mCalculatedSize) / 2.0f);
                float top = this.mGravity.isGravityTop() ? (float)this.mPadding : (this.mGravity.isGravityBottom() ? (float)h - this.mCalculatedSize - (float)this.mPadding : ((float)h - this.mCalculatedSize) / 2.0f);
                this.mShadowBorderRect.set(left + calculatedShadowBorderWidthHalf, top + calculatedShadowBorderWidthHalf, left + this.mCalculatedSize - this.mCalculatedShadowBorderWidth, top + this.mCalculatedSize - this.mCalculatedShadowBorderWidth);
                this.mShadowRect.set(this.mShadowBorderRect);
                this.mShadowRect.inset(calculatedShadowBorderWidthHalf, calculatedShadowBorderWidthHalf);
                this.mRect.set(this.mShadowRect);
                this.mRect.inset((float)(this.mCalculatedShadowPadding + this.mCalculatedBorderWidth / 2), (float)(this.mCalculatedShadowPadding + this.mCalculatedBorderWidth / 2));
                break;
            }
            case HORIZONTAL: {
                float left = this.mGravity.isGravityLeft(this.mIsRtl && !this.mIsRtlDisabled) ? (float)this.mPadding : (this.mGravity.isGravityRight(this.mIsRtl && !this.mIsRtlDisabled) ? (float)w - this.mCalculatedSize - (float)this.mPadding : ((float)w - this.mCalculatedSize) / 2.0f);
                float top = this.mGravity.isGravityTop() ? (float)this.mPadding : (this.mGravity.isGravityBottom() ? (float)(h - this.mCalculatedBorderWidth - this.mPadding) : (float)((h - this.mCalculatedBorderWidth - this.mPadding) / 2));
                this.mShadowBorderRect.set(left + calculatedShadowBorderWidthHalf, top + calculatedShadowBorderWidthHalf, left + this.mCalculatedSize - this.mCalculatedShadowBorderWidth, top + (float)this.mCalculatedBorderWidth - calculatedShadowBorderWidthHalf);
                this.mShadowRect.set(this.mShadowBorderRect);
                this.mShadowRect.inset(calculatedShadowBorderWidthHalf, calculatedShadowBorderWidthHalf);
                this.mRect.set(this.mShadowRect);
                this.mRect.inset((float)this.mCalculatedShadowPadding, (float)this.mCalculatedShadowPadding);
                break;
            }
            default: {
                this.mRect.set(0.0f, 0.0f, 0.0f, 0.0f);
                this.mShadowRect.set(0.0f, 0.0f, 0.0f, 0.0f);
                this.mShadowBorderRect.set(0.0f, 0.0f, 0.0f, 0.0f);
            }
        }
    }

    public final RectF getRect() {
        return this.mRect;
    }

    public final RectF getShadowRect() {
        return this.mShadowRect;
    }

    public final RectF getShadowBorderRect() {
        return this.mShadowBorderRect;
    }

    public void setDeterminateAnimationEnabled(boolean determinateAnimationEnabled) {
        this.mDeterminateAnimationEnabled = determinateAnimationEnabled;
        if (this.listener.get() != null) {
            ((ProgressOptionsListener)this.listener.get()).onOptionsUpdated(this);
        }
    }

    public void setBorderWidth(int borderWidth) {
        this.mBorderWidth = borderWidth;
        this.calculateBounds(this.mCalculatedLastW, this.mCalculatedLastH, this.mCalculatedLastMode);
        if (this.listener.get() != null) {
            ((ProgressOptionsListener)this.listener.get()).onSizeUpdated(this);
        }
    }

    public void setBorderWidth(float borderWidthPercent) {
        this.mBorderWidth = -1;
        if (borderWidthPercent > 100.0f) {
            borderWidthPercent %= 100.0f;
        }
        this.mBorderWidthPercent = borderWidthPercent;
        this.calculateBounds(this.mCalculatedLastW, this.mCalculatedLastH, this.mCalculatedLastMode);
        if (this.listener.get() != null) {
            ((ProgressOptionsListener)this.listener.get()).onSizeUpdated(this);
        }
    }

    public void setValue(float valuePercent) {
        if (valuePercent > 100.0f) {
            valuePercent %= 100.0f;
        }
        if (valuePercent < 0.0f) {
            valuePercent = 0.0f;
        }
        this.mValuePercent = valuePercent;
        boolean modeChanged = this.mIsIndeterminate;
        this.mIsIndeterminate = false;
        if (this.listener.get() != null) {
            if (modeChanged) {
                ((ProgressOptionsListener)this.listener.get()).onModeUpdated(this);
            } else {
                ((ProgressOptionsListener)this.listener.get()).onOptionsUpdated(this);
            }
        }
    }

    public void setFrontColor(int frontColor) {
        this.mFrontColor = frontColor;
        if (this.listener.get() != null) {
            ((ProgressOptionsListener)this.listener.get()).onOptionsUpdated(this);
        }
    }

    public void setBackColor(int backColor) {
        this.mBackColor = backColor;
        if (this.listener.get() != null) {
            ((ProgressOptionsListener)this.listener.get()).onOptionsUpdated(this);
        }
    }

    public void setIndeterminateColor(int indeterminateColor) {
        this.mIndeterminateColor = indeterminateColor;
        if (this.listener.get() != null) {
            ((ProgressOptionsListener)this.listener.get()).onOptionsUpdated(this);
        }
    }

    public void setDrawWedge(boolean mDrawWedge) {
        this.mDrawWedge = mDrawWedge;
        if (this.listener.get() != null) {
            ((ProgressOptionsListener)this.listener.get()).onOptionsUpdated(this);
        }
    }

    public void setPadding(int padding) {
        this.mPadding = padding;
        this.calculateBounds(this.mCalculatedLastW, this.mCalculatedLastH, this.mCalculatedLastMode);
        if (this.listener.get() != null) {
            ((ProgressOptionsListener)this.listener.get()).onSizeUpdated(this);
        }
    }

    public void setSize(int size) {
        this.mSize = size;
        this.calculateBounds(this.mCalculatedLastW, this.mCalculatedLastH, this.mCalculatedLastMode);
        if (this.listener.get() != null) {
            ((ProgressOptionsListener)this.listener.get()).onSizeUpdated(this);
        }
    }

    public void setSize(float sizePercent) {
        this.mSize = -1;
        if (sizePercent > 100.0f) {
            sizePercent %= 100.0f;
        }
        this.mSizePercent = sizePercent;
        this.calculateBounds(this.mCalculatedLastW, this.mCalculatedLastH, this.mCalculatedLastMode);
        if (this.listener.get() != null) {
            ((ProgressOptionsListener)this.listener.get()).onSizeUpdated(this);
        }
    }

    public void setGravity(PivProgressGravity mGravity) {
        this.mGravity = mGravity;
        this.calculateBounds(this.mCalculatedLastW, this.mCalculatedLastH, this.mCalculatedLastMode);
        if (this.listener.get() != null) {
            ((ProgressOptionsListener)this.listener.get()).onSizeUpdated(this);
        }
    }

    public void setRtlDisabled(boolean rtlDisabled) {
        this.mIsRtlDisabled = rtlDisabled;
        this.calculateBounds(this.mCalculatedLastW, this.mCalculatedLastH, this.mCalculatedLastMode);
        if (this.listener.get() != null) {
            ((ProgressOptionsListener)this.listener.get()).onSizeUpdated(this);
        }
    }

    public void setProgressReversed(boolean progressReversed) {
        this.mIsProgressReversed = progressReversed;
        if (this.listener.get() != null) {
            ((ProgressOptionsListener)this.listener.get()).onOptionsUpdated(this);
        }
    }

    public void setRemovedOnChange(boolean removedOnChange) {
        this.mIsRemovedOnChange = removedOnChange;
    }

    public void setIndeterminate(boolean isIndeterminate) {
        boolean modeChanged = this.mIsIndeterminate != isIndeterminate;
        this.mIsIndeterminate = isIndeterminate;
        if (this.listener.get() != null) {
            if (modeChanged) {
                ((ProgressOptionsListener)this.listener.get()).onModeUpdated(this);
            } else {
                ((ProgressOptionsListener)this.listener.get()).onOptionsUpdated(this);
            }
        }
    }

    public void setShadowColor(int shadowColor) {
        this.mShadowColor = shadowColor;
        if (this.listener.get() != null) {
            ((ProgressOptionsListener)this.listener.get()).onOptionsUpdated(this);
        }
    }

    public void setShadowEnabled(boolean shadowEnabled) {
        this.mShadowEnabled = shadowEnabled;
        this.calculateBounds(this.mCalculatedLastW, this.mCalculatedLastH, this.mCalculatedLastMode);
        if (this.listener.get() != null) {
            ((ProgressOptionsListener)this.listener.get()).onSizeUpdated(this);
        }
    }

    public void setShadowPadding(int padding) {
        this.mShadowPadding = padding;
        this.calculateBounds(this.mCalculatedLastW, this.mCalculatedLastH, this.mCalculatedLastMode);
        if (this.listener.get() != null) {
            ((ProgressOptionsListener)this.listener.get()).onSizeUpdated(this);
        }
    }

    public void setShadowPadding(float paddingPercent) {
        this.mShadowPadding = -1;
        if (paddingPercent > 100.0f) {
            this.mShadowPaddingPercent = paddingPercent % 100.0f;
        }
        this.calculateBounds(this.mCalculatedLastW, this.mCalculatedLastH, this.mCalculatedLastMode);
        if (this.listener.get() != null) {
            ((ProgressOptionsListener)this.listener.get()).onSizeUpdated(this);
        }
    }

    public void setShadowBorderColor(int shadowBorderColor) {
        this.mShadowBorderColor = shadowBorderColor;
        if (this.listener.get() != null) {
            ((ProgressOptionsListener)this.listener.get()).onOptionsUpdated(this);
        }
    }

    public void setShadowBorderWidth(float shadowBorderWidth) {
        this.mShadowBorderWidth = shadowBorderWidth;
        this.calculateBounds(this.mCalculatedLastW, this.mCalculatedLastH, this.mCalculatedLastMode);
        if (this.listener.get() != null) {
            ((ProgressOptionsListener)this.listener.get()).onSizeUpdated(this);
        }
    }

    public float getBorderWidthPercent() {
        return this.mBorderWidthPercent;
    }

    public final int getBorderWidth() {
        return this.mBorderWidth;
    }

    public int getSize() {
        return this.mSize;
    }

    public float getSizePercent() {
        return this.mSizePercent;
    }

    public int getPadding() {
        return this.mPadding;
    }

    public PivProgressGravity getGravity() {
        return this.mGravity;
    }

    public boolean isRtlDisabled() {
        return this.mIsRtlDisabled;
    }

    public boolean isIndeterminate() {
        return this.mIsIndeterminate;
    }

    public int getShadowPadding() {
        return this.mShadowPadding;
    }

    public float getShadowPaddingPercent() {
        return this.mShadowPaddingPercent;
    }

    public float getCalculatedSize() {
        return this.mCalculatedSize;
    }

    public float getCalculatedShadowPadding() {
        return this.mCalculatedShadowPadding;
    }

    public boolean isProgressReversed() {
        return (this.mIsRtl && !this.mIsRtlDisabled) != this.mIsProgressReversed;
    }

    public boolean isRemovedOnChange() {
        return this.mIsRemovedOnChange;
    }

    public final boolean isDeterminateAnimationEnabled() {
        return this.mDeterminateAnimationEnabled;
    }

    public final float getValuePercent() {
        return this.mValuePercent;
    }

    public int getCalculatedBorderWidth() {
        return this.mCalculatedBorderWidth;
    }

    public final int getFrontColor() {
        return this.mFrontColor;
    }

    public final int getBackColor() {
        return this.mBackColor;
    }

    public final int getIndeterminateColor() {
        return this.mIndeterminateColor;
    }

    public final boolean isDrawWedge() {
        return this.mDrawWedge;
    }

    public void setListener(ProgressOptionsListener listener) {
        this.listener = new WeakReference<ProgressOptionsListener>(listener);
    }

    public int getShadowColor() {
        return this.mShadowColor;
    }

    public int getShadowBorderColor() {
        return this.mShadowBorderColor;
    }

    public float getShadowBorderWidth() {
        return this.mCalculatedShadowBorderWidth;
    }

    public boolean isShadowEnabled() {
        return this.mShadowEnabled;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeByte((byte)(this.mDeterminateAnimationEnabled ? 1 : 0));
        dest.writeInt(this.mBorderWidth);
        dest.writeFloat(this.mBorderWidthPercent);
        dest.writeFloat(this.mValuePercent);
        dest.writeInt(this.mFrontColor);
        dest.writeInt(this.mBackColor);
        dest.writeInt(this.mIndeterminateColor);
        dest.writeByte((byte)(this.mDrawWedge ? 1 : 0));
        dest.writeByte((byte)(this.mShadowEnabled ? 1 : 0));
        dest.writeInt(this.mShadowColor);
        dest.writeInt(this.mShadowPadding);
        dest.writeFloat(this.mShadowPaddingPercent);
        dest.writeFloat(this.mShadowBorderWidth);
        dest.writeFloat(this.mCalculatedShadowBorderWidth);
        dest.writeInt(this.mShadowBorderColor);
        dest.writeInt(this.mSize);
        dest.writeInt(this.mPadding);
        dest.writeFloat(this.mSizePercent);
        dest.writeByte((byte)(this.mIsRtl ? 1 : 0));
        dest.writeByte((byte)(this.mIsRtlDisabled ? 1 : 0));
        dest.writeByte((byte)(this.mIsIndeterminate ? 1 : 0));
        dest.writeByte((byte)(this.mIsProgressReversed ? 1 : 0));
        dest.writeFloat(this.mCalculatedSize);
        dest.writeInt(this.mCalculatedShadowPadding);
        dest.writeInt(this.mCalculatedBorderWidth);
        dest.writeParcelable((Parcelable)this.mRect, flags);
        dest.writeParcelable((Parcelable)this.mShadowRect, flags);
        dest.writeParcelable((Parcelable)this.mShadowBorderRect, flags);
        dest.writeInt(this.mCalculatedLastW);
        dest.writeInt(this.mCalculatedLastH);
    }

    protected ProgressOptions(Parcel in) {
        this.mDeterminateAnimationEnabled = in.readByte() != 0;
        this.mBorderWidth = in.readInt();
        this.mBorderWidthPercent = in.readFloat();
        this.mValuePercent = in.readFloat();
        this.mFrontColor = in.readInt();
        this.mBackColor = in.readInt();
        this.mIndeterminateColor = in.readInt();
        this.mDrawWedge = in.readByte() != 0;
        this.mShadowEnabled = in.readByte() != 0;
        this.mShadowColor = in.readInt();
        this.mShadowPadding = in.readInt();
        this.mShadowPaddingPercent = in.readFloat();
        this.mShadowBorderWidth = in.readFloat();
        this.mCalculatedShadowBorderWidth = in.readFloat();
        this.mShadowBorderColor = in.readInt();
        this.mSize = in.readInt();
        this.mPadding = in.readInt();
        this.mSizePercent = in.readFloat();
        this.mIsRtl = in.readByte() != 0;
        this.mIsRtlDisabled = in.readByte() != 0;
        this.mIsIndeterminate = in.readByte() != 0;
        this.mIsProgressReversed = in.readByte() != 0;
        this.mCalculatedSize = in.readFloat();
        this.mCalculatedShadowPadding = in.readInt();
        this.mCalculatedBorderWidth = in.readInt();
        this.mRect = (RectF)in.readParcelable(RectF.class.getClassLoader());
        this.mShadowRect = (RectF)in.readParcelable(RectF.class.getClassLoader());
        this.mShadowBorderRect = (RectF)in.readParcelable(RectF.class.getClassLoader());
        this.mCalculatedLastW = in.readInt();
        this.mCalculatedLastH = in.readInt();
    }

    public static interface ProgressOptionsListener {
        public void onOptionsUpdated(ProgressOptions var1);

        public void onSizeUpdated(ProgressOptions var1);

        public void onModeUpdated(ProgressOptions var1);
    }
}

