/*
 * Decompiled with CFR 0.152.
 */
package com.stefanosiano.powerfulimageview.progress;

public enum PivProgressGravity {
    CENTER(0),
    START(1),
    END(2),
    TOP(3),
    TOP_START(4),
    TOP_END(5),
    BOTTOM(6),
    BOTTOM_START(7),
    BOTTOM_END(8);

    private final int value;

    private PivProgressGravity(int value) {
        this.value = value;
    }

    public final int getValue() {
        return this.value;
    }

    public static PivProgressGravity fromValue(int value) {
        switch (value) {
            case 1: {
                return START;
            }
            case 2: {
                return END;
            }
            case 3: {
                return TOP;
            }
            case 4: {
                return TOP_START;
            }
            case 5: {
                return TOP_END;
            }
            case 6: {
                return BOTTOM;
            }
            case 7: {
                return BOTTOM_START;
            }
            case 8: {
                return BOTTOM_END;
            }
        }
        return CENTER;
    }

    public final boolean isGravityLeft(boolean isRtl) {
        switch (this) {
            case START: 
            case BOTTOM_START: 
            case TOP_START: {
                return !isRtl;
            }
            case END: 
            case BOTTOM_END: 
            case TOP_END: {
                return isRtl;
            }
        }
        return false;
    }

    public final boolean isGravityRight(boolean isRtl) {
        switch (this) {
            case START: 
            case BOTTOM_START: 
            case TOP_START: {
                return isRtl;
            }
            case END: 
            case BOTTOM_END: 
            case TOP_END: {
                return !isRtl;
            }
        }
        return false;
    }

    public final boolean isGravityTop() {
        switch (this) {
            case TOP_START: 
            case TOP_END: 
            case TOP: {
                return true;
            }
        }
        return false;
    }

    public final boolean isGravityBottom() {
        switch (this) {
            case BOTTOM_START: 
            case BOTTOM_END: 
            case BOTTOM: {
                return true;
            }
        }
        return false;
    }
}

