/*
 * Decompiled with CFR 0.152.
 */
package com.stefanosiano.powerfulimageview.blur.algorithms;

import android.graphics.Bitmap;
import android.renderscript.RenderScript;
import com.stefanosiano.powerfulimageview.blur.BlurOptions;
import com.stefanosiano.powerfulimageview.blur.algorithms.BlurAlgorithm;
import com.stefanosiano.powerfulimageview.blur.algorithms.RenderscriptException;
import com.stefanosiano.powerfulimageview.blur.algorithms.SharedBlurManager;
import java.util.ArrayList;
import java.util.concurrent.Callable;

final class StackBlurAlgorithm
implements BlurAlgorithm {
    private final short[] stackblur_mul = new short[]{512, 512, 456, 512, 328, 456, 335, 512, 405, 328, 271, 456, 388, 335, 292, 512, 454, 405, 364, 328, 298, 271, 496, 456, 420, 388, 360, 335, 312, 292, 273, 512, 482, 454, 428, 405, 383, 364, 345, 328, 312, 298, 284, 271, 259, 496, 475, 456, 437, 420, 404, 388, 374, 360, 347, 335, 323, 312, 302, 292, 282, 273, 265, 512, 497, 482, 468, 454, 441, 428, 417, 405, 394, 383, 373, 364, 354, 345, 337, 328, 320, 312, 305, 298, 291, 284, 278, 271, 265, 259, 507, 496, 485, 475, 465, 456, 446, 437, 428, 420, 412, 404, 396, 388, 381, 374, 367, 360, 354, 347, 341, 335, 329, 323, 318, 312, 307, 302, 297, 292, 287, 282, 278, 273, 269, 265, 261, 512, 505, 497, 489, 482, 475, 468, 461, 454, 447, 441, 435, 428, 422, 417, 411, 405, 399, 394, 389, 383, 378, 373, 368, 364, 359, 354, 350, 345, 341, 337, 332, 328, 324, 320, 316, 312, 309, 305, 301, 298, 294, 291, 287, 284, 281, 278, 274, 271, 268, 265, 262, 259, 257, 507, 501, 496, 491, 485, 480, 475, 470, 465, 460, 456, 451, 446, 442, 437, 433, 428, 424, 420, 416, 412, 408, 404, 400, 396, 392, 388, 385, 381, 377, 374, 370, 367, 363, 360, 357, 354, 350, 347, 344, 341, 338, 335, 332, 329, 326, 323, 320, 318, 315, 312, 310, 307, 304, 302, 299, 297, 294, 292, 289, 287, 285, 282, 280, 278, 275, 273, 271, 269, 267, 265, 263, 261, 259};
    private final byte[] stackblur_shr = new byte[]{9, 11, 12, 13, 13, 14, 14, 15, 15, 15, 15, 16, 16, 16, 16, 17, 17, 17, 17, 17, 17, 17, 18, 18, 18, 18, 18, 18, 18, 18, 18, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24};

    StackBlurAlgorithm() {
    }

    @Override
    public void setRenderscript(RenderScript renderscript) {
    }

    @Override
    public Bitmap blur(Bitmap original, int radius, BlurOptions options) throws RenderscriptException {
        int w = original.getWidth();
        int h = original.getHeight();
        int[] pix = new int[w * h];
        original.getPixels(pix, 0, w, 0, 0, w, h);
        int cores = Math.min(options.getNumThreads(), Runtime.getRuntime().availableProcessors());
        if (cores <= 0) {
            cores = Runtime.getRuntime().availableProcessors();
        }
        ArrayList<BlurTask> horizontal = new ArrayList<BlurTask>(cores);
        ArrayList<BlurTask> vertical = new ArrayList<BlurTask>(cores);
        for (int i = 0; i < cores; ++i) {
            horizontal.add(new BlurTask(pix, w, h, radius, cores, i, 1));
            vertical.add(new BlurTask(pix, w, h, radius, cores, i, 2));
        }
        try {
            SharedBlurManager.getExecutorService().invokeAll(horizontal);
        }
        catch (InterruptedException e) {
            return null;
        }
        try {
            SharedBlurManager.getExecutorService().invokeAll(vertical);
        }
        catch (InterruptedException e) {
            return null;
        }
        if (!options.isStaticBlur()) {
            return Bitmap.createBitmap((int[])pix, (int)0, (int)w, (int)w, (int)h, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        }
        if (original.isMutable()) {
            original.setPixels(pix, 0, w, 0, 0, w, h);
            return original;
        }
        original.recycle();
        return Bitmap.createBitmap((int[])pix, (int)0, (int)w, (int)w, (int)h, (Bitmap.Config)Bitmap.Config.ARGB_8888);
    }

    private void blurIteration(int[] src, int w, int h, int radius, int cores, int core, int step) {
        block19: {
            int[] stack;
            byte shr_sum;
            short mul_sum;
            int div;
            int hm;
            block18: {
                int wm = w - 1;
                hm = h - 1;
                div = radius * 2 + 1;
                mul_sum = this.stackblur_mul[radius];
                shr_sum = this.stackblur_shr[radius];
                stack = new int[div];
                if (step != 1) break block18;
                int minY = core * h / cores;
                int maxY = (core + 1) * h / cores;
                for (int y = minY; y < maxY; ++y) {
                    int stack_i;
                    int i;
                    long sum_out_a = 0L;
                    long sum_out_b = 0L;
                    long sum_out_g = 0L;
                    long sum_out_r = 0L;
                    long sum_in_a = 0L;
                    long sum_in_b = 0L;
                    long sum_in_g = 0L;
                    long sum_in_r = 0L;
                    long sum_a = 0L;
                    long sum_b = 0L;
                    long sum_g = 0L;
                    long sum_r = 0L;
                    int src_i = w * y;
                    for (i = 0; i <= radius; ++i) {
                        stack_i = i;
                        stack[stack_i] = src[src_i];
                        sum_a += (long)((src[src_i] >>> 24 & 0xFF) * (i + 1));
                        sum_r += (long)((src[src_i] >>> 16 & 0xFF) * (i + 1));
                        sum_g += (long)((src[src_i] >>> 8 & 0xFF) * (i + 1));
                        sum_b += (long)((src[src_i] & 0xFF) * (i + 1));
                        sum_out_a += (long)(src[src_i] >>> 24 & 0xFF);
                        sum_out_r += (long)(src[src_i] >>> 16 & 0xFF);
                        sum_out_g += (long)(src[src_i] >>> 8 & 0xFF);
                        sum_out_b += (long)(src[src_i] & 0xFF);
                    }
                    for (i = 1; i <= radius; ++i) {
                        if (i <= wm) {
                            ++src_i;
                        }
                        stack_i = i + radius;
                        stack[stack_i] = src[src_i];
                        sum_a += (long)((src[src_i] >>> 24 & 0xFF) * (radius + 1 - i));
                        sum_r += (long)((src[src_i] >>> 16 & 0xFF) * (radius + 1 - i));
                        sum_g += (long)((src[src_i] >>> 8 & 0xFF) * (radius + 1 - i));
                        sum_b += (long)((src[src_i] & 0xFF) * (radius + 1 - i));
                        sum_in_a += (long)(src[src_i] >>> 24 & 0xFF);
                        sum_in_r += (long)(src[src_i] >>> 16 & 0xFF);
                        sum_in_g += (long)(src[src_i] >>> 8 & 0xFF);
                        sum_in_b += (long)(src[src_i] & 0xFF);
                    }
                    int sp = radius;
                    int xp = radius;
                    if (xp > wm) {
                        xp = wm;
                    }
                    src_i = xp + y * w;
                    int dst_i = y * w;
                    for (int x = 0; x < w; ++x) {
                        src[dst_i] = (int)((long)(src[dst_i] & 0xFF000000) | (sum_a * (long)mul_sum >>> shr_sum & 0xFFL) << 24 | (sum_r * (long)mul_sum >>> shr_sum & 0xFFL) << 16 | (sum_g * (long)mul_sum >>> shr_sum & 0xFFL) << 8 | sum_b * (long)mul_sum >>> shr_sum & 0xFFL);
                        ++dst_i;
                        sum_a -= sum_out_a;
                        sum_r -= sum_out_r;
                        sum_g -= sum_out_g;
                        sum_b -= sum_out_b;
                        int stack_start = sp + div - radius;
                        if (stack_start >= div) {
                            stack_start -= div;
                        }
                        stack_i = stack_start;
                        sum_out_a -= (long)(stack[stack_i] >>> 24 & 0xFF);
                        sum_out_r -= (long)(stack[stack_i] >>> 16 & 0xFF);
                        sum_out_g -= (long)(stack[stack_i] >>> 8 & 0xFF);
                        sum_out_b -= (long)(stack[stack_i] & 0xFF);
                        if (xp < wm) {
                            ++src_i;
                            ++xp;
                        }
                        stack[stack_i] = src[src_i];
                        sum_a += (sum_in_a += (long)(src[src_i] >>> 24 & 0xFF));
                        sum_r += (sum_in_r += (long)(src[src_i] >>> 16 & 0xFF));
                        sum_g += (sum_in_g += (long)(src[src_i] >>> 8 & 0xFF));
                        sum_b += (sum_in_b += (long)(src[src_i] & 0xFF));
                        if (++sp >= div) {
                            sp = 0;
                        }
                        stack_i = sp;
                        sum_out_a += (long)(stack[stack_i] >>> 24 & 0xFF);
                        sum_out_r += (long)(stack[stack_i] >>> 16 & 0xFF);
                        sum_out_g += (long)(stack[stack_i] >>> 8 & 0xFF);
                        sum_out_b += (long)(stack[stack_i] & 0xFF);
                        sum_in_a -= (long)(stack[stack_i] >>> 24 & 0xFF);
                        sum_in_r -= (long)(stack[stack_i] >>> 16 & 0xFF);
                        sum_in_g -= (long)(stack[stack_i] >>> 8 & 0xFF);
                        sum_in_b -= (long)(stack[stack_i] & 0xFF);
                    }
                }
                break block19;
            }
            if (step != 2) break block19;
            int minX = core * w / cores;
            int maxX = (core + 1) * w / cores;
            for (int x = minX; x < maxX; ++x) {
                int stack_i;
                int i;
                long sum_out_a = 0L;
                long sum_out_b = 0L;
                long sum_out_g = 0L;
                long sum_out_r = 0L;
                long sum_in_a = 0L;
                long sum_in_b = 0L;
                long sum_in_g = 0L;
                long sum_in_r = 0L;
                long sum_a = 0L;
                long sum_b = 0L;
                long sum_g = 0L;
                long sum_r = 0L;
                int src_i = x;
                for (i = 0; i <= radius; ++i) {
                    stack_i = i;
                    stack[stack_i] = src[src_i];
                    sum_a += (long)((src[src_i] >>> 24 & 0xFF) * (i + 1));
                    sum_r += (long)((src[src_i] >>> 16 & 0xFF) * (i + 1));
                    sum_g += (long)((src[src_i] >>> 8 & 0xFF) * (i + 1));
                    sum_b += (long)((src[src_i] & 0xFF) * (i + 1));
                    sum_out_a += (long)(src[src_i] >>> 24 & 0xFF);
                    sum_out_r += (long)(src[src_i] >>> 16 & 0xFF);
                    sum_out_g += (long)(src[src_i] >>> 8 & 0xFF);
                    sum_out_b += (long)(src[src_i] & 0xFF);
                }
                for (i = 1; i <= radius; ++i) {
                    if (i <= hm) {
                        src_i += w;
                    }
                    stack_i = i + radius;
                    stack[stack_i] = src[src_i];
                    sum_a += (long)((src[src_i] >>> 24 & 0xFF) * (radius + 1 - i));
                    sum_r += (long)((src[src_i] >>> 16 & 0xFF) * (radius + 1 - i));
                    sum_g += (long)((src[src_i] >>> 8 & 0xFF) * (radius + 1 - i));
                    sum_b += (long)((src[src_i] & 0xFF) * (radius + 1 - i));
                    sum_in_a += (long)(src[src_i] >>> 24 & 0xFF);
                    sum_in_r += (long)(src[src_i] >>> 16 & 0xFF);
                    sum_in_g += (long)(src[src_i] >>> 8 & 0xFF);
                    sum_in_b += (long)(src[src_i] & 0xFF);
                }
                int sp = radius;
                int yp = radius;
                if (yp > hm) {
                    yp = hm;
                }
                src_i = x + yp * w;
                int dst_i = x;
                for (int y = 0; y < h; ++y) {
                    src[dst_i] = (int)((long)(src[dst_i] & 0xFF000000) | (sum_a * (long)mul_sum >>> shr_sum & 0xFFL) << 24 | (sum_r * (long)mul_sum >>> shr_sum & 0xFFL) << 16 | (sum_g * (long)mul_sum >>> shr_sum & 0xFFL) << 8 | sum_b * (long)mul_sum >>> shr_sum & 0xFFL);
                    dst_i += w;
                    sum_a -= sum_out_a;
                    sum_r -= sum_out_r;
                    sum_g -= sum_out_g;
                    sum_b -= sum_out_b;
                    int stack_start = sp + div - radius;
                    if (stack_start >= div) {
                        stack_start -= div;
                    }
                    stack_i = stack_start;
                    sum_out_a -= (long)(stack[stack_i] >>> 24 & 0xFF);
                    sum_out_r -= (long)(stack[stack_i] >>> 16 & 0xFF);
                    sum_out_g -= (long)(stack[stack_i] >>> 8 & 0xFF);
                    sum_out_b -= (long)(stack[stack_i] & 0xFF);
                    if (yp < hm) {
                        src_i += w;
                        ++yp;
                    }
                    stack[stack_i] = src[src_i];
                    sum_a += (sum_in_a += (long)(src[src_i] >>> 24 & 0xFF));
                    sum_r += (sum_in_r += (long)(src[src_i] >>> 16 & 0xFF));
                    sum_g += (sum_in_g += (long)(src[src_i] >>> 8 & 0xFF));
                    sum_b += (sum_in_b += (long)(src[src_i] & 0xFF));
                    if (++sp >= div) {
                        sp = 0;
                    }
                    stack_i = sp;
                    sum_out_a += (long)(stack[stack_i] >>> 24 & 0xFF);
                    sum_out_r += (long)(stack[stack_i] >>> 16 & 0xFF);
                    sum_out_g += (long)(stack[stack_i] >>> 8 & 0xFF);
                    sum_out_b += (long)(stack[stack_i] & 0xFF);
                    sum_in_a -= (long)(stack[stack_i] >>> 24 & 0xFF);
                    sum_in_r -= (long)(stack[stack_i] >>> 16 & 0xFF);
                    sum_in_g -= (long)(stack[stack_i] >>> 8 & 0xFF);
                    sum_in_b -= (long)(stack[stack_i] & 0xFF);
                }
            }
        }
    }

    private class BlurTask
    implements Callable<Void> {
        private final int[] _src;
        private final int _w;
        private final int _h;
        private final int _radius;
        private final int _totalCores;
        private final int _coreIndex;
        private final int _round;

        BlurTask(int[] src, int w, int h, int radius, int totalCores, int coreIndex, int round) {
            this._src = src;
            this._w = w;
            this._h = h;
            this._radius = radius;
            this._totalCores = totalCores;
            this._coreIndex = coreIndex;
            this._round = round;
        }

        @Override
        public Void call() throws Exception {
            StackBlurAlgorithm.this.blurIteration(this._src, this._w, this._h, this._radius, this._totalCores, this._coreIndex, this._round);
            return null;
        }
    }
}

